/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.cache;

import fr.esrf.Tango.DevFailed;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tango.client.database.DatabaseFactory;
import org.tango.command.CommandTangoType;
import org.tango.server.IPollable;
import org.tango.server.attribute.AttributeImpl;
import org.tango.server.attribute.AttributeValue;
import org.tango.server.attribute.ForwardedAttribute;
import org.tango.server.cache.NoCacheFoundException;
import org.tango.server.cache.TangoCacheManager;
import org.tango.server.command.CommandImpl;
import org.tango.server.servant.AttributeGetterSetter;
import org.tango.server.servant.CommandGetter;
import org.tango.utils.DevFailedUtils;

public final class PollingManager {
    private final Logger logger = LoggerFactory.getLogger(PollingManager.class);
    private final TangoCacheManager cacheManager;
    private final Map<String, Integer> minCommandPolling;
    private final int minPolling;
    private final Map<String, Integer> minAttributePolling;
    private final Map<String, Integer> cmdPollRingDepth;
    private final Map<String, Integer> attrPollRingDepth;
    private final String deviceName;
    private final List<AttributeImpl> attributeList;
    private final List<CommandImpl> commandList;
    private Map<String, Integer> pollAttributes = new HashMap<String, Integer>();
    private int pollRingDepth = 10;

    public PollingManager(String deviceName, TangoCacheManager cacheManager, List<AttributeImpl> attributeList, List<CommandImpl> commandList, int minPolling, Map<String, Integer> minCommandPolling, Map<String, Integer> minAttributePolling, Map<String, Integer> cmdPollRingDepth, Map<String, Integer> attrPollRingDepth) {
        this.deviceName = deviceName;
        this.cacheManager = cacheManager;
        this.attributeList = attributeList;
        this.commandList = commandList;
        this.minPolling = minPolling;
        this.minCommandPolling = minCommandPolling;
        this.minAttributePolling = minAttributePolling;
        this.cmdPollRingDepth = cmdPollRingDepth;
        this.attrPollRingDepth = attrPollRingDepth;
    }

    public void initPolling() throws DevFailed {
        for (AttributeImpl attribute : this.attributeList) {
            attribute.lock();
            try {
                attribute.loadTangoDbConfig();
                this.startPolling(attribute);
            }
            finally {
                attribute.unlock();
            }
        }
        for (CommandImpl command : this.commandList) {
            command.updatePollingConfigFromDB();
            this.startPolling(command);
        }
    }

    public void startPolling(CommandImpl command) throws DevFailed {
        if (command != null) {
            if (command.isPolled()) {
                if (command.getName().equals("State") || command.getName().equals("Status")) {
                    AttributeImpl attribute = AttributeGetterSetter.getAttribute(command.getName(), this.attributeList);
                    this.cacheManager.startStateStatusPolling(command, attribute);
                } else {
                    this.cacheManager.startCommandPolling(command);
                }
            }
            if (this.cmdPollRingDepth.containsKey(command.getName().toLowerCase(Locale.ENGLISH))) {
                command.setPollRingDepth(this.cmdPollRingDepth.get(command.getName().toLowerCase(Locale.ENGLISH)));
            } else {
                command.setPollRingDepth(this.pollRingDepth);
            }
        }
    }

    public void startPolling(AttributeImpl attribute) throws DevFailed {
        if (attribute != null) {
            if (this.pollAttributes.containsKey(attribute.getName().toLowerCase(Locale.ENGLISH))) {
                attribute.configurePolling(this.pollAttributes.get(attribute.getName().toLowerCase(Locale.ENGLISH)));
            }
            if (attribute.isPolled()) {
                this.logger.debug("configure polling of {}", (Object)attribute.getName());
                if (attribute.getName().equals("State") || attribute.getName().equals("Status")) {
                    CommandImpl cmd = CommandGetter.getCommand(attribute.getName(), this.commandList);
                    cmd.updatePollingConfigFromDB();
                    this.cacheManager.startStateStatusPolling(cmd, attribute);
                } else {
                    this.cacheManager.startAttributePolling(attribute);
                }
            }
            if (this.attrPollRingDepth.containsKey(attribute.getName().toLowerCase(Locale.ENGLISH))) {
                attribute.setPollRingDepth(this.attrPollRingDepth.get(attribute.getName().toLowerCase(Locale.ENGLISH)));
            } else {
                attribute.setPollRingDepth(this.pollRingDepth);
            }
        }
    }

    private void savePollingConfig() throws DevFailed {
        String[] pollingConfig = new String[this.pollAttributes.size() * 2];
        int i = 0;
        for (Map.Entry<String, Integer> entry : this.pollAttributes.entrySet()) {
            pollingConfig[i++] = entry.getKey();
            pollingConfig[i++] = Integer.toString(entry.getValue());
        }
        if (pollingConfig.length == 0) {
            DatabaseFactory.getDatabase().deleteDeviceProperty(this.deviceName, "polled_attr");
        } else {
            HashMap<String, String[]> props = new HashMap<String, String[]>();
            props.put("polled_attr", pollingConfig);
            DatabaseFactory.getDatabase().setDeviceProperties(this.deviceName, props);
        }
    }

    public void triggerPolling(String objectName) throws DevFailed {
        boolean isACommand = false;
        CommandImpl cmd = null;
        try {
            cmd = CommandGetter.getCommand(objectName, this.commandList);
            isACommand = true;
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        if (!isACommand) {
            AttributeImpl att = null;
            try {
                att = AttributeGetterSetter.getAttribute(objectName, this.attributeList);
            }
            catch (DevFailed e) {
                this.logger.error("Polled object " + objectName + " not found");
                throw DevFailedUtils.newDevFailed((String)"API_PollObjNotFound", (String)("Polled object " + objectName + " not found"));
            }
            this.checkPolling(objectName, att);
            try {
                this.cacheManager.getAttributeCache(att).refresh((Object)att.getName());
            }
            catch (CacheException e) {
                if (e.getCause() instanceof DevFailed) {
                    throw (DevFailed)e.getCause();
                }
                throw DevFailedUtils.newDevFailed((Throwable)e.getCause());
            }
            catch (NoCacheFoundException e) {
                throw DevFailedUtils.newDevFailed((Throwable)e);
            }
        }
        this.checkPolling(objectName, cmd);
        try {
            this.cacheManager.getCommandCache(cmd).refresh((Object)cmd.getName());
        }
        catch (CacheException e) {
            if (e.getCause() instanceof DevFailed) {
                throw (DevFailed)e.getCause();
            }
            throw DevFailedUtils.newDevFailed((Throwable)e.getCause());
        }
    }

    private void checkPolling(String objectName, IPollable pollable) throws DevFailed {
        if (pollable.isPolled() && pollable.getPollingPeriod() > 0) {
            throw DevFailedUtils.newDevFailed((String)"API_NotSupported", (String)("Polled object " + objectName + " cannot be trigger externally"));
        }
        if (!pollable.isPolled()) {
            throw DevFailedUtils.newDevFailed((String)"API_PollObjNotFound", (String)("Polled object " + objectName + " not polled"));
        }
    }

    public void addCommandPolling(String commandName, int pollingPeriod) throws DevFailed {
        this.checkPollingLimits(commandName, pollingPeriod, this.minCommandPolling);
        CommandImpl command = CommandGetter.getCommand(commandName, this.commandList);
        if (!command.getName().equals("Init") && command.getInType().equals((Object)CommandTangoType.VOID)) {
            command.configurePolling(pollingPeriod);
            if (command.getName().equals("State") || command.getName().equals("Status")) {
                AttributeImpl attribute = AttributeGetterSetter.getAttribute(command.getName(), this.attributeList);
                attribute.configurePolling(pollingPeriod);
                this.pollAttributes.put(attribute.getName().toLowerCase(Locale.ENGLISH), pollingPeriod);
                this.cacheManager.startStateStatusPolling(command, attribute);
                this.pollAttributes.put(attribute.getName().toLowerCase(Locale.ENGLISH), pollingPeriod);
                this.savePollingConfig();
            } else {
                this.cacheManager.startCommandPolling(command);
            }
        }
    }

    private void checkPollingLimits(String commandName, int pollingPeriod, Map<String, Integer> minPollingValues) throws DevFailed {
        if (pollingPeriod != 0) {
            if (pollingPeriod < this.minPolling) {
                throw DevFailedUtils.newDevFailed((String)("min polling period is " + this.minPolling));
            }
            if (minPollingValues.containsKey(commandName.toLowerCase(Locale.ENGLISH)) && pollingPeriod < minPollingValues.get(commandName.toLowerCase(Locale.ENGLISH))) {
                throw DevFailedUtils.newDevFailed((String)("min polling period is " + this.minPolling));
            }
        }
    }

    public void stopPolling() {
        this.cacheManager.stop();
    }

    public void startPolling() {
        this.cacheManager.start();
    }

    public void addAttributePolling(String attributeName, int pollingPeriod) throws DevFailed {
        this.logger.debug("add {} polling with period {}", (Object)attributeName, (Object)pollingPeriod);
        this.checkPollingLimits(attributeName, pollingPeriod, this.minAttributePolling);
        AttributeImpl attribute = AttributeGetterSetter.getAttribute(attributeName, this.attributeList);
        if (attribute.getBehavior() instanceof ForwardedAttribute) {
            throw DevFailedUtils.newDevFailed((String)(attributeName + " not pollable because it is a forwarded attribute"));
        }
        attribute.configurePolling(pollingPeriod);
        if (attribute.getName().equals("State") || attribute.getName().equals("Status")) {
            CommandImpl cmd = CommandGetter.getCommand(attribute.getName(), this.commandList);
            cmd.configurePolling(pollingPeriod);
            this.cacheManager.startStateStatusPolling(cmd, attribute);
        } else {
            this.cacheManager.startAttributePolling(attribute);
        }
        this.pollAttributes.put(attributeName.toLowerCase(Locale.ENGLISH), pollingPeriod);
        this.savePollingConfig();
    }

    public void removeAttributePolling(String attributeName) throws DevFailed {
        AttributeImpl attribute = AttributeGetterSetter.getAttribute(attributeName, this.attributeList);
        attribute.resetPolling();
        this.cacheManager.removeAttributePolling(attribute);
        this.pollAttributes.remove(attributeName.toLowerCase(Locale.ENGLISH));
        if (attribute.getName().equals("State") || attribute.getName().equals("Status")) {
            CommandImpl cmd = CommandGetter.getCommand(attribute.getName(), this.commandList);
            cmd.resetPolling();
            this.cacheManager.removeCommandPolling(cmd);
        }
        this.savePollingConfig();
    }

    public void removeCommandPolling(String commandName) throws DevFailed {
        CommandImpl command = CommandGetter.getCommand(commandName, this.commandList);
        command.resetPolling();
        this.cacheManager.removeCommandPolling(command);
        if (command.getName().equals("State") || command.getName().equals("Status")) {
            AttributeImpl attribute = AttributeGetterSetter.getAttribute(command.getName(), this.attributeList);
            attribute.resetPolling();
            this.cacheManager.removeAttributePolling(attribute);
            this.pollAttributes.remove(command.getName().toLowerCase(Locale.ENGLISH));
            this.savePollingConfig();
        }
    }

    public void removeAll() {
        this.cacheManager.removeAll();
    }

    public Object getCommandCacheElement(CommandImpl cmd) throws DevFailed {
        Object ret;
        try {
            Element element = this.cacheManager.getCommandCache(cmd).get((Serializable)((Object)cmd.getName().toLowerCase(Locale.ENGLISH)));
            Serializable cmdValue = element.getValue();
            ret = cmdValue instanceof AttributeValue ? ((AttributeValue)cmdValue).getValue() : element.getValue();
        }
        catch (CacheException e) {
            if (e.getCause() instanceof DevFailed) {
                throw (DevFailed)e.getCause();
            }
            throw DevFailedUtils.newDevFailed((Throwable)e.getCause());
        }
        return ret;
    }

    public AttributeValue getAttributeCacheElement(AttributeImpl att) throws CacheException {
        try {
            Element element = this.cacheManager.getAttributeCache(att).get((Serializable)((Object)att.getName().toLowerCase(Locale.ENGLISH)));
            return (AttributeValue)element.getValue();
        }
        catch (NoCacheFoundException e) {
            return null;
        }
    }

    public void setPollRingDepth(int pollRingDepth) {
        this.pollRingDepth = pollRingDepth;
    }

    public void setPollAttributes(Map<String, Integer> pollAttributes) {
        this.pollAttributes = pollAttributes;
    }
}

