/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.cache;

import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import org.tango.server.PolledObjectConfig;
import org.tango.server.properties.AttributePropertiesManager;

public final class PollingUtils {
    private PollingUtils() {
    }

    public static void configurePolling(int pollingPeriod, PolledObjectConfig config, AttributePropertiesManager attributePropertiesManager) throws DevFailed {
        int unsignedPolling = Math.abs(pollingPeriod);
        config.setPolled(true);
        config.setPollingPeriod(unsignedPolling);
        attributePropertiesManager.setAttributePropertyInDB(config.getName(), "isPolled", "true");
        attributePropertiesManager.setAttributePropertyInDB(config.getName(), "pollingPeriod", Integer.toString(unsignedPolling));
    }

    public static void resetPolling(PolledObjectConfig config, AttributePropertiesManager attributePropertiesManager) throws DevFailed {
        config.setPolled(false);
        config.setPollingPeriod(0);
        attributePropertiesManager.setAttributePropertyInDB(config.getName(), "isPolled", "false");
        attributePropertiesManager.setAttributePropertyInDB(config.getName(), "pollingPeriod", "0");
    }

    public static void updatePollingConfigFromDB(PolledObjectConfig config, AttributePropertiesManager attributePropertiesManager) throws DevFailed {
        String isPolledProp = attributePropertiesManager.getAttributePropertyFromDB(config.getName(), "isPolled");
        if (!isPolledProp.isEmpty()) {
            config.setPolled(Boolean.valueOf(isPolledProp));
            String periodProp = attributePropertiesManager.getAttributePropertyFromDB(config.getName(), "pollingPeriod");
            if (!periodProp.isEmpty()) {
                config.setPollingPeriod(Integer.valueOf(periodProp));
            }
        }
    }

    public static String toString(DevFailed e) {
        StringBuilder buffer = new StringBuilder();
        if (e != null) {
            if (e.errors != null) {
                for (DevError error : e.errors) {
                    buffer.append("\tReason = ").append(error.reason).append("\n");
                    buffer.append("\tDesc = ").append(error.desc).append("\n");
                    buffer.append("\tOrigin = ").append(error.origin).append("\n");
                }
            } else {
                buffer.append("EMPTY DevFailed");
            }
        }
        return buffer.toString();
    }
}

