/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.cache;

import fr.esrf.Tango.DevFailed;
import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.management.MBeanServer;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.constructs.blocking.SelfPopulatingCache;
import net.sf.ehcache.management.ManagementService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tango.client.database.DatabaseFactory;
import org.tango.server.ServerManager;
import org.tango.server.attribute.AttributeImpl;
import org.tango.server.cache.AttributeCache;
import org.tango.server.cache.CommandCache;
import org.tango.server.cache.NoCacheFoundException;
import org.tango.server.cache.StateStatusCache;
import org.tango.server.cache.TangoCacheThreadFactory;
import org.tango.server.command.CommandImpl;
import org.tango.server.device.AroundInvokeImpl;
import org.tango.server.device.DeviceLocker;
import org.tango.server.properties.PropertiesUtils;

public final class TangoCacheManager {
    private static final String POLLING_THREADS_POOL_CONF = "polling_threads_pool_conf";
    private static final Logger LOGGER = LoggerFactory.getLogger(TangoCacheManager.class);
    private static final int POOL_SIZE = 1;
    private static volatile ScheduledExecutorService POLLING_POOL = new ScheduledThreadPoolExecutor(1, new TangoCacheThreadFactory());
    private static List<String> polledDevices = new LinkedList<String>();
    private static volatile CacheManager MANAGER;
    private static int poolSize;
    private static Map<String, TangoCacheManager> cacheList;
    private final Map<AttributeImpl, AttributeCache> attributeCacheMap = new HashMap<AttributeImpl, AttributeCache>();
    private final Map<CommandImpl, CommandCache> commandCacheMap = new HashMap<CommandImpl, CommandCache>();
    private final Map<AttributeImpl, AttributeCache> extTrigAttributeCacheMap = new HashMap<AttributeImpl, AttributeCache>();
    private final Map<CommandImpl, CommandCache> extTrigCommandCacheMap = new HashMap<CommandImpl, CommandCache>();
    private final DeviceLocker deviceLock;
    private final String deviceName;
    private final AroundInvokeImpl aroundInvoke;
    private StateStatusCache stateCache;
    private StateStatusCache statusCache;

    public TangoCacheManager(String deviceName, DeviceLocker deviceLock, AroundInvokeImpl aroundInvoke) {
        this.deviceLock = deviceLock;
        this.deviceName = deviceName;
        this.aroundInvoke = aroundInvoke;
        cacheList.put(deviceName, this);
    }

    private static void startCache() {
        Configuration config = new Configuration();
        config.setUpdateCheck(false);
        CacheConfiguration defaultCacheConfiguration = new CacheConfiguration();
        defaultCacheConfiguration.setDiskPersistent(false);
        defaultCacheConfiguration.setOverflowToDisk(false);
        defaultCacheConfiguration.setMaxElementsInMemory(1);
        config.setDefaultCacheConfiguration(defaultCacheConfiguration);
        MANAGER = CacheManager.create((Configuration)config);
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        ManagementService.registerMBeans((CacheManager)MANAGER, (MBeanServer)mBeanServer, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)true);
        TangoCacheManager.setPollSize(1);
    }

    public static void shutdown() {
        if (MANAGER != null) {
            MANAGER.shutdown();
            MANAGER = null;
        }
        if (POLLING_POOL != null) {
            POLLING_POOL.shutdownNow();
            POLLING_POOL = null;
        }
    }

    public static void initPoolConf() throws DevFailed {
        polledDevices.clear();
        Map<String, String[]> prop = PropertiesUtils.getDeviceProperties(ServerManager.getInstance().getAdminDeviceName());
        if (prop.containsKey(POLLING_THREADS_POOL_CONF)) {
            String[] pollingThreadsPoolConf = prop.get(POLLING_THREADS_POOL_CONF);
            for (int i = 0; i < pollingThreadsPoolConf.length; ++i) {
                if (!cacheList.containsKey(pollingThreadsPoolConf[i]) || pollingThreadsPoolConf[i].isEmpty() || polledDevices.contains(pollingThreadsPoolConf[i])) continue;
                polledDevices.add(pollingThreadsPoolConf[i]);
            }
        }
    }

    public static void setPollSize(int poolSize) {
        if (poolSize > 0) {
            TangoCacheManager.poolSize = poolSize;
            for (TangoCacheManager cache : cacheList.values()) {
                cache.stop();
            }
            if (POLLING_POOL != null) {
                POLLING_POOL.shutdownNow();
            }
            POLLING_POOL = new ScheduledThreadPoolExecutor(poolSize, new TangoCacheThreadFactory());
            for (TangoCacheManager cache : cacheList.values()) {
                cache.start();
            }
            LOGGER.debug("polling pool size is {}", (Object)poolSize);
        }
    }

    public static int getPoolSize() {
        return poolSize;
    }

    public static List<String> getPolledDevices() {
        return polledDevices;
    }

    private void updatePoolConf() throws DevFailed {
        if (!polledDevices.contains(this.deviceName)) {
            polledDevices.add(this.deviceName);
            HashMap<String, String[]> properties = new HashMap<String, String[]>();
            properties.put(POLLING_THREADS_POOL_CONF, polledDevices.toArray(new String[0]));
            DatabaseFactory.getDatabase().setDeviceProperties(ServerManager.getInstance().getAdminDeviceName(), properties);
        }
    }

    public synchronized void startStateStatusPolling(CommandImpl command, AttributeImpl attribute) {
        if (MANAGER == null) {
            TangoCacheManager.startCache();
        }
        if (command.getName().equalsIgnoreCase("State")) {
            if (this.stateCache != null) {
                this.stateCache.stopRefresh();
            }
            this.stateCache = new StateStatusCache(MANAGER, command, attribute, this.deviceName, this.deviceLock, this.aroundInvoke);
            if (command.getPollingPeriod() != 0) {
                this.stateCache.startRefresh(POLLING_POOL);
            }
        } else if (command.getName().equalsIgnoreCase("Status")) {
            if (this.statusCache != null) {
                this.statusCache.stopRefresh();
            }
            this.statusCache = new StateStatusCache(MANAGER, command, attribute, this.deviceName, this.deviceLock, this.aroundInvoke);
            if (command.getPollingPeriod() != 0) {
                this.statusCache.startRefresh(POLLING_POOL);
            }
        }
    }

    public synchronized void startCommandPolling(CommandImpl command) throws DevFailed {
        this.addCommandPolling(command);
        LOGGER.debug("starting command {} for polling on device {}", (Object)command.getName(), (Object)this.deviceName);
        if (command.getPollingPeriod() != 0) {
            this.commandCacheMap.get(command).startRefresh(POLLING_POOL);
        }
    }

    private void addCommandPolling(CommandImpl command) throws DevFailed {
        if (MANAGER == null) {
            TangoCacheManager.startCache();
        }
        this.removeCommandPolling(command);
        CommandCache cache = new CommandCache(MANAGER, command, this.deviceName, this.deviceLock, this.aroundInvoke);
        if (command.getPollingPeriod() == 0) {
            this.extTrigCommandCacheMap.put(command, cache);
        } else {
            this.commandCacheMap.put(command, cache);
        }
        this.updatePoolConf();
    }

    public synchronized void startAttributePolling(AttributeImpl attr) throws DevFailed {
        this.addAttributePolling(attr);
        LOGGER.debug("starting attribute {} for polling on device {}", (Object)attr.getName(), (Object)this.deviceName);
        if (attr.getPollingPeriod() != 0) {
            this.attributeCacheMap.get(attr).startRefresh(POLLING_POOL);
        }
    }

    private void addAttributePolling(AttributeImpl attr) throws DevFailed {
        if (MANAGER == null) {
            TangoCacheManager.startCache();
        }
        this.removeAttributePolling(attr);
        AttributeCache cache = new AttributeCache(MANAGER, attr, this.deviceName, this.deviceLock, this.aroundInvoke);
        if (attr.getPollingPeriod() == 0) {
            this.extTrigAttributeCacheMap.put(attr, cache);
        } else {
            this.attributeCacheMap.put(attr, cache);
        }
        this.updatePoolConf();
    }

    public synchronized void removeAttributePolling(AttributeImpl attr) throws DevFailed {
        if (this.attributeCacheMap.containsKey(attr)) {
            AttributeCache cache = this.attributeCacheMap.get(attr);
            cache.stopRefresh();
            this.attributeCacheMap.remove(attr);
        } else if (this.extTrigAttributeCacheMap.containsKey(attr)) {
            this.extTrigAttributeCacheMap.remove(attr);
        } else if (attr.getName().equalsIgnoreCase("State") && this.stateCache != null) {
            this.stateCache.stopRefresh();
            this.stateCache = null;
        } else if (attr.getName().equalsIgnoreCase("Status") && this.statusCache != null) {
            this.statusCache.stopRefresh();
            this.statusCache = null;
        }
    }

    public synchronized void removeAll() {
        for (AttributeCache attributeCache : this.attributeCacheMap.values()) {
            attributeCache.stopRefresh();
        }
        this.attributeCacheMap.clear();
        this.extTrigAttributeCacheMap.clear();
        for (CommandCache commandCache : this.commandCacheMap.values()) {
            commandCache.stopRefresh();
        }
        this.commandCacheMap.clear();
        this.extTrigCommandCacheMap.clear();
        if (this.stateCache != null) {
            this.stateCache.stopRefresh();
            this.stateCache = null;
        }
        if (this.statusCache != null) {
            this.statusCache.stopRefresh();
            this.statusCache = null;
        }
        cacheList.remove(this.deviceName);
    }

    public synchronized void removeCommandPolling(CommandImpl command) throws DevFailed {
        if (this.commandCacheMap.containsKey(command)) {
            CommandCache cache = this.commandCacheMap.get(command);
            cache.stopRefresh();
            this.commandCacheMap.remove(command);
        } else if (this.extTrigCommandCacheMap.containsKey(command)) {
            this.extTrigCommandCacheMap.remove(command);
        } else if (command.getName().equalsIgnoreCase("State") && this.stateCache != null) {
            this.stateCache.stopRefresh();
            this.stateCache = null;
        } else if (command.getName().equalsIgnoreCase("Status") && this.statusCache != null) {
            this.statusCache.stopRefresh();
            this.statusCache = null;
        }
    }

    public synchronized void start() {
        for (AttributeCache attributeCache : this.attributeCacheMap.values()) {
            attributeCache.startRefresh(POLLING_POOL);
        }
        for (CommandCache commandCache : this.commandCacheMap.values()) {
            commandCache.startRefresh(POLLING_POOL);
        }
        if (this.stateCache != null) {
            this.stateCache.startRefresh(POLLING_POOL);
        }
        if (this.statusCache != null) {
            this.statusCache.startRefresh(POLLING_POOL);
        }
    }

    public synchronized void stop() {
        for (AttributeCache attributeCache : this.attributeCacheMap.values()) {
            attributeCache.stopRefresh();
        }
        for (CommandCache commandCache : this.commandCacheMap.values()) {
            commandCache.stopRefresh();
        }
        if (this.stateCache != null) {
            this.stateCache.stopRefresh();
        }
        if (this.statusCache != null) {
            this.statusCache.stopRefresh();
        }
        if (POLLING_POOL != null) {
            POLLING_POOL.shutdownNow();
            POLLING_POOL = new ScheduledThreadPoolExecutor(poolSize, new TangoCacheThreadFactory());
        }
    }

    public synchronized SelfPopulatingCache getAttributeCache(AttributeImpl attr) throws NoCacheFoundException {
        if (attr.getName().equalsIgnoreCase("State")) {
            return this.stateCache.getCache();
        }
        if (attr.getName().equalsIgnoreCase("Status")) {
            return this.statusCache.getCache();
        }
        return this.tryGetAttributeCache(attr);
    }

    private SelfPopulatingCache tryGetAttributeCache(AttributeImpl attr) throws NoCacheFoundException {
        AttributeCache attrCache = this.attributeCacheMap.get(attr);
        if (attrCache == null && (attrCache = this.extTrigAttributeCacheMap.get(attr)) == null) {
            throw new NoCacheFoundException("No cache found for " + attr.getName());
        }
        return attrCache.getCache();
    }

    public synchronized SelfPopulatingCache getCommandCache(CommandImpl cmd) {
        SelfPopulatingCache cache = null;
        if (cmd.getName().equalsIgnoreCase("State")) {
            cache = this.stateCache.getCache();
        } else if (cmd.getName().equalsIgnoreCase("Status")) {
            cache = this.statusCache.getCache();
        } else {
            CommandCache cmdCache = this.commandCacheMap.get(cmd);
            if (cmdCache == null) {
                cmdCache = this.extTrigCommandCacheMap.get(cmd);
            }
            cache = cmdCache.getCache();
        }
        return cache;
    }

    static {
        poolSize = 1;
        cacheList = new HashMap<String, TangoCacheManager>();
    }
}

