/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.command;

import fr.esrf.Tango.AttributeDim;
import fr.esrf.Tango.DevCmdHistory_4;
import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.EltInArray;
import fr.esrf.Tango.TimeVal;
import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tango.orb.ORBManager;
import org.tango.server.idl.CleverAnyCommand;
import org.tango.server.idl.TangoIDLUtil;
import org.tango.utils.ArrayUtils;

public final class CommandHistory {
    private final Logger logger = LoggerFactory.getLogger(CommandHistory.class);
    private static final Map<Integer, Integer> SCALAR_TO_ARRAY = new HashMap<Integer, Integer>();
    private final Deque<HistoryItem> commandHistory = new ArrayDeque<HistoryItem>(100);
    private final int type;
    private int maxSize = 10;

    public CommandHistory(int type) {
        this.type = type;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public synchronized void addToHistory(Object value, DevError[] error) throws DevFailed {
        while (this.commandHistory.size() >= this.maxSize - 1) {
            this.commandHistory.poll();
        }
        boolean isInserted = this.commandHistory.offer(new HistoryItem(value, System.currentTimeMillis(), error));
        if (!isInserted) {
            this.logger.debug("{} not inserted in command history queue ", value);
        }
    }

    public synchronized int size() {
        return this.commandHistory.size();
    }

    public synchronized void clear() {
        this.commandHistory.clear();
    }

    public synchronized DevCmdHistory_4 toDevCmdHistory4(int maxSize) throws DevFailed {
        DevCmdHistory_4 history = new DevCmdHistory_4();
        if (!this.commandHistory.isEmpty()) {
            HistoryItem[] returnedhistoryArray = this.createHistoryArray(maxSize);
            TimeVal[] times = new TimeVal[returnedhistoryArray.length];
            LinkedList<AttributeDim> dim = new LinkedList<AttributeDim>();
            LinkedList<EltInArray> dimSize = new LinkedList<EltInArray>();
            LinkedList<DevError[]> errors = new LinkedList<DevError[]>();
            LinkedList<EltInArray> errorsArray = new LinkedList<EltInArray>();
            Object array = this.fillHistoryArray(returnedhistoryArray, times, dim, dimSize, errors, errorsArray);
            history.errors_array = errorsArray.toArray(new EltInArray[0]);
            history.errors = (DevError[][])errors.toArray((T[])new DevError[0][0]);
            history.cmd_type = this.type;
            history.dates = times;
            history.dims = dim.toArray(new AttributeDim[0]);
            history.dims_array = dimSize.toArray(new EltInArray[0]);
            history.value = this.type != 0 ? CleverAnyCommand.set(SCALAR_TO_ARRAY.get(this.type), array) : ORBManager.createAny();
        } else {
            history.errors_array = new EltInArray[0];
            history.errors = new DevError[0][0];
            history.cmd_type = this.type;
            history.dates = new TimeVal[0];
            history.dims = new AttributeDim[0];
            history.dims_array = new EltInArray[0];
            history.value = ORBManager.createAny();
        }
        return history;
    }

    private Object fillHistoryArray(HistoryItem[] returnedhistoryArray, TimeVal[] times, Deque<AttributeDim> dim, Deque<EltInArray> dimSize, Deque<DevError[]> errors, Deque<EltInArray> errorsArray) {
        int i = 0;
        Object array = null;
        for (HistoryItem item : returnedhistoryArray) {
            times[i++] = item.getDate();
            Object value = item.getValue();
            int dimX = 1;
            if (value == null) {
                dimX = 0;
            } else if (value.getClass().isArray()) {
                dimX = Array.getLength(value);
                array = ArrayUtils.addAll((Object)value, (Object)array);
            } else {
                array = ArrayUtils.addAll((Object)value, array);
            }
            if (item.getError() != null && item.getError().length != 0) {
                errors.add(item.getError());
                errorsArray.add(new EltInArray(i - 1, 1));
            }
            if (dim.isEmpty() || !dim.isEmpty() && dimX != dim.getLast().dim_x) {
                dimSize.add(new EltInArray(i - 1, 1));
                dim.add(new AttributeDim(dimX, 1));
                continue;
            }
            ++dimSize.getLast().nb_elt;
            ++dimSize.getLast().start;
        }
        return array;
    }

    private HistoryItem[] createHistoryArray(int maxSize) {
        HistoryItem[] returnedhistoryArray;
        HistoryItem[] historyArray = Collections.asLifoQueue(this.commandHistory).toArray(new HistoryItem[this.commandHistory.size()]);
        if (this.commandHistory.size() > maxSize) {
            returnedhistoryArray = new HistoryItem[maxSize];
            System.arraycopy(historyArray, historyArray.length - maxSize, returnedhistoryArray, 0, returnedhistoryArray.length);
        } else {
            returnedhistoryArray = historyArray;
        }
        return returnedhistoryArray;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    static {
        SCALAR_TO_ARRAY.put(1, 1);
        SCALAR_TO_ARRAY.put(2, 10);
        SCALAR_TO_ARRAY.put(3, 11);
        SCALAR_TO_ARRAY.put(4, 12);
        SCALAR_TO_ARRAY.put(5, 13);
        SCALAR_TO_ARRAY.put(6, 14);
        SCALAR_TO_ARRAY.put(7, 15);
        SCALAR_TO_ARRAY.put(8, 16);
        SCALAR_TO_ARRAY.put(23, 25);
        SCALAR_TO_ARRAY.put(24, 26);
        SCALAR_TO_ARRAY.put(21, 9);
        SCALAR_TO_ARRAY.put(17, 17);
        SCALAR_TO_ARRAY.put(18, 18);
        SCALAR_TO_ARRAY.put(19, 19);
        SCALAR_TO_ARRAY.put(20, 20);
        SCALAR_TO_ARRAY.put(22, 22);
        SCALAR_TO_ARRAY.put(27, 27);
        SCALAR_TO_ARRAY.put(28, 28);
        SCALAR_TO_ARRAY.put(10, 10);
        SCALAR_TO_ARRAY.put(11, 11);
        SCALAR_TO_ARRAY.put(12, 12);
        SCALAR_TO_ARRAY.put(13, 13);
        SCALAR_TO_ARRAY.put(14, 14);
        SCALAR_TO_ARRAY.put(15, 15);
        SCALAR_TO_ARRAY.put(16, 16);
        SCALAR_TO_ARRAY.put(25, 25);
        SCALAR_TO_ARRAY.put(26, 26);
        SCALAR_TO_ARRAY.put(9, 9);
    }

    private static class HistoryItem {
        private final TimeVal date;
        private final Object value;
        private final DevError[] error;

        public HistoryItem(Object value, long date, DevError[] error) throws DevFailed {
            this.value = value;
            this.date = TangoIDLUtil.getTime(date);
            this.error = Arrays.copyOf(error, error.length);
        }

        public TimeVal getDate() {
            return this.date;
        }

        public Object getValue() {
            return this.value;
        }

        public DevError[] getError() {
            return this.error;
        }
    }
}

