/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.device;

import java.util.HashMap;
import java.util.Map;
import org.tango.server.annotation.TransactionType;

public final class DeviceLocker {
    private final Object attributeLock;
    private final Object commandLock;
    private static final Object SERVER_LOCK = new Object();
    private static final Map<Class<?>, Object> CLASS_LOCKS = new HashMap();
    private final TransactionType txType;

    public DeviceLocker(TransactionType txType, Class<?> deviceClass) {
        this.txType = txType;
        switch (txType) {
            case DEVICE: {
                this.commandLock = this.attributeLock = new Object();
                break;
            }
            case ATTRIBUTE: {
                this.attributeLock = new Object();
                this.commandLock = null;
                break;
            }
            case COMMAND: {
                this.commandLock = new Object();
                this.attributeLock = null;
                break;
            }
            case CLASS: {
                if (CLASS_LOCKS.containsKey(deviceClass)) {
                    this.attributeLock = this.commandLock = CLASS_LOCKS.get(deviceClass);
                    break;
                }
                this.attributeLock = this.commandLock = new Object();
                CLASS_LOCKS.put(deviceClass, this.commandLock);
                break;
            }
            case SERVER: {
                this.attributeLock = SERVER_LOCK;
                this.commandLock = SERVER_LOCK;
                break;
            }
            case ATTRIBUTE_COMMAND: {
                this.attributeLock = new Object();
                this.commandLock = new Object();
                break;
            }
            default: {
                this.attributeLock = null;
                this.commandLock = null;
            }
        }
    }

    public Object getAttributeLock() {
        return this.attributeLock;
    }

    public Object getCommandLock() {
        return this.commandLock;
    }

    public TransactionType getTxType() {
        return this.txType;
    }
}

