/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.device;

import fr.esrf.Tango.DevFailed;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.tango.DeviceState;
import org.tango.server.DeviceBehaviorObject;
import org.tango.server.cache.PollingManager;
import org.tango.server.device.StateImpl;
import org.tango.server.device.StatusImpl;
import org.tango.utils.DevFailedUtils;

public final class InitImpl
extends DeviceBehaviorObject {
    private final Logger logger = LoggerFactory.getLogger(InitImpl.class);
    private final Method initMethod;
    private final boolean isLazy;
    private final Object businessObject;
    private final ExecutorService executor;
    private Future<Void> future;
    private final AtomicBoolean isInitDoneCorrectly = new AtomicBoolean(false);
    private PollingManager pollingManager;
    private final Map<String, String> contextMap = MDC.getCopyOfContextMap();

    public void setPollingManager(PollingManager pollingManager) {
        this.pollingManager = pollingManager;
    }

    public InitImpl(String deviceName, Method initMethod, boolean isLazy, Object businessObject, PollingManager pollingManager) {
        this.initMethod = initMethod;
        this.isLazy = isLazy;
        this.businessObject = businessObject;
        this.pollingManager = pollingManager;
        this.executor = Executors.newSingleThreadExecutor(new ThreadFact(deviceName));
    }

    public synchronized void execute(final StateImpl stateImpl, final StatusImpl statusImpl) {
        if (this.isLazy && !this.isInitInProgress()) {
            Callable<Void> initRunnable = new Callable<Void>(){

                @Override
                public Void call() throws DevFailed {
                    InitImpl.this.logger.debug("Lazy init in");
                    MDC.setContextMap((Map)InitImpl.this.contextMap);
                    InitImpl.this.doInit(stateImpl, statusImpl);
                    InitImpl.this.logger.debug("Lazy init out");
                    return null;
                }
            };
            this.future = this.executor.submit(initRunnable);
        } else {
            this.doInit(stateImpl, statusImpl);
        }
    }

    public boolean isInitInProgress() {
        boolean isInitInProgress = false;
        if (this.future != null) {
            isInitInProgress = !this.future.isDone();
        }
        return isInitInProgress;
    }

    public boolean isInitDoneCorrectly() {
        return this.isInitDoneCorrectly.get();
    }

    private void doInit(StateImpl stateImpl, StatusImpl statusImpl) {
        this.isInitDoneCorrectly.set(false);
        try {
            if (this.initMethod != null) {
                stateImpl.stateMachine(DeviceState.INIT);
                statusImpl.statusMachine("Init in progress", DeviceState.INIT);
                this.initMethod.invoke(this.businessObject, new Object[0]);
                if (this.getEndState() != null) {
                    stateImpl.stateMachine(this.getEndState());
                } else if (stateImpl.isDefaultState()) {
                    stateImpl.stateMachine(DeviceState.UNKNOWN);
                }
            }
            this.pollingManager.initPolling();
            this.isInitDoneCorrectly.set(true);
        }
        catch (IllegalArgumentException e) {
            this.manageError(stateImpl, statusImpl, e);
        }
        catch (IllegalAccessException e) {
            this.manageError(stateImpl, statusImpl, e);
        }
        catch (InvocationTargetException e) {
            this.manageInitError(stateImpl, statusImpl, e);
        }
        catch (DevFailed e) {
            this.logger.error("Init failed", (Throwable)e);
            try {
                stateImpl.stateMachine(DeviceState.FAULT);
                statusImpl.statusMachine(DevFailedUtils.toString((DevFailed)e), DeviceState.FAULT);
            }
            catch (DevFailed e1) {
                this.logger.debug(DevFailedUtils.toString((DevFailed)e1));
            }
        }
    }

    private void manageInitError(StateImpl stateImpl, StatusImpl statusImpl, InvocationTargetException e) {
        try {
            this.logger.error("Init failed", e.getCause());
            stateImpl.stateMachine(DeviceState.FAULT);
            if (e.getCause() instanceof DevFailed) {
                this.logger.error("Tango error at Init: {}", (Object)DevFailedUtils.toString((DevFailed)((DevFailed)e.getCause())));
                statusImpl.statusMachine("Init failed: " + DevFailedUtils.toString((DevFailed)((DevFailed)e.getCause())), DeviceState.FAULT);
            } else {
                StringWriter sw = new StringWriter();
                e.getCause().printStackTrace(new PrintWriter(sw));
                String stacktrace = sw.toString();
                statusImpl.statusMachine("Init failed: " + stacktrace, DeviceState.FAULT);
            }
        }
        catch (DevFailed e1) {
            this.logger.error(DevFailedUtils.toString((DevFailed)e1));
        }
    }

    private void manageError(StateImpl stateImpl, StatusImpl statusImpl, Exception e) {
        try {
            stateImpl.stateMachine(DeviceState.FAULT);
            StringWriter sw = new StringWriter();
            if (e.getCause() != null) {
                e.getCause().printStackTrace(new PrintWriter(sw));
            } else {
                e.printStackTrace(new PrintWriter(sw));
            }
            String stacktrace = sw.toString();
            statusImpl.statusMachine(stacktrace, DeviceState.FAULT);
        }
        catch (DevFailed e1) {
            this.logger.debug(DevFailedUtils.toString((DevFailed)e1));
        }
    }

    @Override
    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("name", (Object)this.initMethod);
        builder.append("device class", this.businessObject.getClass());
        return builder.toString();
    }

    private static class ThreadFact
    implements ThreadFactory {
        private final String name;

        ThreadFact(String name) {
            this.name = name;
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, this.name + " Init");
        }
    }
}

