/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.dynamic.attribute;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.AttributeInfo;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.soleil.tango.clientapi.InsertExtractUtils;
import fr.soleil.tango.clientapi.TangoGroupAttribute;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.math3.stat.StatUtils;
import org.tango.server.StateMachineBehavior;
import org.tango.server.attribute.AttributeConfiguration;
import org.tango.server.attribute.AttributePropertiesImpl;
import org.tango.server.attribute.AttributeValue;
import org.tango.server.attribute.IAttributeBehavior;
import org.tango.utils.DevFailedUtils;
import org.tango.utils.TangoUtil;

public class GroupAttribute
implements IAttributeBehavior {
    private final String name;
    private final TangoGroupAttribute attributeGroup;
    private final String[] attributeNames;
    private final boolean isExternalRead;
    private AttrDataFormat attributeFormat = AttrDataFormat.SCALAR;
    private AttrWriteType attributeWritable = AttrWriteType.READ;
    private DeviceAttribute[] readValues;
    private boolean isMean = true;

    public GroupAttribute(String groupAttributeName, boolean isExternalRead, String ... attributeNames) throws DevFailed {
        this.name = groupAttributeName;
        this.attributeNames = attributeNames;
        this.isExternalRead = isExternalRead;
        this.attributeGroup = new TangoGroupAttribute(attributeNames);
        this.attributeWritable = AttrWriteType.READ;
        this.init();
    }

    public GroupAttribute(String groupAttributeName, boolean isExternalRead, boolean isMean, String ... attributeNames) throws DevFailed {
        this.isMean = isMean;
        this.name = groupAttributeName;
        this.attributeNames = attributeNames;
        this.isExternalRead = isExternalRead;
        this.attributeGroup = new TangoGroupAttribute(attributeNames);
        this.attributeWritable = AttrWriteType.READ;
        this.init();
    }

    private void init() throws DevFailed {
        AttrDataFormat firstAttributeFormat = AttrDataFormat.SCALAR;
        for (int i = 0; i < this.attributeNames.length; ++i) {
            String attributeName = TangoUtil.getAttributeName((String)this.attributeNames[i]);
            if (attributeName == null) {
                throw DevFailedUtils.newDevFailed((String)("cannot retrieve " + this.attributeNames[i]));
            }
            AttributeInfo info = this.attributeGroup.getGroup().getDevice(this.attributeNames[i]).get_attribute_info(attributeName);
            if (info.data_type == 8) {
                throw DevFailedUtils.newDevFailed((String)(this.attributeNames[i] + " is a String, not supported"));
            }
            if (i == 0) {
                firstAttributeFormat = info.data_format;
                continue;
            }
            if (!info.data_format.equals(firstAttributeFormat)) {
                throw DevFailedUtils.newDevFailed((String)"All attributes must have the same format");
            }
            if (!this.isMean || info.writable.equals(AttrWriteType.READ)) continue;
            this.attributeWritable = AttrWriteType.READ_WRITE;
        }
        if (this.isMean) {
            this.attributeFormat = firstAttributeFormat;
        } else if (firstAttributeFormat.equals(AttrDataFormat.SCALAR)) {
            this.attributeFormat = AttrDataFormat.SPECTRUM;
        } else if (firstAttributeFormat.equals(AttrDataFormat.SPECTRUM)) {
            this.attributeFormat = AttrDataFormat.IMAGE;
        } else {
            throw DevFailedUtils.newDevFailed((String)"image format not supported");
        }
    }

    @Override
    public AttributeConfiguration getConfiguration() throws DevFailed {
        AttributeConfiguration config = new AttributeConfiguration();
        config.setName(this.name);
        config.setTangoType(5, this.attributeFormat);
        config.setWritable(this.attributeWritable);
        AttributePropertiesImpl props = new AttributePropertiesImpl();
        if (this.isMean) {
            props.setDescription("manage attributes: " + Arrays.toString(this.attributeNames) + "\nread part: average for scalars, write part: write on all writable attributes");
        } else {
            props.setDescription("read attributes: " + Arrays.toString(this.attributeNames));
        }
        config.setAttributeProperties(props);
        return config;
    }

    public void setReadValue(DeviceAttribute[] readValues) {
        this.readValues = Arrays.copyOf(readValues, readValues.length);
    }

    @Override
    public AttributeValue getValue() throws DevFailed {
        AttributeValue value = null;
        DeviceAttribute[] result = this.isExternalRead ? this.readValues : this.attributeGroup.read();
        if (this.attributeFormat.equals(AttrDataFormat.SCALAR)) {
            double[] data = new double[result.length];
            for (int i = 0; i < result.length; ++i) {
                data[i] = (Double)InsertExtractUtils.extractRead((DeviceAttribute)result[i], (AttrDataFormat)AttrDataFormat.SCALAR, Double.TYPE);
            }
            value = this.isMean ? new AttributeValue(StatUtils.mean((double[])data)) : new AttributeValue(data);
        } else {
            LinkedList<double[]> values = new LinkedList<double[]>();
            int maxLength = 0;
            int maxDimX = 0;
            int maxDimY = 0;
            for (DeviceAttribute element : result) {
                double[] data = (double[])InsertExtractUtils.extractRead((DeviceAttribute)element, (AttrDataFormat)AttrDataFormat.SPECTRUM, double[].class);
                values.add(data);
                if (data.length > maxLength) {
                    maxLength = data.length;
                }
                if (element.getDimX() > maxDimX) {
                    maxDimX = element.getDimX();
                }
                if (element.getDimY() <= maxDimY) continue;
                maxDimY = element.getDimY();
            }
            double[][] array = new double[maxLength][this.attributeNames.length];
            for (int i = 0; i < this.attributeNames.length; ++i) {
                double[] attrValue;
                double[] totalArray = attrValue = (double[])values.get(i);
                if (attrValue.length < maxLength) {
                    double[] fillArray = new double[maxLength - attrValue.length];
                    Arrays.fill(fillArray, 0.0);
                    totalArray = ArrayUtils.addAll((double[])attrValue, (double[])fillArray);
                }
                for (int x = 0; x < maxLength; ++x) {
                    array[x][i] = totalArray[x];
                }
            }
            if (this.isMean) {
                double[] avg = new double[maxLength];
                for (int i = 0; i < array.length; ++i) {
                    avg[i] = StatUtils.mean((double[])array[i]);
                }
                if (this.attributeFormat.equals(AttrDataFormat.SPECTRUM)) {
                    value = new AttributeValue(avg);
                } else {
                    value = new AttributeValue(avg);
                    value.setXDim(maxDimX);
                    value.setYDim(maxDimY);
                }
            } else {
                value = new AttributeValue(array);
            }
        }
        return value;
    }

    @Override
    public void setValue(AttributeValue value) throws DevFailed {
        this.attributeGroup.write(value.getValue());
    }

    @Override
    public StateMachineBehavior getStateMachine() throws DevFailed {
        return null;
    }
}

