/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.dynamic.attribute;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceProxy;
import fr.soleil.tango.clientapi.InsertExtractUtils;
import org.tango.server.attribute.AttributeValue;
import org.tango.server.attribute.IAttributeBehavior;
import org.tango.server.dynamic.DynamicManager;
import org.tango.server.dynamic.attribute.ProxyAttribute;

public final class MultiAttributeProxy {
    private final DeviceProxy device;
    private final DynamicManager dynamicManager;

    public MultiAttributeProxy(DeviceProxy device, DynamicManager dynamicManager) {
        this.device = device;
        this.dynamicManager = dynamicManager;
    }

    public AttributeValue[] readAttributes(String ... attnames) throws DevFailed {
        AttributeValue[] result = new AttributeValue[attnames.length];
        DeviceAttribute[] da = this.device.read_attribute(attnames);
        int i = 0;
        for (DeviceAttribute deviceAttribute : da) {
            AttrDataFormat format = this.device.get_attribute_info((String)attnames[i]).data_format;
            Object value = InsertExtractUtils.extractRead((DeviceAttribute)deviceAttribute, (AttrDataFormat)format);
            IAttributeBehavior attribute = this.dynamicManager.getAttribute(deviceAttribute.getName());
            AttributeValue attrVal = new AttributeValue(value, deviceAttribute.getQuality());
            attrVal.setTime(deviceAttribute.getTime());
            if (attribute instanceof ProxyAttribute) {
                ((ProxyAttribute)attribute).setReadValue(attrVal);
            }
            result[i++] = attrVal;
        }
        return result;
    }
}

