/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.dynamic.attribute;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.DevFailed;
import fr.soleil.tango.clientapi.TangoAttribute;
import org.tango.server.StateMachineBehavior;
import org.tango.server.attribute.AttributeConfiguration;
import org.tango.server.attribute.AttributeValue;
import org.tango.server.attribute.IAttributeBehavior;
import org.tango.server.attribute.ISetValueUpdater;
import org.tango.server.dynamic.attribute.TangoConverter;
import org.tango.utils.DevFailedUtils;

public final class ProxyAttribute
implements IAttributeBehavior,
ISetValueUpdater {
    private final StateMachineBehavior smb = new StateMachineBehavior();
    private final AttributeConfiguration ac;
    private AttributeValue readValue = new AttributeValue();
    private final TangoAttribute proxy;
    private final boolean isReadyOnly;
    private boolean autoUpdate = true;

    public ProxyAttribute(String attributeName, String attributeProxyName, boolean isReadyOnly) throws DevFailed {
        this.isReadyOnly = isReadyOnly;
        this.proxy = new TangoAttribute(attributeProxyName);
        this.ac = TangoConverter.toAttributeConfiguration(this.proxy.getAttributeProxy().get_info());
        int type = this.ac.getTangoType();
        AttrDataFormat format = this.ac.getFormat();
        if (type == 22) {
            this.ac.setTangoType(2, format);
        } else if (type == 6) {
            this.ac.setTangoType(3, format);
        } else if (type == 7) {
            this.ac.setTangoType(23, format);
        }
        this.ac.getAttributeProperties().setDescription("Proxied from " + attributeProxyName);
        this.ac.setName(attributeName);
        if (isReadyOnly) {
            this.ac.setWritable(AttrWriteType.READ);
        }
    }

    public ProxyAttribute(String attributeName, String attributeProxyName, boolean isReadyOnly, boolean autoUpdate) throws DevFailed {
        this(attributeName, attributeProxyName, isReadyOnly);
        this.autoUpdate = autoUpdate;
    }

    @Override
    public AttributeValue getValue() throws DevFailed {
        if (this.autoUpdate) {
            this.readValue.setValue(this.proxy.read());
            this.readValue.setQuality(this.proxy.getDeviceAttribute().getQuality());
            this.readValue.setTime(this.proxy.getTimestamp());
        }
        return this.readValue;
    }

    @Override
    public void setValue(AttributeValue value) throws DevFailed {
        if (this.isReadyOnly) {
            throw DevFailedUtils.newDevFailed((String)"SECURITY_ERROR", (String)"it not allowed to write this attribute");
        }
        this.proxy.write(value.getValue());
    }

    @Override
    public AttributeConfiguration getConfiguration() {
        return this.ac;
    }

    @Override
    public StateMachineBehavior getStateMachine() {
        return this.smb;
    }

    public void setReadValue(AttributeValue readValue) {
        this.readValue = readValue;
    }

    @Override
    public AttributeValue getSetValue() throws DevFailed {
        AttributeValue value = new AttributeValue();
        this.proxy.update();
        value.setValue(this.proxy.extractWritten());
        return value;
    }
}

