/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.dynamic.attribute;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.DevEncoded;
import fr.esrf.Tango.DevFailed;
import java.util.HashMap;
import java.util.Map;
import org.tango.DeviceState;
import org.tango.server.StateMachineBehavior;
import org.tango.server.attribute.AttributeConfiguration;
import org.tango.server.attribute.AttributePropertiesImpl;
import org.tango.server.attribute.AttributeValue;
import org.tango.server.attribute.IAttributeBehavior;
import org.tango.server.attribute.ISetValueUpdater;
import org.tango.utils.DevFailedUtils;
import org.tango.utils.TangoTypeUtils;

public final class PublisherAttribute
implements IAttributeBehavior,
ISetValueUpdater {
    private static final Map<String, Class<?>> JAVA_TYPES_MAP = new HashMap();
    private final AttributeConfiguration configAttr = new AttributeConfiguration();
    private AttributeValue value;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PublisherAttribute(String ... config) throws DevFailed {
        if (config.length < 1) {
            this.configAttr.setName("");
            throw DevFailedUtils.newDevFailed((String)"DEVICE_PROP_ERROR", (String)"unknown attribute config");
        }
        this.configAttr.setName(config[0]);
        if (config.length == 2) {
            Class<?> c = JAVA_TYPES_MAP.get(config[1].toLowerCase());
            this.configAttr.setType(c);
            return;
        }
        if (config.length < 3) throw DevFailedUtils.newDevFailed((String)"DEVICE_PROP_ERROR", (String)"unknown attribute config");
        int typeAttr = 0;
        try {
            typeAttr = Integer.parseInt(config[1]);
        }
        catch (NumberFormatException e) {
            typeAttr = TangoTypeUtils.getAttributeType((String)config[1]);
        }
        if (config[2].equalsIgnoreCase("SCALAR")) {
            this.configAttr.setTangoType(typeAttr, AttrDataFormat.SCALAR);
            return;
        } else if (config[2].equalsIgnoreCase("SPECTRUM")) {
            this.configAttr.setTangoType(typeAttr, AttrDataFormat.SPECTRUM);
            return;
        } else {
            if (!config[2].equalsIgnoreCase("IMAGE")) throw DevFailedUtils.newDevFailed((String)"DEVICE_PROP_ERROR", (String)("unknown attribute format: " + config[1]));
            this.configAttr.setTangoType(typeAttr, AttrDataFormat.IMAGE);
        }
    }

    @Override
    public AttributeConfiguration getConfiguration() throws DevFailed {
        this.configAttr.setWritable(AttrWriteType.WRITE);
        this.configAttr.setMemorized(true);
        AttributePropertiesImpl prop = new AttributePropertiesImpl();
        prop.setLabel(this.configAttr.getName());
        this.configAttr.setAttributeProperties(prop);
        return this.configAttr;
    }

    @Override
    public AttributeValue getValue() throws DevFailed {
        return null;
    }

    @Override
    public void setValue(AttributeValue value) throws DevFailed {
        this.value = value;
    }

    @Override
    public StateMachineBehavior getStateMachine() {
        return null;
    }

    @Override
    public AttributeValue getSetValue() throws DevFailed {
        if (this.value != null) {
            this.value.setTime(System.currentTimeMillis());
        }
        return this.value;
    }

    static {
        JAVA_TYPES_MAP.put("int", Integer.TYPE);
        JAVA_TYPES_MAP.put("long", Long.TYPE);
        JAVA_TYPES_MAP.put("double", Double.TYPE);
        JAVA_TYPES_MAP.put("float", Float.TYPE);
        JAVA_TYPES_MAP.put("boolean", Boolean.TYPE);
        JAVA_TYPES_MAP.put("byte", Byte.TYPE);
        JAVA_TYPES_MAP.put("short", Short.TYPE);
        JAVA_TYPES_MAP.put("string", String.class);
        JAVA_TYPES_MAP.put("devstate", DeviceState.class);
        JAVA_TYPES_MAP.put("state", DeviceState.class);
        JAVA_TYPES_MAP.put("devencoded", DevEncoded.class);
        JAVA_TYPES_MAP.put("int[]", int[].class);
        JAVA_TYPES_MAP.put("long[]", long[].class);
        JAVA_TYPES_MAP.put("double[]", double[].class);
        JAVA_TYPES_MAP.put("float[]", float[].class);
        JAVA_TYPES_MAP.put("boolean[]", boolean[].class);
        JAVA_TYPES_MAP.put("byte[]", byte[].class);
        JAVA_TYPES_MAP.put("short[]", short[].class);
        JAVA_TYPES_MAP.put("string[]", String[].class);
        JAVA_TYPES_MAP.put("devstate[]", DeviceState[].class);
        JAVA_TYPES_MAP.put("state[]", DeviceState[].class);
        JAVA_TYPES_MAP.put("devencoded[]", DevEncoded[].class);
        JAVA_TYPES_MAP.put("int[][]", int[][].class);
        JAVA_TYPES_MAP.put("long[][]", long[][].class);
        JAVA_TYPES_MAP.put("double[][]", double[][].class);
        JAVA_TYPES_MAP.put("float[][]", float[][].class);
        JAVA_TYPES_MAP.put("boolean[][]", boolean[][].class);
        JAVA_TYPES_MAP.put("byte[][]", byte[][].class);
        JAVA_TYPES_MAP.put("short[][]", short[][].class);
        JAVA_TYPES_MAP.put("string[][]", String[][].class);
        JAVA_TYPES_MAP.put("state[][]", DeviceState[][].class);
        JAVA_TYPES_MAP.put("devstate[][]", DeviceState[][].class);
        JAVA_TYPES_MAP.put("devencoded[][]", DevEncoded[][].class);
    }
}

