/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.dynamic.command;

import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.ErrSeverity;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.Group.Group;
import fr.esrf.TangoApi.Group.GroupCmdReply;
import fr.esrf.TangoApi.Group.GroupCmdReplyList;
import fr.esrf.TangoApi.Group.GroupReply;
import fr.soleil.tango.clientapi.InsertExtractUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tango.server.StateMachineBehavior;
import org.tango.server.command.CommandConfiguration;
import org.tango.server.command.ICommandBehavior;
import org.tango.utils.DevFailedUtils;

public final class GroupCommand
implements ICommandBehavior {
    private static final Logger LOGGER = LoggerFactory.getLogger(GroupCommand.class);
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
    private final CommandConfiguration config = new CommandConfiguration();
    private final Group group;
    private final Map<String, String> errorReportMap = Collections.synchronizedMap(new HashMap());
    private final String name;

    public GroupCommand(String commandName, Group group) throws DevFailed {
        this.name = commandName;
        this.group = group;
        this.checkCommand(group);
    }

    public GroupCommand(String commandName, String ... deviceNames) throws DevFailed {
        this.name = commandName;
        for (String deviceName : deviceNames) {
            new DeviceProxy(deviceName);
        }
        this.group = new Group(this.name);
        this.group.add(deviceNames);
        this.checkCommand(this.group);
    }

    private void checkCommand(Group group) throws DevFailed {
        this.config.setName(this.name + "All");
        this.config.setOutType(Void.TYPE);
        int found = 0;
        int grpSize = group.get_size(true);
        for (int k = 0; k < grpSize; ++k) {
            CommandInfo[] tmpCommandInfoList;
            DeviceProxy tmpProxy = group.get_device(k + 1);
            if (tmpProxy == null) continue;
            for (CommandInfo tmpCommandInfo : tmpCommandInfoList = tmpProxy.command_list_query()) {
                if (!this.name.equalsIgnoreCase(tmpCommandInfo.cmd_name)) continue;
                ++found;
                this.config.setInTangoType(tmpCommandInfo.in_type);
                break;
            }
            if (found == k + 1) continue;
            throw DevFailedUtils.newDevFailed((String)"INIT_ERROR", (String)("Cannot create command " + this.name + ", it does not exist on " + tmpProxy.get_name()));
        }
    }

    @Override
    public Object execute(Object arg) throws DevFailed {
        this.errorReportMap.clear();
        String tmpReplyName = "";
        boolean hasFailed = false;
        ArrayList<DevError[]> errors = new ArrayList<DevError[]>();
        int size = 0;
        DeviceData argin = new DeviceData();
        InsertExtractUtils.insert((DeviceData)argin, (int)this.config.getInTangoType(), (Object)arg);
        GroupCmdReplyList tmpReplyList = this.group.command_inout(this.name, argin, true);
        for (Object tmpReply : tmpReplyList) {
            tmpReplyName = ((GroupReply)tmpReply).dev_name();
            LOGGER.debug("getting answer for {}", (Object)tmpReplyName);
            try {
                ((GroupCmdReply)tmpReply).get_data();
            }
            catch (DevFailed e) {
                LOGGER.error("command failed on {}/{} - {}", new Object[]{tmpReplyName, this.name, DevFailedUtils.toString((DevFailed)e)});
                hasFailed = true;
                errors.add(e.errors);
                size = e.errors.length;
                this.errorReportMap.put(tmpReplyName, this.dateFormat.format(new Date()) + " : " + this.name + " result " + DevFailedUtils.toString((DevFailed)e));
            }
        }
        if (hasFailed) {
            DevError[] totalErrors = new DevError[errors.size() * size + 1];
            totalErrors[0] = new DevError("CONNECTION_ERROR", ErrSeverity.ERR, "cannot execute command ", this.getClass().getCanonicalName() + ".executeCommand(" + this.name + ")");
            int i = 1;
            Iterator iterator = errors.iterator();
            while (iterator.hasNext()) {
                DevError[] devErrors;
                for (DevError devError : devErrors = (DevError[])iterator.next()) {
                    totalErrors[i++] = devError;
                }
            }
            throw new DevFailed(totalErrors);
        }
        return null;
    }

    @Override
    public CommandConfiguration getConfiguration() {
        return this.config;
    }

    public Map<String, String> getErrorReportMap() {
        return new HashMap<String, String>(this.errorReportMap);
    }

    @Override
    public StateMachineBehavior getStateMachine() {
        return null;
    }

    public boolean isArgPrimitiveType() {
        return false;
    }
}

