/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.events;

import fr.esrf.Tango.DevEncoded;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.EventProperties;
import java.lang.reflect.Array;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.server.attribute.AttributeImpl;
import org.tango.server.attribute.AttributeValue;
import org.tango.server.events.IEventTrigger;
import org.tango.server.events.QualityEventTrigger;
import org.tango.utils.ArrayUtils;
import org.tango.utils.DevFailedUtils;

public class ChangeEventTrigger
implements IEventTrigger {
    private static final Logger logger = LoggerFactory.getLogger(ChangeEventTrigger.class);
    private final XLogger xlogger = XLoggerFactory.getXLogger(ChangeEventTrigger.class);
    private final AttributeImpl attribute;
    private final QualityEventTrigger qualityTrigger;
    private AttributeValue previousValue;
    private AttributeValue value;
    private double absolute;
    private boolean checkAbsolute;
    private double relative;
    private boolean checkRelative;
    private DevFailed error;
    private DevFailed previousError;
    private boolean previousInitialized = false;

    public ChangeEventTrigger(AttributeImpl attribute, String absolute, String relative) {
        this.attribute = attribute;
        this.value = attribute.getReadValue();
        this.qualityTrigger = new QualityEventTrigger(attribute);
        this.setCriteria(absolute, relative);
    }

    static void checkEventCriteria(AttributeImpl attribute) throws DevFailed {
        if (attribute.isState() || attribute.isString() || attribute.isBoolean()) {
            return;
        }
        EventProperties props = attribute.getProperties().getEventProp();
        if (attribute.isCheckChangeEvent() && props.ch_event.abs_change.equals("Not specified") && props.ch_event.rel_change.equals("Not specified")) {
            logger.warn("{}, Event properties (abs_change or rel_change) for attribute {} are not set", (Object)"API_EventPropertiesNotSet", (Object)attribute.getName());
        }
    }

    public void setCriteria(String absolute, String relative) {
        try {
            this.absolute = Double.parseDouble(absolute);
            this.checkAbsolute = true;
        }
        catch (NumberFormatException e) {
            this.checkAbsolute = false;
        }
        try {
            this.relative = Double.parseDouble(relative);
            this.checkRelative = true;
        }
        catch (NumberFormatException e) {
            this.checkRelative = false;
        }
    }

    @Override
    public boolean isSendEvent() throws DevFailed {
        this.xlogger.entry(new Object[0]);
        boolean hasChanged = this.qualityTrigger.isSendEvent();
        if (!hasChanged) {
            this.value = this.attribute.getReadValue();
            if (!this.previousInitialized) {
                this.previousError = this.error;
                this.previousValue = this.value;
                this.previousInitialized = true;
                hasChanged = true;
            } else {
                if (this.previousError != null && this.error == null) {
                    hasChanged = true;
                } else if (this.previousError == null && this.error != null) {
                    hasChanged = true;
                } else if (this.previousError != null && this.error != null) {
                    if (!DevFailedUtils.toString((DevFailed)this.previousError).equals(DevFailedUtils.toString((DevFailed)this.error))) {
                        hasChanged = true;
                    }
                } else {
                    hasChanged = this.value.getValue() == null && this.previousValue.getValue() == null ? false : (this.value.getValue() == null && this.previousValue.getValue() != null ? true : (this.value.getValue() != null && this.previousValue.getValue() == null ? true : (this.attribute.isScalar() ? (this.attribute.isNumber() ? this.hasScalarNumberChanged() : (this.attribute.isState() ? this.hasStateChanged() : (this.attribute.isDevEncoded() ? this.hasDevEncodedChanged() : this.hasScalarStringChanged()))) : (this.attribute.isNumber() ? this.hasArrayNumberChanged() : (this.attribute.isState() ? this.hasStateArrayChanged() : this.hasArrayStringChanged())))));
                }
                if (hasChanged) {
                    this.previousValue = this.value;
                }
            }
        }
        logger.debug("CHANGE event for {} must send: {}", (Object)this.attribute.getName(), (Object)hasChanged);
        this.xlogger.exit();
        return hasChanged;
    }

    @Override
    public void setError(DevFailed error) {
        this.previousError = this.error;
        this.error = error;
    }

    private boolean hasScalarNumberChanged() {
        double delta;
        boolean hasChanged = false;
        double val = Double.parseDouble(this.value.getValue().toString());
        double previousVal = Double.parseDouble(this.previousValue.getValue().toString());
        if (this.checkAbsolute) {
            delta = val - previousVal;
            boolean bl = hasChanged = Math.abs(delta) >= this.absolute;
        }
        if (!hasChanged && this.checkRelative) {
            delta = previousVal == 0.0 ? (val == 0.0 ? 0.0 : 100.0) : (val - previousVal) / previousVal * 100.0;
            hasChanged = Math.abs(delta) >= this.relative;
        }
        return hasChanged;
    }

    private boolean hasDevEncodedChanged() {
        DevEncoded val = (DevEncoded)this.value.getValue();
        DevEncoded previousVal = (DevEncoded)this.previousValue.getValue();
        return !Arrays.equals(val.encoded_data, previousVal.encoded_data);
    }

    private boolean hasScalarStringChanged() {
        String previousVal;
        String val = this.value.getValue().toString();
        return !val.equals(previousVal = this.previousValue.getValue().toString());
    }

    private boolean hasArrayNumberChanged() {
        boolean hasChanged = false;
        if (Array.getLength(this.value.getValue()) != Array.getLength(this.previousValue.getValue())) {
            hasChanged = true;
        } else {
            String[] val = ArrayUtils.toStringArray((Object)this.value.getValue());
            String[] previousVal = ArrayUtils.toStringArray((Object)this.previousValue.getValue());
            for (int i = 0; i < previousVal.length; ++i) {
                double delta;
                double valD = Double.parseDouble(val[i]);
                double previousValD = Double.parseDouble(previousVal[i]);
                if (this.checkAbsolute) {
                    delta = valD - previousValD;
                    boolean bl = hasChanged = Math.abs(delta) >= this.absolute;
                }
                if (!hasChanged && this.checkRelative) {
                    delta = previousValD == 0.0 ? (valD == 0.0 ? 0.0 : 100.0) : valD - previousValD * 100.0 / previousValD;
                    boolean bl = hasChanged = Math.abs(delta) >= this.relative;
                }
                if (hasChanged) break;
            }
        }
        return hasChanged;
    }

    private boolean hasArrayStringChanged() {
        boolean hasChanged = false;
        if (Array.getLength(this.value.getValue()) != Array.getLength(this.previousValue.getValue())) {
            hasChanged = true;
        } else {
            Object[] previousVal;
            Object[] val;
            if (this.value.getValue() instanceof String[]) {
                val = (String[])this.value.getValue();
                previousVal = (String[])this.previousValue.getValue();
            } else {
                val = ArrayUtils.toStringArray((Object)this.value.getValue());
                previousVal = ArrayUtils.toStringArray((Object)this.previousValue.getValue());
            }
            if (!Arrays.equals(val, previousVal)) {
                hasChanged = true;
            }
        }
        return hasChanged;
    }

    private boolean hasStateChanged() {
        DevState previousState;
        DevState state = (DevState)this.value.getValue();
        return state != (previousState = (DevState)this.previousValue.getValue());
    }

    private boolean hasStateArrayChanged() {
        DevState[] previousState;
        boolean hasChanged = false;
        DevState[] state = (DevState[])this.value.getValue();
        if (state.length != (previousState = (DevState[])this.previousValue.getValue()).length) {
            hasChanged = true;
        } else {
            for (int i = 0; i < previousState.length; ++i) {
                if (state[i].equals(previousState[i])) continue;
                hasChanged = true;
                break;
            }
        }
        return hasChanged;
    }

    @Override
    public void updateProperties() throws DevFailed {
        EventProperties props = this.attribute.getProperties().getEventProp();
        this.setCriteria(props.ch_event.abs_change, props.ch_event.rel_change);
    }

    @Override
    public boolean doCheck() {
        return this.attribute.isCheckChangeEvent();
    }

    @Override
    public boolean isPushedFromDeviceCode() {
        return this.attribute.isPushChangeEvent();
    }
}

