/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.events;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevIntrChange;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tango.server.ServerManager;
import org.tango.server.events.EventManager;
import org.tango.utils.DevFailedUtils;

public class DeviceInterfaceChangedSender {
    private final Logger logger = LoggerFactory.getLogger(DeviceInterfaceChangedSender.class);
    private final String deviceName;
    private final EventSenderTask task;
    private ExecutorService executor;
    private Future<?> future;

    public DeviceInterfaceChangedSender(final String deviceName) {
        this.deviceName = deviceName;
        this.task = new EventSenderTask(deviceName);
        this.executor = Executors.newFixedThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "DeviceInterfaceChangedSender-" + deviceName);
            }
        });
    }

    public synchronized void pushEvent(DevIntrChange deviceInterface, boolean isStarted) {
        if (isStarted) {
            if (!this.deviceName.equalsIgnoreCase("dserver/" + ServerManager.getInstance().getServerName())) {
                this.task.clear();
                this.logger.debug("send event for interface changed of {}", (Object)this.deviceName);
                try {
                    EventManager.getInstance().pushInterfaceChangedEvent(this.deviceName, deviceInterface);
                }
                catch (DevFailed e) {
                    this.logger.error(DevFailedUtils.toString((DevFailed)e));
                    this.logger.error("impossible to send event", (Throwable)e);
                }
            }
        } else {
            this.logger.debug("request for interface changed of {} queued", (Object)this.deviceName);
            this.task.add(deviceInterface);
            if (this.future == null && EventManager.getInstance().hasSubscriber(this.deviceName)) {
                this.future = this.executor.submit(this.task);
            }
        }
    }

    public synchronized void stop() {
        this.task.clear();
        if (this.future != null) {
            this.future.cancel(true);
            this.future = null;
        }
    }

    private class EventSenderTask
    implements Runnable {
        private final LinkedBlockingDeque<DevIntrChange> interfaces = new LinkedBlockingDeque(1);
        private final String deviceName;

        public EventSenderTask(String deviceName) {
            this.deviceName = deviceName;
        }

        public void add(DevIntrChange deviceInterface) {
            this.interfaces.clear();
            this.interfaces.add(deviceInterface);
        }

        public void clear() {
            this.interfaces.clear();
        }

        @Override
        public void run() {
            boolean stop = false;
            while (!stop && EventManager.getInstance().hasSubscriber(this.deviceName)) {
                try {
                    DevIntrChange devInterface = this.interfaces.take();
                    EventManager.getInstance().pushInterfaceChangedEvent(this.deviceName, devInterface);
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    stop = true;
                }
                catch (DevFailed e) {
                    DeviceInterfaceChangedSender.this.logger.error(DevFailedUtils.toString((DevFailed)e));
                    DeviceInterfaceChangedSender.this.logger.error("impossible to send event", (Throwable)e);
                }
            }
        }
    }
}

