/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.events;

import fr.esrf.Tango.AttDataReady;
import fr.esrf.Tango.AttributeConfig_5;
import fr.esrf.Tango.AttributeValue_5;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevIntrChange;
import fr.esrf.Tango.DevPipeData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.server.attribute.AttributeImpl;
import org.tango.server.events.DefaultEventTrigger;
import org.tango.server.events.EventTriggerFactory;
import org.tango.server.events.EventType;
import org.tango.server.events.EventUtilities;
import org.tango.server.events.IEventTrigger;
import org.tango.server.pipe.PipeImpl;
import org.tango.utils.DevFailedUtils;
import org.zeromq.ZMQ;
import org.zeromq.ZMQException;

final class EventImpl {
    private final Logger logger = LoggerFactory.getLogger(EventImpl.class);
    private final XLogger xlogger = XLoggerFactory.getXLogger(EventImpl.class);
    private final IEventTrigger eventTrigger;
    private final boolean islatestIDLVersion;
    private final String fullName;
    private AttributeImpl attribute;
    private long subscribeTime;
    private int counter = 0;

    EventImpl(AttributeImpl attribute, EventType eventType, int idlVersion, String fullName) throws DevFailed {
        this.attribute = attribute;
        this.islatestIDLVersion = idlVersion == 5;
        this.fullName = fullName;
        this.eventTrigger = EventTriggerFactory.createEventTrigger(eventType, attribute);
        this.logger.debug("event trigger for {} type is {}", (Object)attribute.getName(), this.eventTrigger.getClass());
        this.updateSubscribeTime();
    }

    EventImpl(PipeImpl pipe, int idlVersion, String fullName) {
        this.islatestIDLVersion = idlVersion == 5;
        this.fullName = fullName;
        this.eventTrigger = new DefaultEventTrigger();
        this.logger.debug("event trigger for {} type is {}", (Object)pipe.getName(), this.eventTrigger.getClass());
        this.updateSubscribeTime();
    }

    EventImpl(int idlVersion, String fullName) {
        this.islatestIDLVersion = idlVersion == 5;
        this.fullName = fullName;
        this.eventTrigger = new DefaultEventTrigger();
        this.logger.debug("event trigger for Device, type is {}", this.eventTrigger.getClass());
        this.updateSubscribeTime();
    }

    void updateSubscribeTime() {
        this.subscribeTime = System.currentTimeMillis();
    }

    boolean isStillSubscribed() {
        long dt = System.currentTimeMillis() - this.subscribeTime;
        return dt < 600000L;
    }

    protected void pushAttributeValueEvent(ZMQ.Socket eventSocket, boolean isPushedFromPolling) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        this.eventTrigger.setError(null);
        this.eventTrigger.updateProperties();
        if (this.isSendEvent(isPushedFromPolling)) {
            this.sendAttributeValueEvent(eventSocket);
        }
        this.xlogger.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pushDevFailedEvent(DevFailed devFailed, ZMQ.Socket eventSocket, boolean isPushedFromPolling) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        this.eventTrigger.updateProperties();
        this.eventTrigger.setError(devFailed);
        if (this.isSendEvent(isPushedFromPolling)) {
            try {
                ZMQ.Socket socket = eventSocket;
                synchronized (socket) {
                    EventUtilities.sendToSocket(eventSocket, this.fullName, this.counter++, true, EventUtilities.marshall(devFailed));
                }
            }
            catch (ZMQException e) {
                throw DevFailedUtils.newDevFailed((Throwable)e);
            }
        }
        this.xlogger.exit();
    }

    private boolean isSendEvent(boolean isPushedFromPolling) throws DevFailed {
        boolean isSend = true;
        if (!isPushedFromPolling && !this.eventTrigger.isPushedFromDeviceCode()) {
            isSend = false;
        } else if (this.eventTrigger.doCheck()) {
            isSend = this.eventTrigger.isSendEvent();
        } else if (isPushedFromPolling && this.eventTrigger.isPushedFromDeviceCode()) {
            isSend = false;
        }
        this.logger.debug("Event must be sent  = {} (isPushFromPolling = {})", (Object)isSend, (Object)isPushedFromPolling);
        return isSend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAttributeValueEvent(ZMQ.Socket eventSocket) throws DevFailed {
        block10: {
            this.xlogger.entry(new Object[0]);
            try {
                if (this.islatestIDLVersion) {
                    ZMQ.Socket socket = eventSocket;
                    synchronized (socket) {
                        EventUtilities.sendToSocket(eventSocket, this.fullName, this.counter++, EventUtilities.marshallIDL5(this.attribute));
                        break block10;
                    }
                }
                ZMQ.Socket socket = eventSocket;
                synchronized (socket) {
                    EventUtilities.sendToSocket(eventSocket, this.fullName, this.counter++, EventUtilities.marshallIDL4(this.attribute));
                }
            }
            catch (ArrayIndexOutOfBoundsException | ZMQException e) {
                if (e instanceof ArrayIndexOutOfBoundsException) {
                    this.logger.error(this.fullName, e);
                }
                throw DevFailedUtils.newDevFailed((Throwable)e);
            }
        }
        this.xlogger.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushAttributeIDL5Event(AttributeValue_5 value, ZMQ.Socket eventSocket) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        try {
            ZMQ.Socket socket = eventSocket;
            synchronized (socket) {
                EventUtilities.sendToSocket(eventSocket, this.fullName, this.counter++, EventUtilities.marshallIDL5(value));
            }
        }
        catch (ArrayIndexOutOfBoundsException | ZMQException e) {
            if (e instanceof ArrayIndexOutOfBoundsException) {
                this.logger.error(this.fullName, e);
            }
            throw DevFailedUtils.newDevFailed((Throwable)e);
        }
        this.xlogger.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pushAttributeDataReadyEvent(int counter, ZMQ.Socket eventSocket) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        try {
            AttDataReady dataReady = new AttDataReady(this.attribute.getName(), this.attribute.getTangoType(), counter);
            ZMQ.Socket socket = eventSocket;
            synchronized (socket) {
                EventUtilities.sendToSocket(eventSocket, this.fullName, counter, EventUtilities.marshall(dataReady));
            }
        }
        catch (ZMQException e) {
            throw DevFailedUtils.newDevFailed((Throwable)e);
        }
        this.xlogger.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pushAttributeConfigIDL5Event(AttributeConfig_5 config, ZMQ.Socket eventSocket) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        try {
            ZMQ.Socket socket = eventSocket;
            synchronized (socket) {
                EventUtilities.sendToSocket(eventSocket, this.fullName, this.counter++, EventUtilities.marshallIDL5Config(config));
            }
        }
        catch (ZMQException e) {
            throw DevFailedUtils.newDevFailed((Throwable)e);
        }
        this.xlogger.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pushAttributeConfigEvent(ZMQ.Socket eventSocket) throws DevFailed {
        block9: {
            this.xlogger.entry(new Object[0]);
            try {
                if (this.islatestIDLVersion) {
                    ZMQ.Socket socket = eventSocket;
                    synchronized (socket) {
                        EventUtilities.sendToSocket(eventSocket, this.fullName, this.counter++, EventUtilities.marshallIDL5Config(this.attribute));
                        break block9;
                    }
                }
                ZMQ.Socket socket = eventSocket;
                synchronized (socket) {
                    EventUtilities.sendToSocket(eventSocket, this.fullName, this.counter++, EventUtilities.marshallIDL4Config(this.attribute));
                }
            }
            catch (ZMQException e) {
                throw DevFailedUtils.newDevFailed((Throwable)e);
            }
        }
        this.xlogger.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pushInterfaceChangeEvent(DevIntrChange deviceInterface, ZMQ.Socket eventSocket) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        try {
            ZMQ.Socket socket = eventSocket;
            synchronized (socket) {
                EventUtilities.sendToSocket(eventSocket, this.fullName, this.counter++, EventUtilities.marshall(deviceInterface));
            }
        }
        catch (ZMQException e) {
            throw DevFailedUtils.newDevFailed((Throwable)e);
        }
        this.xlogger.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pushPipeEvent(DevPipeData pipeData, ZMQ.Socket eventSocket) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        try {
            ZMQ.Socket socket = eventSocket;
            synchronized (socket) {
                EventUtilities.sendToSocket(eventSocket, this.fullName, this.counter++, EventUtilities.marshall(pipeData));
            }
        }
        catch (ZMQException e) {
            throw DevFailedUtils.newDevFailed((Throwable)e);
        }
        this.xlogger.exit();
    }
}

