/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.events;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import fr.esrf.Tango.AttributeConfig_5;
import fr.esrf.Tango.AttributeValue_5;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevIntrChange;
import fr.esrf.Tango.DevPipeData;
import fr.esrf.Tango.DevVarLongStringArray;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.client.database.DatabaseFactory;
import org.tango.orb.ORBManager;
import org.tango.server.ServerManager;
import org.tango.server.attribute.AttributeImpl;
import org.tango.server.attribute.ForwardedAttribute;
import org.tango.server.events.ArchiveEventTrigger;
import org.tango.server.events.ChangeEventTrigger;
import org.tango.server.events.EventConstants;
import org.tango.server.events.EventImpl;
import org.tango.server.events.EventType;
import org.tango.server.events.EventUtilities;
import org.tango.server.idl.TangoIDLUtil;
import org.tango.server.pipe.PipeImpl;
import org.tango.server.pipe.PipeValue;
import org.tango.utils.DevFailedUtils;
import org.zeromq.ZContext;
import org.zeromq.ZMQ;

public final class EventManager {
    private static final Logger logger = LoggerFactory.getLogger(EventManager.class);
    private final XLogger xlogger = XLoggerFactory.getXLogger(EventManager.class);
    public static final int MINIMUM_IDL_VERSION = 4;
    public static final String IDL_REGEX = "idl[0-9]_[a-z]*";
    public static final String IDL_LATEST = "idl5_";
    private static final EventManager INSTANCE = new EventManager();
    private final Map<String, EventImpl> eventImplMap = new HashMap<String, EventImpl>();
    private final int serverHWM = this.initializeServerHwm();
    private final int clientHWN = this.initializeClientHwm();
    private final List<String> heartbeatEndpoints = new LinkedList<String>();
    private final List<String> eventEndpoints = new LinkedList<String>();
    private ZMQ.Socket heartbeatSocket;
    private ZMQ.Socket eventSocket;
    private ZContext context;
    private ScheduledExecutorService heartBeatExecutor;
    private AtomicBoolean isInitialized = new AtomicBoolean(false);
    private String heartbeatName;

    private EventManager() {
    }

    public static EventManager getInstance() {
        return INSTANCE;
    }

    public static void checkEventCriteria(AttributeImpl attribute, EventType eventType) throws DevFailed {
        switch (eventType) {
            case CHANGE_EVENT: {
                ChangeEventTrigger.checkEventCriteria(attribute);
                break;
            }
            case ARCHIVE_EVENT: {
                ArchiveEventTrigger.checkEventCriteria(attribute);
                break;
            }
        }
        if (!attribute.isPolled()) {
            boolean showWarning = false;
            switch (eventType) {
                case ARCHIVE_EVENT: {
                    if (attribute.isPushArchiveEvent()) break;
                    showWarning = true;
                    break;
                }
                case CHANGE_EVENT: {
                    if (attribute.isPushChangeEvent()) break;
                    showWarning = true;
                    break;
                }
                case DATA_READY_EVENT: {
                    if (attribute.isPushDataReady()) break;
                    showWarning = true;
                    break;
                }
                case USER_EVENT: 
                case ATT_CONF_EVENT: 
                case INTERFACE_CHANGE_EVENT: {
                    break;
                }
                default: {
                    showWarning = true;
                }
            }
            if (showWarning) {
                logger.warn("{}, The polling (necessary to send events) for the attribute {} is not started", (Object)"API_AttrNotPolled", (Object)attribute.getName());
            }
        }
    }

    private int initializeServerHwm() {
        String env = System.getenv("TANGO_DS_EVENT_BUFFER_HWM");
        try {
            if (env != null) {
                return Integer.parseInt(env);
            }
            return 1000;
        }
        catch (NumberFormatException e) {
            logger.error("system.env TANGO_DS_EVENT_BUFFER_HWM is not a number: {} ", (Object)env);
            return 1000;
        }
    }

    private int initializeClientHwm() {
        String value = "";
        try {
            value = DatabaseFactory.getDatabase().getFreeProperty("CtrlSystem", "EventBufferHwm");
            return Integer.parseInt(value);
        }
        catch (DevFailed e) {
            DevFailedUtils.logDevFailed((DevFailed)e, (Logger)logger);
            return 1000;
        }
        catch (NumberFormatException e) {
            logger.warn("CtrlSystem/EventBufferHwm property is not a number: {}, the default value will be used instead: {}", (Object)value, (Object)1000);
            return 1000;
        }
    }

    private void initialize() throws DevFailed {
        this.xlogger.entry(new Object[0]);
        Iterable<String> ipAddress = this.getIpAddresses();
        Iterable ip4Address = Iterables.filter(ipAddress, s -> s.split("\\.").length == 4);
        this.context = new ZContext();
        this.heartbeatSocket = this.createSocket();
        this.bindEndpoints(this.heartbeatSocket, ip4Address, this.heartbeatEndpoints, SocketType.HEARTBEAT);
        this.eventSocket = this.createEventSocket();
        this.bindEndpoints(this.eventSocket, ip4Address, this.eventEndpoints, SocketType.EVENTS);
        String adminDeviceName = ServerManager.getInstance().getAdminDeviceName();
        this.heartbeatName = EventUtilities.buildHeartBeatEventName(adminDeviceName);
        this.heartBeatExecutor = Executors.newScheduledThreadPool(1, r -> new Thread(r, "Event HeartBeat"));
        this.heartBeatExecutor.scheduleAtFixedRate(new HeartbeatThread(this.heartbeatName), 0L, 9000L, TimeUnit.MILLISECONDS);
        this.isInitialized.set(true);
        logger.info("ZMQ ({}) SERVER event system started", (Object)ZMQ.getVersionString());
        this.xlogger.exit();
    }

    private Iterable<String> getIpAddresses() throws DevFailed {
        ArrayList<String> result;
        if (ORBManager.OAI_ADDR != null && !ORBManager.OAI_ADDR.isEmpty()) {
            result = new ArrayList<String>(1);
            result.add(ORBManager.OAI_ADDR);
        } else {
            try {
                ArrayList<NetworkInterface> networkInterfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
                result = new ArrayList();
                Predicate<NetworkInterface> isLoopback = new Predicate<NetworkInterface>(){

                    public boolean apply(NetworkInterface networkInterface) {
                        try {
                            return !networkInterface.isLoopback();
                        }
                        catch (SocketException e) {
                            logger.warn("Ignoring NetworkInterface({}) due to an exception: {}", (Object)networkInterface.getName(), (Object)e);
                            return false;
                        }
                    }
                };
                Function<InterfaceAddress, String> interfaceAddressToString = new Function<InterfaceAddress, String>(){

                    public String apply(InterfaceAddress interfaceAddress) {
                        return interfaceAddress.getAddress().getHostAddress();
                    }
                };
                Iterable filteredNICs = Iterables.filter(networkInterfaces, (Predicate)isLoopback);
                for (NetworkInterface nic : filteredNICs) {
                    result.addAll(Lists.transform(nic.getInterfaceAddresses(), (Function)interfaceAddressToString));
                }
            }
            catch (SocketException e) {
                throw DevFailedUtils.newDevFailed((Throwable)e);
            }
        }
        return result;
    }

    private void bindEndpoints(ZMQ.Socket socket, Iterable<String> ipAddresses, List<String> endpoints, SocketType socketType) {
        this.xlogger.entry(new Object[]{ipAddresses, endpoints, socketType});
        for (String ipAddress : ipAddresses) {
            StringBuilder endpoint = new StringBuilder("tcp://").append(ipAddress);
            int port = socket.bindToRandomPort(endpoint.toString());
            endpoint.append(":").append(port);
            endpoints.add(endpoint.toString());
            logger.debug("bind ZMQ socket {} for {}", (Object)endpoint, (Object)socketType);
        }
        this.xlogger.exit();
    }

    private ZMQ.Socket createSocket() {
        ZMQ.Socket socket = this.context.createSocket(org.zeromq.SocketType.PUB);
        socket.setLinger(0);
        socket.setReconnectIVL(-1);
        return socket;
    }

    private ZMQ.Socket createEventSocket() {
        ZMQ.Socket socket = this.context.createSocket(org.zeromq.SocketType.PUB);
        socket.setLinger(0);
        socket.setReconnectIVL(-1);
        socket.setSndHWM(this.serverHWM);
        logger.debug("HWM has been set to {}", (Object)socket.getSndHWM());
        return socket;
    }

    private EventImpl getEventImpl(String fullName) {
        if (!this.isInitialized.get()) {
            return null;
        }
        EventImpl eventImpl = this.eventImplMap.get(fullName);
        if (eventImpl != null && !eventImpl.isStillSubscribed()) {
            logger.debug("{} not subscribed any more", (Object)fullName);
            this.eventImplMap.remove(fullName);
            if (this.eventImplMap.isEmpty()) {
                logger.debug("no subscribers on server, closing resources");
                this.close();
            }
            eventImpl = null;
        }
        return eventImpl;
    }

    public boolean hasSubscriber(String deviceName) {
        boolean hasSubscriber = false;
        for (String eventName : this.eventImplMap.keySet()) {
            if (!eventName.toLowerCase(Locale.ENGLISH).contains(deviceName.toLowerCase(Locale.ENGLISH))) continue;
            hasSubscriber = true;
            break;
        }
        return hasSubscriber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.xlogger.entry(new Object[0]);
        logger.debug("closing all event resources");
        AtomicBoolean atomicBoolean = this.isInitialized;
        synchronized (atomicBoolean) {
            if (this.heartBeatExecutor != null) {
                this.heartBeatExecutor.shutdown();
                try {
                    this.heartBeatExecutor.awaitTermination(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    logger.error("could not stop event hearbeat");
                    Thread.currentThread().interrupt();
                }
                this.heartBeatExecutor = null;
            }
            if (this.context != null) {
                this.context.destroy();
            }
            this.eventImplMap.clear();
            this.isInitialized.set(false);
        }
        logger.debug("all event resources closed");
        this.xlogger.exit();
    }

    public DevVarLongStringArray getInfo() {
        DevVarLongStringArray longStringArray = new DevVarLongStringArray();
        longStringArray.lvalue = new int[]{930, 5, this.clientHWN, 0, 0, EventConstants.ZMQ_RELEASE};
        longStringArray.svalue = this.heartbeatEndpoints.isEmpty() || this.eventEndpoints.isEmpty() ? new String[]{"No ZMQ event yet !"} : this.endpointsAndEventsAsStringArray("");
        return longStringArray;
    }

    private String[] endpointsAndEventsAsStringArray(String eventName) {
        ArrayList<String> svalue = new ArrayList<String>(this.heartbeatEndpoints.size() + this.eventEndpoints.size());
        int size = this.heartbeatEndpoints.size();
        for (int i = 0; i < size; ++i) {
            svalue.add((String)Iterables.get(this.heartbeatEndpoints, (int)i));
            svalue.add((String)Iterables.get(this.eventEndpoints, (int)i));
        }
        svalue.add(eventName);
        svalue.add(StringUtils.removeEnd((String)this.heartbeatName, (String)".heartbeat"));
        return svalue.toArray(new String[svalue.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DevVarLongStringArray subscribe(String deviceName, PipeImpl pipe) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        AtomicBoolean atomicBoolean = this.isInitialized;
        synchronized (atomicBoolean) {
            if (!this.isInitialized.get()) {
                this.initialize();
            }
        }
        String fullName = EventUtilities.buildPipeEventName(deviceName, pipe.getName());
        EventImpl eventImpl = this.eventImplMap.get(fullName);
        if (eventImpl == null) {
            eventImpl = new EventImpl(pipe, 5, fullName);
            this.eventImplMap.put(fullName, eventImpl);
        } else {
            eventImpl.updateSubscribeTime();
        }
        return this.buildConnectionParameters(fullName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DevVarLongStringArray subscribe(String deviceName, AttributeImpl attribute, EventType eventType, int idlVersion) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        AtomicBoolean atomicBoolean = this.isInitialized;
        synchronized (atomicBoolean) {
            if (!this.isInitialized.get()) {
                this.initialize();
            }
        }
        String fullName = EventUtilities.buildEventName(deviceName, attribute.getName(), eventType, idlVersion);
        EventImpl eventImpl = this.eventImplMap.get(fullName);
        if (eventImpl == null) {
            if (attribute.getBehavior() instanceof ForwardedAttribute) {
                ForwardedAttribute fwdAttr = (ForwardedAttribute)attribute.getBehavior();
                fwdAttr.subscribe(eventType);
            }
            eventImpl = new EventImpl(attribute, eventType, idlVersion, fullName);
            this.eventImplMap.put(fullName, eventImpl);
        } else {
            eventImpl.updateSubscribeTime();
        }
        logger.debug("starting event {}", (Object)fullName);
        return this.buildConnectionParameters(fullName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DevVarLongStringArray subscribe(String deviceName) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        AtomicBoolean atomicBoolean = this.isInitialized;
        synchronized (atomicBoolean) {
            if (!this.isInitialized.get()) {
                this.initialize();
            }
        }
        String fullName = EventUtilities.buildDeviceEventName(deviceName, EventType.INTERFACE_CHANGE_EVENT);
        EventImpl eventImpl = this.eventImplMap.get(fullName);
        if (eventImpl == null) {
            eventImpl = new EventImpl(5, fullName);
            this.eventImplMap.put(fullName, eventImpl);
        } else {
            eventImpl.updateSubscribeTime();
        }
        return this.buildConnectionParameters(fullName);
    }

    private DevVarLongStringArray buildConnectionParameters(String fullName) {
        DevVarLongStringArray longStringArray = new DevVarLongStringArray();
        longStringArray.lvalue = new int[]{930, 5, this.clientHWN, 0, 0, EventConstants.ZMQ_RELEASE};
        longStringArray.svalue = this.endpointsAndEventsAsStringArray(fullName);
        logger.debug("event registered for {}", (Object)fullName);
        return longStringArray;
    }

    public void pushAttributeErrorEvent(String deviceName, String attributeName, DevFailed devFailed, boolean isPushedFromPolling) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        for (EventType eventType : EventType.values()) {
            String fullName = EventUtilities.buildEventName(deviceName, attributeName, eventType);
            EventImpl eventImpl = this.getEventImpl(fullName);
            if (eventImpl == null) continue;
            eventImpl.pushDevFailedEvent(devFailed, this.eventSocket, isPushedFromPolling);
        }
        this.xlogger.exit();
    }

    public void pushAttributeValueEvent(String deviceName, String attributeName, boolean isPushedFromPolling) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        for (EventType eventType : EventType.getEventTypeListForAttrPolling()) {
            this.pushAttributeValueEventIdlLoop(deviceName, attributeName, eventType, isPushedFromPolling);
        }
        this.xlogger.exit();
    }

    private void pushAttributeValueEventIdlLoop(String deviceName, String attributeName, EventType eventType, boolean isPushedFromPolling) throws DevFailed {
        for (int idl = 4; idl <= 5; ++idl) {
            String fullName = EventUtilities.buildEventName(deviceName, attributeName, eventType, idl);
            EventImpl eventImpl = this.getEventImpl(fullName);
            if (eventImpl == null) continue;
            eventImpl.pushAttributeValueEvent(this.eventSocket, isPushedFromPolling);
        }
        this.xlogger.exit();
    }

    public void pushAttributeValueEvent(String deviceName, String attributeName, EventType eventType) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        this.pushAttributeValueEventIdlLoop(deviceName, attributeName, eventType, false);
        this.xlogger.exit();
    }

    public void pushAttributeDataReadyEvent(String deviceName, String attributeName, int counter) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        String fullName = EventUtilities.buildEventName(deviceName, attributeName, EventType.DATA_READY_EVENT);
        EventImpl eventImpl = this.getEventImpl(fullName);
        if (eventImpl != null) {
            eventImpl.pushAttributeDataReadyEvent(counter, this.eventSocket);
        }
        this.xlogger.exit();
    }

    public void pushAttributeConfigEvent(String deviceName, String attributeName) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        for (int idl = 4; idl <= 5; ++idl) {
            String fullName = EventUtilities.buildEventName(deviceName, attributeName, EventType.ATT_CONF_EVENT, idl);
            EventImpl eventImpl = this.getEventImpl(fullName);
            if (eventImpl == null) continue;
            eventImpl.pushAttributeConfigEvent(this.eventSocket);
        }
        this.xlogger.exit();
    }

    public void pushInterfaceChangedEvent(String deviceName, DevIntrChange deviceInterface) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        String fullName = EventUtilities.buildDeviceEventName(deviceName, EventType.INTERFACE_CHANGE_EVENT);
        EventImpl eventImpl = this.getEventImpl(fullName);
        if (eventImpl != null) {
            eventImpl.pushInterfaceChangeEvent(deviceInterface, this.eventSocket);
        }
        this.xlogger.exit();
    }

    public void pushPipeEvent(String deviceName, String pipeName, PipeValue blob) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        String fullName = EventUtilities.buildPipeEventName(deviceName, pipeName);
        EventImpl eventImpl = this.getEventImpl(fullName);
        if (eventImpl != null) {
            eventImpl.pushPipeEvent(new DevPipeData(pipeName, TangoIDLUtil.getTime(blob.getTime()), blob.getValue().getDevPipeBlobObject()), this.eventSocket);
        }
        this.xlogger.exit();
    }

    public void pushPipeEvent(String deviceName, String pipeName, DevFailed devFailed) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        String fullName = EventUtilities.buildPipeEventName(deviceName, pipeName);
        EventImpl eventImpl = this.getEventImpl(fullName);
        if (eventImpl != null) {
            eventImpl.pushDevFailedEvent(devFailed, this.eventSocket, false);
        }
        this.xlogger.exit();
    }

    public void pushAttributeValueIDL5Event(String deviceName, String attributeName, AttributeValue_5 value, EventType evtType) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        String fullName = EventUtilities.buildEventName(deviceName, attributeName, evtType);
        EventImpl eventImpl = this.getEventImpl(fullName);
        if (eventImpl != null) {
            eventImpl.pushAttributeIDL5Event(value, this.eventSocket);
        }
        this.xlogger.exit();
    }

    public void pushAttributeConfigIDL5Event(String deviceName, String attributeName, AttributeConfig_5 config) throws DevFailed {
        this.xlogger.entry(new Object[0]);
        String fullName = EventUtilities.buildEventName(deviceName, attributeName, EventType.ATT_CONF_EVENT);
        EventImpl eventImpl = this.getEventImpl(fullName);
        if (eventImpl != null) {
            eventImpl.pushAttributeConfigIDL5Event(config, this.eventSocket);
        }
        this.xlogger.exit();
    }

    class HeartbeatThread
    implements Runnable {
        private final String heartbeatName;

        HeartbeatThread(String heartbeatName) {
            this.heartbeatName = heartbeatName;
        }

        @Override
        public void run() {
            EventManager.this.xlogger.entry(new Object[0]);
            if (EventManager.this.eventImplMap.isEmpty()) {
                return;
            }
            try {
                EventUtilities.sendHeartbeat(EventManager.this.heartbeatSocket, this.heartbeatName);
            }
            catch (DevFailed e) {
                DevFailedUtils.logDevFailed((DevFailed)e, (Logger)logger);
            }
            logger.debug("Heartbeat sent for {}", (Object)this.heartbeatName);
            EventManager.this.xlogger.exit();
        }
    }

    private static enum SocketType {
        HEARTBEAT,
        EVENTS;

    }
}

