/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.events;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.EventProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tango.server.attribute.AttributeImpl;
import org.tango.server.events.ArchiveEventTrigger;
import org.tango.server.events.ChangeEventTrigger;
import org.tango.server.events.DefaultEventTrigger;
import org.tango.server.events.EventType;
import org.tango.server.events.IEventTrigger;
import org.tango.server.events.PeriodicEventTrigger;

public class EventTriggerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventTriggerFactory.class);

    public static IEventTrigger createEventTrigger(EventType eventType, AttributeImpl attribute) throws DevFailed {
        IEventTrigger eventTrigger;
        LOGGER.debug("create event trigger for attribute {} of type {}", (Object)attribute.getName(), (Object)eventType);
        EventProperties props = attribute.getProperties().getEventProp();
        switch (eventType) {
            case PERIODIC_EVENT: {
                long period = Long.parseLong(props.per_event.period);
                eventTrigger = new PeriodicEventTrigger(period, attribute);
                break;
            }
            case CHANGE_EVENT: {
                eventTrigger = new ChangeEventTrigger(attribute, props.ch_event.abs_change, props.ch_event.rel_change);
                break;
            }
            case ARCHIVE_EVENT: {
                long periodA;
                try {
                    periodA = Long.parseLong(props.arch_event.period);
                }
                catch (NumberFormatException e) {
                    periodA = -1L;
                }
                eventTrigger = new ArchiveEventTrigger(periodA, props.arch_event.abs_change, props.arch_event.rel_change, attribute);
                break;
            }
            default: {
                eventTrigger = new DefaultEventTrigger();
            }
        }
        return eventTrigger;
    }
}

