/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.events;

import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.DevFailed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.server.attribute.AttributeImpl;
import org.tango.server.attribute.AttributeValue;
import org.tango.server.events.IEventTrigger;

public class QualityEventTrigger
implements IEventTrigger {
    private final Logger logger = LoggerFactory.getLogger(QualityEventTrigger.class);
    private final XLogger xlogger = XLoggerFactory.getXLogger(QualityEventTrigger.class);
    private AttributeValue previousValue;
    private AttributeValue value;
    private final AttributeImpl attribute;
    private boolean previousInitialized;

    public QualityEventTrigger(AttributeImpl attribute) {
        this.attribute = attribute;
        this.previousInitialized = false;
    }

    @Override
    public boolean isSendEvent() {
        this.xlogger.entry(new Object[0]);
        this.previousValue = this.value;
        boolean hasChanged = false;
        this.value = this.attribute.getReadValue();
        if (!this.previousInitialized) {
            this.previousValue = this.value;
            this.previousInitialized = true;
        } else if (this.previousValue != null) {
            AttrQuality previousQuality = this.previousValue.getQuality();
            AttrQuality quality = this.value.getQuality();
            hasChanged = !quality.equals(previousQuality);
        }
        this.logger.debug("QUALITY event must send: {}", (Object)hasChanged);
        this.xlogger.exit();
        return hasChanged;
    }

    @Override
    public void setError(DevFailed error) {
    }

    @Override
    public void updateProperties() {
    }

    @Override
    public boolean doCheck() {
        return true;
    }

    @Override
    public boolean isPushedFromDeviceCode() {
        return false;
    }
}

