/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.idl;

import fr.esrf.Tango.AttrDataFormat;
import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.AttrValUnion;
import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.AttributeAlarm;
import fr.esrf.Tango.AttributeConfig;
import fr.esrf.Tango.AttributeConfig_2;
import fr.esrf.Tango.AttributeConfig_3;
import fr.esrf.Tango.AttributeConfig_5;
import fr.esrf.Tango.AttributeDim;
import fr.esrf.Tango.AttributeValue_3;
import fr.esrf.Tango.AttributeValue_4;
import fr.esrf.Tango.AttributeValue_5;
import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import java.lang.reflect.Array;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.orb.ORBManager;
import org.tango.server.attribute.AttributeConfiguration;
import org.tango.server.attribute.AttributeImpl;
import org.tango.server.attribute.AttributePropertiesImpl;
import org.tango.server.attribute.AttributeValue;
import org.tango.server.idl.CleverAnyAttribute;
import org.tango.server.idl.CleverAttrValUnion;
import org.tango.server.idl.TangoIDLUtil;
import org.tango.utils.DevFailedUtils;

public final class TangoIDLAttributeUtil {
    private static final XLogger XLOGGER = XLoggerFactory.getXLogger(TangoIDLAttributeUtil.class);

    private TangoIDLAttributeUtil() {
    }

    public static fr.esrf.Tango.AttributeValue toAttributeValue(AttributeImpl attributeImpl, AttributeValue value) throws DevFailed {
        XLOGGER.entry(new Object[0]);
        fr.esrf.Tango.AttributeValue value2 = new fr.esrf.Tango.AttributeValue();
        try {
            value2.name = attributeImpl.getName();
            value2.value = CleverAnyAttribute.set(attributeImpl.getTangoType(), value.getValue());
            value2.quality = value.getQuality();
            value2.time = TangoIDLUtil.getTime(value.getTime());
            value2.dim_x = value.getXDim();
            value2.dim_y = value.getYDim();
        }
        catch (IllegalArgumentException e) {
            throw DevFailedUtils.newDevFailed((Throwable)e);
        }
        XLOGGER.exit();
        return value2;
    }

    public static AttributeValue_3 toAttributeValue3(AttributeImpl attributeImpl, AttributeValue read, AttributeValue write) throws DevFailed {
        XLOGGER.entry(new Object[0]);
        AttributeValue_3 value3 = new AttributeValue_3();
        try {
            value3.name = attributeImpl.getName();
            value3.w_dim = new AttributeDim();
            Object readValue = read.getValue();
            if (write != null && write.getValue() != null) {
                Object writeValue = write.getValue();
                Object insert = TangoIDLAttributeUtil.readWriteInArray(readValue, writeValue);
                value3.value = CleverAnyAttribute.set(attributeImpl.getTangoType(), insert);
                value3.w_dim.dim_x = write.getXDim();
                value3.w_dim.dim_y = write.getYDim();
            } else {
                value3.value = CleverAnyAttribute.set(attributeImpl.getTangoType(), read.getValue());
            }
            value3.quality = read.getQuality();
            value3.time = TangoIDLUtil.getTime(read.getTime());
            value3.r_dim = new AttributeDim();
            value3.r_dim.dim_x = read.getXDim();
            value3.r_dim.dim_y = read.getYDim();
            value3.err_list = new DevError[0];
        }
        catch (IllegalArgumentException e) {
            throw DevFailedUtils.newDevFailed((Throwable)e);
        }
        XLOGGER.exit();
        return value3;
    }

    public static AttributeValue_3 toAttributeValue3Error(String name, DevFailed e) {
        AttributeValue_3 value3 = new AttributeValue_3();
        value3.name = name;
        try {
            value3.value = ORBManager.createAny();
        }
        catch (DevFailed devFailed) {
            // empty catch block
        }
        value3.quality = AttrQuality.ATTR_INVALID;
        value3.time = TangoIDLUtil.getTime(System.currentTimeMillis());
        value3.r_dim = new AttributeDim();
        value3.w_dim = new AttributeDim();
        value3.err_list = e.errors;
        return value3;
    }

    public static AttributeValue_5 toAttributeValue5(AttributeImpl attributeImpl, AttributeValue read, AttributeValue write) throws DevFailed {
        XLOGGER.entry(new Object[0]);
        AttributeValue_5 value = new AttributeValue_5();
        try {
            Object readValue = read.getValue();
            value.name = attributeImpl.getName();
            value.data_format = attributeImpl.getFormat();
            value.data_type = attributeImpl.getTangoType();
            value.w_dim = new AttributeDim();
            if (attributeImpl.getWritable().equals(AttrWriteType.READ_WRITE) && write != null && write.getValue() != null) {
                Object writeValue = write.getValue();
                Object insert = TangoIDLAttributeUtil.readWriteInArray(readValue, writeValue);
                value.value = CleverAttrValUnion.set(attributeImpl.getTangoType(), insert);
                value.w_dim.dim_x = write.getXDim();
                value.w_dim.dim_y = write.getYDim();
            } else {
                value.value = CleverAttrValUnion.set(attributeImpl.getTangoType(), readValue);
            }
            value.quality = read.getQuality();
            value.time = TangoIDLUtil.getTime(read.getTime());
            value.r_dim = new AttributeDim();
            value.r_dim.dim_x = read.getXDim();
            value.r_dim.dim_y = read.getYDim();
            value.err_list = new DevError[0];
        }
        catch (IllegalArgumentException e) {
            throw DevFailedUtils.newDevFailed((Throwable)e);
        }
        XLOGGER.exit();
        return value;
    }

    public static AttributeValue_4 toAttributeValue4(AttributeImpl attributeImpl, AttributeValue read, AttributeValue write) throws DevFailed {
        XLOGGER.entry(new Object[0]);
        AttributeValue_4 value4 = new AttributeValue_4();
        try {
            Object readValue = read.getValue();
            value4.name = attributeImpl.getName();
            value4.data_format = attributeImpl.getFormat();
            value4.w_dim = new AttributeDim();
            if (attributeImpl.getWritable().equals(AttrWriteType.READ_WRITE) && write != null && write.getValue() != null) {
                Object writeValue = write.getValue();
                Object insert = TangoIDLAttributeUtil.readWriteInArray(readValue, writeValue);
                value4.value = CleverAttrValUnion.set(attributeImpl.getTangoType(), insert);
                value4.w_dim.dim_x = write.getXDim();
                value4.w_dim.dim_y = write.getYDim();
            } else {
                value4.value = CleverAttrValUnion.set(attributeImpl.getTangoType(), readValue);
            }
            value4.quality = read.getQuality();
            value4.time = TangoIDLUtil.getTime(read.getTime());
            value4.r_dim = new AttributeDim();
            value4.r_dim.dim_x = read.getXDim();
            value4.r_dim.dim_y = read.getYDim();
            value4.err_list = new DevError[0];
        }
        catch (IllegalArgumentException e) {
            throw DevFailedUtils.newDevFailed((Throwable)e);
        }
        XLOGGER.exit();
        return value4;
    }

    private static Object readWriteInArray(Object readValue, Object writeValue) {
        Object insert = null;
        if (readValue.getClass().isArray()) {
            int readLength = Array.getLength(readValue);
            int writeLength = Array.getLength(writeValue);
            insert = Array.newInstance(readValue.getClass().getComponentType(), readLength + writeLength);
            System.arraycopy(readValue, 0, insert, 0, readLength);
            System.arraycopy(writeValue, 0, insert, readLength, writeLength);
        } else {
            insert = Array.newInstance(readValue.getClass(), 2);
            Array.set(insert, 0, readValue);
            Array.set(insert, 1, writeValue);
        }
        return insert;
    }

    public static AttributeValue_4 toAttributeValue4Error(String name, AttrDataFormat format, DevFailed e) {
        AttributeValue_4 value4 = new AttributeValue_4();
        value4.name = name;
        value4.data_format = format;
        value4.value = new AttrValUnion();
        value4.value.union_no_data(true);
        value4.quality = AttrQuality.ATTR_INVALID;
        value4.time = TangoIDLUtil.getTime(System.currentTimeMillis());
        value4.r_dim = new AttributeDim();
        value4.w_dim = new AttributeDim();
        value4.err_list = e.errors;
        return value4;
    }

    public static AttributeValue_5 toAttributeValue5Error(String name, AttrDataFormat format, int dataType, DevFailed e) {
        AttributeValue_5 value = new AttributeValue_5();
        value.name = name;
        value.data_format = format;
        value.data_type = dataType;
        value.value = new AttrValUnion();
        value.value.union_no_data(true);
        value.quality = AttrQuality.ATTR_INVALID;
        value.time = TangoIDLUtil.getTime(System.currentTimeMillis());
        value.r_dim = new AttributeDim();
        value.w_dim = new AttributeDim();
        value.err_list = e.errors;
        return value;
    }

    public static AttributeConfig toAttributeConfig(AttributeImpl attribute) throws DevFailed {
        AttributePropertiesImpl props = attribute.getProperties();
        return new AttributeConfig(attribute.getName(), attribute.getWritable(), attribute.getFormat(), attribute.getTangoType(), attribute.getMaxX(), attribute.getMaxY(), props.getDescription(), attribute.getProperties().getLabel(), props.getUnit(), props.getStandardUnit(), attribute.getProperties().getDisplayUnit(), props.getFormat(), props.getMinValue(), attribute.getProperties().getMaxValue(), props.getMinAlarm(), props.getMaxAlarm(), props.getWritableAttrName(), props.getExtensions());
    }

    public static AttributeConfig_2 toAttributeConfig2(AttributeImpl attribute) throws DevFailed {
        AttributePropertiesImpl props = attribute.getProperties();
        return new AttributeConfig_2(attribute.getName(), attribute.getWritable(), attribute.getFormat(), attribute.getTangoType(), attribute.getMaxX(), attribute.getMaxY(), props.getDescription(), attribute.getProperties().getLabel(), props.getUnit(), props.getStandardUnit(), attribute.getProperties().getDisplayUnit(), props.getFormat(), props.getMinValue(), attribute.getProperties().getMaxValue(), props.getMinAlarm(), props.getMaxAlarm(), props.getWritableAttrName(), attribute.getDispLevel(), props.getExtensions());
    }

    public static AttributeConfig_5 toAttributeConfig5(AttributeImpl attribute) throws DevFailed {
        AttributePropertiesImpl props = attribute.getProperties();
        AttributeAlarm alarm = new AttributeAlarm();
        alarm.delta_t = props.getDeltaT();
        alarm.delta_val = props.getDeltaVal();
        alarm.max_alarm = props.getMaxAlarm();
        alarm.max_warning = props.getMaxWarning();
        alarm.min_alarm = props.getMinAlarm();
        alarm.min_warning = props.getMinWarning();
        alarm.extensions = props.getAlarmExtensions();
        return new AttributeConfig_5(attribute.getName(), attribute.getWritable(), attribute.getFormat(), attribute.getTangoType(), attribute.isMemorized(), attribute.isMemorizedAtInit(), attribute.getMaxX(), attribute.getMaxY(), props.getDescription(), attribute.getProperties().getLabel(), props.getUnit(), props.getStandardUnit(), attribute.getProperties().getDisplayUnit(), props.getFormat(), props.getMinValue(), attribute.getProperties().getMaxValue(), props.getWritableAttrName(), attribute.getDispLevel(), props.getRootAttribute(), props.getEnumLabels(), alarm, props.getEventProp(), props.getExtensions(), props.getSysExtensions());
    }

    public static AttributeConfig_5 toAttributeConfig5(AttributeConfiguration config) throws DevFailed {
        AttributePropertiesImpl props = config.getAttributeProperties();
        AttributeAlarm alarm = new AttributeAlarm();
        alarm.delta_t = props.getDeltaT();
        alarm.delta_val = props.getDeltaVal();
        alarm.max_alarm = props.getMaxAlarm();
        alarm.max_warning = props.getMaxWarning();
        alarm.min_alarm = props.getMinAlarm();
        alarm.min_warning = props.getMinWarning();
        alarm.extensions = props.getAlarmExtensions();
        return new AttributeConfig_5(config.getName(), config.getWritable(), config.getFormat(), config.getTangoType(), config.isMemorized(), config.isMemorizedAtInit(), config.getMaxX(), config.getMaxY(), props.getDescription(), config.getAttributeProperties().getLabel(), props.getUnit(), props.getStandardUnit(), config.getAttributeProperties().getDisplayUnit(), props.getFormat(), props.getMinValue(), config.getAttributeProperties().getMaxValue(), props.getWritableAttrName(), config.getDispLevel(), props.getRootAttribute(), props.getEnumLabels(), alarm, props.getEventProp(), props.getExtensions(), props.getSysExtensions());
    }

    public static AttributeConfig_3 toAttributeConfig3(AttributeImpl attribute) throws DevFailed {
        AttributePropertiesImpl props = attribute.getProperties();
        AttributeAlarm alarm = new AttributeAlarm();
        alarm.delta_t = props.getDeltaT();
        alarm.delta_val = props.getDeltaVal();
        alarm.max_alarm = props.getMaxAlarm();
        alarm.max_warning = props.getMaxWarning();
        alarm.min_alarm = props.getMinAlarm();
        alarm.min_warning = props.getMinWarning();
        alarm.extensions = props.getAlarmExtensions();
        return new AttributeConfig_3(attribute.getName(), attribute.getWritable(), attribute.getFormat(), attribute.getTangoType(), attribute.getMaxX(), attribute.getMaxY(), props.getDescription(), attribute.getProperties().getLabel(), props.getUnit(), props.getStandardUnit(), attribute.getProperties().getDisplayUnit(), props.getFormat(), props.getMinValue(), attribute.getProperties().getMaxValue(), props.getWritableAttrName(), attribute.getDispLevel(), alarm, props.getEventProp(), props.getExtensions(), props.getSysExtensions());
    }

    public static AttributePropertiesImpl toAttributeProperties(AttributeConfig config) {
        AttributePropertiesImpl props = new AttributePropertiesImpl();
        props.setDescription(config.description);
        props.setDisplayUnit(config.display_unit);
        props.setExtensions(config.extensions);
        props.setFormat(config.format);
        props.setLabel(config.label);
        props.setMaxAlarm(config.max_alarm);
        props.setMaxValue(config.max_value);
        props.setMinAlarm(config.min_alarm);
        props.setMinValue(config.min_value);
        props.setStandardUnit(config.standard_unit);
        props.setUnit(config.unit);
        return props;
    }

    public static AttributePropertiesImpl toAttributeProperties(AttributeConfig_2 config2) {
        AttributePropertiesImpl props = new AttributePropertiesImpl();
        props.setDescription(config2.description);
        props.setDisplayUnit(config2.display_unit);
        props.setExtensions(config2.extensions);
        props.setFormat(config2.format);
        props.setLabel(config2.label);
        props.setMaxAlarm(config2.max_alarm);
        props.setMaxValue(config2.max_value);
        props.setMinAlarm(config2.min_alarm);
        props.setMinValue(config2.min_value);
        props.setStandardUnit(config2.standard_unit);
        props.setUnit(config2.unit);
        props.setWritableAttrName(config2.writable_attr_name);
        return props;
    }

    public static AttributePropertiesImpl toAttributeProperties(AttributeConfig_3 config) {
        AttributePropertiesImpl props = new AttributePropertiesImpl();
        props.setAlarmExtensions(config.att_alarm.extensions);
        props.setDeltaT(config.att_alarm.delta_t);
        props.setDeltaVal(config.att_alarm.delta_val);
        props.setDescription(config.description);
        props.setDisplayUnit(config.display_unit);
        props.setEventProp(config.event_prop);
        props.setExtensions(config.extensions);
        props.setFormat(config.format);
        props.setLabel(config.label);
        props.setMaxAlarm(config.att_alarm.max_alarm);
        props.setMaxValue(config.max_value);
        props.setMaxWarning(config.att_alarm.max_warning);
        props.setMinAlarm(config.att_alarm.min_alarm);
        props.setMinValue(config.min_value);
        props.setMinWarning(config.att_alarm.min_warning);
        props.setStandardUnit(config.standard_unit);
        props.setSysExtensions(config.sys_extensions);
        props.setUnit(config.unit);
        props.setWritableAttrName(config.writable_attr_name);
        return props;
    }

    public static AttributePropertiesImpl toAttributeProperties(AttributeConfig_5 config) throws DevFailed {
        AttributePropertiesImpl props = new AttributePropertiesImpl();
        props.setAlarmExtensions(config.att_alarm.extensions);
        props.setDeltaT(config.att_alarm.delta_t);
        props.setDeltaVal(config.att_alarm.delta_val);
        props.setDescription(config.description);
        props.setDisplayUnit(config.display_unit);
        props.setEventProp(config.event_prop);
        props.setExtensions(config.extensions);
        props.setFormat(config.format);
        props.setLabel(config.label);
        props.setMaxAlarm(config.att_alarm.max_alarm);
        props.setMaxValue(config.max_value);
        props.setMaxWarning(config.att_alarm.max_warning);
        props.setMinAlarm(config.att_alarm.min_alarm);
        props.setMinValue(config.min_value);
        props.setMinWarning(config.att_alarm.min_warning);
        props.setStandardUnit(config.standard_unit);
        props.setSysExtensions(config.sys_extensions);
        props.setUnit(config.unit);
        props.setWritableAttrName(config.writable_attr_name);
        props.setEnumLabels(config.enum_labels);
        return props;
    }
}

