/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.idl;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevPipeBlob;
import fr.esrf.Tango.DevPipeData;
import fr.esrf.Tango.PipeConfig;
import fr.esrf.Tango.TimeVal;
import fr.esrf.TangoApi.PipeBlob;
import org.tango.server.pipe.PipeConfiguration;
import org.tango.server.pipe.PipeImpl;
import org.tango.server.pipe.PipeValue;

public final class TangoIDLUtil {
    private static final int FACTOR_1000 = 1000;

    private TangoIDLUtil() {
    }

    public static TimeVal getTime(long nbMillisec) {
        TimeVal timeVal = new TimeVal();
        timeVal.tv_sec = (int)(nbMillisec / 1000L);
        timeVal.tv_usec = (int)((nbMillisec - nbMillisec / 1000L * 1000L) * 1000L);
        timeVal.tv_nsec = 0;
        return timeVal;
    }

    public static int getTime(TimeVal timeVal) {
        return timeVal.tv_nsec * 1000 + timeVal.tv_usec * 1000 * 1000;
    }

    public static PipeConfig toPipeConfig(PipeImpl pipe) throws DevFailed {
        PipeConfiguration props = pipe.getConfiguration();
        return new PipeConfig(pipe.getName(), props.getDescription(), props.getLabel(), props.getDisplayLevel(), props.getWriteType(), props.getExtensions());
    }

    public static DevPipeData toDevPipeData(String pipeName, PipeValue pipeValue) throws DevFailed {
        DevPipeBlob devPipeBlob = pipeValue.getValue().getDevPipeBlobObject();
        return new DevPipeData(pipeName, TangoIDLUtil.getTime(pipeValue.getTime()), devPipeBlob);
    }

    public static PipeValue toPipeValue(DevPipeData pipeData) throws DevFailed {
        PipeValue value = new PipeValue();
        value.setValue(new PipeBlob(pipeData.data_blob), (long)TangoIDLUtil.getTime(pipeData.time));
        return value;
    }
}

