/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.pipe;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DispLevel;
import fr.esrf.Tango.PipeWriteType;
import java.util.HashMap;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.tango.server.IConfigurable;
import org.tango.server.properties.PropertiesUtils;

public final class PipeConfiguration
implements IConfigurable {
    private final String name;
    private String label = "";
    private String description = "";
    private DispLevel displayLevel;
    private PipeWriteType writeType;
    private String[] extensions = new String[0];

    public PipeConfiguration(String name) {
        this.name = name;
    }

    public DispLevel getDisplayLevel() {
        return this.displayLevel;
    }

    public void setDisplayLevel(DispLevel displayLevel) {
        this.displayLevel = displayLevel;
    }

    public PipeWriteType getWriteType() {
        return this.writeType;
    }

    public void setWriteType(PipeWriteType writeType) {
        this.writeType = writeType;
    }

    public String[] getExtensions() {
        return this.extensions;
    }

    public void setExtensions(String[] extensions) {
        this.extensions = extensions;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        if (!label.isEmpty()) {
            this.label = label;
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description.isEmpty() || description.equalsIgnoreCase("Not specified") || description.equalsIgnoreCase("None") ? "No description" : description;
    }

    @Override
    public void persist(String deviceName) throws DevFailed {
        HashMap<String, String[]> properties = new HashMap<String, String[]>();
        if (!this.getLabel().isEmpty()) {
            properties.put("label", new String[]{this.getLabel()});
        }
        if (!this.getDescription().equals("No description")) {
            properties.put("description", new String[]{this.getDescription()});
        }
        PropertiesUtils.setDevicePipePropertiesInDB(deviceName, this.name, properties);
    }

    @Override
    public void load(String deviceName) throws DevFailed {
        String[] descs;
        String[] labels = PropertiesUtils.getDevicePipeProperty(deviceName, "", this.name, "label");
        if (labels.length == 1) {
            this.setLabel(labels[0]);
        }
        if ((descs = PropertiesUtils.getDevicePipeProperty(deviceName, "", this.name, "description")).length == 1) {
            this.setDescription(descs[0]);
        }
    }

    @Override
    public void clear(String deviceName) throws DevFailed {
    }

    public String toString() {
        ReflectionToStringBuilder reflectionToStringBuilder = new ReflectionToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        return reflectionToStringBuilder.toString();
    }
}

