/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.properties;

import fr.esrf.Tango.DevFailed;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.client.database.DatabaseFactory;
import org.tango.utils.CaseInsensitiveMap;

public final class AttributePropertiesManager {
    private final XLogger xlogger = XLoggerFactory.getXLogger(AttributePropertiesManager.class);
    private final Logger logger = LoggerFactory.getLogger(AttributePropertiesManager.class);
    private final String deviceName;

    public AttributePropertiesManager(String deviceName) {
        this.deviceName = deviceName;
    }

    public Map<String, String[]> getAttributePropertiesFromDB(String attributeName) throws DevFailed {
        this.xlogger.entry(new Object[]{attributeName});
        this.xlogger.exit();
        return DatabaseFactory.getDatabase().getAttributeProperties(this.deviceName, attributeName);
    }

    private Map<String, String> getAttributePropertiesFromDBSingle(String attributeName) throws DevFailed {
        this.xlogger.entry(new Object[]{attributeName});
        CaseInsensitiveMap result = new CaseInsensitiveMap();
        Map prop = DatabaseFactory.getDatabase().getAttributeProperties(this.deviceName, attributeName);
        for (Map.Entry entry : prop.entrySet()) {
            String name = (String)entry.getKey();
            String[] value = (String[])entry.getValue();
            if (value.length <= 0 || value[0].equalsIgnoreCase("Not specified")) continue;
            result.put(name, value[0]);
        }
        this.xlogger.exit();
        return result;
    }

    public void removeAttributeProperties(String ... attributeNames) throws DevFailed {
        DatabaseFactory.getDatabase().deleteAttributeProperties(this.deviceName, attributeNames);
    }

    public String getAttributePropertyFromDB(String attributeName, String propertyName) throws DevFailed {
        this.xlogger.entry(new Object[]{propertyName});
        Object[] result = new String[]{};
        Map prop = DatabaseFactory.getDatabase().getAttributeProperties(this.deviceName, attributeName);
        if (prop.get(propertyName) != null) {
            result = (String[])prop.get(propertyName);
            this.logger.debug(attributeName + " property {} is {}", (Object)propertyName, (Object)Arrays.toString(result));
        }
        this.xlogger.exit();
        String single = "";
        if (result.length == 1 && !result[0].isEmpty()) {
            single = result[0];
        }
        return single;
    }

    public void setAttributePropertyInDB(String attributeName, String propertyName, String value) throws DevFailed {
        this.xlogger.entry(new Object[]{propertyName});
        this.logger.debug("update in DB {}, property {}= {}", new Object[]{attributeName, propertyName, value});
        HashMap<String, String[]> propInsert = new HashMap<String, String[]>();
        propInsert.put(propertyName, new String[]{value});
        DatabaseFactory.getDatabase().setAttributeProperties(this.deviceName, attributeName, propInsert);
        this.xlogger.exit();
    }

    public void setAttributePropertiesInDB(String attributeName, Map<String, String[]> properties) throws DevFailed {
        this.xlogger.entry(new Object[]{properties});
        Map<String, String> currentValues = this.getAttributePropertiesFromDBSingle(attributeName);
        HashMap<String, String[]> propInsert = new HashMap<String, String[]>();
        for (Map.Entry<String, String[]> entry : properties.entrySet()) {
            String propertyName = entry.getKey();
            String[] valueArray = entry.getValue();
            if (valueArray.length == 1) {
                String value = valueArray[0];
                String presentValue = currentValues.get(propertyName);
                boolean isADefaultValue = false;
                if (presentValue != null) {
                    boolean bl = isADefaultValue = presentValue.isEmpty() && (value.equalsIgnoreCase("Not specified") || value.equalsIgnoreCase("No display unit") || value.equalsIgnoreCase("No unit") || value.equalsIgnoreCase("No standard unit"));
                }
                if (isADefaultValue) continue;
                if (presentValue == null) {
                    propInsert.put(propertyName, valueArray);
                    continue;
                }
                if (presentValue.equals(value) || value.isEmpty() || value.equals("NaN")) continue;
                propInsert.put(propertyName, valueArray);
                continue;
            }
            propInsert.put(propertyName, valueArray);
        }
        this.logger.debug("update attribute {} properties {} in DB ", (Object)attributeName, properties.keySet());
        DatabaseFactory.getDatabase().setAttributeProperties(this.deviceName, attributeName, propInsert);
        this.xlogger.exit();
    }

    public String getDeviceName() {
        return this.deviceName;
    }
}

