/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.properties;

import fr.esrf.Tango.DevFailed;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.server.properties.PropertiesUtils;

public final class ClassPropertyImpl {
    private final XLogger xlogger = XLoggerFactory.getXLogger(ClassPropertyImpl.class);
    private final Method propertyMethod;
    private final String description;
    private final Object businessObject;
    private final String className;
    private final String name;
    private final String[] defaultValue;

    public ClassPropertyImpl(String propertyName, String description, Method propertyMethod, Object businessObject, String className, String ... defaultValue) throws DevFailed {
        this.description = description;
        this.propertyMethod = propertyMethod;
        this.businessObject = businessObject;
        this.className = className;
        this.name = propertyName;
        this.defaultValue = defaultValue.length == 0 ? new String[]{} : defaultValue;
    }

    public void update() throws DevFailed {
        this.xlogger.entry(new Object[]{this.name});
        String[] property = new String[]{};
        Map<String, String[]> prop = PropertiesUtils.getClassProperties(this.className);
        String[] temp = PropertiesUtils.getProp(prop, this.name);
        if (temp != null) {
            property = temp;
        }
        PropertiesUtils.injectProperty(this.name, this.propertyMethod, property, this.businessObject, this.defaultValue);
        this.xlogger.exit();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getDefaultValue() {
        return Arrays.copyOf(this.defaultValue, this.defaultValue.length);
    }
}

