/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.servant;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.Device_5;
import java.util.Locale;
import java.util.StringTokenizer;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.WrongAdapter;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;
import org.slf4j.ext.XLogger;
import org.slf4j.ext.XLoggerFactory;
import org.tango.client.database.DatabaseFactory;
import org.tango.client.database.DeviceExportInfo;
import org.tango.orb.IORDump;
import org.tango.orb.ORBManager;
import org.tango.server.servant.DeviceImpl;
import org.tango.utils.DevFailedUtils;

public final class ORBUtils {
    private static final XLogger XLOGGER = XLoggerFactory.getXLogger(ORBUtils.class);

    private ORBUtils() {
    }

    public static void exportDevice(DeviceImpl dev, String hostName, String pid) throws DevFailed {
        if (DatabaseFactory.isUseDb()) {
            ORBUtils.exportDeviceWithDatabase(dev, hostName, pid);
        } else {
            ORBUtils.exportDeviceWithoutDatabase(dev);
        }
    }

    private static void exportDeviceWithDatabase(DeviceImpl dev, String hostName, String pid) throws DevFailed {
        XLOGGER.entry(new java.lang.Object[]{dev.getName()});
        ORB orb = ORBManager.getOrb();
        Device_5 d = dev._this(orb);
        POA poa = ORBManager.getPoa();
        try {
            dev.setObjId(poa.reference_to_id((Object)d));
        }
        catch (WrongAdapter e) {
            throw DevFailedUtils.newDevFailed((Throwable)e);
        }
        catch (WrongPolicy e) {
            throw DevFailedUtils.newDevFailed((Throwable)e);
        }
        DeviceExportInfo info = new DeviceExportInfo(dev.getName(), orb.object_to_string((Object)d), hostName, Integer.toString(5), pid, dev.getClassName());
        DatabaseFactory.getDatabase().exportDevice(info);
        XLOGGER.exit();
    }

    private static void exportDeviceWithoutDatabase(DeviceImpl dev) throws DevFailed {
        XLOGGER.entry(new java.lang.Object[]{dev.getName()});
        String lowerCaseDevice = dev.getName().toLowerCase(Locale.ENGLISH);
        byte[] oid = lowerCaseDevice.getBytes();
        POA poa = ORBManager.getPoa();
        try {
            poa.activate_object_with_id(oid, (Servant)dev);
        }
        catch (ServantAlreadyActive e) {
            throw DevFailedUtils.newDevFailed((Throwable)e);
        }
        catch (ObjectAlreadyActive e) {
            throw DevFailedUtils.newDevFailed((Throwable)e);
        }
        catch (WrongPolicy e) {
            throw DevFailedUtils.newDevFailed((Throwable)e);
        }
        dev._this(ORBManager.getOrb());
        dev.setObjId(oid);
        ORBUtils.registerDeviceForJacorb(lowerCaseDevice);
        XLOGGER.exit();
    }

    public static IORDump getIORDump(DeviceImpl dev) throws DevFailed {
        ORB orb = ORBManager.getOrb();
        Device_5 d = dev._this(orb);
        return new IORDump(dev.getName(), orb.object_to_string((Object)d));
    }

    public static void unexportDevice(DeviceImpl device) throws DevFailed {
        XLOGGER.entry(new java.lang.Object[]{device.getName()});
        device.deleteDevice();
        POA poa = ORBManager.getPoa();
        try {
            poa.deactivate_object(device.getObjId());
        }
        catch (ObjectNotActive e) {
            throw DevFailedUtils.newDevFailed((Throwable)e);
        }
        catch (WrongPolicy e) {
            throw DevFailedUtils.newDevFailed((Throwable)e);
        }
        XLOGGER.exit();
    }

    private static void registerDeviceForJacorb(String name) throws DevFailed {
        StringTokenizer st = new StringTokenizer(name, "/");
        String[] field = new String[3];
        for (int i = 0; i < 3 && st.countTokens() > 0; ++i) {
            field[i] = st.nextToken();
        }
        String separator = "&%25";
        String targetname = "nodb.device/nodb_poa/" + field[0] + "&%25" + field[1] + "&%25" + field[2];
        org.jacorb.orb.ORB jacorb = (org.jacorb.orb.ORB)ORBManager.getOrb();
        jacorb.addObjectKey(name, targetname);
    }
}

