/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.testserver;

import fr.esrf.Tango.AttrWriteType;
import fr.esrf.Tango.DevEncoded;
import fr.esrf.Tango.DevFailed;
import java.util.HashMap;
import java.util.Map;
import org.tango.DeviceState;
import org.tango.server.StateMachineBehavior;
import org.tango.server.attribute.AttributeConfiguration;
import org.tango.server.attribute.AttributeValue;
import org.tango.server.attribute.IAttributeBehavior;
import org.tango.server.attribute.ISetValueUpdater;

public final class DynamicAttributeTest
implements IAttributeBehavior,
ISetValueUpdater {
    private AttributeValue value = new AttributeValue();
    private final AttributeConfiguration configAttr = new AttributeConfiguration();
    private static final Map<Class<?>, Object> RESULTS_MAP = new HashMap();

    public DynamicAttributeTest(Class<?> clazz) throws DevFailed {
        this.configAttr.setType(clazz);
        this.configAttr.setName(clazz.getSimpleName() + "Dynamic");
        this.configAttr.setWritable(AttrWriteType.READ_WRITE);
        this.value.setValue(RESULTS_MAP.get(this.configAttr.getType()));
    }

    public DynamicAttributeTest(Class<?> clazz, String attributeName) throws DevFailed {
        this.configAttr.setType(clazz);
        this.configAttr.setName(attributeName);
        this.configAttr.setWritable(AttrWriteType.READ_WRITE);
        this.value.setValue(RESULTS_MAP.get(this.configAttr.getType()));
    }

    @Override
    public AttributeValue getValue() throws DevFailed {
        return this.value;
    }

    @Override
    public void setValue(AttributeValue value) throws DevFailed {
        this.value = value;
    }

    @Override
    public AttributeConfiguration getConfiguration() throws DevFailed {
        return this.configAttr;
    }

    @Override
    public StateMachineBehavior getStateMachine() {
        StateMachineBehavior stateMachine = new StateMachineBehavior();
        stateMachine.setDeniedStates(DeviceState.FAULT);
        stateMachine.setEndState(DeviceState.ON);
        return stateMachine;
    }

    @Override
    public AttributeValue getSetValue() throws DevFailed {
        if (this.configAttr.getType().equals(Double.TYPE)) {
            return new AttributeValue(120.3);
        }
        return this.value;
    }

    static {
        RESULTS_MAP.put(Boolean.TYPE, false);
        RESULTS_MAP.put(Short.TYPE, (short)0);
        RESULTS_MAP.put(Integer.TYPE, 0);
        RESULTS_MAP.put(Byte.TYPE, (byte)0);
        RESULTS_MAP.put(Float.TYPE, Float.valueOf(0.0f));
        RESULTS_MAP.put(Long.TYPE, 0L);
        RESULTS_MAP.put(Double.TYPE, 0.0);
        RESULTS_MAP.put(String.class, "");
        RESULTS_MAP.put(DeviceState.class, DeviceState.ON);
        RESULTS_MAP.put(DevEncoded.class, new DevEncoded());
        RESULTS_MAP.put(short[].class, new short[0]);
        RESULTS_MAP.put(int[].class, new int[0]);
        RESULTS_MAP.put(byte[].class, new byte[0]);
        RESULTS_MAP.put(float[].class, new float[0]);
        RESULTS_MAP.put(double[].class, new double[0]);
        RESULTS_MAP.put(long[].class, new long[0]);
        RESULTS_MAP.put(String[].class, new String[0]);
        RESULTS_MAP.put(boolean[].class, new boolean[0]);
        RESULTS_MAP.put(DeviceState[].class, new DeviceState[0]);
        RESULTS_MAP.put(DevEncoded[].class, new DevEncoded[0]);
        RESULTS_MAP.put(short[][].class, new short[][]{new short[0]});
        RESULTS_MAP.put(int[][].class, new int[][]{new int[0]});
        RESULTS_MAP.put(byte[][].class, new byte[][]{new byte[0]});
        RESULTS_MAP.put(float[][].class, new float[][]{new float[0]});
        RESULTS_MAP.put(double[][].class, new double[][]{new double[0]});
        RESULTS_MAP.put(long[][].class, new long[][]{new long[0]});
        RESULTS_MAP.put(String[][].class, new String[][]{new String[0]});
        RESULTS_MAP.put(boolean[][].class, new boolean[][]{new boolean[0]});
        RESULTS_MAP.put(DeviceState[][].class, new DeviceState[][]{new DeviceState[0]});
        RESULTS_MAP.put(DevEncoded[][].class, new DevEncoded[][]{new DevEncoded[0]});
    }
}

