/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.testserver;

import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.DevEncoded;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import org.tango.DeviceState;
import org.tango.server.ServerManager;
import org.tango.server.annotation.Attribute;
import org.tango.server.annotation.AttributeProperties;
import org.tango.server.annotation.Command;
import org.tango.server.annotation.Delete;
import org.tango.server.annotation.Device;
import org.tango.server.annotation.DeviceManagement;
import org.tango.server.annotation.Init;
import org.tango.server.annotation.State;
import org.tango.server.attribute.AttributePropertiesImpl;
import org.tango.server.attribute.AttributeValue;
import org.tango.server.device.DeviceManager;
import org.tango.server.events.EventType;
import org.tango.utils.DevFailedUtils;

@Device
public class EventServer {
    public static final String INSTANCE_NAME = "1";
    public static final String NO_DB_DEVICE_NAME = "1/2/3";
    public static final String SERVER_NAME = EventServer.class.getSimpleName();
    @Attribute(isPolled=true, pollingPeriod=100)
    @AttributeProperties(changeEventAbsolute="1", periodicEvent="100")
    private final double[] doubleArrayAtt = new double[]{1.0};
    @Attribute(isPolled=true, pollingPeriod=100)
    private final String[] stringArrayAtt = new String[]{"1"};
    @Attribute(isPolled=true, pollingPeriod=100)
    @AttributeProperties(changeEventAbsolute="100")
    private final boolean[] booleanArrayAtt = new boolean[]{false};
    @Attribute(isPolled=true, pollingPeriod=100)
    DeviceState[] stateArray = new DeviceState[]{DeviceState.OFF};
    @DeviceManagement
    DeviceManager deviceManager;
    @Attribute(isPolled=true, pollingPeriod=100)
    @AttributeProperties(changeEventAbsolute="1", periodicEvent="100")
    private volatile double doubleAtt = 1.0;
    @Attribute(isPolled=true, pollingPeriod=100, checkChangeEvent=true, pushChangeEvent=true)
    @AttributeProperties(changeEventAbsolute="0.9", periodicEvent="100")
    private double doubleAttSendTwice = 0.0;
    @Attribute(isPolled=true, pollingPeriod=100)
    @AttributeProperties(changeEventRelative="1")
    private double changeRelative = 1.0;
    @Attribute(isPolled=true, pollingPeriod=100)
    private String stringAtt = "1";
    @Attribute(isPolled=true, pollingPeriod=100)
    @AttributeProperties(changeEventAbsolute="5")
    private int qualityAtt;
    private AttrQuality quality = AttrQuality.ATTR_VALID;
    @Attribute(isPolled=true, pollingPeriod=100, checkArchivingEvent=false)
    @AttributeProperties(archiveEventPeriod="100")
    private long archive = 1L;
    @Attribute(checkArchivingEvent=true, pushArchiveEvent=true)
    @AttributeProperties(archiveEventRelative="0.001")
    private short archiveCheck = (short)3;
    @Attribute(isPolled=true, pollingPeriod=100)
    @AttributeProperties(changeEventAbsolute="100")
    private boolean booleanAtt = false;
    @Attribute(isPolled=true, pollingPeriod=100)
    @AttributeProperties(changeEventAbsolute="1")
    private DevEncoded devEncodedAttr;
    private byte counterEncoded = 0;
    @State
    private DeviceState state = DeviceState.OFF;
    private int counter = 1;
    private int error = 0;

    public static void startNoDb(int portNr) throws DevFailed {
        System.setProperty("OAPort", Integer.toString(portNr));
        ServerManager.getInstance().addClass(EventServer.class.getCanonicalName(), EventServer.class);
        ServerManager.getInstance().startError(new String[]{INSTANCE_NAME, "-nodb", "-dlist", NO_DB_DEVICE_NAME}, SERVER_NAME);
    }

    public static void start() throws DevFailed {
        ServerManager.getInstance().addClass(EventServer.class.getCanonicalName(), EventServer.class);
        ServerManager.getInstance().startError(new String[]{INSTANCE_NAME}, EventServer.class.getSimpleName());
        System.out.println("Event server started");
    }

    public static void main(String[] args) throws DevFailed {
        EventServer.start();
    }

    public double getDoubleAtt() throws DevFailed {
        this.doubleAtt += 1.0;
        String value = Double.toString(this.doubleAtt);
        AttributePropertiesImpl properties = this.deviceManager.getAttributeProperties("doubleAtt");
        properties.setLabel(value);
        properties.setArchivingEventAbsChange(value);
        this.deviceManager.setAttributeProperties("doubleAtt", properties);
        return this.doubleAtt;
    }

    public short getArchiveCheck() throws DevFailed {
        this.archiveCheck = (short)(this.archiveCheck + 1);
        return this.archiveCheck;
    }

    @Command
    public void sendCheckArchiveEvent() throws DevFailed {
        this.deviceManager.pushEvent("archiveCheck", EventType.ARCHIVE_EVENT);
    }

    @Delete
    public void delete() throws DevFailed {
        this.deviceManager.clearAttributeProperties();
    }

    public double getDoubleAttSendTwice() throws DevFailed {
        this.deviceManager.pushEvent("doubleAttSendTwice", new AttributeValue(this.doubleAttSendTwice - 1.0), EventType.CHANGE_EVENT);
        this.doubleAttSendTwice += 1.0;
        return this.doubleAttSendTwice;
    }

    public double getChangeRelative() throws DevFailed {
        this.changeRelative += 1.0;
        return this.changeRelative;
    }

    public double[] getDoubleArrayAtt() throws DevFailed {
        this.doubleArrayAtt[0] = this.doubleArrayAtt[0] + 1.0;
        return this.doubleArrayAtt;
    }

    public String getStringAtt() {
        this.stringAtt = Double.toString(Double.parseDouble(this.stringAtt) + 1.0);
        return this.stringAtt;
    }

    public String[] getStringArrayAtt() {
        this.stringArrayAtt[0] = Double.toString(Double.parseDouble(this.stringArrayAtt[0]) + 1.0);
        return this.stringArrayAtt;
    }

    public AttributeValue getQualityAtt() throws DevFailed {
        this.quality = this.quality == AttrQuality.ATTR_VALID ? AttrQuality.ATTR_CHANGING : AttrQuality.ATTR_VALID;
        return new AttributeValue(10, this.quality);
    }

    public long getArchive() {
        ++this.archive;
        return this.archive;
    }

    public AttributeValue getBooleanAtt() throws DevFailed {
        AttributeValue val = new AttributeValue();
        this.booleanAtt = !this.booleanAtt;
        val.setValue((Object)this.booleanAtt, 34567L);
        return val;
    }

    public boolean[] getBooleanArrayAtt() {
        this.booleanArrayAtt[0] = !this.booleanArrayAtt[0];
        return this.booleanArrayAtt;
    }

    public DevEncoded getDevEncodedAttr() {
        this.devEncodedAttr = new DevEncoded("toto", new byte[]{this.counterEncoded});
        this.counterEncoded = (byte)(this.counterEncoded + 1);
        return this.devEncodedAttr;
    }

    @Init
    public void init() throws DevFailed {
        this.deviceManager.startPolling("State", 100);
    }

    @Attribute
    public int getErrorAtt() throws DevFailed {
        throw DevFailedUtils.newDevFailed((String)"test");
    }

    public DeviceState[] getStateArray() {
        DeviceState[] deviceStateArray;
        if (this.stateArray[0] == DeviceState.OFF) {
            DeviceState[] deviceStateArray2 = new DeviceState[1];
            deviceStateArray = deviceStateArray2;
            deviceStateArray2[0] = DeviceState.ON;
        } else {
            DeviceState[] deviceStateArray3 = new DeviceState[1];
            deviceStateArray = deviceStateArray3;
            deviceStateArray3[0] = DeviceState.OFF;
        }
        this.stateArray = deviceStateArray;
        return this.stateArray;
    }

    @Attribute(pushDataReady=true)
    public double getDataReady() {
        return 10.0;
    }

    @Command
    public void pushDataReady() throws DevFailed {
        this.deviceManager.pushDataReadyEvent("doubleArrayAtt", this.counter++);
    }

    @Attribute
    public String getUserEvent() throws DevFailed {
        return "Hello";
    }

    @Command
    public void pushUserEvent() throws DevFailed {
        this.deviceManager.pushEvent("userEvent", EventType.USER_EVENT);
    }

    @Attribute(pushChangeEvent=true, checkChangeEvent=true)
    @AttributeProperties(changeEventAbsolute="100")
    public int getError() throws DevFailed {
        switch (this.error) {
            case 0: {
                throw DevFailedUtils.newDevFailed((String)"error0");
            }
            case 1: {
                throw DevFailedUtils.newDevFailed((String)"error1");
            }
        }
        return 0;
    }

    @Command
    public void setError(int error) throws DevFailed {
        this.error = error;
    }

    @Command
    public void pushError() throws DevFailed {
        this.deviceManager.pushEvent("error", EventType.CHANGE_EVENT);
    }

    public DeviceState getState() throws DevFailed {
        this.state = this.state == DeviceState.OFF ? DeviceState.ON : DeviceState.OFF;
        return this.state;
    }

    public void setState(DeviceState state) {
        this.state = state;
    }

    @Command
    public void pushDeviceStateEvents() throws DevFailed {
        DeviceState value = DeviceState.FAULT;
        this.deviceManager.pushEvent("State", new AttributeValue(value), EventType.USER_EVENT);
    }

    @Command
    public void pushDevStateEvents() throws DevFailed {
        this.deviceManager.pushEvent("State", new AttributeValue(DevState.ALARM), EventType.USER_EVENT);
    }

    public void setDeviceManager(DeviceManager deviceManager) {
        this.deviceManager = deviceManager;
    }
}

