/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.testserver;

import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.DevEncoded;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.DevVarDoubleStringArray;
import fr.esrf.Tango.DevVarLongStringArray;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tango.DeviceState;
import org.tango.server.InvocationContext;
import org.tango.server.ServerManager;
import org.tango.server.annotation.AroundInvoke;
import org.tango.server.annotation.Attribute;
import org.tango.server.annotation.AttributeProperties;
import org.tango.server.annotation.ClassProperty;
import org.tango.server.annotation.Command;
import org.tango.server.annotation.Delete;
import org.tango.server.annotation.Device;
import org.tango.server.annotation.DeviceManagement;
import org.tango.server.annotation.DeviceProperties;
import org.tango.server.annotation.DeviceProperty;
import org.tango.server.annotation.DynamicManagement;
import org.tango.server.annotation.Init;
import org.tango.server.annotation.Schedule;
import org.tango.server.annotation.State;
import org.tango.server.annotation.StateMachine;
import org.tango.server.annotation.Status;
import org.tango.server.annotation.TransactionType;
import org.tango.server.attribute.AttributeValue;
import org.tango.server.device.DeviceManager;
import org.tango.server.dynamic.DynamicManager;
import org.tango.server.testserver.DynamicAttributeTest;
import org.tango.server.testserver.DynamicCommandTest;
import org.tango.server.testserver.DynamicEnumAttribute;
import org.tango.utils.ArrayUtils;
import org.tango.utils.DevFailedUtils;

@Device(transactionType=TransactionType.NONE)
public final class JTangoTest {
    public static final String DEFAULT_NO_DB_DEVICE_NAME = "1/1/1";
    public static final String INSTANCE_NAME = "1";
    public static final String SERVER_NAME = JTangoTest.class.getSimpleName();
    private static final int SPECTRUM_SIZE = 100000;
    private static final int BOOLEAN_SPECTRUM_SIZE = 10000;
    private static final int X_IMAGE_SIZE = 200;
    private static final int Y_IMAGE_SIZE = 500;
    private final Logger logger = LoggerFactory.getLogger(JTangoTest.class);
    @Attribute
    @AttributeProperties(deltaTime="1", deltaValue="5")
    private final double deltaAttribute = 0.0;
    @Attribute
    @AttributeProperties(minAlarm="2")
    private final double invalidQuality = 0.0;
    @Attribute
    @AttributeProperties(minAlarm="2")
    private final double invalidQuality2 = 0.0;
    @State
    private DevState state;
    @Status
    private String status;
    @DeviceProperties
    private Map<String, String[]> props = new HashMap<String, String[]>();
    @DeviceProperty(defaultValue={"default"})
    private String myProp = "toto";
    @DeviceProperty
    private boolean booleanProp = false;
    @ClassProperty(defaultValue={"classDefault"})
    private String[] myClassProp = new String[]{"test0"};
    private short shortScalar = 0;
    @DeviceProperty
    private String[] emptyArrayProperty;
    @Attribute
    private short[] shortSpectrum = new short[0];
    @Attribute
    private short[][] shortImage = new short[0][];
    @Attribute
    private int intScalar = 0;
    @Attribute
    private int[] intSpectrum = new int[0];
    @Attribute
    private int[][] intImage = new int[0][];
    @Attribute
    @AttributeProperties(maxAlarm="10", description="toto")
    private long longScalar = 0L;
    @Attribute
    @AttributeProperties(minAlarm="0", maxAlarm="10", minValue="-100", maxValue="1015054014654325L", minWarning="3", maxWarning="4", description="test", deltaTime="10", deltaValue="20")
    private long[] longSpectrum = new long[]{1L, 2L};
    @Attribute
    private long[][] longImage = new long[0][];
    @Attribute
    private float floatScalar = 0.0f;
    @Attribute
    private float[] floatSpectrum = new float[0];
    @Attribute
    private float[][] floatImage = new float[][]{{10.2f, 10.214f}, {20.0121f, 20.0f}};
    @Attribute
    @AttributeProperties(minAlarm="0", maxAlarm="10", minValue="-100", maxValue="1002501.125D", deltaTime="10", deltaValue="20", minWarning="3", maxWarning="4", description="test")
    private double doubleScalar = 0.0;
    @Attribute
    private double[] doubleSpectrum = new double[0];
    @Attribute
    private double[][] doubleImage = new double[0][];
    private byte byteScalar = 1;
    @Attribute
    private byte[] byteSpectrum = new byte[0];
    @Attribute
    private byte[][] byteImage = new byte[0][];
    @Attribute
    private boolean booleanScalar = false;
    @Attribute
    private boolean[] booleanSpectrum = new boolean[0];
    @Attribute
    private boolean[][] booleanImage = new boolean[0][];
    @Attribute
    private String stringScalar = "totoScal";
    @Attribute
    private String[] stringSpectrum = new String[0];
    @Attribute
    private String[][] stringImage = new String[0][];
    @Attribute
    @StateMachine(deniedStates={DeviceState.OFF})
    private DeviceState stateScalar = DeviceState.ON;
    @Attribute
    private DeviceState[] stateSpectrum = new DeviceState[]{DeviceState.ON, DeviceState.OFF};
    @Attribute
    private DevEncoded devEncodedScalar = new DevEncoded("yfui", new byte[]{1, 2, 3});
    @Attribute
    private TestType enumAttribute = TestType.VALUE1;
    @DynamicManagement
    private DynamicManager dynamicManager;
    @DeviceManagement
    private DeviceManager deviceManager;
    private boolean error = false;
    private boolean error2 = false;
    private volatile boolean isScheduleRunning;

    public static void start() throws DevFailed {
        ServerManager.getInstance().addClass(JTangoTest.class.getCanonicalName(), JTangoTest.class);
        ServerManager.getInstance().startError(new String[]{INSTANCE_NAME}, SERVER_NAME);
    }

    public static void startNoDbFile(int portNr) throws DevFailed {
        System.setProperty("OAPort", Integer.toString(portNr));
        ServerManager.getInstance().addClass(JTangoTest.class.getCanonicalName(), JTangoTest.class);
        ServerManager.getInstance().startError(new String[]{INSTANCE_NAME, "-nodb", "-dlist", DEFAULT_NO_DB_DEVICE_NAME, "-file=" + JTangoTest.class.getResource("/noDbproperties.txt").getPath()}, SERVER_NAME);
    }

    public static void startNoDb(int portNr) throws DevFailed {
        JTangoTest.startNoDb(portNr, DEFAULT_NO_DB_DEVICE_NAME);
    }

    public static void startNoDb(int portNr, String deviceList) throws DevFailed {
        System.setProperty("OAPort", Integer.toString(portNr));
        ServerManager.getInstance().addClass(JTangoTest.class.getCanonicalName(), JTangoTest.class);
        ServerManager.getInstance().startError(new String[]{INSTANCE_NAME, "-nodb", "-dlist", deviceList}, SERVER_NAME);
    }

    public static void main(String[] args) {
        if (args.length > 1 && args[1].equals("NODB")) {
            try {
                JTangoTest.startNoDb(Integer.valueOf(args[2]));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            catch (DevFailed e) {
                e.printStackTrace();
            }
        } else {
            ServerManager.getInstance().addClass(JTangoTest.class.getCanonicalName(), JTangoTest.class);
            ServerManager.getInstance().start(new String[]{INSTANCE_NAME}, SERVER_NAME);
        }
    }

    @Command
    public String[] getEmptyArrayProperty() {
        return this.emptyArrayProperty;
    }

    public void setEmptyArrayProperty(String[] emptyArrayProperty) {
        this.emptyArrayProperty = emptyArrayProperty;
    }

    @Schedule(activationProperty="isRunRefresh", cronExpression="0/1 * * * * ?")
    public void refresh() {
        this.isScheduleRunning = true;
    }

    @Attribute
    public boolean isScheduleRunning() {
        return this.isScheduleRunning;
    }

    @Init
    @StateMachine(endState=DeviceState.ON)
    public void init() throws DevFailed {
        this.isScheduleRunning = false;
        this.setDefaultValues();
        this.shortScalar = (short)10;
        this.createDynamicAttributes();
        this.createDynamicCommands();
        this.logger.debug("props {}", this.props);
        this.status = "hello";
    }

    @Command
    public String getName() {
        return this.deviceManager.getName();
    }

    private void setDefaultValues() {
        int n;
        Object[] element2;
        this.shortSpectrum = new short[100000];
        Arrays.fill(this.shortSpectrum, (short)1);
        this.intSpectrum = new int[100000];
        Arrays.fill(this.intSpectrum, 0);
        this.byteSpectrum = new byte[100000];
        Arrays.fill(this.byteSpectrum, (byte)0);
        this.doubleSpectrum = new double[100000];
        Arrays.fill(this.doubleSpectrum, 0.0);
        this.floatSpectrum = new float[100000];
        Arrays.fill(this.floatSpectrum, 0.0f);
        this.booleanSpectrum = new boolean[10000];
        Arrays.fill(this.booleanSpectrum, true);
        this.stringSpectrum = new String[100000];
        Arrays.fill(this.stringSpectrum, "");
        for (Object[] element2 : this.shortImage = new short[200][500]) {
            Arrays.fill(element2, (short)0);
        }
        int[][] nArray = this.intImage = new int[200][500];
        int n2 = nArray.length;
        for (n = 0; n < n2; ++n) {
            element2 = nArray[n];
            Arrays.fill((int[])element2, 0);
        }
        byte[][] byArray = this.byteImage = new byte[200][500];
        n2 = byArray.length;
        for (n = 0; n < n2; ++n) {
            element2 = byArray[n];
            Arrays.fill((byte[])element2, (byte)0);
        }
        double[][] dArray = this.doubleImage = new double[200][500];
        n2 = dArray.length;
        for (n = 0; n < n2; ++n) {
            element2 = dArray[n];
            Arrays.fill((double[])element2, 0.0);
        }
        float[][] fArray = this.floatImage = new float[200][500];
        n2 = fArray.length;
        for (n = 0; n < n2; ++n) {
            element2 = fArray[n];
            Arrays.fill((float[])element2, 0.0f);
        }
        boolean[][] blArray = this.booleanImage = new boolean[200][500];
        n2 = blArray.length;
        for (n = 0; n < n2; ++n) {
            element2 = blArray[n];
            Arrays.fill((boolean[])element2, true);
        }
        String[][] stringArray = this.stringImage = new String[200][500];
        n2 = stringArray.length;
        for (n = 0; n < n2; ++n) {
            element2 = stringArray[n];
            Arrays.fill(element2, "");
        }
    }

    private void createDynamicCommands() throws DevFailed {
        this.dynamicManager.addCommand(new DynamicCommandTest(String.class));
        this.dynamicManager.addCommand(new DynamicCommandTest(String[].class));
        this.dynamicManager.addCommand(new DynamicCommandTest(Double.TYPE));
        this.dynamicManager.addCommand(new DynamicCommandTest(double[].class));
        this.dynamicManager.addCommand(new DynamicCommandTest(Integer.TYPE));
        this.dynamicManager.addCommand(new DynamicCommandTest(int[].class));
        this.dynamicManager.addCommand(new DynamicCommandTest(Float.TYPE));
        this.dynamicManager.addCommand(new DynamicCommandTest(float[].class));
        this.dynamicManager.addCommand(new DynamicCommandTest(Short.TYPE));
        this.dynamicManager.addCommand(new DynamicCommandTest(short[].class));
        this.dynamicManager.addCommand(new DynamicCommandTest(Long.TYPE));
        this.dynamicManager.addCommand(new DynamicCommandTest(long[].class));
        this.dynamicManager.addCommand(new DynamicCommandTest(Byte.TYPE));
        this.dynamicManager.addCommand(new DynamicCommandTest(byte[].class));
        this.dynamicManager.addCommand(new DynamicCommandTest(Boolean.TYPE));
        this.dynamicManager.addCommand(new DynamicCommandTest(DevVarDoubleStringArray.class));
        this.dynamicManager.addCommand(new DynamicCommandTest(DevVarLongStringArray.class));
    }

    private void createDynamicAttributes() throws DevFailed {
        this.dynamicManager.addAttribute(new DynamicAttributeTest(String.class));
        this.dynamicManager.addAttribute(new DynamicAttributeTest(String[].class));
        this.dynamicManager.addAttribute(new DynamicAttributeTest(String[][].class));
        this.dynamicManager.addAttribute(new DynamicAttributeTest(Double.TYPE));
        this.dynamicManager.addAttribute(new DynamicAttributeTest(double[].class));
        this.dynamicManager.addAttribute(new DynamicAttributeTest(double[][].class));
        this.dynamicManager.addAttribute(new DynamicAttributeTest(Integer.TYPE));
        this.dynamicManager.addAttribute(new DynamicAttributeTest(int[].class));
        this.dynamicManager.addAttribute(new DynamicAttributeTest(int[][].class));
        this.dynamicManager.addAttribute(new DynamicAttributeTest(Float.TYPE));
        this.dynamicManager.addAttribute(new DynamicAttributeTest(float[].class));
        this.dynamicManager.addAttribute(new DynamicAttributeTest(float[][].class));
        this.dynamicManager.addAttribute(new DynamicAttributeTest(Short.TYPE));
        this.dynamicManager.addAttribute(new DynamicAttributeTest(short[].class));
        this.dynamicManager.addAttribute(new DynamicAttributeTest(short[][].class));
        this.dynamicManager.addAttribute(new DynamicAttributeTest(Long.TYPE));
        this.dynamicManager.addAttribute(new DynamicAttributeTest(long[].class));
        this.dynamicManager.addAttribute(new DynamicAttributeTest(long[][].class));
        this.dynamicManager.addAttribute(new DynamicAttributeTest(Byte.TYPE));
        this.dynamicManager.addAttribute(new DynamicAttributeTest(byte[].class));
        this.dynamicManager.addAttribute(new DynamicAttributeTest(byte[][].class));
        this.dynamicManager.addAttribute(new DynamicAttributeTest(Boolean.TYPE));
        this.dynamicManager.addAttribute(new DynamicAttributeTest(boolean[].class));
        this.dynamicManager.addAttribute(new DynamicAttributeTest(boolean[][].class));
        this.dynamicManager.addAttribute(new DynamicEnumAttribute());
        this.dynamicManager.addAttribute(new DynamicAttributeTest(Double.TYPE, "testfowarded"));
    }

    @Delete
    public void delete() throws DevFailed {
        this.dynamicManager.clearAll();
    }

    @Attribute
    public short getShortScalar() {
        return this.shortScalar;
    }

    public void setShortScalar(short shortScalar) {
        this.shortScalar = shortScalar;
    }

    public void setShortSpectrum(short[] shortSpectrum) {
        this.shortSpectrum = new short[shortSpectrum.length];
        System.arraycopy(shortSpectrum, 0, this.shortSpectrum, 0, shortSpectrum.length);
    }

    public short[][] getShortImage() {
        return (short[][])Arrays.copyOf(this.shortImage, this.shortImage.length);
    }

    public void setShortImage(short[][] shortImage) {
        this.shortImage = ArrayUtils.copyOf((short[][])shortImage);
    }

    public int getIntScalar() {
        return this.intScalar;
    }

    public void setIntScalar(int intScalar) {
        this.intScalar = intScalar;
    }

    public int[] getIntSpectrum() {
        return Arrays.copyOf(this.intSpectrum, this.intSpectrum.length);
    }

    public void setIntSpectrum(int[] intSpectrum) {
        this.intSpectrum = new int[intSpectrum.length];
        System.arraycopy(intSpectrum, 0, this.intSpectrum, 0, intSpectrum.length);
    }

    public int[][] getIntImage() {
        return ArrayUtils.copyOf((int[][])this.intImage);
    }

    public void setIntImage(int[][] intImage) {
        this.intImage = ArrayUtils.copyOf((int[][])intImage);
    }

    public long getLongScalar() {
        return this.longScalar;
    }

    public void setLongScalar(long longScalar) {
        this.longScalar = longScalar;
    }

    public long[] getLongSpectrum() {
        return Arrays.copyOf(this.longSpectrum, this.longSpectrum.length);
    }

    public void setLongSpectrum(long[] longSpectrum) {
        this.longSpectrum = new long[longSpectrum.length];
        System.arraycopy(longSpectrum, 0, this.longSpectrum, 0, longSpectrum.length);
    }

    @Attribute
    public long[] getPollSpectrum() throws DevFailed {
        boolean bl = this.error2 = !this.error2;
        if (this.error2) {
            throw DevFailedUtils.newDevFailed((String)"error pollSpectrum");
        }
        return new long[]{1L, 2L};
    }

    public void setPollSpectrum(long[] value) {
    }

    public long[][] getLongImage() {
        return ArrayUtils.copyOf((long[][])this.longImage);
    }

    public void setLongImage(long[][] longImage) {
        this.longImage = ArrayUtils.copyOf((long[][])longImage);
    }

    public float getFloatScalar() {
        return this.floatScalar;
    }

    public void setFloatScalar(float floatScalar) {
        this.floatScalar = floatScalar;
    }

    public float[] getFloatSpectrum() {
        return Arrays.copyOf(this.floatSpectrum, this.floatSpectrum.length);
    }

    public void setFloatSpectrum(float[] floatSpectrum) {
        this.floatSpectrum = new float[floatSpectrum.length];
        System.arraycopy(floatSpectrum, 0, this.floatSpectrum, 0, floatSpectrum.length);
    }

    public float[][] getFloatImage() {
        return ArrayUtils.copyOf((float[][])this.floatImage);
    }

    public void setFloatImage(float[][] floatImage) {
        this.floatImage = ArrayUtils.copyOf((float[][])floatImage);
    }

    public double getDoubleScalar() {
        return this.doubleScalar;
    }

    public void setDoubleScalar(double doubleScalar) {
        this.doubleScalar = doubleScalar;
    }

    public double[] getDoubleSpectrum() {
        return Arrays.copyOf(this.doubleSpectrum, this.doubleSpectrum.length);
    }

    public void setDoubleSpectrum(double[] doubleSpectrum) {
        this.doubleSpectrum = new double[doubleSpectrum.length];
        System.arraycopy(doubleSpectrum, 0, this.doubleSpectrum, 0, doubleSpectrum.length);
    }

    public double[][] getDoubleImage() {
        return ArrayUtils.copyOf((double[][])this.doubleImage);
    }

    public void setDoubleImage(double[][] doubleImage) {
        this.doubleImage = ArrayUtils.copyOf((double[][])doubleImage);
    }

    public AttributeValue isBooleanScalar() throws DevFailed {
        AttributeValue val = new AttributeValue(this.booleanScalar, AttrQuality.ATTR_CHANGING);
        val.setValue((Object)this.booleanScalar, 123456L);
        return val;
    }

    public void setBooleanScalar(boolean booleanScalar) {
        this.booleanScalar = booleanScalar;
    }

    public boolean[] getBooleanSpectrum() {
        return Arrays.copyOf(this.booleanSpectrum, this.booleanSpectrum.length);
    }

    public void setBooleanSpectrum(boolean[] booleanSpectrum) {
        this.booleanSpectrum = new boolean[booleanSpectrum.length];
        System.arraycopy(booleanSpectrum, 0, this.booleanSpectrum, 0, booleanSpectrum.length);
    }

    public boolean[][] getBooleanImage() {
        return ArrayUtils.copyOf((boolean[][])this.booleanImage);
    }

    public void setBooleanImage(boolean[][] booleanImage) {
        this.booleanImage = ArrayUtils.copyOf((boolean[][])booleanImage);
    }

    public String getStringScalar() {
        return this.stringScalar;
    }

    public void setStringScalar(String stringScalar) {
        this.stringScalar = stringScalar;
    }

    public String[] getStringSpectrum() {
        return Arrays.copyOf(this.stringSpectrum, this.stringSpectrum.length);
    }

    public void setStringSpectrum(String[] stringSpectrum) {
        this.stringSpectrum = new String[stringSpectrum.length];
        System.arraycopy(stringSpectrum, 0, this.stringSpectrum, 0, stringSpectrum.length);
    }

    public String[][] getStringImage() {
        return (String[][])ArrayUtils.copyOf((Object[][])this.stringImage);
    }

    public void setStringImage(String[][] stringImage) {
        this.stringImage = (String[][])ArrayUtils.copyOf((Object[][])stringImage);
    }

    @Attribute
    public byte getByteScalar() {
        return this.byteScalar;
    }

    public void setByteScalar(byte byteScalar) {
        this.byteScalar = byteScalar;
    }

    public byte[] getByteSpectrum() {
        return Arrays.copyOf(this.byteSpectrum, this.byteSpectrum.length);
    }

    public void setByteSpectrum(byte[] byteSpectrum) {
        this.byteSpectrum = new byte[byteSpectrum.length];
        System.arraycopy(byteSpectrum, 0, this.byteSpectrum, 0, byteSpectrum.length);
    }

    public byte[][] getByteImage() {
        return ArrayUtils.copyOf((byte[][])this.byteImage);
    }

    public void setByteImage(byte[][] byteImage) {
        this.byteImage = ArrayUtils.copyOf((byte[][])byteImage);
    }

    public AttributeValue getInvalidQuality() throws DevFailed {
        return new AttributeValue(0.0, AttrQuality.ATTR_INVALID);
    }

    public AttributeValue getInvalidQuality2() throws DevFailed {
        AttributeValue value = new AttributeValue();
        value.setQuality(AttrQuality.ATTR_INVALID);
        value.setValue((Object)0.0);
        return value;
    }

    @Command(outTypeDesc="do nothing")
    public void voidCommand() {
    }

    @Command(outTypeDesc="returns the input value (short)")
    public short shortCommand(short value) {
        return value;
    }

    @Command(outTypeDesc="returns the input value (short[])")
    public short[] shortSpectrumCommand(short[] value) {
        return value;
    }

    @Command(outTypeDesc="returns the input value (int)")
    public int intCommand(int value) {
        return value;
    }

    @Command(outTypeDesc="returns the input value (int[])")
    public int[] intSpectrumCommand(int[] value) {
        return value;
    }

    @Command(outTypeDesc="returns the input value (byte)")
    public byte byteCommand(byte value) {
        return value;
    }

    @Command(outTypeDesc="returns the input value (byte[])")
    public byte[] byteSpectrumCommand(byte[] value) {
        return value;
    }

    @Command(outTypeDesc="returns the input value (long)")
    public long longCommand(long value) {
        return value;
    }

    @Command(outTypeDesc="returns the input value (long[])")
    public long[] longSpectrumCommand(long[] value) {
        return value;
    }

    @Command(outTypeDesc="returns the input value (float)")
    public float floatCommand(float value) {
        return value;
    }

    @Command(outTypeDesc="returns the input value (float[])")
    public float[] floatSpectrumCommand(float[] value) {
        return value;
    }

    @Command(outTypeDesc="returns the input value (double)")
    public double doubleCommand(double value) {
        return value;
    }

    @Command(outTypeDesc="returns the input value (double[])")
    public double[] doubleSpectrumCommand(double[] value) {
        return value;
    }

    @Command(outTypeDesc="returns the input value (boolean)")
    public boolean booleanCommand(boolean value) {
        return value;
    }

    @Command(outTypeDesc="returns the input value (String)")
    public String stringCommand(String value) {
        return value;
    }

    @Command(outTypeDesc="returns the input value (String[])")
    public String[] stringSpectrumCommmand(String[] value) {
        return value;
    }

    @Command(outTypeDesc="returns the input value (DevVarLongStringArray)")
    public DevVarLongStringArray longStringCommand(DevVarLongStringArray value) {
        return value;
    }

    @Command(outTypeDesc="returns the input value (DevVarDoubleStringArray)")
    public DevVarDoubleStringArray doubleStringCommand(DevVarDoubleStringArray value) {
        return value;
    }

    @Command
    public double testPolling() throws DevFailed {
        double value = 12.0;
        boolean bl = this.error = !this.error;
        if (this.error) {
            throw DevFailedUtils.newDevFailed((String)"error");
        }
        return 12.0;
    }

    @Command
    public int[] testPollingArray() {
        return new int[]{1, 2};
    }

    @Command
    @StateMachine(endState=DeviceState.FAULT)
    public void testState() {
    }

    @Attribute(isPolled=true, pollingPeriod=0)
    public short getFillHistory() {
        return 0;
    }

    @Command
    public void fillHistory() throws DevFailed {
        AttributeValue[] values = new AttributeValue[3];
        for (int i = 0; i < values.length; ++i) {
            values[i] = new AttributeValue();
            values[i].setValue((Object)((short)i));
        }
        this.deviceManager.fillAttributeHistory("fillHistory", values, values, null);
    }

    public void setMyProp(String myProp) {
        this.myProp = myProp;
    }

    public void setMyClassProp(String[] myClassProp) {
        this.myClassProp = Arrays.copyOf(myClassProp, myClassProp.length);
    }

    @Command
    public String getMyProperty() {
        return this.myProp;
    }

    @Command
    public String[] getMyClassProperty() {
        return Arrays.copyOf(this.myClassProp, this.myClassProp.length);
    }

    public DeviceState getStateScalar() {
        return this.stateScalar;
    }

    public void setStateScalar(DeviceState stateScalar) {
        this.stateScalar = stateScalar;
    }

    public DevEncoded getDevEncodedScalar() {
        return this.devEncodedScalar;
    }

    public void setDevEncodedScalar(DevEncoded devEncodedScalar) {
        this.devEncodedScalar = devEncodedScalar;
    }

    @AroundInvoke
    public void alwaysHook(InvocationContext ctx) {
        this.logger.debug(ctx.toString());
    }

    public DevState getState() {
        return this.state;
    }

    public void setState(DevState state) {
        this.state = state;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setDynamicManager(DynamicManager dynamicManager) {
        this.dynamicManager = dynamicManager;
    }

    public void setProps(Map<String, String[]> props) {
        this.props = props;
    }

    @Command
    public boolean isBooleanProp() {
        return this.booleanProp;
    }

    public void setBooleanProp(boolean booleanProp) {
        this.booleanProp = booleanProp;
    }

    public DeviceState[] getStateSpectrum() {
        return Arrays.copyOf(this.stateSpectrum, this.stateSpectrum.length);
    }

    public void setStateSpectrum(DeviceState[] stateSpectrum) {
        this.stateSpectrum = Arrays.copyOf(stateSpectrum, stateSpectrum.length);
    }

    public double getDeltaAttribute() {
        return 0.0;
    }

    public void setDeltaAttribute(double deltaAttribute) {
    }

    public void setDeviceManager(DeviceManager deviceManager) {
        this.deviceManager = deviceManager;
    }

    public TestType getEnumAttribute() {
        return this.enumAttribute;
    }

    public void setEnumAttribute(TestType enumAttribute) {
        this.enumAttribute = enumAttribute;
    }

    public static enum TestType {
        VALUE1,
        VALUE2;

    }
}

