/*
 * Decompiled with CFR 0.152.
 */
package org.tango.server.testserver;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tango.server.ServerManager;
import org.tango.server.annotation.Attribute;
import org.tango.server.annotation.AttributeProperties;
import org.tango.server.annotation.Command;
import org.tango.server.annotation.Delete;
import org.tango.server.annotation.Device;
import org.tango.server.annotation.Init;

@Device
public class TestDevice {
    private final Logger logger = LoggerFactory.getLogger(TestDevice.class);
    public static final String SERVER_NAME = TestDevice.class.getSimpleName();
    public static final String INSTANCE_NAME = "1";
    @Attribute(isPolled=true, pollingPeriod=3000)
    @AttributeProperties(archiveEventAbsolute="10")
    public double testAttribute;

    public static void main(String[] args) {
        ServerManager.getInstance().addClass(TestDevice.class.getCanonicalName(), TestDevice.class);
        ServerManager.getInstance().start(new String[]{INSTANCE_NAME}, SERVER_NAME);
    }

    @Init
    public void init() {
        this.logger.debug("Init device");
    }

    @Delete
    public void delete() {
        this.logger.debug("delete command executed");
    }

    @Command
    public void start() {
        this.logger.debug("start command executed");
    }

    public double getTestAttribute() {
        this.logger.debug("Get Test Attribute {}", (Object)this.testAttribute);
        return this.testAttribute;
    }

    public void setTestAttribute(double testAttribute) {
        this.logger.debug("setMyAttribute {}", (Object)testAttribute);
        this.testAttribute = testAttribute;
    }
}

