/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.TangoApi.AccessProxy;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.Connection;
import fr.esrf.TangoApi.ConnectionDAODefaultImpl;
import fr.esrf.TangoApi.Database;
import fr.esrf.TangoApi.DbAttribute;
import fr.esrf.TangoApi.DbDatum;
import fr.esrf.TangoApi.DbDevExportInfo;
import fr.esrf.TangoApi.DbDevImportInfo;
import fr.esrf.TangoApi.DbDevInfo;
import fr.esrf.TangoApi.DbHistory;
import fr.esrf.TangoApi.DbPipe;
import fr.esrf.TangoApi.DbServInfo;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceInfo;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoApi.IDatabaseDAO;
import fr.esrf.TangoApi.TangoUrl;
import fr.esrf.TangoApi.events.DbEventImportInfo;
import fr.esrf.TangoDs.Except;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public class DatabaseDAODefaultImpl
extends ConnectionDAODefaultImpl
implements IDatabaseDAO {
    private boolean access_service_read = false;
    private static final Object monitor = new Object();

    public void init(Database database) throws DevFailed {
        super.init((Connection)database);
    }

    public void init(Database database, String host, String port) throws DevFailed {
        super.init((Connection)database, host, port);
    }

    public String toString(Database database) {
        return database.url.host + ":" + database.url.port;
    }

    private String stringArray2String(String[] array) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            sb.append(array[i]);
            if (i >= array.length - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    private void checkAccess(Database database) {
        if (database.check_access && !database.isAccess_checked()) {
            database.access = this.checkAccessControl(database, database.devname, database.url);
            database.setAccess_checked(true);
            ApiUtil.getReconnectionDelay();
        }
    }

    public String get_info(Database database) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argOut = this.command_inout((Connection)database, "DbInfo");
        String[] info = argOut.extractStringArray();
        return this.stringArray2String(info);
    }

    public String[] get_host_list(Database database) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argIn = new DeviceData();
        argIn.insert("*");
        DeviceData argOut = this.command_inout((Connection)database, "DbGetHostList", argIn);
        return argOut.extractStringArray();
    }

    public String[] get_host_list(Database database, String wildcard) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argIn = new DeviceData();
        argIn.insert(wildcard);
        DeviceData argOut = this.command_inout((Connection)database, "DbGetHostList", argIn);
        return argOut.extractStringArray();
    }

    public String[] get_server_class_list(Database database, String serverName) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argIn = new DeviceData();
        argIn.insert(serverName);
        DeviceData argOut = this.command_inout((Connection)database, "DbGetDeviceServerClassList", argIn);
        String[] list = argOut.extractStringArray();
        int nb_classes = list.length == 0 ? 0 : list.length - 1;
        String[] classes = new String[nb_classes];
        int j = 0;
        for (int i = 0; i < list.length && j < nb_classes; ++i) {
            if (list[i].equals("DServer")) continue;
            classes[j++] = list[i];
        }
        return classes;
    }

    public String[] get_server_name_list(Database database) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argIn = new DeviceData();
        argIn.insert("*");
        DeviceData argOut = this.command_inout((Connection)database, "DbGetServerNameList", argIn);
        return argOut.extractStringArray();
    }

    public String[] get_instance_name_list(Database database, String serverName) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argIn = new DeviceData();
        argIn.insert(serverName);
        DeviceData argOut = this.command_inout((Connection)database, "DbGetInstanceNameList", argIn);
        return argOut.extractStringArray();
    }

    public String[] get_server_list(Database database) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argIn = new DeviceData();
        argIn.insert("*");
        DeviceData argOut = this.command_inout((Connection)database, "DbGetServerList", argIn);
        return argOut.extractStringArray();
    }

    public String[] get_server_list(Database database, String wildcard) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argIn = new DeviceData();
        argIn.insert(wildcard);
        DeviceData argOut = this.command_inout((Connection)database, "DbGetServerList", argIn);
        return argOut.extractStringArray();
    }

    public String[] get_host_server_list(Database database, String hostname) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argIn = new DeviceData();
        argIn.insert(hostname);
        DeviceData argOut = this.command_inout((Connection)database, "DbGetHostServerList", argIn);
        return argOut.extractStringArray();
    }

    public DbServInfo get_server_info(Database database, String serverName) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argIn = new DeviceData();
        argIn.insert(serverName);
        DeviceData argOut = this.command_inout((Connection)database, "DbGetServerInfo", argIn);
        String[] info = argOut.extractStringArray();
        return new DbServInfo(info);
    }

    public void put_server_info(Database database, DbServInfo info) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] array = new String[]{info.name, info.host, info.controlled ? "1" : "0", Integer.toString(info.startup_level)};
        DeviceData argIn = new DeviceData();
        argIn.insert(array);
        this.command_inout((Connection)database, "DbPutServerInfo", argIn);
    }

    public void delete_server_info(Database database, String serverName) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argIn = new DeviceData();
        argIn.insert(serverName);
        this.command_inout((Connection)database, "DbDeleteServerInfo", argIn);
    }

    public void rename_server(Database database, String srcServerName, String newServerName) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argIn = new DeviceData();
        argIn.insert(new String[]{srcServerName, newServerName});
        this.command_inout((Connection)database, "DbRenameServer", argIn);
    }

    public void add_device(Database database, DbDevInfo devinfo) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argIn = new DeviceData();
        argIn.insert(devinfo.toStringArray());
        this.command_inout((Connection)database, "DbAddDevice", argIn);
    }

    public void add_device(Database database, String deviceName, String classname, String serverName) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DbDevInfo devinfo = new DbDevInfo(deviceName, classname, serverName);
        DeviceData argIn = new DeviceData();
        argIn.insert(devinfo.toStringArray());
        this.command_inout((Connection)database, "DbAddDevice", argIn);
    }

    public void delete_device(Database database, String deviceName) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        boolean delete = true;
        try {
            String fullDeviceName = "tango://" + database.get_tango_host() + "/" + deviceName;
            DeviceProxy d = new DeviceProxy(fullDeviceName);
            d.ping();
            delete = false;
        }
        catch (DevFailed fullDeviceName) {
            // empty catch block
        }
        if (delete) {
            DeviceData argIn = new DeviceData();
            argIn.insert(deviceName);
            this.command_inout((Connection)database, "DbDeleteDevice", argIn);
        } else {
            Except.throw_connection_failed((String)"TangoApi_DEVICE_ALIVE", (String)"Cannot delete a device which is ALIVE.", (String)"delete_device()");
        }
    }

    public DeviceInfo get_device_info(Database database, String deviceName) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argIn = new DeviceData();
        argIn.insert(deviceName);
        DeviceData argOut = this.command_inout((Connection)database, "DbGetDeviceInfo", argIn);
        DevVarLongStringArray info = argOut.extractLongStringArray();
        return new DeviceInfo(info);
    }

    public String[] get_device_list(Database database, String wildcard) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argIn = new DeviceData();
        argIn.insert(wildcard);
        DeviceData argOut = this.command_inout((Connection)database, "DbGetDeviceWideList", argIn);
        return argOut.extractStringArray();
    }

    public DbDevImportInfo import_device(Database database, String deviceName) throws DevFailed {
        DevVarLongStringArray info;
        int tmp_access = database.access;
        database.access = 1;
        try {
            DeviceData argIn = new DeviceData();
            argIn.insert(deviceName);
            DeviceData argOut = this.command_inout((Connection)database, "DbImportDevice", argIn);
            info = argOut.extractLongStringArray();
            database.access = tmp_access;
        }
        catch (DevFailed e) {
            database.access = tmp_access;
            throw e;
        }
        return new DbDevImportInfo(info);
    }

    public void unexport_device(Database database, String deviceName) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argIn = new DeviceData();
        argIn.insert(deviceName);
        this.command_inout((Connection)database, "DbUnExportDevice", argIn);
    }

    public void export_device(Database database, DbDevExportInfo devExportInfo) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        if (devExportInfo.host.isEmpty()) {
            devExportInfo.host = "null";
        }
        if (devExportInfo.ior.isEmpty()) {
            devExportInfo.ior = "null";
        }
        if (devExportInfo.version.isEmpty()) {
            devExportInfo.version = "null";
        }
        String[] array = devExportInfo.toStringArray();
        DeviceData argIn = new DeviceData();
        argIn.insert(array);
        this.command_inout((Connection)database, "DbExportDevice", argIn);
    }

    public String[] get_device_class_list(Database database, String serverName) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argIn = new DeviceData();
        argIn.insert(serverName);
        DeviceData argOut = this.command_inout((Connection)database, "DbGetDeviceClassList", argIn);
        return argOut.extractStringArray();
    }

    public String[] get_device_name(Database database, String serverName, String classname) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] array = new String[]{serverName, classname};
        DeviceData argIn = new DeviceData();
        argIn.insert(array);
        DeviceData argOut = this.command_inout((Connection)database, "DbGetDeviceList", argIn);
        return argOut.extractStringArray();
    }

    public String[] get_device_domain(Database database, String wildcard) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argIn = new DeviceData();
        argIn.insert(wildcard);
        DeviceData argOut = this.command_inout((Connection)database, "DbGetDeviceDomainList", argIn);
        return argOut.extractStringArray();
    }

    public String[] get_device_family(Database database, String wildcard) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argIn = new DeviceData();
        argIn.insert(wildcard);
        DeviceData argOut = this.command_inout((Connection)database, "DbGetDeviceFamilyList", argIn);
        return argOut.extractStringArray();
    }

    public String[] get_device_member(Database database, String wildcard) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argIn = new DeviceData();
        argIn.insert(wildcard);
        DeviceData argOut = this.command_inout((Connection)database, "DbGetDeviceMemberList", argIn);
        return argOut.extractStringArray();
    }

    public void add_server(Database database, String serverName, DbDevInfo[] devinfo) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] array = new String[1 + 2 * devinfo.length];
        array[0] = serverName;
        for (int i = 0; i < devinfo.length; ++i) {
            array[2 * i + 1] = devinfo[i].name;
            array[2 * i + 2] = devinfo[i]._class;
        }
        DeviceData argIn = new DeviceData();
        argIn.insert(array);
        this.command_inout((Connection)database, "DbAddServer", argIn);
    }

    public void delete_server(Database database, String deviceName) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argIn = new DeviceData();
        argIn.insert(deviceName);
        this.command_inout((Connection)database, "DbDeleteServer", argIn);
    }

    public void export_server(Database database, DbDevExportInfo[] devExportInfos) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] array = new String[6 * devExportInfos.length];
        for (int i = 0; i < devExportInfos.length; ++i) {
            String[] one = devExportInfos[i].toStringArray();
            System.arraycopy(one, 0, array, 6 * i, 6);
        }
        DeviceData argIn = new DeviceData();
        argIn.insert(array);
        this.command_inout((Connection)database, "DbExportServer", argIn);
    }

    public void unexport_server(Database database, String deviceName) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argIn = new DeviceData();
        argIn.insert(deviceName);
        this.command_inout((Connection)database, "DbUnExportServer", argIn);
    }

    private String[] dbdatum2StringArray(String name, DbDatum[] properties) {
        int size = 2;
        for (DbDatum property : properties) {
            size += 2;
            size += property.size();
        }
        String[] result = new String[size];
        result[0] = name;
        result[1] = String.valueOf(properties.length);
        int pnum = 2;
        for (int i = 0; i < properties.length; ++i) {
            String[] prop;
            for (String propname : prop = properties[i].toStringArray()) {
                result[pnum++] = propname;
            }
        }
        return result;
    }

    private DbDatum[] stringArray2DbDatum(String[] strprop) {
        int nb_prop = Integer.parseInt(strprop[1]);
        DbDatum[] properties = new DbDatum[nb_prop];
        int i = 2;
        int pnum = 0;
        while (i < strprop.length - 1) {
            int nb = Integer.parseInt(strprop[i + 1]);
            int start_val = i + 2;
            int end_val = i + 2 + nb;
            if (nb > 0) {
                properties[pnum++] = new DbDatum(strprop[i], strprop, start_val, end_val);
            } else {
                String s;
                properties[pnum++] = new DbDatum(strprop[i]);
                if (start_val + 1 < strprop.length && ((s = strprop[start_val]).length() == 0 || s.equals(" "))) {
                    end_val = start_val + 1;
                }
            }
            i = end_val;
        }
        return properties;
    }

    private DbDatum[] get_obj_property(Database database, String name, String type, DbDatum[] properties) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] array = new String[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            array[i] = properties[i].name;
        }
        return this.get_obj_property(database, name, type, array);
    }

    private DbDatum get_obj_property(Database database, String name, String type, String propname) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] array = new String[]{propname};
        DbDatum[] data = this.get_obj_property(database, name, type, array);
        return data[0];
    }

    private DbDatum[] get_obj_property(Database database, String name, String type, String[] propnames) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] array = new String[1 + propnames.length];
        array[0] = name;
        System.arraycopy(propnames, 0, array, 1, propnames.length);
        String cmd = "DbGet" + type + "Property";
        DeviceData argIn = new DeviceData();
        argIn.insert(array);
        DeviceData argOut = this.command_inout((Connection)database, cmd, argIn);
        String[] result = argOut.extractStringArray();
        return this.stringArray2DbDatum(result);
    }

    private void delete_obj_property(Database database, String name, String type, DbDatum[] properties) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] array = new String[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            array[i] = properties[i].name;
        }
        this.delete_obj_property(database, name, type, array);
    }

    private void delete_obj_property(Database database, String name, String type, String propname) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] array = new String[]{propname};
        this.delete_obj_property(database, name, type, array);
    }

    private void delete_obj_property(Database database, String name, String type, String[] propnames) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] array = new String[propnames.length + 1];
        array[0] = name;
        System.arraycopy(propnames, 0, array, 1, propnames.length);
        String cmd = "DbDelete" + type + "Property";
        DeviceData argIn = new DeviceData();
        argIn.insert(array);
        this.command_inout((Connection)database, cmd, argIn);
    }

    public String[] get_object_list(Database database, String wildcard) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argIn = new DeviceData();
        argIn.insert(wildcard);
        DeviceData argOut = this.command_inout((Connection)database, "DbGetObjectList", argIn);
        return argOut.extractStringArray();
    }

    public String[] get_object_property_list(Database database, String objname, String wildcard) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] array = new String[]{objname, wildcard};
        DeviceData argIn = new DeviceData();
        argIn.insert(array);
        DeviceData argOut = this.command_inout((Connection)database, "DbGetPropertyList", argIn);
        return argOut.extractStringArray();
    }

    public DbDatum[] get_property(Database database, String name, String[] propnames) throws DevFailed {
        String type = "";
        return this.get_obj_property(database, name, type, propnames);
    }

    public DbDatum get_property(Database database, String name, String propname) throws DevFailed {
        String type = "";
        return this.get_obj_property(database, name, type, propname);
    }

    public DbDatum get_property(Database database, String name, String propname, boolean forced) throws DevFailed {
        DbDatum datum;
        int tmp_access = database.access;
        if (forced) {
            database.access = 1;
        }
        try {
            String[] array = new String[]{name, propname};
            DeviceData argIn = new DeviceData();
            argIn.insert(array);
            DeviceData argOut = this.command_inout((Connection)database, "DbGetProperty", argIn);
            String[] result = argOut.extractStringArray();
            datum = this.stringArray2DbDatum(result)[0];
            database.access = tmp_access;
        }
        catch (DevFailed e) {
            database.access = tmp_access;
            throw e;
        }
        return datum;
    }

    public DbDatum[] get_property(Database database, String name, DbDatum[] properties) throws DevFailed {
        String type = "";
        return this.get_obj_property(database, name, type, properties);
    }

    public void put_property(Database database, String name, DbDatum[] properties) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] array = this.dbdatum2StringArray(name, properties);
        DeviceData argIn = new DeviceData();
        argIn.insert(array);
        this.command_inout((Connection)database, "DbPutProperty", argIn);
    }

    public void delete_property(Database database, String name, String[] propnames) throws DevFailed {
        String type = "";
        this.delete_obj_property(database, name, type, propnames);
    }

    public void delete_property(Database database, String name, String propname) throws DevFailed {
        String type = "";
        this.delete_obj_property(database, name, type, propname);
    }

    public void delete_property(Database database, String name, DbDatum[] properties) throws DevFailed {
        String type = "";
        this.delete_obj_property(database, name, type, properties);
    }

    public String[] get_class_property_list(Database database, String classname, String wildcard) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argIn = new DeviceData();
        argIn.insert(classname);
        DeviceData argOut = this.command_inout((Connection)database, "DbGetClassPropertyList", argIn);
        return argOut.extractStringArray();
    }

    public String[] get_device_property_list(Database database, String deviceName, String wildcard) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] array = new String[]{deviceName, wildcard};
        DeviceData argIn = new DeviceData();
        argIn.insert(array);
        DeviceData argOut = this.command_inout((Connection)database, "DbGetDevicePropertyList", argIn);
        return argOut.extractStringArray();
    }

    public String get_class_for_device(Database database, String deviceName) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argIn = new DeviceData();
        argIn.insert(deviceName);
        DeviceData argOut = this.command_inout((Connection)database, "DbGetClassForDevice", argIn);
        return argOut.extractString();
    }

    public String[] get_class_inheritance_for_device(Database database, String deviceName) throws DevFailed {
        String[] result;
        block3: {
            if (!database.isAccess_checked()) {
                this.checkAccess(database);
            }
            result = new String[]{"Device_3Impl"};
            try {
                DeviceData argIn = new DeviceData();
                argIn.insert(deviceName);
                DeviceData argOut = this.command_inout((Connection)database, "DbGetClassInheritanceForDevice", argIn);
                result = argOut.extractStringArray();
            }
            catch (DevFailed e) {
                if (e.errors[0].reason.equals("API_CommandNotFound")) break block3;
                throw e;
            }
        }
        return result;
    }

    public DbDatum[] get_device_property(Database database, String name, String[] propnames) throws DevFailed {
        String type = "Device";
        return this.get_obj_property(database, name, type, propnames);
    }

    public DbDatum get_device_property(Database database, String name, String propname) throws DevFailed {
        String type = "Device";
        return this.get_obj_property(database, name, type, propname);
    }

    public DbDatum[] get_device_property(Database database, String name, DbDatum[] properties) throws DevFailed {
        String type = "Device";
        return this.get_obj_property(database, name, type, properties);
    }

    public void put_device_property(Database database, String name, DbDatum[] properties) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] array = this.dbdatum2StringArray(name, properties);
        DeviceData argIn = new DeviceData();
        argIn.insert(array);
        this.command_inout((Connection)database, "DbPutDeviceProperty", argIn);
    }

    public void delete_device_property(Database database, String name, String[] propnames) throws DevFailed {
        String type = "Device";
        this.delete_obj_property(database, name, type, propnames);
    }

    public void delete_device_property(Database database, String name, String propname) throws DevFailed {
        String type = "Device";
        this.delete_obj_property(database, name, type, propname);
    }

    public void delete_device_property(Database database, String name, DbDatum[] properties) throws DevFailed {
        String type = "Device";
        this.delete_obj_property(database, name, type, properties);
    }

    public String[] get_device_attribute_list(Database database, String deviceName) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argIn = new DeviceData();
        argIn.insert(new String[]{deviceName, "*"});
        DeviceData argOut = this.command_inout((Connection)database, "DbGetDeviceAttributeList", argIn);
        return argOut.extractStringArray();
    }

    public DbAttribute[] get_device_attribute_property(Database database, String deviceName, String[] attnames) throws DevFailed {
        DeviceData argOut;
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argIn = new DeviceData();
        int mode = 2;
        try {
            argIn.insert(ApiUtil.toStringArray((String)deviceName, (String[])attnames));
            argOut = this.command_inout((Connection)database, "DbGetDeviceAttributeProperty2", argIn);
        }
        catch (DevFailed e) {
            if (e.errors[0].reason.equals("API_CommandNotFound")) {
                argOut = this.command_inout((Connection)database, "DbGetDeviceAttributeProperty", argIn);
                mode = 1;
            }
            throw e;
        }
        return ApiUtil.toDbAttributeArray((String[])argOut.extractStringArray(), (int)mode);
    }

    public DbAttribute get_device_attribute_property(Database database, String deviceName, String attname) throws DevFailed {
        String[] attnames = new String[]{attname};
        return this.get_device_attribute_property(database, deviceName, attnames)[0];
    }

    public void put_device_attribute_property(Database database, String deviceName, DbAttribute[] attr) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argIn = new DeviceData();
        try {
            argIn.insert(ApiUtil.toStringArray((String)deviceName, (DbAttribute[])attr, (int)2));
            this.command_inout((Connection)database, "DbPutDeviceAttributeProperty2", argIn);
        }
        catch (DevFailed e) {
            if (e.errors[0].reason.equals("API_CommandNotFound")) {
                argIn.insert(ApiUtil.toStringArray((String)deviceName, (DbAttribute[])attr, (int)1));
                this.command_inout((Connection)database, "DbPutDeviceAttributeProperty", argIn);
            }
            throw e;
        }
    }

    public void put_device_attribute_property(Database database, String deviceName, DbAttribute attr) throws DevFailed {
        DbAttribute[] da = new DbAttribute[]{attr};
        this.put_device_attribute_property(database, deviceName, da);
    }

    public void delete_device_attribute_property(Database database, String deviceName, DbAttribute attr) throws DevFailed {
        this.delete_device_attribute_property(database, deviceName, attr.name, attr.get_property_list());
    }

    public void delete_device_attribute_property(Database database, String deviceName, DbAttribute[] attribute) throws DevFailed {
        for (DbAttribute att : attribute) {
            this.delete_device_attribute_property(database, deviceName, att.name, att.get_property_list());
        }
    }

    public void delete_device_attribute_property(Database database, String deviceName, String attname, String[] propnames) throws DevFailed {
        if (propnames.length == 0) {
            return;
        }
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] array = new String[2 + propnames.length];
        array[0] = deviceName;
        array[1] = attname;
        System.arraycopy(propnames, 0, array, 2, propnames.length);
        DeviceData argIn = new DeviceData();
        argIn.insert(array);
        this.command_inout((Connection)database, "DbDeleteDeviceAttributeProperty", argIn);
    }

    public void delete_device_attribute_property(Database database, String deviceName, String attname, String propname) throws DevFailed {
        String[] array = new String[]{propname};
        this.delete_device_attribute_property(database, deviceName, attname, array);
    }

    public void delete_device_attribute(Database database, String deviceName, String attname) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] array = new String[]{deviceName, attname};
        DeviceData argIn = new DeviceData();
        argIn.insert(array);
        this.command_inout((Connection)database, "DbDeleteDeviceAttribute", argIn);
    }

    public String[] get_class_list(Database database, String serverName) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argIn = new DeviceData();
        argIn.insert(serverName);
        DeviceData argOut = this.command_inout((Connection)database, "DbGetClassList", argIn);
        return argOut.extractStringArray();
    }

    public DbDatum[] get_class_property(Database database, String name, String[] propnames) throws DevFailed {
        String type = "Class";
        return this.get_obj_property(database, name, type, propnames);
    }

    public DbDatum get_class_property(Database database, String name, String propname) throws DevFailed {
        String type = "Class";
        return this.get_obj_property(database, name, type, propname);
    }

    public DbDatum[] get_class_property(Database database, String name, DbDatum[] properties) throws DevFailed {
        String type = "Class";
        return this.get_obj_property(database, name, type, properties);
    }

    public void put_class_property(Database database, String name, DbDatum[] properties) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] array = this.dbdatum2StringArray(name, properties);
        DeviceData argIn = new DeviceData();
        argIn.insert(array);
        this.command_inout((Connection)database, "DbPutClassProperty", argIn);
    }

    public void delete_class_property(Database database, String name, String[] propnames) throws DevFailed {
        String type = "Class";
        this.delete_obj_property(database, name, type, propnames);
    }

    public void delete_class_property(Database database, String name, String propname) throws DevFailed {
        String type = "Class";
        this.delete_obj_property(database, name, type, propname);
    }

    public void delete_class_property(Database database, String name, DbDatum[] properties) throws DevFailed {
        String type = "Class";
        this.delete_obj_property(database, name, type, properties);
    }

    public String[] get_class_attribute_list(Database database, String classname, String wildcard) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argIn = new DeviceData();
        argIn.insert(ApiUtil.toStringArray((String)classname, (String)wildcard));
        DeviceData argOut = this.command_inout((Connection)database, "DbGetClassAttributeList", argIn);
        return argOut.extractStringArray();
    }

    public DbAttribute get_class_attribute_property(Database database, String classname, String attname) throws DevFailed {
        String[] attnames = new String[]{attname};
        return this.get_class_attribute_property(database, classname, attnames)[0];
    }

    public DbAttribute[] get_class_attribute_property(Database database, String classname, String[] attnames) throws DevFailed {
        DeviceData argOut;
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argIn = new DeviceData();
        int mode = 2;
        try {
            argIn.insert(ApiUtil.toStringArray((String)classname, (String[])attnames));
            argOut = this.command_inout((Connection)database, "DbGetClassAttributeProperty2", argIn);
        }
        catch (DevFailed e) {
            if (e.errors[0].reason.equals("API_CommandNotFound")) {
                argOut = this.command_inout((Connection)database, "DbGetClassAttributeProperty", argIn);
                mode = 1;
            }
            throw e;
        }
        return ApiUtil.toDbAttributeArray((String[])argOut.extractStringArray(), (int)mode);
    }

    public void put_class_attribute_property(Database database, String classname, DbAttribute[] attr) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argIn = new DeviceData();
        argIn.insert(ApiUtil.toStringArray((String)classname, (DbAttribute[])attr, (int)2));
        this.command_inout((Connection)database, "DbPutClassAttributeProperty2", argIn);
    }

    public void put_class_attribute_property(Database database, String classname, DbAttribute attr) throws DevFailed {
        DbAttribute[] da = new DbAttribute[]{attr};
        this.put_class_attribute_property(database, classname, da);
    }

    public void delete_class_attribute_property(Database database, String name, String attname, String propname) throws DevFailed {
        String[] array = new String[]{propname};
        this.delete_class_attribute_property(database, name, attname, array);
    }

    public void delete_class_attribute_property(Database database, String name, String attname, String[] propnames) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        String[] array = new String[2 + propnames.length];
        array[0] = name;
        array[1] = attname;
        System.arraycopy(propnames, 0, array, 2, propnames.length);
        DeviceData argIn = new DeviceData();
        argIn.insert(array);
        this.command_inout((Connection)database, "DbDeleteClassAttributeProperty", argIn);
    }

    public String[] get_device_exported(Database database, String wildcard) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argIn = new DeviceData();
        argIn.insert(wildcard);
        DeviceData argOut = this.command_inout((Connection)database, "DbGetDeviceExportedList", argIn);
        return argOut.extractStringArray();
    }

    public String[] get_device_exported_for_class(Database database, String classname) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argIn = new DeviceData();
        argIn.insert(classname);
        DeviceData argOut = this.command_inout((Connection)database, "DbGetExportdDeviceListForClass", argIn);
        return argOut.extractStringArray();
    }

    public String getAliasFromDevice(Database database, String deviceName) throws DevFailed {
        DeviceData argIn = new DeviceData();
        argIn.insert(deviceName);
        DeviceData argOut = this.command_inout((Connection)database, "DbGetDeviceAlias", argIn);
        return argOut.extractString();
    }

    public String getDeviceFromAlias(Database database, String alias) throws DevFailed {
        DeviceData argIn = new DeviceData();
        argIn.insert(alias);
        DeviceData argOut = this.command_inout((Connection)database, "DbGetAliasDevice", argIn);
        return argOut.extractString();
    }

    public String getAliasFromAttribute(Database database, String attName) throws DevFailed {
        DeviceData argIn = new DeviceData();
        argIn.insert(attName);
        DeviceData argOut = this.command_inout((Connection)database, "DbGetAttributeAlias2", argIn);
        return argOut.extractString();
    }

    public String getAttributeFromAlias(Database database, String alias) throws DevFailed {
        DeviceData argIn = new DeviceData();
        argIn.insert(alias);
        DeviceData argOut = this.command_inout((Connection)database, "DbGetAliasAttribute", argIn);
        return argOut.extractString();
    }

    public String[] get_device_alias_list(Database database, String wildcard) throws DevFailed {
        DeviceData argIn = new DeviceData();
        argIn.insert(wildcard);
        DeviceData argOut = this.command_inout((Connection)database, "DbGetDeviceAliasList", argIn);
        return argOut.extractStringArray();
    }

    public String get_device_alias(Database database, String deviceName) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argIn = new DeviceData();
        argIn.insert(deviceName);
        DeviceData argOut = this.command_inout((Connection)database, "DbGetDeviceAlias", argIn);
        return argOut.extractString();
    }

    public String get_alias_device(Database database, String alias) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argIn = new DeviceData();
        argIn.insert(alias);
        DeviceData argOut = this.command_inout((Connection)database, "DbGetAliasDevice", argIn);
        return argOut.extractString();
    }

    public void put_device_alias(Database database, String deviceName, String aliasname) throws DevFailed {
        String[] array = new String[]{deviceName, aliasname};
        DeviceData argIn = new DeviceData();
        argIn.insert(array);
        this.command_inout((Connection)database, "DbPutDeviceAlias", argIn);
    }

    public void delete_device_alias(Database database, String alias) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argIn = new DeviceData();
        argIn.insert(alias);
        this.command_inout((Connection)database, "DbDeleteDeviceAlias", argIn);
    }

    public String[] get_attribute_alias_list(Database database, String wildcard) throws DevFailed {
        DeviceData argIn = new DeviceData();
        argIn.insert(wildcard);
        DeviceData argOut = this.command_inout((Connection)database, "DbGetAttributeAliasList", argIn);
        return argOut.extractStringArray();
    }

    public String get_attribute_alias(Database database, String attname) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argIn = new DeviceData();
        argIn.insert(attname);
        DeviceData argOut = this.command_inout((Connection)database, "DbGetAttributeAlias", argIn);
        return argOut.extractString();
    }

    public void put_attribute_alias(Database database, String attname, String aliasname) throws DevFailed {
        String[] array = new String[]{attname, aliasname};
        DeviceData argIn = new DeviceData();
        argIn.insert(array);
        this.command_inout((Connection)database, "DbPutAttributeAlias", argIn);
    }

    public void delete_attribute_alias(Database database, String alias) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argIn = new DeviceData();
        argIn.insert(alias);
        this.command_inout((Connection)database, "DbDeleteAttributeAlias", argIn);
    }

    public String[] getDevices(Database database, String wildcard) throws DevFailed {
        StringTokenizer stk = new StringTokenizer(wildcard, "/");
        ArrayList<String> list = new ArrayList<String>();
        while (stk.hasMoreTokens()) {
            list.add(stk.nextToken());
        }
        if (list.size() < 3) {
            Except.throw_exception((String)"TangoApi_DeviceNameNotValid", (String)"Device name not valid", (String)"ATangoApi.Database.getDevices()");
        }
        String domain = (String)list.get(0);
        String family = (String)list.get(1);
        String member = (String)list.get(2);
        list.clear();
        String[] domains = this.get_device_domain(database, domain);
        if (domains.length == 0) {
            domains = new String[]{domain};
        }
        for (String domain_1 : domains) {
            String domain_header = domain_1 + "/";
            String[] families = this.get_device_family(database, domain_header + family);
            if (families.length == 0) {
                families = new String[]{family};
            }
            for (String family_1 : families) {
                String[] members;
                String family_header = domain_header + family_1 + "/";
                for (String member_1 : members = this.get_device_member(database, family_header + member)) {
                    list.add(family_header + member_1);
                }
            }
        }
        return list.toArray(new String[0]);
    }

    public DbEventImportInfo import_event(Database database, String channel_name) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        channel_name = new TangoUrl((String)channel_name).devname;
        DeviceData argIn = new DeviceData();
        argIn.insert(channel_name);
        DeviceData argOut = this.command_inout((Connection)database, "DbImportEvent", argIn);
        DevVarLongStringArray info = argOut.extractLongStringArray();
        return new DbEventImportInfo(info);
    }

    private List<DbHistory> convertPropertyHistory(String[] ret, boolean isAttribute) throws DevFailed {
        int offset;
        ArrayList<DbHistory> list = new ArrayList<DbHistory>();
        int count = 0;
        String aName = "";
        for (int i = 0; i < ret.length; i += count + offset) {
            String pCount;
            String pDate;
            String pName;
            if (isAttribute) {
                aName = ret[i];
                pName = ret[i + 1];
                pDate = ret[i + 2];
                pCount = ret[i + 3];
                offset = 4;
            } else {
                pName = ret[i];
                pDate = ret[i + 1];
                pCount = ret[i + 2];
                offset = 3;
            }
            try {
                count = Integer.parseInt(pCount);
            }
            catch (NumberFormatException e) {
                Except.throw_exception((String)"TangoApi_HistoryInvalid", (String)"History format is invalid");
            }
            String[] value = new String[count];
            System.arraycopy(ret, i + offset, value, 0, count);
            if (isAttribute) {
                list.add(new DbHistory(aName, pName, pDate, value));
                continue;
            }
            list.add(new DbHistory(pName, pDate, value));
        }
        return list;
    }

    public DbHistory[] get_device_property_history(Database database, String deviceName, String propname) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argIn = new DeviceData();
        argIn.insert(new String[]{deviceName, propname});
        DeviceData argOut = this.command_inout((Connection)database, "DbGetDevicePropertyHist", argIn);
        List<DbHistory> dbHistories = this.convertPropertyHistory(argOut.extractStringArray(), false);
        DbHistory[] array = new DbHistory[dbHistories.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = dbHistories.get(i);
        }
        return array;
    }

    public DbHistory[] get_device_attribute_property_history(Database database, String deviceName, String attname, String propname) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argIn = new DeviceData();
        argIn.insert(new String[]{deviceName, attname, propname});
        DeviceData argOut = this.command_inout((Connection)database, "DbGetDeviceAttributePropertyHist", argIn);
        List<DbHistory> dbHistories = this.convertPropertyHistory(argOut.extractStringArray(), true);
        DbHistory[] array = new DbHistory[dbHistories.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = dbHistories.get(i);
        }
        return array;
    }

    public DbHistory[] get_class_property_history(Database database, String classname, String propname) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argIn = new DeviceData();
        argIn.insert(new String[]{classname, propname});
        DeviceData argOut = this.command_inout((Connection)database, "DbGetClassPropertyHist", argIn);
        List<DbHistory> dbHistories = this.convertPropertyHistory(argOut.extractStringArray(), false);
        DbHistory[] array = new DbHistory[dbHistories.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = dbHistories.get(i);
        }
        return array;
    }

    public DbHistory[] get_class_attribute_property_history(Database database, String classname, String attname, String propname) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argIn = new DeviceData();
        argIn.insert(new String[]{classname, attname, propname});
        DeviceData argOut = this.command_inout((Connection)database, "DbGetClassAttributePropertyHist", argIn);
        List<DbHistory> dbHistories = this.convertPropertyHistory(argOut.extractStringArray(), true);
        DbHistory[] array = new DbHistory[dbHistories.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = dbHistories.get(i);
        }
        return array;
    }

    public DbHistory[] get_property_history(Database database, String objname, String propname) throws DevFailed {
        if (!database.isAccess_checked()) {
            this.checkAccess(database);
        }
        DeviceData argIn = new DeviceData();
        argIn.insert(new String[]{objname, propname});
        DeviceData argOut = this.command_inout((Connection)database, "DbGetPropertyHist", argIn);
        List<DbHistory> dbHistories = this.convertPropertyHistory(argOut.extractStringArray(), false);
        DbHistory[] array = new DbHistory[dbHistories.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = dbHistories.get(i);
        }
        return array;
    }

    public String[] getServices(Database database, String servicename, String instname) throws DevFailed {
        ArrayList<String> list = new ArrayList<String>();
        DbDatum datum = this.get_property(database, "CtrlSystem", "Services", true);
        if (!datum.is_empty()) {
            int separ;
            String[] services = datum.extractStringArray();
            String target = servicename.toLowerCase();
            if (!instname.equals("*")) {
                target = target + "/" + instname.toLowerCase();
                separ = 58;
            } else {
                separ = 47;
            }
            for (String service : services) {
                String startLine;
                int start = service.indexOf(separ);
                if (start <= 0 || !(startLine = service.substring(0, start).toLowerCase()).equals(target)) continue;
                list.add(service.substring(service.indexOf(58) + 1));
            }
        }
        return list.toArray(new String[0]);
    }

    public void registerService(Database database, String serviceName, String instanceName, String deviceName) throws DevFailed {
        String[] services = new String[]{};
        DbDatum data = this.get_property(database, "CtrlSystem", "Services");
        if (!data.is_empty()) {
            services = data.extractStringArray();
        }
        String new_line = serviceName + "/" + instanceName;
        String target = new_line.toLowerCase();
        new_line = new_line + ":" + deviceName;
        boolean exists = false;
        ArrayList<String> list = new ArrayList<String>();
        for (String service : services) {
            String line = service.toLowerCase();
            int idx = line.indexOf(58);
            if (idx > 0) {
                line = line.substring(0, idx);
            }
            if (line.equals(target)) {
                exists = true;
                list.add(new_line);
                continue;
            }
            list.add(service);
        }
        if (!exists) {
            list.add(new_line);
        }
        services = list.toArray(new String[0]);
        data = new DbDatum("Services");
        data.insert(services);
        this.put_property(database, "CtrlSystem", new DbDatum[]{data});
    }

    public void unregisterService(Database database, String serviceName, String instanceName, String deviceName) throws DevFailed {
        String[] services = new String[]{};
        DbDatum data = this.get_property(database, "CtrlSystem", "Services");
        if (!data.is_empty()) {
            services = data.extractStringArray();
        }
        String target = serviceName + "/" + instanceName;
        target = target.toLowerCase();
        boolean exists = false;
        ArrayList<String> list = new ArrayList<String>();
        for (String service : services) {
            String line = service.toLowerCase();
            int idx = line.indexOf(58);
            if (idx > 0) {
                line = line.substring(0, idx);
            }
            if (line.equals(target)) {
                exists = true;
                continue;
            }
            list.add(service);
        }
        if (exists) {
            services = list.toArray(new String[0]);
            data = new DbDatum("Services");
            data.insert(services);
            this.put_property(database, "CtrlSystem", new DbDatum[]{data});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkAccessControl(Database database, String deviceName, TangoUrl devUrl) {
        int access = 1;
        Object object = monitor;
        synchronized (object) {
            if (database.devname == null) {
                database.devname = database.device.name();
            }
            if (deviceName.equals(database.devname) && database.isAccess_checked()) {
                return database.access;
            }
            try {
                if (database.getAccess_proxy() == null) {
                    String access_deviceName = ApiUtil.getAccessDevname();
                    if (access_deviceName == null || access_deviceName.length() == 0) {
                        if (this.access_service_read && !database.check_access) {
                            return 1;
                        }
                        String[] services = this.getServices(database, "AccessControl", "*");
                        if (services.length > 0) {
                            access_deviceName = services[0];
                        } else {
                            database.check_access = false;
                            this.access_service_read = true;
                            return 1;
                        }
                    }
                    if (!devUrl.fromEnv && !access_deviceName.startsWith("tango://")) {
                        access_deviceName = "tango://" + devUrl.host + ":" + devUrl.port + "/" + access_deviceName;
                    }
                    database.setAccess_proxy(new AccessProxy(access_deviceName));
                }
                if (database.getAccess_proxy() != null) {
                    access = database.getAccess_proxy().checkAccessControl(deviceName);
                }
                if (!database.isAccess_checked() && !deviceName.equals(database.device.name())) {
                    this.checkAccess(database);
                }
            }
            catch (DevFailed e) {
                access = 0;
                if (e.errors.length > 1 && e.errors[1].reason.equals("TangoApi_CANNOT_IMPORT_DEVICE")) {
                    e.errors[0].desc = e.errors[0].desc + "\nControlled access service defined in Db but unreachable --> Read Only access given to all devices...";
                }
                database.setAccess_devfailed(e);
            }
        }
        return access;
    }

    public boolean isCommandAllowed(Database database, String classname, String cmd) throws DevFailed {
        if (database.getAccess_proxy() == null) {
            if (!database.isAccess_checked()) {
                this.checkAccess(database);
            }
            return !database.check_access;
        }
        return database.getAccess_proxy().isCommandAllowed(classname, cmd);
    }

    public String[] getPossibleTangoHosts(Database database) {
        String[] tangoHosts = null;
        try {
            DeviceData deviceData = database.command_inout("DbGetCSDbServerList");
            tangoHosts = deviceData.extractStringArray();
        }
        catch (DevFailed e) {
            String desc = e.errors[0].desc.toLowerCase();
            try {
                if (desc.startsWith("command ") && desc.endsWith("not found")) {
                    tangoHosts = new String[]{database.getFullTangoHost()};
                } else {
                    System.err.println(e.errors[0].desc);
                }
            }
            catch (DevFailed e2) {
                System.err.println(e2.errors[0].desc);
            }
        }
        return tangoHosts;
    }

    public DbPipe getDevicePipeProperties(Database database, String deviceName, String pipeName) throws DevFailed {
        DeviceData argIn = new DeviceData();
        argIn.insert(new String[]{deviceName, pipeName});
        DeviceData argOut = database.command_inout("DbGetDevicePipeProperty", argIn);
        return ApiUtil.toDbPipe((String)pipeName, (String[])argOut.extractStringArray());
    }

    public DbPipe getClassPipeProperties(Database database, String className, String pipeName) throws DevFailed {
        DeviceData argIn = new DeviceData();
        argIn.insert(new String[]{className, pipeName});
        DeviceData argOut = database.command_inout("DbGetClassPipeProperty", argIn);
        return ApiUtil.toDbPipe((String)pipeName, (String[])argOut.extractStringArray());
    }

    public void putDevicePipeProperty(Database database, String deviceName, DbPipe dbPipe) throws DevFailed {
        DeviceData argIn = new DeviceData();
        String[] array = ApiUtil.toStringArray((String)deviceName, (DbPipe)dbPipe);
        argIn.insert(array);
        database.command_inout("DbPutDevicePipeProperty", argIn);
    }

    public void putClassPipeProperty(Database database, String className, DbPipe dbPipe) throws DevFailed {
        DeviceData argIn = new DeviceData();
        String[] array = ApiUtil.toStringArray((String)className, (DbPipe)dbPipe);
        argIn.insert(array);
        database.command_inout("DbPutClassPipeProperty", argIn);
    }

    public List<String> getDevicePipeList(Database database, String deviceName, String wildcard) throws DevFailed {
        DeviceData argIn = new DeviceData();
        argIn.insert(new String[]{deviceName, wildcard});
        DeviceData argOut = database.command_inout("DbGetDevicePipeList", argIn);
        String[] array = argOut.extractStringArray();
        ArrayList<String> list = new ArrayList<String>();
        Collections.addAll(list, array);
        return list;
    }

    public List<String> getClassPipeList(Database database, String className, String wildcard) throws DevFailed {
        DeviceData argIn = new DeviceData();
        argIn.insert(new String[]{className, wildcard});
        DeviceData argOut = database.command_inout("DbGetDevicePipeList", argIn);
        String[] array = argOut.extractStringArray();
        ArrayList<String> list = new ArrayList<String>();
        Collections.addAll(list, array);
        return list;
    }

    public void deleteDevicePipeProperties(Database database, String deviceName, String pipeName, List<String> propertyNames) throws DevFailed {
        String[] array = new String[propertyNames.size() + 2];
        int i = 0;
        array[i++] = deviceName;
        array[i++] = pipeName;
        for (String propertyName : propertyNames) {
            array[i++] = propertyName;
        }
        DeviceData argIn = new DeviceData();
        argIn.insert(array);
        database.command_inout("DbDeleteDevicePipeProperty", argIn);
    }

    public void deleteClassPipeProperties(Database database, String className, String pipeName, List<String> propertyNames) throws DevFailed {
        String[] array = new String[propertyNames.size() + 2];
        int i = 0;
        array[i++] = className;
        array[i++] = pipeName;
        for (String propertyName : propertyNames) {
            array[i++] = propertyName;
        }
        DeviceData argIn = new DeviceData();
        argIn.insert(array);
        database.command_inout("DbDeleteClassPipeProperty", argIn);
    }

    public void deleteDevicePipe(Database database, String deviceName, String pipeName) throws DevFailed {
        String[] array = new String[]{deviceName, pipeName};
        DeviceData argIn = new DeviceData();
        argIn.insert(array);
        database.command_inout("DbDeleteDevicePipe", argIn);
    }

    public void deleteClassPipe(Database database, String className, String pipeName) throws DevFailed {
        String[] array = new String[]{className, pipeName};
        DeviceData argIn = new DeviceData();
        argIn.insert(array);
        database.command_inout("DbDeleteClassPipe", argIn);
    }

    public void deleteAllDevicePipeProperty(Database database, String deviceName, List<String> pipeNames) throws DevFailed {
        String[] array = new String[1 + pipeNames.size()];
        int i = 0;
        array[i++] = deviceName;
        for (String pipeName : pipeNames) {
            array[i++] = pipeName;
        }
        DeviceData argIn = new DeviceData();
        argIn.insert(array);
        database.command_inout("DbDeleteAllDevicePipeProperty", argIn);
    }

    public List<DbHistory> getDevicePipePropertyHistory(Database database, String deviceName, String pipeName, String propertyName) throws DevFailed {
        String[] array = new String[]{deviceName, pipeName, propertyName};
        DeviceData argIn = new DeviceData();
        argIn.insert(array);
        DeviceData argOut = database.command_inout("DbGetDevicePipePropertyHist", argIn);
        return this.convertPropertyHistory(argOut.extractStringArray(), true);
    }

    public List<DbHistory> getClassPipePropertyHistory(Database database, String className, String pipeName, String propertyName) throws DevFailed {
        String[] array = new String[]{className, pipeName, propertyName};
        DeviceData argIn = new DeviceData();
        argIn.insert(array);
        DeviceData argOut = database.command_inout("DbGetClassPipePropertyHist", argIn);
        return this.convertPropertyHistory(argOut.extractStringArray(), true);
    }

    public List<String[]> getForwardedAttributeDataForDevice(Database database, String deviceName) throws DevFailed {
        DeviceData argIn = new DeviceData();
        argIn.insert(deviceName);
        DeviceData argOut = database.command_inout("DbGetForwardedAttributeListForDevice", argIn);
        String[] array = argOut.extractStringArray();
        ArrayList<String[]> list = new ArrayList<String[]>();
        for (int i = 0; i < array.length / 3; ++i) {
            list.add(new String[]{array[3 * i], array[3 * i + 1], array[3 * i + 2]});
        }
        return list;
    }
}

