/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.DevCmdInfo;
import fr.esrf.Tango.DevFailed;
import fr.esrf.TangoApi.CommandInfo;
import fr.esrf.TangoDs.Except;

public class DevVarCmdArray {
    protected CommandInfo[] cmd_info;
    protected String devname;

    public DevVarCmdArray(String devname, DevCmdInfo[] info) {
        this.devname = devname;
        this.cmd_info = new CommandInfo[info.length];
        for (int i = 0; i < info.length; ++i) {
            this.cmd_info[i] = new CommandInfo(info[i]);
        }
    }

    public DevVarCmdArray(String devname, CommandInfo[] info) {
        this.devname = devname;
        this.cmd_info = info;
    }

    public int size() {
        return this.cmd_info.length;
    }

    public CommandInfo elementAt(int i) {
        return this.cmd_info[i];
    }

    public CommandInfo[] getInfoArray() {
        return this.cmd_info;
    }

    public int argoutType(String cmdname) throws DevFailed {
        for (CommandInfo info : this.cmd_info) {
            if (!cmdname.equals(info.cmd_name)) continue;
            return info.out_type;
        }
        Except.throw_non_supported_exception((String)"TACO_CMD_UNAVAILABLE", (String)(cmdname + " command unknown for device " + this.devname), (String)"DevVarCmdArray.argoutType()");
        return -1;
    }

    public int arginType(String cmdname) throws DevFailed {
        for (CommandInfo info : this.cmd_info) {
            if (!cmdname.equals(info.cmd_name)) continue;
            return info.in_type;
        }
        Except.throw_non_supported_exception((String)"TACO_CMD_UNAVAILABLE", (String)(cmdname + " command unknown for device " + this.devname), (String)"DevVarCmdArray.arginType()");
        return -1;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (CommandInfo info : this.cmd_info) {
            sb.append(info.cmd_name);
            sb.append("(").append(info.in_type);
            sb.append(", ").append(info.out_type).append(")\n");
        }
        return sb.toString();
    }
}

