/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi;

import fr.esrf.Tango.AttrQuality;
import fr.esrf.Tango.AttributeDim;
import fr.esrf.Tango.AttributeValue_3;
import fr.esrf.Tango.DevAttrHistory;
import fr.esrf.Tango.DevAttrHistory_3;
import fr.esrf.Tango.DevBooleanHelper;
import fr.esrf.Tango.DevCmdHistory;
import fr.esrf.Tango.DevDoubleHelper;
import fr.esrf.Tango.DevEncoded;
import fr.esrf.Tango.DevEncodedHelper;
import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevFloatHelper;
import fr.esrf.Tango.DevLongHelper;
import fr.esrf.Tango.DevShortHelper;
import fr.esrf.Tango.DevState;
import fr.esrf.Tango.DevStateHelper;
import fr.esrf.Tango.DevStringHelper;
import fr.esrf.Tango.DevULongHelper;
import fr.esrf.Tango.DevUShortHelper;
import fr.esrf.Tango.DevVarBooleanArrayHelper;
import fr.esrf.Tango.DevVarCharArrayHelper;
import fr.esrf.Tango.DevVarDoubleArrayHelper;
import fr.esrf.Tango.DevVarDoubleStringArray;
import fr.esrf.Tango.DevVarDoubleStringArrayHelper;
import fr.esrf.Tango.DevVarEncodedArrayHelper;
import fr.esrf.Tango.DevVarFloatArrayHelper;
import fr.esrf.Tango.DevVarLong64ArrayHelper;
import fr.esrf.Tango.DevVarLongArrayHelper;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.Tango.DevVarLongStringArrayHelper;
import fr.esrf.Tango.DevVarShortArrayHelper;
import fr.esrf.Tango.DevVarStateArrayHelper;
import fr.esrf.Tango.DevVarStringArrayHelper;
import fr.esrf.Tango.DevVarULong64ArrayHelper;
import fr.esrf.Tango.DevVarULongArrayHelper;
import fr.esrf.Tango.DevVarUShortArrayHelper;
import fr.esrf.Tango.TimeVal;
import fr.esrf.TangoApi.DeviceDataHistory;
import fr.esrf.TangoApi.IDeviceDataHistoryDAO;
import fr.esrf.TangoApi.WrongData;
import fr.esrf.TangoDs.Except;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;

public class DeviceDataHistoryDAODefaultImpl
implements IDeviceDataHistoryDAO {
    private Any any;
    private AttributeValue_3 attrval;
    private TimeVal tval;
    private int setType = -1;
    private boolean[] bool_data = null;
    private short[] short_data = null;
    private int[] int_data = null;
    private long[] long_data = null;
    private float[] float_data = null;
    private double[] double_data = null;
    private String[] string_data = null;
    private DevState[] state_data = null;
    private DevEncoded[] enc_data = null;
    private DevVarLongStringArray long_string_data = null;
    private DevVarDoubleStringArray double_string_data = null;

    public void init(DeviceDataHistory deviceDataHistory, String cmdname, DevCmdHistory cmd_hist) throws DevFailed {
        this.any = cmd_hist.value;
        deviceDataHistory.source = 0;
        deviceDataHistory.name = cmdname;
        this.tval = cmd_hist.time;
        deviceDataHistory.failed = cmd_hist.cmd_failed;
        deviceDataHistory.errors = cmd_hist.errors;
    }

    public void init(DeviceDataHistory deviceDataHistory, DevAttrHistory att_histo) throws DevFailed {
        this.any = att_histo.value.value;
        deviceDataHistory.source = 1;
        this.attrval = new AttributeValue_3(this.any, att_histo.value.quality, att_histo.value.time, att_histo.value.name, new AttributeDim(att_histo.value.dim_x, att_histo.value.dim_y), new AttributeDim(0, 0), att_histo.errors);
        deviceDataHistory.name = att_histo.value.name;
        this.tval = att_histo.value.time;
        deviceDataHistory.failed = att_histo.attr_failed;
        deviceDataHistory.errors = att_histo.errors;
    }

    public void init(DeviceDataHistory deviceDataHistory, DevAttrHistory_3 att_histo) throws DevFailed {
        this.any = att_histo.value.value;
        deviceDataHistory.source = 1;
        this.attrval = att_histo.value;
        deviceDataHistory.name = att_histo.value.name;
        this.tval = att_histo.value.time;
        deviceDataHistory.failed = att_histo.attr_failed;
        deviceDataHistory.errors = att_histo.value.err_list;
    }

    public void init(DeviceDataHistory deviceDataHistory, String name, int source, TimeVal time) throws DevFailed {
        this.any = null;
        deviceDataHistory.source = source;
        this.attrval = new AttributeValue_3(null, null, time, name, null, null, null);
        deviceDataHistory.name = name;
        this.tval = time;
        deviceDataHistory.failed = false;
        deviceDataHistory.errors = null;
    }

    public void init(DeviceDataHistory deviceDataHistory, String name, int source, long t) throws DevFailed {
        this.any = null;
        deviceDataHistory.source = source;
        int sec = (int)(t / 1000L);
        int usec = (int)((t - (long)(1000 * sec)) * 1000L);
        TimeVal time = new TimeVal(sec, usec, 0);
        this.attrval = new AttributeValue_3(null, null, time, name, null, null, null);
        deviceDataHistory.name = name;
        this.tval = time;
        deviceDataHistory.failed = false;
        deviceDataHistory.errors = null;
    }

    public void setTimeVal(DeviceDataHistory deviceDataHistory, TimeVal tval) {
        this.tval = tval;
    }

    public TimeVal getTimeVal(DeviceDataHistory deviceDataHistory) {
        return this.tval;
    }

    public long getTimeValSec(DeviceDataHistory deviceDataHistory) {
        return this.tval.tv_sec;
    }

    public long getTime(DeviceDataHistory deviceDataHistory) {
        return (long)this.tval.tv_sec * 1000L + (long)(this.tval.tv_usec / 1000);
    }

    public void setAttrQuality(DeviceDataHistory deviceDataHistory, AttrQuality q) throws DevFailed {
        this.attrval.quality = q;
    }

    public AttrQuality getAttrQuality(DeviceDataHistory deviceDataHistory) throws DevFailed {
        if (deviceDataHistory.source == 0) {
            Except.throw_non_supported_exception((String)"TangoApi_NOT_AVAILABLE", (String)"Method not avalaible for command", (String)"DeviceDataHistory.getAttrQuality()");
        }
        return this.attrval.quality;
    }

    public void setDimX(DeviceDataHistory deviceDataHistory, int dim) throws DevFailed {
        if (this.attrval.r_dim == null) {
            this.attrval.r_dim = new AttributeDim();
        }
        this.attrval.r_dim.dim_x = dim;
        this.attrval.r_dim.dim_y = 1;
    }

    public void setDimY(DeviceDataHistory deviceDataHistory, int dim) throws DevFailed {
        if (this.attrval.r_dim == null) {
            this.attrval.r_dim = new AttributeDim();
        }
        this.attrval.r_dim.dim_y = dim == 0 ? 1 : dim;
    }

    public int getDimX(DeviceDataHistory deviceDataHistory) throws DevFailed {
        if (deviceDataHistory.source == 0 && this.attrval.r_dim == null) {
            Except.throw_non_supported_exception((String)"TangoApi_NOT_AVAILABLE", (String)"Method not avalaible for command", (String)"DeviceDataHistory.getDimX()");
        }
        return this.attrval.r_dim.dim_x;
    }

    public int getDimY(DeviceDataHistory deviceDataHistory) throws DevFailed {
        if (deviceDataHistory.source == 0 && this.attrval.r_dim == null) {
            Except.throw_non_supported_exception((String)"TangoApi_NOT_AVAILABLE", (String)"Method not avalaible for command", (String)"DeviceDataHistory.getDimY()");
        }
        return this.attrval.r_dim.dim_y;
    }

    public boolean hasFailed(DeviceDataHistory deviceDataHistory) {
        return deviceDataHistory.failed;
    }

    public void setErrStack(DeviceDataHistory deviceDataHistory, DevError[] err) {
        deviceDataHistory.failed = true;
        this.attrval.err_list = err;
    }

    public DevError[] getErrStack(DeviceDataHistory deviceDataHistory) {
        return this.attrval.err_list;
    }

    public String getName(DeviceDataHistory deviceDataHistory) {
        return this.attrval.name;
    }

    private int DIM_MINI(int x) {
        return x == 0 ? 1 : x;
    }

    public int getNbRead(DeviceDataHistory deviceDataHistory) {
        return this.attrval.r_dim.dim_x * this.DIM_MINI(this.attrval.r_dim.dim_y);
    }

    public int getNbWritten(DeviceDataHistory deviceDataHistory) {
        return this.attrval.w_dim.dim_x * this.DIM_MINI(this.attrval.w_dim.dim_y);
    }

    public void setWrittenDimX(DeviceDataHistory deviceDataHistory, int dim) {
        if (this.attrval.w_dim == null) {
            this.attrval.w_dim = new AttributeDim();
        }
        this.attrval.w_dim.dim_x = dim;
        this.attrval.w_dim.dim_y = 1;
    }

    public void setWrittenDimY(DeviceDataHistory deviceDataHistory, int dim) {
        if (this.attrval.w_dim == null) {
            this.attrval.w_dim = new AttributeDim();
        }
        this.attrval.w_dim.dim_y = dim == 0 ? 1 : dim;
    }

    public int getWrittenDimX(DeviceDataHistory deviceDataHistory) {
        return this.attrval.w_dim.dim_x;
    }

    public int getWrittenDimY(DeviceDataHistory deviceDataHistory) {
        return this.attrval.w_dim.dim_y;
    }

    private void manageExceptions(String method_name) throws DevFailed {
        if (this.attrval.err_list != null && this.attrval.err_list.length > 0) {
            throw new WrongData(this.attrval.err_list);
        }
        if (this.attrval.quality == AttrQuality.ATTR_INVALID) {
            Except.throw_wrong_data_exception((String)"AttrQuality_ATTR_INVALID", (String)"Attribute quality factor is INVALID", (String)("DeviceAttributeHistory." + method_name + "()"));
        }
    }

    public Any extractAny(DeviceDataHistory deviceDataHistory) throws DevFailed {
        return this.any;
    }

    public boolean extractBoolean(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractBoolean()");
        if (this.bool_data != null) {
            return this.bool_data[0];
        }
        return DevBooleanHelper.extract((Any)this.any);
    }

    public short extractUChar(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractUChar()");
        if (this.short_data != null) {
            return this.short_data[0];
        }
        if (deviceDataHistory.source == 1) {
            return this.extractUCharArray(deviceDataHistory)[0];
        }
        return this.extractUChar(deviceDataHistory);
    }

    public short extractShort(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractShort()");
        if (this.short_data != null) {
            return this.short_data[0];
        }
        if (deviceDataHistory.source == 1) {
            return this.extractShortArray(deviceDataHistory)[0];
        }
        return DevShortHelper.extract((Any)this.any);
    }

    public short extractUShort(DeviceDataHistory deviceDataHistory) throws DevFailed {
        return DevUShortHelper.extract((Any)this.any);
    }

    public int extractLong(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractLong()");
        if (this.int_data != null) {
            return this.int_data[0];
        }
        if (deviceDataHistory.source == 1) {
            return this.extractLongArray(deviceDataHistory)[0];
        }
        return DevLongHelper.extract((Any)this.any);
    }

    public int extractULong(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractULong()");
        if (this.int_data != null) {
            return this.int_data[0];
        }
        if (deviceDataHistory.source == 1) {
            return this.extractULongArray(deviceDataHistory)[0];
        }
        return DevULongHelper.extract((Any)this.any);
    }

    public long extractLong64(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractLong64");
        if (this.long_data != null) {
            return this.long_data[0];
        }
        return this.extractLong64Array(deviceDataHistory)[0];
    }

    public long extractULong64(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractULong64");
        if (this.long_data != null) {
            return this.long_data[0];
        }
        return this.extractULong64Array(deviceDataHistory)[0];
    }

    public float extractFloat(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractFloat()");
        if (this.float_data != null) {
            return this.float_data[0];
        }
        if (deviceDataHistory.source == 1) {
            return this.extractFloatArray(deviceDataHistory)[0];
        }
        return DevFloatHelper.extract((Any)this.any);
    }

    public double extractDouble(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractDouble()");
        if (this.double_data != null) {
            return this.double_data[0];
        }
        if (deviceDataHistory.source == 1) {
            return this.extractDoubleArray(deviceDataHistory)[0];
        }
        return DevDoubleHelper.extract((Any)this.any);
    }

    public String extractString(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractString()");
        if (this.string_data != null) {
            return this.string_data[0];
        }
        if (deviceDataHistory.source == 1) {
            return this.extractStringArray(deviceDataHistory)[0];
        }
        return DevStringHelper.extract((Any)this.any);
    }

    public DevState extractDevState(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractDevState");
        if (this.state_data != null) {
            return this.state_data[0];
        }
        if (this.isArray()) {
            return deviceDataHistory.extractDevStateArray()[0];
        }
        return DevStateHelper.extract((Any)this.attrval.value);
    }

    public DevEncoded extractDevEncoded(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractDevEncoded");
        if (this.enc_data != null) {
            return this.enc_data[0];
        }
        if (deviceDataHistory.source == 1) {
            return this.extractDevEncodedArray(deviceDataHistory)[0];
        }
        return DevEncodedHelper.extract((Any)this.any);
    }

    public boolean[] extractBooleanArray(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractBooleanArray()");
        if (this.bool_data != null) {
            return this.bool_data;
        }
        return DevVarBooleanArrayHelper.extract((Any)this.any);
    }

    public byte[] extractByteArray(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractByteArray()");
        return DevVarCharArrayHelper.extract((Any)this.any);
    }

    public short[] extractUCharArray(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractUCharArray()");
        if (this.short_data != null) {
            return this.short_data;
        }
        byte[] argout = DevVarCharArrayHelper.extract((Any)this.any);
        short[] val = new short[argout.length];
        int mask = 255;
        for (int i = 0; i < argout.length; ++i) {
            val[i] = (short)(mask & argout[i]);
        }
        return val;
    }

    public short[] extractShortArray(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractShortArray()");
        if (this.short_data != null) {
            return this.short_data;
        }
        return DevVarShortArrayHelper.extract((Any)this.any);
    }

    public short[] extractUShortArray(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractUShortArray()");
        return DevVarUShortArrayHelper.extract((Any)this.any);
    }

    public int[] extractLongArray(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractLongArray()");
        if (this.int_data != null) {
            return this.int_data;
        }
        return DevVarLongArrayHelper.extract((Any)this.any);
    }

    public int[] extractULongArray(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractULongArray()");
        if (this.int_data != null) {
            return this.int_data;
        }
        return DevVarULongArrayHelper.extract((Any)this.any);
    }

    public long[] extractLong64Array(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractLong64Array()");
        if (this.long_data != null) {
            return this.long_data;
        }
        return DevVarLong64ArrayHelper.extract((Any)this.any);
    }

    public long[] extractULong64Array(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractULong64Array()");
        if (this.long_data != null) {
            return this.long_data;
        }
        return DevVarULong64ArrayHelper.extract((Any)this.any);
    }

    public float[] extractFloatArray(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractFloatArray()");
        if (this.float_data != null) {
            return this.float_data;
        }
        return DevVarFloatArrayHelper.extract((Any)this.any);
    }

    public double[] extractDoubleArray(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractDoubleArray()");
        if (this.double_data != null) {
            return this.double_data;
        }
        return DevVarDoubleArrayHelper.extract((Any)this.any);
    }

    public String[] extractStringArray(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractStringArray()");
        if (this.string_data != null) {
            return this.string_data;
        }
        return DevVarStringArrayHelper.extract((Any)this.any);
    }

    public DevState[] extractDevStateArray(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractDevStateArray()");
        if (this.state_data != null) {
            return this.state_data;
        }
        try {
            if (this.isArray()) {
                return DevVarStateArrayHelper.extract((Any)this.any);
            }
            return new DevState[]{DevStateHelper.extract((Any)this.any)};
        }
        catch (BAD_PARAM e) {
            Except.throw_wrong_data_exception((String)e.toString(), (String)("Exception catched : " + e.toString() + "\nMaybe the attribute value has not been initialized"), (String)"DeviceAttribute.extractDevStateArray()");
            return new DevState[0];
        }
    }

    public DevEncoded[] extractDevEncodedArray(DeviceDataHistory deviceDataHistory) throws DevFailed {
        this.manageExceptions("extractDevEncodedArray()");
        if (this.enc_data != null) {
            return this.enc_data;
        }
        return DevVarEncodedArrayHelper.extract((Any)this.any);
    }

    public DevVarLongStringArray extractLongStringArray(DeviceDataHistory deviceDataHistory) throws DevFailed {
        if (this.long_string_data != null) {
            return this.long_string_data;
        }
        return DevVarLongStringArrayHelper.extract((Any)this.any);
    }

    public DevVarDoubleStringArray extractDoubleStringArray(DeviceDataHistory deviceDataHistory) throws DevFailed {
        if (this.double_string_data != null) {
            return this.double_string_data;
        }
        return DevVarDoubleStringArrayHelper.extract((Any)this.any);
    }

    public TypeCode type(DeviceDataHistory deviceDataHistory) {
        return this.any.type();
    }

    private static boolean isArray(Any local_any) {
        boolean retval = true;
        try {
            TypeCode tc = local_any.type();
            TypeCode tc_alias = tc.content_type();
            tc_alias.content_type();
        }
        catch (BadKind e) {
            retval = false;
        }
        return retval;
    }

    private boolean isArray() {
        return DeviceDataHistoryDAODefaultImpl.isArray(this.any);
    }

    public int getType(DeviceDataHistory deviceDataHistory) throws DevFailed {
        if (this.setType != -1) {
            return this.setType;
        }
        int type = -1;
        try {
            TypeCode tc = this.attrval.value.type();
            if (tc.kind().value() == 0) {
                return 0;
            }
            if (tc.kind().value() == 17) {
                return 19;
            }
            TypeCode tc_alias = tc.content_type();
            TypeCode tc_seq = tc_alias.content_type();
            TCKind kind = tc_seq.kind();
            switch (kind.value()) {
                case 1: {
                    type = 0;
                    break;
                }
                case 8: {
                    type = 1;
                    break;
                }
                case 9: {
                    type = 21;
                    break;
                }
                case 10: {
                    type = 22;
                    break;
                }
                case 2: {
                    type = 2;
                    break;
                }
                case 4: {
                    type = 6;
                    break;
                }
                case 3: {
                    type = 3;
                    break;
                }
                case 5: {
                    type = 7;
                    break;
                }
                case 6: {
                    type = 4;
                    break;
                }
                case 7: {
                    type = 5;
                    break;
                }
                case 18: {
                    type = 8;
                    break;
                }
                case 17: {
                    type = 19;
                    break;
                }
                case 15: {
                    type = 28;
                }
            }
        }
        catch (BadKind e) {
            Except.throw_wrong_data_exception((String)"Api_TypeCodePackage.BadKind", (String)"Bad or unknown type ", (String)"DeviceDataHistory.getType()");
        }
        return type;
    }

    public int getDataLength(DeviceDataHistory ddh) throws DevFailed {
        int r_dim_x = ddh.getDimX();
        int r_dim_y = ddh.getDimY();
        int data_length = r_dim_y == 0 ? r_dim_x : r_dim_x * r_dim_y;
        if (ddh.source == 1) {
            int w_dim_x = ddh.getWrittenDimX();
            int w_dim_y = ddh.getWrittenDimY();
            data_length = w_dim_y == 0 ? (data_length += w_dim_x) : (data_length += w_dim_x * w_dim_y);
        }
        return data_length;
    }

    public int insert(DeviceDataHistory ddh, boolean[] values, int base) throws DevFailed {
        if (ddh.failed || ddh.source == 1 && ddh.getAttrQuality() == AttrQuality.ATTR_INVALID) {
            return base;
        }
        int data_length = ddh.getDataLength();
        this.bool_data = new boolean[data_length];
        for (int i = 0; i < data_length; ++i) {
            this.bool_data[i] = values[base - data_length + i];
        }
        this.setType = 1;
        return base - data_length;
    }

    public int insert(DeviceDataHistory ddh, short[] values, int base) throws DevFailed {
        if (ddh.failed || ddh.source == 1 && ddh.getAttrQuality() == AttrQuality.ATTR_INVALID) {
            return base;
        }
        int data_length = ddh.getDataLength();
        this.short_data = new short[data_length];
        for (int i = 0; i < data_length; ++i) {
            this.short_data[i] = values[base - data_length + i];
        }
        this.setType = 2;
        if (ddh.source == 0 && data_length > 1) {
            this.setType = 10;
        }
        return base - data_length;
    }

    public int insert(DeviceDataHistory ddh, int[] values, int base) throws DevFailed {
        if (ddh.failed || ddh.source == 1 && ddh.getAttrQuality() == AttrQuality.ATTR_INVALID) {
            return base;
        }
        int data_length = ddh.getDataLength();
        this.int_data = new int[data_length];
        for (int i = 0; i < data_length; ++i) {
            this.int_data[i] = values[base - data_length + i];
        }
        this.setType = 3;
        if (ddh.source == 0 && data_length > 1) {
            this.setType = 11;
        }
        return base - data_length;
    }

    public int insert(DeviceDataHistory ddh, long[] values, int base) throws DevFailed {
        if (ddh.failed || ddh.source == 1 && ddh.getAttrQuality() == AttrQuality.ATTR_INVALID) {
            return base;
        }
        int data_length = ddh.getDataLength();
        this.long_data = new long[data_length];
        for (int i = 0; i < data_length; ++i) {
            this.long_data[i] = values[base - data_length + i];
        }
        this.setType = 23;
        if (ddh.source == 0 && data_length > 1) {
            this.setType = 25;
        }
        return base - data_length;
    }

    public int insert(DeviceDataHistory ddh, float[] values, int base) throws DevFailed {
        if (ddh.failed || ddh.source == 1 && ddh.getAttrQuality() == AttrQuality.ATTR_INVALID) {
            return base;
        }
        int data_length = ddh.getDataLength();
        this.float_data = new float[data_length];
        for (int i = 0; i < data_length; ++i) {
            this.float_data[i] = values[base - data_length + i];
        }
        this.setType = 4;
        if (ddh.source == 0 && data_length > 1) {
            this.setType = 12;
        }
        return base - data_length;
    }

    public int insert(DeviceDataHistory ddh, double[] values, int base) throws DevFailed {
        if (ddh.failed || ddh.source == 1 && ddh.getAttrQuality() == AttrQuality.ATTR_INVALID) {
            return base;
        }
        int data_length = ddh.getDataLength();
        this.double_data = new double[data_length];
        for (int i = 0; i < data_length; ++i) {
            this.double_data[i] = values[base - data_length + i];
        }
        this.setType = 5;
        if (ddh.source == 0 && data_length > 1) {
            this.setType = 13;
        }
        return base - data_length;
    }

    public int insert(DeviceDataHistory ddh, String[] values, int base) throws DevFailed {
        if (ddh.failed || ddh.source == 1 && ddh.getAttrQuality() == AttrQuality.ATTR_INVALID) {
            return base;
        }
        int data_length = ddh.getDataLength();
        this.string_data = new String[data_length];
        for (int i = 0; i < data_length; ++i) {
            this.string_data[i] = values[base - data_length + i];
        }
        this.setType = 8;
        if (ddh.source == 0 && data_length > 1) {
            this.setType = 16;
        }
        return base - data_length;
    }

    public int insert(DeviceDataHistory ddh, DevState[] values, int base) throws DevFailed {
        if (ddh.failed || ddh.source == 1 && ddh.getAttrQuality() == AttrQuality.ATTR_INVALID) {
            return base;
        }
        int data_length = ddh.getDataLength();
        this.state_data = new DevState[data_length];
        for (int i = 0; i < data_length; ++i) {
            this.state_data[i] = values[base - data_length + i];
        }
        this.setType = 19;
        return base - data_length;
    }

    public int insert(DeviceDataHistory ddh, DevEncoded[] values, int base) throws DevFailed {
        if (ddh.failed || ddh.source == 1 && ddh.getAttrQuality() == AttrQuality.ATTR_INVALID) {
            return base;
        }
        int data_length = ddh.getDataLength();
        this.enc_data = new DevEncoded[data_length];
        for (int i = 0; i < data_length; ++i) {
            this.enc_data[i] = values[base - data_length + i];
        }
        this.setType = 28;
        return base - data_length;
    }

    public int[] insert(DeviceDataHistory ddh, DevVarLongStringArray lsa, int[] bases) throws DevFailed {
        int i;
        if (ddh.failed || ddh.source == 1 && ddh.getAttrQuality() == AttrQuality.ATTR_INVALID) {
            return bases;
        }
        int s_base = bases[0];
        int l_base = bases[1];
        int s_size = ddh.getDimX();
        int l_size = ddh.getDimY();
        this.long_string_data = new DevVarLongStringArray();
        this.long_string_data.svalue = new String[s_size];
        this.long_string_data.lvalue = new int[l_size];
        for (i = 0; i < s_size; ++i) {
            this.long_string_data.svalue[i] = lsa.svalue[s_base - s_size + i];
        }
        for (i = 0; i < l_size; ++i) {
            this.long_string_data.lvalue[i] = lsa.lvalue[l_base - l_size + i];
        }
        this.setType = 17;
        bases[0] = s_base - s_size;
        bases[1] = l_base - l_size;
        return bases;
    }

    public int[] insert(DeviceDataHistory ddh, DevVarDoubleStringArray dsa, int[] bases) throws DevFailed {
        int i;
        if (ddh.failed || ddh.source == 1 && ddh.getAttrQuality() == AttrQuality.ATTR_INVALID) {
            return bases;
        }
        int s_base = bases[0];
        int d_base = bases[1];
        int s_size = ddh.getDimX();
        int d_size = ddh.getDimY();
        this.double_string_data = new DevVarDoubleStringArray();
        this.double_string_data.svalue = new String[s_size];
        this.double_string_data.dvalue = new double[d_size];
        for (i = 0; i < s_size; ++i) {
            this.double_string_data.svalue[i] = dsa.svalue[s_base - s_size + i];
        }
        for (i = 0; i < d_size; ++i) {
            this.double_string_data.dvalue[i] = dsa.dvalue[d_base - d_size + i];
        }
        this.setType = 18;
        bases[0] = s_base - s_size;
        bases[1] = d_base - d_size;
        return bases;
    }

    public void insert(DeviceDataHistory ddh, double[] values) throws DevFailed {
        if (ddh.failed || ddh.source == 1 && ddh.getAttrQuality() == AttrQuality.ATTR_INVALID) {
            return;
        }
        ddh.setDimX(values.length);
        ddh.setDimY(1);
        ddh.setWrittenDimX(0);
        ddh.setWrittenDimY(0);
        this.double_data = values;
        this.setType = 5;
        if (ddh.source == 0 && values.length > 1) {
            this.setType = 13;
        }
    }

    public void insert(DeviceDataHistory ddh, String[] values) throws DevFailed {
        if (ddh.failed || ddh.source == 1 && ddh.getAttrQuality() == AttrQuality.ATTR_INVALID) {
            return;
        }
        ddh.setDimX(values.length);
        ddh.setDimY(1);
        ddh.setWrittenDimX(0);
        ddh.setWrittenDimY(0);
        this.string_data = values;
        this.setType = 8;
        if (ddh.source == 0 && values.length > 1) {
            this.setType = 16;
        }
    }
}

