/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TangoApi.events;

import fr.esrf.Tango.AttDataReady;
import fr.esrf.Tango.AttDataReadyHelper;
import fr.esrf.Tango.AttributeConfig_3;
import fr.esrf.Tango.AttributeConfig_3Helper;
import fr.esrf.Tango.AttributeConfig_5;
import fr.esrf.Tango.AttributeConfig_5Helper;
import fr.esrf.Tango.AttributeValue_4;
import fr.esrf.Tango.AttributeValue_4Helper;
import fr.esrf.Tango.AttributeValue_5;
import fr.esrf.Tango.AttributeValue_5Helper;
import fr.esrf.Tango.DevError;
import fr.esrf.Tango.DevErrorListHelper;
import fr.esrf.Tango.DevFailed;
import fr.esrf.Tango.DevIntrChangeHelper;
import fr.esrf.Tango.DevPipeData;
import fr.esrf.Tango.DevPipeDataHelper;
import fr.esrf.Tango.DevVarLongStringArray;
import fr.esrf.Tango.ZmqCallInfo;
import fr.esrf.Tango.ZmqCallInfoHelper;
import fr.esrf.TangoApi.ApiUtil;
import fr.esrf.TangoApi.AttributeInfoEx;
import fr.esrf.TangoApi.DeviceAttribute;
import fr.esrf.TangoApi.DeviceData;
import fr.esrf.TangoApi.DeviceInterface;
import fr.esrf.TangoApi.DevicePipe;
import fr.esrf.TangoApi.DeviceProxy;
import fr.esrf.TangoDs.Except;
import fr.esrf.TangoDs.TangoConst;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.jacorb.orb.CDRInputStream;
import org.omg.CORBA.portable.InputStream;
import org.zeromq.ZMQ;
import org.zeromq.ZMQException;

public class ZMQutils {
    public static final int ZMQ_END = 0;
    public static final int ZMQ_CONNECT_HEARTBEAT = 1;
    public static final int ZMQ_DISCONNECT_HEARTBEAT = 2;
    public static final int ZMQ_CONNECT_EVENT = 3;
    public static final int ZMQ_DISCONNECT_EVENT = 4;
    public static final int ZMQ_CONNECT_MCAST_EVENT = 5;
    public static final int ZMQ_DELAY_EVENT = 6;
    public static final int ZMQ_RELEASE_EVENT = 7;
    public static final String SUBSCRIBE_COMMAND = "ZmqEventSubscriptionChange";
    public static final String SUBSCRIBE_COMMAND_NOT_FOUND = "Command ZmqEventSubscriptionChange not found";
    private static final String[] commandNames = new String[]{"ZMQ_END", "ZMQ_CONNECT_HEARTBEAT", "ZMQ_DISCONNECT_HEARTBEAT", "ZMQ_CONNECT_EVENT", "ZMQ_DISCONNECT_EVENT", "ZMQ_CONNECT_MCAST_EVENT", "ZMQ_DELAY_EVENT", "ZMQ_RELEASE_EVENT"};
    private static final int HWM_DEFAULT = 1000;
    private static ZMQ.Context context = ZMQ.context((int)1);
    private static ZMQutils instance = null;
    private static double zmqVersion = -1.0;

    private ZMQutils() {
    }

    static ZMQutils getInstance() {
        if (instance == null) {
            instance = new ZMQutils();
        }
        return instance;
    }

    public static double getZmqVersion() {
        if (zmqVersion < 0.0) {
            zmqVersion = 0.0;
            try {
                String strVersion = ZMQ.getVersionString();
                StringTokenizer stk = new StringTokenizer(strVersion, ".");
                ArrayList<String> list = new ArrayList<String>();
                while (stk.hasMoreTokens()) {
                    list.add(stk.nextToken());
                }
                strVersion = (String)list.get(0) + "." + (String)list.get(1);
                if (list.size() > 2) {
                    strVersion = strVersion + (String)list.get(2);
                }
                try {
                    zmqVersion = Double.parseDouble(strVersion);
                }
                catch (NumberFormatException e) {
                    System.err.println("ZMQutils.getZmqVersion(): " + e);
                }
            }
            catch (Error | Exception throwable) {
                // empty catch block
            }
        }
        return zmqVersion;
    }

    static ZMQ.Context getContext() {
        return context;
    }

    private static byte[] buildTheBuffer(int command, boolean forceConnect, List<String> stringList) {
        return ZMQutils.buildTheBuffer(command, forceConnect, stringList, null);
    }

    private static byte[] buildTheBuffer(int command, boolean forceConnect, List<String> stringList, List<Integer> intList) {
        byte[] bytes;
        int size = 2;
        if (stringList.size() > 0) {
            for (String s : stringList) {
                size += s.length() + 1;
            }
            if (intList != null && intList.size() > 0) {
                size += intList.size() * 4;
            }
        }
        byte[] buffer = new byte[size];
        int idx = 0;
        buffer[idx++] = (byte)command;
        buffer[idx++] = (byte)(forceConnect ? 49 : 48);
        for (String s : stringList) {
            for (byte b : bytes = s.getBytes()) {
                buffer[idx++] = b;
            }
            buffer[idx++] = 0;
        }
        if (intList != null && intList.size() > 0) {
            Iterator<Object> iterator = intList.iterator();
            while (iterator.hasNext()) {
                int value = (Integer)iterator.next();
                for (byte b : bytes = ZMQutils.codeInteger(value)) {
                    buffer[idx++] = b;
                }
            }
        }
        return buffer;
    }

    private static String getString(byte[] bytes, int start) throws DevFailed {
        int length;
        int end = -1;
        for (int i = start; i < bytes.length && end < 0; ++i) {
            if (bytes[i] != 0) continue;
            end = i;
        }
        if (end < 0) {
            end = bytes.length - 1;
        }
        if ((length = end - start) <= 0) {
            Except.throw_wrong_syntax_exception((String)"API_BadSyntax", (String)"Bad syntax in control buffer (String not found)", (String)"ZMQutils.getString()");
        }
        byte[] b = new byte[length];
        System.arraycopy(bytes, start, b, 0, length);
        return new String(b);
    }

    private static byte[] codeInteger(int value) {
        byte[] b = new byte[4];
        for (int i = 0; i < 4; ++i) {
            b[i] = (byte)(value >> i * 8);
        }
        return b;
    }

    private static int decodeInteger(byte[] bytes) {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            int x = bytes[i] << i * 8 & 255 << i * 8;
            value += x;
        }
        return value;
    }

    private static int getInteger(byte[] buffer, int start) {
        byte[] bytes = new byte[4];
        System.arraycopy(buffer, start, bytes, 0, 4);
        return ZMQutils.decodeInteger(bytes);
    }

    static void sendToZmqControlSocket(byte[] buffer) throws DevFailed {
        ZMQ.Socket controlSocket;
        block5: {
            controlSocket = context.socket(3);
            try {
                controlSocket.connect("inproc://control");
            }
            catch (ZMQException e) {
                if (!e.toString().contains("Connection refused")) break block5;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                controlSocket.connect("inproc://control");
            }
        }
        controlSocket.send(buffer, 0);
        byte[] resp = controlSocket.recv(0);
        controlSocket.close();
        if (resp.length > 0) {
            Except.throw_exception((String)"API_InternalCommunicationError", (String)new String(resp));
        }
        ApiUtil.printTrace((String)"---> Message sent");
    }

    static String getFullAttributeName(String tangoHost, String deviceName, String attributeName, int idl, String eventName) {
        if (deviceName.startsWith("tango://")) {
            int start = deviceName.indexOf(47, "tango://".length() + 1);
            deviceName = deviceName.substring(start + 1);
        }
        if (idl >= 5) {
            if (eventName.equals(TangoConst.eventNames[7])) {
                return ("tango://" + tangoHost + "/" + deviceName + "." + eventName).toLowerCase();
            }
            if (eventName.equals(TangoConst.eventNames[8])) {
                return ("tango://" + tangoHost + "/" + deviceName + "/" + attributeName + "." + eventName).toLowerCase();
            }
            return ("tango://" + tangoHost + "/" + deviceName + "/" + attributeName + ".idl" + idl + "_" + eventName).toLowerCase();
        }
        return ("tango://" + tangoHost + "/" + deviceName + "/" + attributeName + "." + eventName).toLowerCase();
    }

    static String getFullHeartBeatName(String tangoHost, String deviceName) {
        return ("tango://" + tangoHost + "/" + deviceName + ".heartbeat").toLowerCase();
    }

    static void disConnectEvent(String tgHost, String deviceName, String attributeName, int idl, String eventName) throws DevFailed {
        String[] tangoHosts = ApiUtil.get_db_obj((String)tgHost).getPossibleTangoHosts();
        if (tangoHosts != null) {
            for (String tangoHost : tangoHosts) {
                byte[] buffer = ZMQutils.getBufferToDisConnectEvent(tangoHost, deviceName, attributeName, idl, eventName);
                ZMQutils.sendToZmqControlSocket(buffer);
            }
        }
    }

    private static byte[] getBufferToDisConnectEvent(String tangoHost, String deviceName, String attributeName, int idl, String eventName) throws DevFailed {
        byte[] buffer = new byte[]{};
        try {
            ArrayList<String> stringList = new ArrayList<String>();
            stringList.add(ZMQutils.getFullAttributeName(tangoHost, deviceName, attributeName, idl, eventName));
            buffer = ZMQutils.buildTheBuffer(4, false, stringList);
        }
        catch (Exception e) {
            e.printStackTrace();
            Except.throw_exception((String)"API_ConversionFailed", (String)e.toString());
        }
        return buffer;
    }

    static void connectEvent(String tgHost, String deviceName, String attributeName, DevVarLongStringArray lsa, String eventName, boolean forceConnect) throws DevFailed {
        String[] tangoHosts = ApiUtil.get_db_obj((String)tgHost).getPossibleTangoHosts();
        if (tangoHosts != null) {
            int n = 0;
            for (String tangoHost : tangoHosts) {
                boolean reallyForce = n++ == 0 && forceConnect;
                byte[] buffer = ZMQutils.getBufferToConnectEvent(tangoHost, deviceName, attributeName, lsa, eventName, reallyForce);
                ZMQutils.sendToZmqControlSocket(buffer);
            }
        } else {
            Except.throw_exception((String)"Api_NoTangoHost", (String)"No TANGO_HOST defined");
        }
    }

    private static byte[] getBufferToConnectEvent(String tangoHost, String deviceName, String attributeName, DevVarLongStringArray lsa, String eventName, boolean forceConnect) throws DevFailed {
        byte[] buffer = new byte[]{};
        try {
            ArrayList<String> stringList = new ArrayList<String>();
            stringList.add(lsa.svalue[1]);
            int tangoVersion = lsa.lvalue[0];
            if (tangoVersion >= 930) {
                stringList.add(lsa.svalue[lsa.svalue.length - 2]);
            } else {
                stringList.add(ZMQutils.getFullAttributeName(tangoHost, deviceName, attributeName, lsa.lvalue[1], eventName));
            }
            ArrayList<Integer> intList = new ArrayList<Integer>();
            intList.add(lsa.lvalue[0]);
            intList.add(lsa.lvalue[1]);
            intList.add(lsa.lvalue[2]);
            intList.add(lsa.lvalue[3]);
            intList.add(lsa.lvalue[4]);
            buffer = ZMQutils.buildTheBuffer(3, forceConnect, stringList, intList);
        }
        catch (Exception e) {
            e.printStackTrace();
            Except.throw_exception((String)"API_ConversionFailed", (String)e.toString());
        }
        return buffer;
    }

    static void connectHeartbeat(String tgHost, String adminDeviceName, DevVarLongStringArray lsa, boolean forceConnect) throws DevFailed {
        String[] tangoHosts = ApiUtil.get_db_obj((String)tgHost).getPossibleTangoHosts();
        if (tangoHosts != null) {
            int n = 0;
            for (String tangoHost : tangoHosts) {
                boolean reallyForce = n++ == 0 && forceConnect;
                byte[] buffer = ZMQutils.getBufferToConnectHeartbeat(tangoHost, adminDeviceName, lsa, reallyForce);
                ZMQutils.sendToZmqControlSocket(buffer);
            }
        }
    }

    private static byte[] getBufferToConnectHeartbeat(String tangoHost, String adminDeviceName, DevVarLongStringArray lsa, boolean forceConnect) throws DevFailed {
        byte[] buffer = new byte[]{};
        try {
            ArrayList<String> stringList = new ArrayList<String>();
            stringList.add(lsa.svalue[0]);
            int tangoVersion = lsa.lvalue[0];
            if (tangoVersion >= 930) {
                stringList.add(lsa.svalue[lsa.svalue.length - 1]);
            } else {
                stringList.add(ZMQutils.getFullHeartBeatName(tangoHost, adminDeviceName));
            }
            buffer = ZMQutils.buildTheBuffer(1, forceConnect, stringList);
        }
        catch (Exception e) {
            Except.throw_exception((String)"API_ConversionFailed", (String)e.toString());
        }
        return buffer;
    }

    private static byte[] getBufferToDisconnectHeartbeat(String tangoHost, String deviceName) throws DevFailed {
        byte[] buffer = new byte[]{};
        try {
            ArrayList<String> stringList = new ArrayList<String>();
            stringList.add(ZMQutils.getFullHeartBeatName(tangoHost, deviceName));
            buffer = ZMQutils.buildTheBuffer(2, false, stringList);
        }
        catch (Exception e) {
            Except.throw_exception((String)"API_ConversionFailed", (String)e.toString());
        }
        return buffer;
    }

    static DeviceData getEventSubscriptionInfoFromAdmDevice(DeviceProxy adminDevice, String deviceName, String attributeName, String eventName) throws DevFailed {
        DeviceData argIn = new DeviceData();
        String[] strArray = new String[]{deviceName, attributeName == null ? "" : attributeName, "subscribe", eventName, Integer.toString(adminDevice.get_idl_version())};
        argIn.insert(strArray);
        return adminDevice.command_inout(SUBSCRIBE_COMMAND, argIn);
    }

    static DevError[] deMarshallErrorList(byte[] recData, boolean littleIndian) throws DevFailed {
        try {
            byte[] buffer = new byte[recData.length - 4];
            System.arraycopy(recData, 4, buffer, 0, recData.length - 4);
            CDRInputStream is = new CDRInputStream(ApiUtil.getOrb(), buffer, littleIndian);
            return DevErrorListHelper.read((InputStream)is);
        }
        catch (Exception e) {
            Except.throw_exception((String)"Api_ConversionFailed", (String)("An exception " + e + " has been catch"));
            return null;
        }
    }

    static ZmqCallInfo deMarshallZmqCallInfo(byte[] recData, boolean littleIndian) throws DevFailed {
        try {
            CDRInputStream is = new CDRInputStream(ApiUtil.getOrb(), recData, littleIndian);
            return ZmqCallInfoHelper.read((InputStream)is);
        }
        catch (Exception e) {
            Except.throw_exception((String)"Api_ConversionFailed", (String)("An exception '" + e + "' has been catch"));
            return null;
        }
    }

    static AttDataReady deMarshallAttDataReady(byte[] recData, boolean littleIndian) throws DevFailed {
        try {
            byte[] buffer = new byte[recData.length - 4];
            System.arraycopy(recData, 4, buffer, 0, recData.length - 4);
            CDRInputStream is = new CDRInputStream(ApiUtil.getOrb(), buffer, littleIndian);
            return AttDataReadyHelper.read((InputStream)is);
        }
        catch (Exception e) {
            Except.throw_exception((String)"Api_ConversionFailed", (String)("An exception " + e + " has been catch"));
            return null;
        }
    }

    static DeviceInterface deMarshallAttInterfaceChange(byte[] recData, boolean littleIndian) throws DevFailed {
        try {
            byte[] buffer = new byte[recData.length - 4];
            System.arraycopy(recData, 4, buffer, 0, recData.length - 4);
            CDRInputStream is = new CDRInputStream(ApiUtil.getOrb(), buffer, littleIndian);
            return new DeviceInterface(DevIntrChangeHelper.read((InputStream)is));
        }
        catch (Exception e) {
            Except.throw_exception((String)"Api_ConversionFailed", (String)("An exception " + e + " has been catch"));
            return null;
        }
    }

    static AttributeInfoEx deMarshallAttributeConfig(byte[] recData, boolean littleIndian, int idl) throws DevFailed {
        try {
            byte[] buffer = new byte[recData.length - 4];
            System.arraycopy(recData, 4, buffer, 0, recData.length - 4);
            CDRInputStream is = new CDRInputStream(ApiUtil.getOrb(), buffer, littleIndian);
            if (idl >= 5) {
                AttributeConfig_5 attributeConfig_5 = AttributeConfig_5Helper.read((InputStream)is);
                return new AttributeInfoEx(attributeConfig_5);
            }
            AttributeConfig_3 attributeConfig_3 = AttributeConfig_3Helper.read((InputStream)is);
            return new AttributeInfoEx(attributeConfig_3);
        }
        catch (Exception e) {
            Except.throw_exception((String)"Api_ConversionFailed", (String)("An exception " + e + " has been catch"));
            return null;
        }
    }

    static DeviceAttribute deMarshallAttribute(byte[] recData, boolean littleIndian, int idl) throws DevFailed {
        try {
            byte[] buffer = new byte[recData.length - 4];
            if (idl >= 4) {
                if (idl < 5) {
                    System.arraycopy(recData, 4, buffer, 0, recData.length - 4);
                    CDRInputStream is = new CDRInputStream(ApiUtil.getOrb(), buffer, littleIndian);
                    AttributeValue_4 attributeValue_4 = AttributeValue_4Helper.read((InputStream)is);
                    return new DeviceAttribute(attributeValue_4);
                }
                System.arraycopy(recData, 4, buffer, 0, recData.length - 4);
                CDRInputStream is = new CDRInputStream(ApiUtil.getOrb(), buffer, littleIndian);
                AttributeValue_5 attributeValue_5 = AttributeValue_5Helper.read((InputStream)is);
                return new DeviceAttribute(attributeValue_5);
            }
            Except.throw_exception((String)"SeverTooOld", (String)("ZMQ events are not supported for IDL " + idl));
        }
        catch (DevFailed e) {
            throw e;
        }
        catch (Exception e) {
            Except.throw_exception((String)"Api_ConversionFailed", (String)("An exception " + e + " has been catch"));
        }
        return null;
    }

    static DevicePipe deMarshallPipe(byte[] recData, boolean littleIndian, int idl) throws DevFailed {
        try {
            byte[] buffer = new byte[recData.length - 8];
            if (idl >= 5) {
                System.arraycopy(recData, 8, buffer, 0, recData.length - 8);
                CDRInputStream inputStream = new CDRInputStream(ApiUtil.getOrb(), buffer, littleIndian);
                DevPipeData devPipeData = DevPipeDataHelper.read((InputStream)inputStream);
                return new DevicePipe(devPipeData);
            }
            Except.throw_exception((String)"SeverTooOld", (String)("Pipe events are not supported for IDL " + idl));
        }
        catch (DevFailed e) {
            throw e;
        }
        catch (Exception e) {
            Except.throw_exception((String)"Api_ConversionFailed", (String)("An exception " + e + " has been catch"));
        }
        return null;
    }

    static int getEventType(String eventName) throws DevFailed {
        int type = -1;
        int pos = eventName.lastIndexOf(46);
        if (pos > 0) {
            String strType = eventName.substring(pos + 1);
            if (strType.startsWith("idl")) {
                strType = strType.substring(strType.indexOf(95) + 1);
            }
            for (int i = 0; type < 0 && i < TangoConst.eventNames.length; ++i) {
                if (!strType.equals(TangoConst.eventNames[i])) continue;
                type = i;
            }
        }
        if (type < 0) {
            Except.throw_exception((String)"Api_BadParameterException", (String)("Cannot find event type for " + eventName));
        }
        return type;
    }

    static void zmqEventTrace(String s) {
        String env = System.getenv("ZmqTrace");
        if (env != null && env.equals("true")) {
            System.out.println(s);
        }
    }

    public static void trace(DevVarLongStringArray lsa) {
        System.out.println("Svalue");
        for (String s : lsa.svalue) {
            System.out.println("\t" + s);
        }
        System.out.println("Lvalue");
        for (int i : lsa.lvalue) {
            System.out.println("\t" + i);
        }
    }

    public static void dump(byte[] rec) {
        for (int i = 0; i < rec.length; ++i) {
            String s = String.format("%02x", 0xFF & rec[i]);
            System.out.print("0x" + s + " ");
            if ((i + 1) % 16 != 0) continue;
            System.out.println();
        }
        System.out.println();
    }

    ControlStructure decodeControlBuffer(byte[] bytes) throws DevFailed {
        ControlStructure controlStructure = new ControlStructure();
        int idx = 0;
        int sizeOfInt = 4;
        controlStructure.commandCode = bytes[idx++];
        controlStructure.forceReconnection = bytes[idx++] != 48;
        switch (controlStructure.commandCode) {
            case 0: {
                break;
            }
            case 1: {
                controlStructure.endPoint = ZMQutils.getString(bytes, idx++);
                controlStructure.eventName = ZMQutils.getString(bytes, idx += controlStructure.endPoint.length());
                ZMQutils.zmqEventTrace(controlStructure.toString());
                break;
            }
            case 2: {
                controlStructure.eventName = ZMQutils.getString(bytes, idx);
                break;
            }
            case 3: {
                controlStructure.endPoint = ZMQutils.getString(bytes, idx++);
                idx += controlStructure.endPoint.length();
                controlStructure.eventName = ZMQutils.getString(bytes, idx++);
                controlStructure.tango = ZMQutils.getInteger(bytes, idx += controlStructure.eventName.length());
                controlStructure.idl = ZMQutils.getInteger(bytes, idx += sizeOfInt);
                int hwm = ZMQutils.getInteger(bytes, idx += sizeOfInt);
                controlStructure.hwm = this.manageHwmValue(hwm);
                controlStructure.rate = ZMQutils.getInteger(bytes, idx += sizeOfInt);
                controlStructure.ivl = ZMQutils.getInteger(bytes, idx += sizeOfInt);
                ZMQutils.zmqEventTrace(controlStructure.toString());
                break;
            }
            case 4: {
                controlStructure.eventName = ZMQutils.getString(bytes, idx);
                break;
            }
            default: {
                Except.throw_exception((String)"API_NotImplemented", (String)("Command " + controlStructure.commandCode + "  NOT yet implemented"));
            }
        }
        return controlStructure;
    }

    private int manageHwmValue(int ctrlValue) {
        String envValue = System.getenv("TANGO_EVENT_BUFFER_HWM");
        if (envValue != null) {
            try {
                return Integer.parseInt(envValue);
            }
            catch (NumberFormatException e) {
                System.err.println("TANGO_EVENT_BUFFER_HWM value " + e);
            }
        }
        if (ApiUtil.getEventBufferHWM() > 0) {
            return ApiUtil.getEventBufferHWM();
        }
        return ctrlValue;
    }

    class ControlStructure {
        int commandCode = -1;
        String endPoint;
        String eventName;
        boolean forceReconnection = false;
        int tango = 0;
        int idl = 0;
        int hwm = 1000;
        int rate = 0;
        int ivl = 0;

        ControlStructure() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Command: ").append(commandNames[this.commandCode]).append("\n");
            if (this.endPoint != null) {
                sb.append("endPoint: ").append(this.endPoint).append("\n");
            }
            if (this.eventName != null) {
                sb.append("eventName: ").append(this.eventName).append("\n");
            }
            sb.append("int: ").append(this.hwm).append("  ").append(this.rate).append("  ").append(this.ivl).append("\n");
            return sb.toString();
        }
    }
}

