/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.teasoft.bee.osql.Condition;
import org.teasoft.bee.osql.FunctionType;
import org.teasoft.bee.osql.IncludeType;
import org.teasoft.bee.osql.Op;
import org.teasoft.bee.osql.OrderType;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.exception.BeeErrorGrammarException;
import org.teasoft.honey.osql.core.Expression;

public class ConditionImpl
implements Condition {
    private SuidType suidType;
    public List<Expression> list = new ArrayList<Expression>();
    private Set<String> fieldSet = new HashSet<String>();
    private IncludeType includeType;
    private List<Expression> updateSetList = new ArrayList<Expression>();
    private Set<String> updatefieldSet = new HashSet<String>();
    private boolean isStartGroupBy = true;
    private boolean isStartHaving = true;
    private boolean isStartOrderBy = true;
    private static String COMMA = ",";
    private Integer start;
    private Integer size;
    private static String setAdd = "setAdd";
    private static String setMultiply = "setMultiply";

    public Condition start(Integer start) {
        this.start = start;
        return this;
    }

    public Condition size(Integer size) {
        this.size = size;
        return this;
    }

    public IncludeType getIncludeType() {
        return this.includeType;
    }

    public Condition setIncludeType(IncludeType includeType) {
        this.includeType = includeType;
        return this;
    }

    public Condition op(String field, Op Op2, Object value) {
        this.list.add(new Expression(field, Op2, value));
        this.fieldSet.add(field);
        return this;
    }

    public Set<String> getFieldSet() {
        return this.fieldSet;
    }

    public Condition and() {
        Expression exp = new Expression();
        exp.setOpNum(1);
        exp.value = "and";
        this.list.add(exp);
        return this;
    }

    public Condition or() {
        Expression exp = new Expression();
        exp.setOpNum(1);
        exp.value = "or";
        this.list.add(exp);
        return this;
    }

    public Condition lParentheses() {
        Expression exp = new Expression();
        exp.setOpNum(-2);
        exp.value = "(";
        this.list.add(exp);
        return this;
    }

    public Condition rParentheses() {
        Expression exp = new Expression();
        exp.setOpNum(-1);
        exp.value = ")";
        this.list.add(exp);
        return this;
    }

    public Condition groupBy(String field) {
        Expression exp = new Expression();
        exp.fieldName = field;
        exp.opType = "groupBy";
        if (this.isStartGroupBy) {
            this.isStartGroupBy = false;
            exp.value = " group by ";
        } else {
            exp.value = COMMA;
        }
        this.list.add(exp);
        return this;
    }

    public Condition having(String expressionStr) {
        Expression exp = new Expression();
        exp.opType = "having";
        exp.opNum = 2;
        exp.value2 = expressionStr;
        if (this.isStartHaving) {
            if (this.isStartGroupBy) {
                throw new BeeErrorGrammarException("The 'having' must be after 'group by' !");
            }
            this.isStartHaving = false;
            exp.value = " having ";
        } else {
            exp.value = " and ";
        }
        this.list.add(exp);
        return this;
    }

    public Condition having(FunctionType functionType, String field, Op Op2, Number value) {
        Expression exp = new Expression();
        exp.opType = "having";
        exp.fieldName = field;
        exp.value2 = value;
        exp.value3 = functionType.getName();
        exp.opNum = 5;
        exp.value4 = Op2.getOperator();
        if (this.isStartHaving) {
            if (this.isStartGroupBy) {
                throw new BeeErrorGrammarException("The 'having' must be after 'group by' !");
            }
            this.isStartHaving = false;
            exp.value = " having ";
        } else {
            exp.value = " and ";
        }
        this.list.add(exp);
        return this;
    }

    public Condition orderBy(String field) {
        Expression exp = new Expression();
        exp.opType = "orderBy";
        exp.fieldName = field;
        exp.opNum = 2;
        if (this.isStartOrderBy) {
            this.isStartOrderBy = false;
            exp.value = " order by ";
        } else {
            exp.value = COMMA;
        }
        this.list.add(exp);
        return this;
    }

    public Condition orderBy(String field, OrderType orderType) {
        Expression exp = new Expression();
        exp.opType = "orderBy";
        exp.fieldName = field;
        exp.value2 = orderType.getName();
        exp.opNum = 3;
        if (this.isStartOrderBy) {
            this.isStartOrderBy = false;
            exp.value = " order by ";
        } else {
            exp.value = COMMA;
        }
        this.list.add(exp);
        return this;
    }

    public Condition orderBy(FunctionType functionType, String field, OrderType orderType) {
        Expression exp = new Expression();
        exp.opType = "orderBy";
        exp.fieldName = field;
        exp.value2 = orderType.getName();
        exp.value3 = functionType.getName();
        exp.opNum = 4;
        if (this.isStartOrderBy) {
            this.isStartOrderBy = false;
            exp.value = " order by ";
        } else {
            exp.value = COMMA;
        }
        this.list.add(exp);
        return this;
    }

    private void setForBetween(String field, Object low, Object high, String type) {
        Expression exp = new Expression();
        exp.fieldName = field;
        exp.opType = type;
        exp.value = low;
        exp.value2 = high;
        exp.opNum = 3;
        this.fieldSet.add(field);
        this.list.add(exp);
    }

    public Condition between(String field, Number low, Number high) {
        this.setForBetween(field, low, high, " between ");
        return this;
    }

    public Condition notBetween(String field, Number low, Number high) {
        this.setForBetween(field, low, high, " not between ");
        return this;
    }

    public Condition between(String field, String low, String high) {
        this.setForBetween(field, low, high, " between ");
        return this;
    }

    public Condition notBetween(String field, String low, String high) {
        this.setForBetween(field, low, high, " not between ");
        return this;
    }

    public void setSuidType(SuidType suidType) {
        this.suidType = suidType;
    }

    public SuidType getSuidType() {
        return this.suidType;
    }

    public List<Expression> getExpList() {
        return this.list;
    }

    public Integer getStart() {
        return this.start;
    }

    public Integer getSize() {
        return this.size;
    }

    public Condition setAdd(String field, double num) {
        return this.forUpdateSet(field, num, setAdd);
    }

    public Condition setMultiply(String field, double num) {
        return this.forUpdateSet(field, num, setMultiply);
    }

    public List<Expression> getUpdateExpList() {
        return this.updateSetList;
    }

    private Condition forUpdateSet(String field, double num, String opType) {
        Expression exp = new Expression();
        exp.fieldName = field;
        exp.opType = opType;
        exp.value = num;
        exp.opNum = 1;
        this.updatefieldSet.add(field);
        this.updateSetList.add(exp);
        return this;
    }

    public Set<String> getUpdatefieldSet() {
        return this.updatefieldSet;
    }
}

