/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import org.teasoft.bee.osql.BeeSql;
import org.teasoft.bee.osql.Cache;
import org.teasoft.bee.osql.CallableSql;
import org.teasoft.bee.osql.MoreObjToSQL;
import org.teasoft.bee.osql.MoreTable;
import org.teasoft.bee.osql.NameTranslate;
import org.teasoft.bee.osql.ObjToSQL;
import org.teasoft.bee.osql.ObjToSQLRich;
import org.teasoft.bee.osql.PreparedSql;
import org.teasoft.bee.osql.Suid;
import org.teasoft.bee.osql.SuidRich;
import org.teasoft.bee.osql.dialect.DbFeature;
import org.teasoft.bee.osql.exception.NoConfigException;
import org.teasoft.honey.osql.core.CallableSqlLib;
import org.teasoft.honey.osql.core.DefaultCache;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.MoreObjSQL;
import org.teasoft.honey.osql.core.MoreObjectToSQL;
import org.teasoft.honey.osql.core.NoCache;
import org.teasoft.honey.osql.core.ObjSQL;
import org.teasoft.honey.osql.core.ObjSQLRich;
import org.teasoft.honey.osql.core.ObjectToSQL;
import org.teasoft.honey.osql.core.ObjectToSQLRich;
import org.teasoft.honey.osql.core.PreparedSqlLib;
import org.teasoft.honey.osql.core.SqlLib;
import org.teasoft.honey.osql.dialect.mysql.MySqlFeature;
import org.teasoft.honey.osql.dialect.oracle.OracleFeature;
import org.teasoft.honey.osql.dialect.sqlserver.SqlServerFeature;
import org.teasoft.honey.osql.name.OriginalName;
import org.teasoft.honey.osql.name.UnderScoreAndCamelName;
import org.teasoft.honey.osql.name.UpperCaseUnderScoreAndCamelName;

public class HoneyFactory {
    private Suid suid;
    private SuidRich suidRich;
    private BeeSql beeSql;
    private ObjToSQL objToSQL;
    private ObjToSQLRich objToSQLRich;
    private PreparedSql preparedSql;
    private CallableSql callableSql;
    private DbFeature dbFeature;
    private NameTranslate nameTranslate;
    private Cache cache;
    private MoreObjToSQL moreObjToSQL;
    private MoreTable moreTable;

    public Suid getSuid() {
        if (this.suid == null) {
            return new ObjSQL();
        }
        return this.suid;
    }

    public void setSuid(Suid suid) {
        this.suid = suid;
    }

    public SuidRich getSuidRich() {
        if (this.suidRich == null) {
            return new ObjSQLRich();
        }
        return this.suidRich;
    }

    public void setSuidRich(SuidRich suidRich) {
        this.suidRich = suidRich;
    }

    public MoreTable getMoreTable() {
        if (this.moreTable == null) {
            return new MoreObjSQL();
        }
        return this.moreTable;
    }

    public void setMoreTable(MoreTable moreTable) {
        this.moreTable = moreTable;
    }

    public BeeSql getBeeSql() {
        if (this.beeSql == null) {
            return new SqlLib();
        }
        return this.beeSql;
    }

    public void setBeeSql(BeeSql beeSql) {
        this.beeSql = beeSql;
    }

    public ObjToSQL getObjToSQL() {
        if (this.objToSQL == null) {
            return new ObjectToSQL();
        }
        return this.objToSQL;
    }

    public void setObjToSQL(ObjToSQL objToSQL) {
        this.objToSQL = objToSQL;
    }

    public ObjToSQLRich getObjToSQLRich() {
        if (this.objToSQLRich == null) {
            return new ObjectToSQLRich();
        }
        return this.objToSQLRich;
    }

    public void setObjToSQLRich(ObjToSQLRich objToSQLRich) {
        this.objToSQLRich = objToSQLRich;
    }

    public MoreObjToSQL getMoreObjToSQL() {
        if (this.moreObjToSQL == null) {
            return new MoreObjectToSQL();
        }
        return this.moreObjToSQL;
    }

    public void setMoreObjToSQL(MoreObjToSQL moreObjToSQL) {
        this.moreObjToSQL = moreObjToSQL;
    }

    public PreparedSql getPreparedSql() {
        if (this.preparedSql == null) {
            return new PreparedSqlLib();
        }
        return this.preparedSql;
    }

    public void setPreparedSql(PreparedSql preparedSql) {
        this.preparedSql = preparedSql;
    }

    public CallableSql getCallableSql() {
        if (this.callableSql == null) {
            return new CallableSqlLib();
        }
        return this.callableSql;
    }

    public void setCallableSql(CallableSql callableSql) {
        this.callableSql = callableSql;
    }

    private DbFeature getDbDialect() {
        if ("mysql".equalsIgnoreCase(HoneyContext.getDbDialect()) || "MariaDB".equalsIgnoreCase(HoneyContext.getDbDialect())) {
            return new MySqlFeature();
        }
        if ("oracle".equalsIgnoreCase(HoneyContext.getDbDialect())) {
            return new OracleFeature();
        }
        if ("sqlserver".equalsIgnoreCase(HoneyContext.getDbDialect())) {
            return new SqlServerFeature();
        }
        throw new NoConfigException("Error: Do not set the database name. ");
    }

    public DbFeature getDbFeature() {
        if (this.dbFeature != null) {
            return this.dbFeature;
        }
        return this.getDbDialect();
    }

    public void setDbFeature(DbFeature dbFeature) {
        this.dbFeature = dbFeature;
    }

    public NameTranslate getNameTranslate() {
        if (this.nameTranslate == null) {
            int translateType = HoneyConfig.getHoneyConfig().getNamingTranslateType();
            if (translateType == 1) {
                this.nameTranslate = new UnderScoreAndCamelName();
            } else if (translateType == 2) {
                this.nameTranslate = new UpperCaseUnderScoreAndCamelName();
            } else if (translateType == 3) {
                this.nameTranslate = new OriginalName();
            }
            return this.nameTranslate;
        }
        return this.nameTranslate;
    }

    public void setNameTranslate(NameTranslate nameTranslate) {
        this.nameTranslate = nameTranslate;
    }

    public Cache getCache() {
        if (this.cache == null) {
            boolean nocache = HoneyConfig.getHoneyConfig().isNocache();
            if (nocache) {
                return new NoCache();
            }
            return new DefaultCache();
        }
        return this.cache;
    }
}

