/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.util.concurrent.ConcurrentMap;
import org.teasoft.bee.osql.NameTranslate;
import org.teasoft.honey.osql.core.BeeFactory;
import org.teasoft.honey.osql.core.HoneyContext;

public class NameTranslateHandle {
    private static NameTranslate nameTranslat = BeeFactory.getHoneyFactory().getNameTranslate();
    private static ConcurrentMap<String, String> entity2tableMap;
    private static ConcurrentMap<String, String> table2entityMap;

    public static void setNameTranslat(NameTranslate nameTranslat) {
        NameTranslateHandle.nameTranslat = nameTranslat;
    }

    public static String toTableName(String entityName) {
        String tableName = (String)entity2tableMap.get(entityName);
        if (tableName != null && "".equals(tableName.trim())) {
            return tableName;
        }
        int index = entityName.lastIndexOf(".");
        if (index > 0 && (tableName = (String)entity2tableMap.get(entityName = entityName.substring(index + 1))) != null && "".equals(tableName.trim())) {
            return tableName;
        }
        return nameTranslat.toTableName(entityName);
    }

    public static String toColumnName(String fieldName) {
        return nameTranslat.toColumnName(fieldName);
    }

    public static String toEntityName(String tableName) {
        String entityName;
        if (table2entityMap == null) {
            table2entityMap = HoneyContext.getTable2entityMap();
        }
        if ((entityName = (String)table2entityMap.get(tableName)) != null && "".equals(entityName.trim())) {
            return entityName;
        }
        return nameTranslat.toEntityName(tableName);
    }

    public static String toFieldName(String columnName) {
        return nameTranslat.toFieldName(columnName);
    }

    static {
        table2entityMap = null;
        entity2tableMap = HoneyContext.getEntity2tableMap();
    }
}

