/*
 * Decompiled with CFR 0.152.
 */
package org.teasoft.honey.osql.core;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Set;
import org.teasoft.bee.osql.Condition;
import org.teasoft.bee.osql.ObjSQLException;
import org.teasoft.bee.osql.SuidType;
import org.teasoft.bee.osql.annotation.JoinTable;
import org.teasoft.bee.osql.exception.BeeErrorGrammarException;
import org.teasoft.bee.osql.exception.BeeIllegalBusinessException;
import org.teasoft.honey.osql.core.CacheSuidStruct;
import org.teasoft.honey.osql.core.ConditionHelper;
import org.teasoft.honey.osql.core.ExceptionHelper;
import org.teasoft.honey.osql.core.HoneyConfig;
import org.teasoft.honey.osql.core.HoneyContext;
import org.teasoft.honey.osql.core.HoneyUtil;
import org.teasoft.honey.osql.core.Logger;
import org.teasoft.honey.osql.core.NameTranslateHandle;
import org.teasoft.honey.osql.core.PreparedValue;
import org.teasoft.honey.osql.core.SqlValueWrap;
import org.teasoft.honey.osql.name.NameUtil;

final class _ObjectToSQLHelper {
    private static final String INSERT_INTO = "insert into ";

    private _ObjectToSQLHelper() {
    }

    static <T> String _toSelectSQL(T entity, String fieldNameList) {
        _ObjectToSQLHelper.checkPackage(entity);
        String sql = "";
        StringBuffer sqlBuffer = new StringBuffer();
        StringBuffer valueBuffer = new StringBuffer();
        try {
            String tableName = _ObjectToSQLHelper._toTableName(entity);
            Field[] fields = entity.getClass().getDeclaredFields();
            sqlBuffer.append("select " + fieldNameList + " from ");
            sqlBuffer.append(tableName);
            boolean firstWhere = true;
            int len = fields.length;
            ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
            PreparedValue preparedValue = null;
            int k = 0;
            for (int i = 0; i < len; ++i) {
                fields[i].setAccessible(true);
                if (fields[i].get(entity) == null || "serialVersionUID".equals(fields[i].getName()) || fields[i].isAnnotationPresent(JoinTable.class)) continue;
                if (firstWhere) {
                    sqlBuffer.append(" where ");
                    firstWhere = false;
                } else {
                    sqlBuffer.append(" and ");
                }
                sqlBuffer.append(_ObjectToSQLHelper._toColumnName(fields[i].getName()));
                sqlBuffer.append("=");
                sqlBuffer.append("?");
                valueBuffer.append(",");
                valueBuffer.append(fields[i].get(entity));
                preparedValue = new PreparedValue();
                preparedValue.setType(fields[i].getType().getName());
                preparedValue.setValue(fields[i].get(entity));
                list.add(k++, preparedValue);
            }
            sql = sqlBuffer.toString();
            if (valueBuffer.length() > 0) {
                valueBuffer.deleteCharAt(0);
            }
            HoneyContext.setPreparedValue(sql, list);
            HoneyContext.setSqlValue(sql, valueBuffer.toString());
            _ObjectToSQLHelper.addInContextForCache(sql, valueBuffer.toString(), tableName);
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        return sql;
    }

    static <T> String _toSelectSQL(T entity, int includeType, Condition condition) {
        _ObjectToSQLHelper.checkPackage(entity);
        Set conditionFieldSet = null;
        if (condition != null) {
            conditionFieldSet = condition.getFieldSet();
        }
        StringBuffer sqlBuffer = new StringBuffer();
        StringBuffer valueBuffer = new StringBuffer();
        String tableName = _ObjectToSQLHelper._toTableName(entity);
        ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
        boolean firstWhere = true;
        try {
            Field[] fields = entity.getClass().getDeclaredFields();
            String packageAndClassName = entity.getClass().getName();
            String columnNames = HoneyContext.getBeanField(packageAndClassName);
            if (columnNames == null) {
                columnNames = HoneyUtil.getBeanField(fields);
                HoneyContext.addBeanField(packageAndClassName, columnNames);
            }
            sqlBuffer.append("select " + columnNames + " from ");
            sqlBuffer.append(tableName);
            int len = fields.length;
            PreparedValue preparedValue = null;
            int k = 0;
            for (int i = 0; i < len; ++i) {
                fields[i].setAccessible(true);
                if (HoneyUtil.isContinue(includeType, fields[i].get(entity), fields[i]) || fields[i].get(entity) == null && "id".equalsIgnoreCase(fields[i].getName()) || conditionFieldSet != null && conditionFieldSet.contains(fields[i].getName())) continue;
                if (firstWhere) {
                    sqlBuffer.append(" where ");
                    firstWhere = false;
                } else {
                    sqlBuffer.append(" and ");
                }
                sqlBuffer.append(_ObjectToSQLHelper._toColumnName(fields[i].getName()));
                if (fields[i].get(entity) == null) {
                    sqlBuffer.append(" is null");
                    continue;
                }
                sqlBuffer.append("=");
                sqlBuffer.append("?");
                valueBuffer.append(",");
                valueBuffer.append(fields[i].get(entity));
                preparedValue = new PreparedValue();
                preparedValue.setType(fields[i].getType().getName());
                preparedValue.setValue(fields[i].get(entity));
                list.add(k++, preparedValue);
            }
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        if (condition != null) {
            condition.setSuidType(SuidType.SELECT);
            ConditionHelper.processCondition(sqlBuffer, valueBuffer, list, condition, firstWhere);
        }
        if (valueBuffer.length() > 0) {
            valueBuffer.deleteCharAt(0);
        }
        HoneyContext.setPreparedValue(sqlBuffer.toString(), list);
        HoneyContext.setSqlValue(sqlBuffer.toString(), valueBuffer.toString());
        _ObjectToSQLHelper.addInContextForCache(sqlBuffer.toString(), valueBuffer.toString(), tableName);
        return sqlBuffer.toString();
    }

    static <T> String _toSelectSQL(T entity, int includeType) {
        return _ObjectToSQLHelper._toSelectSQL(entity, includeType, null);
    }

    static <T> String _toUpdateSQL(T entity, int includeType) {
        _ObjectToSQLHelper.checkPackage(entity);
        Field field = null;
        try {
            field = entity.getClass().getDeclaredField("id");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (field == null) {
            throw new ObjSQLException("ObjSQLException: in the update(T entity) or update(T entity,IncludeType includeType), the id field of entity must not be null !");
        }
        return _ObjectToSQLHelper._toUpdateBySQL(entity, new String[]{"id"}, includeType);
    }

    static <T> String _toUpdateSQL(T entity, String[] setColmn, int includeType) {
        return _ObjectToSQLHelper._toUpdateSQL(entity, setColmn, includeType, null);
    }

    static <T> String _toUpdateSQL(T entity, String[] setColmns, int includeType, Condition condition) {
        boolean notUpdateWholeRecords;
        _ObjectToSQLHelper.checkPackage(entity);
        Set conditionFieldSet = null;
        if (condition != null) {
            conditionFieldSet = condition.getFieldSet();
        }
        Set updatefieldSet = null;
        if (condition != null) {
            updatefieldSet = condition.getUpdatefieldSet();
        }
        String sql = "";
        StringBuffer sqlBuffer = new StringBuffer();
        StringBuffer valueBuffer = new StringBuffer();
        StringBuffer whereValueBuffer = new StringBuffer();
        boolean firstSet = true;
        boolean firstWhere = true;
        boolean isExistWhere = false;
        StringBuffer whereStament = new StringBuffer();
        ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
        String tableName = _ObjectToSQLHelper._toTableName(entity);
        try {
            sqlBuffer.append("update ");
            sqlBuffer.append(tableName);
            sqlBuffer.append(" set ");
            if (condition != null) {
                condition.setSuidType(SuidType.UPDATE);
                firstSet = ConditionHelper.processConditionForUpdateSet(sqlBuffer, whereValueBuffer, list, condition);
            }
            Field[] fields = entity.getClass().getDeclaredFields();
            int len = fields.length;
            ArrayList<PreparedValue> whereList = new ArrayList<PreparedValue>();
            PreparedValue preparedValue = null;
            int w = 0;
            for (int i = 0; i < len; ++i) {
                fields[i].setAccessible(true);
                if (_ObjectToSQLHelper.isContainField(setColmns, fields[i].getName())) {
                    if (updatefieldSet != null && updatefieldSet.contains(fields[i].getName())) continue;
                    if (firstSet) {
                        sqlBuffer.append(" ");
                        firstSet = false;
                    } else {
                        sqlBuffer.append(" , ");
                    }
                    sqlBuffer.append(_ObjectToSQLHelper._toColumnName(fields[i].getName()));
                    if (fields[i].get(entity) == null) {
                        sqlBuffer.append(" =null");
                        continue;
                    }
                    sqlBuffer.append("=");
                    sqlBuffer.append("?");
                    valueBuffer.append(",");
                    valueBuffer.append(fields[i].get(entity));
                    preparedValue = new PreparedValue();
                    preparedValue.setType(fields[i].getType().getName());
                    preparedValue.setValue(fields[i].get(entity));
                    list.add(preparedValue);
                    continue;
                }
                if (HoneyUtil.isContinue(includeType, fields[i].get(entity), fields[i]) || fields[i].get(entity) == null && "id".equalsIgnoreCase(fields[i].getName()) || conditionFieldSet != null && conditionFieldSet.contains(fields[i].getName())) continue;
                if (firstWhere) {
                    whereStament.append(" where ");
                    firstWhere = false;
                } else {
                    whereStament.append(" and ");
                }
                whereStament.append(_ObjectToSQLHelper._toColumnName(fields[i].getName()));
                if (fields[i].get(entity) == null) {
                    whereStament.append(" is null");
                } else {
                    whereStament.append("=");
                    whereStament.append("?");
                    whereValueBuffer.append(",");
                    whereValueBuffer.append(fields[i].get(entity));
                    preparedValue = new PreparedValue();
                    preparedValue.setType(fields[i].getType().getName());
                    preparedValue.setValue(fields[i].get(entity));
                    whereList.add(w++, preparedValue);
                }
                isExistWhere = true;
            }
            sqlBuffer.append(whereStament);
            list.addAll(whereList);
            valueBuffer.append(whereValueBuffer);
            if (firstSet) {
                Logger.logSQL("update SQL(updateFields) :", sql);
                throw new BeeErrorGrammarException("BeeErrorGrammarException: the SQL update set part is empty!");
            }
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        if (condition != null) {
            condition.setSuidType(SuidType.UPDATE);
            firstWhere = ConditionHelper.processCondition(sqlBuffer, valueBuffer, list, condition, firstWhere);
        }
        sql = sqlBuffer.toString();
        if (valueBuffer.length() > 0) {
            valueBuffer.deleteCharAt(0);
        }
        HoneyContext.setPreparedValue(sql, list);
        HoneyContext.setSqlValue(sql, valueBuffer.toString());
        _ObjectToSQLHelper.addInContextForCache(sqlBuffer.toString(), valueBuffer.toString(), tableName);
        if (firstWhere && (notUpdateWholeRecords = HoneyConfig.getHoneyConfig().isNotUpdateWholeRecords())) {
            Logger.logSQL("update SQL: ", sql);
            throw new BeeIllegalBusinessException("BeeIllegalBusinessException: It is not allowed update whole records in one table.");
        }
        return sql;
    }

    static <T> String _toUpdateBySQL(T entity, String[] whereColumns, int includeType) {
        return _ObjectToSQLHelper._toUpdateBySQL(entity, whereColumns, includeType, null);
    }

    static <T> String _toUpdateBySQL(T entity, String[] whereColumns, int includeType, Condition condition) {
        boolean notUpdateWholeRecords;
        _ObjectToSQLHelper.checkPackage(entity);
        Set conditionFieldSet = null;
        if (condition != null) {
            conditionFieldSet = condition.getFieldSet();
        }
        Set updatefieldSet = null;
        if (condition != null) {
            updatefieldSet = condition.getUpdatefieldSet();
        }
        String sql = "";
        StringBuffer sqlBuffer = new StringBuffer();
        StringBuffer valueBuffer = new StringBuffer();
        StringBuffer whereValueBuffer = new StringBuffer();
        boolean firstSet = true;
        boolean firstWhere = true;
        boolean isExistWhere = false;
        StringBuffer whereStament = new StringBuffer();
        String tableName = _ObjectToSQLHelper._toTableName(entity);
        ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
        try {
            sqlBuffer.append("update ");
            sqlBuffer.append(tableName);
            sqlBuffer.append(" set ");
            if (condition != null) {
                condition.setSuidType(SuidType.UPDATE);
                firstSet = ConditionHelper.processConditionForUpdateSet(sqlBuffer, whereValueBuffer, list, condition);
            }
            Field[] fields = entity.getClass().getDeclaredFields();
            int len = fields.length;
            ArrayList<PreparedValue> whereList = new ArrayList<PreparedValue>();
            PreparedValue preparedValue = null;
            int w = 0;
            for (int i = 0; i < len; ++i) {
                fields[i].setAccessible(true);
                if (!_ObjectToSQLHelper.isContainField(whereColumns, fields[i].getName())) {
                    if (HoneyUtil.isContinue(includeType, fields[i].get(entity), fields[i]) || fields[i].get(entity) == null && "id".equalsIgnoreCase(fields[i].getName()) || updatefieldSet != null && updatefieldSet.contains(fields[i].getName())) continue;
                    if (firstSet) {
                        sqlBuffer.append(" ");
                        firstSet = false;
                    } else {
                        sqlBuffer.append(" , ");
                    }
                    sqlBuffer.append(_ObjectToSQLHelper._toColumnName(fields[i].getName()));
                    if (fields[i].get(entity) == null) {
                        sqlBuffer.append(" =null");
                        continue;
                    }
                    sqlBuffer.append("=");
                    sqlBuffer.append("?");
                    valueBuffer.append(",");
                    valueBuffer.append(fields[i].get(entity));
                    preparedValue = new PreparedValue();
                    preparedValue.setType(fields[i].getType().getName());
                    preparedValue.setValue(fields[i].get(entity));
                    list.add(preparedValue);
                    continue;
                }
                if (conditionFieldSet != null && conditionFieldSet.contains(fields[i].getName()) || fields[i].get(entity) == null && "id".equalsIgnoreCase(fields[i].getName())) continue;
                if (firstWhere) {
                    whereStament.append(" where ");
                    firstWhere = false;
                } else {
                    whereStament.append(" and ");
                }
                whereStament.append(_ObjectToSQLHelper._toColumnName(fields[i].getName()));
                if (fields[i].get(entity) == null) {
                    whereStament.append(" is null");
                } else {
                    whereStament.append("=");
                    whereStament.append("?");
                    whereValueBuffer.append(",");
                    whereValueBuffer.append(fields[i].get(entity));
                    preparedValue = new PreparedValue();
                    preparedValue.setType(fields[i].getType().getName());
                    preparedValue.setValue(fields[i].get(entity));
                    whereList.add(w++, preparedValue);
                }
                isExistWhere = true;
            }
            sqlBuffer.append(whereStament);
            list.addAll(whereList);
            valueBuffer.append(whereValueBuffer);
            if (firstSet) {
                Logger.logSQL("update SQL(updateFields) :", sql);
                throw new BeeErrorGrammarException("BeeErrorGrammarException: the SQL update set part is empty!");
            }
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        if (condition != null) {
            condition.setSuidType(SuidType.UPDATE);
            firstWhere = ConditionHelper.processCondition(sqlBuffer, valueBuffer, list, condition, firstWhere);
        }
        sql = sqlBuffer.toString();
        if (valueBuffer.length() > 0) {
            valueBuffer.deleteCharAt(0);
        }
        HoneyContext.setPreparedValue(sql, list);
        HoneyContext.setSqlValue(sql, valueBuffer.toString());
        _ObjectToSQLHelper.addInContextForCache(sqlBuffer.toString(), valueBuffer.toString(), tableName);
        if (firstWhere && (notUpdateWholeRecords = HoneyConfig.getHoneyConfig().isNotUpdateWholeRecords())) {
            Logger.logSQL("update SQL: ", sql);
            throw new BeeIllegalBusinessException("BeeIllegalBusinessException: It is not allowed update whole records in one table.");
        }
        return sql;
    }

    static <T> String _toInsertSQL(T entity, int includeType) throws IllegalAccessException {
        _ObjectToSQLHelper.checkPackage(entity);
        StringBuffer sqlBuffer = new StringBuffer();
        StringBuffer sqlValue = new StringBuffer(") values (");
        StringBuffer valueBuffer = new StringBuffer();
        String sql = "";
        boolean isFirst = true;
        String tableName = _ObjectToSQLHelper._toTableName(entity);
        sqlBuffer.append(INSERT_INTO);
        sqlBuffer.append(tableName);
        sqlBuffer.append("(");
        Field[] fields = entity.getClass().getDeclaredFields();
        int len = fields.length;
        ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
        PreparedValue preparedValue = null;
        int k = 0;
        for (int i = 0; i < len; ++i) {
            fields[i].setAccessible(true);
            if (HoneyUtil.isContinue(includeType, fields[i].get(entity), fields[i])) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                sqlBuffer.append(",");
                sqlValue.append(",");
            }
            sqlBuffer.append(_ObjectToSQLHelper._toColumnName(fields[i].getName()));
            if (fields[i].get(entity) == null) {
                sqlValue.append("null");
                continue;
            }
            sqlValue.append("?");
            valueBuffer.append(",");
            valueBuffer.append(fields[i].get(entity));
            preparedValue = new PreparedValue();
            preparedValue.setType(fields[i].getType().getName());
            preparedValue.setValue(fields[i].get(entity));
            list.add(k++, preparedValue);
        }
        sqlBuffer.append(sqlValue);
        sqlBuffer.append(")");
        sql = sqlBuffer.toString();
        if (valueBuffer.length() > 0) {
            valueBuffer.deleteCharAt(0);
        }
        HoneyContext.setPreparedValue(sql, list);
        HoneyContext.setSqlValue(sql, valueBuffer.toString());
        _ObjectToSQLHelper.addInContextForCache(sqlBuffer.toString(), valueBuffer.toString(), tableName);
        return sql;
    }

    static <T> SqlValueWrap _toInsertSQL0(T entity, int includeType, String excludeFieldList) throws IllegalAccessException {
        _ObjectToSQLHelper.checkPackage(entity);
        StringBuffer sqlBuffer = new StringBuffer();
        StringBuffer sqlValue = new StringBuffer(") values (");
        StringBuffer valueBuffer = new StringBuffer();
        SqlValueWrap wrap = new SqlValueWrap();
        boolean isFirst = true;
        String tableName = _ObjectToSQLHelper._toTableName(entity);
        wrap.setTableNames(tableName);
        sqlBuffer.append(INSERT_INTO);
        sqlBuffer.append(tableName);
        sqlBuffer.append("(");
        Field[] fields = entity.getClass().getDeclaredFields();
        int len = fields.length;
        ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
        PreparedValue preparedValue = null;
        int k = 0;
        for (int i = 0; i < len; ++i) {
            fields[i].setAccessible(true);
            if (HoneyUtil.isContinue(includeType, fields[i].get(entity), fields[i]) || !"".equals(excludeFieldList) && _ObjectToSQLHelper.isExcludeField(excludeFieldList, fields[i].getName())) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                sqlBuffer.append(",");
                sqlValue.append(",");
            }
            sqlBuffer.append(_ObjectToSQLHelper._toColumnName(fields[i].getName()));
            sqlValue.append("?");
            valueBuffer.append(",");
            valueBuffer.append(fields[i].get(entity));
            preparedValue = new PreparedValue();
            preparedValue.setType(fields[i].getType().getName());
            preparedValue.setValue(fields[i].get(entity));
            list.add(k++, preparedValue);
        }
        sqlBuffer.append(sqlValue);
        sqlBuffer.append(")");
        if (valueBuffer.length() > 0) {
            valueBuffer.deleteCharAt(0);
        }
        wrap.setSql(sqlBuffer.toString());
        wrap.setList(list);
        wrap.setValueBuffer(valueBuffer);
        return wrap;
    }

    static <T> SqlValueWrap _toInsertSQL_for_ValueList(T entity, String excludeFieldList) throws IllegalAccessException {
        _ObjectToSQLHelper.checkPackage(entity);
        StringBuffer valueBuffer = new StringBuffer();
        SqlValueWrap wrap = new SqlValueWrap();
        Field[] fields = entity.getClass().getDeclaredFields();
        int len = fields.length;
        ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
        PreparedValue preparedValue = null;
        int k = 0;
        for (int i = 0; i < len; ++i) {
            fields[i].setAccessible(true);
            if ("serialVersionUID".equals(fields[i].getName()) || fields[i] != null && fields[i].isAnnotationPresent(JoinTable.class) || !"".equals(excludeFieldList) && _ObjectToSQLHelper.isExcludeField(excludeFieldList, fields[i].getName())) continue;
            valueBuffer.append(",");
            valueBuffer.append(fields[i].get(entity));
            preparedValue = new PreparedValue();
            preparedValue.setType(fields[i].getType().getName());
            preparedValue.setValue(fields[i].get(entity));
            list.add(k++, preparedValue);
        }
        if (valueBuffer.length() > 0) {
            valueBuffer.deleteCharAt(0);
        }
        wrap.setList(list);
        wrap.setValueBuffer(valueBuffer);
        return wrap;
    }

    static <T> String _toDeleteSQL(T entity, int includeType) {
        return _ObjectToSQLHelper._toDeleteSQL(entity, includeType, null);
    }

    static <T> String _toDeleteSQL(T entity, int includeType, Condition condition) {
        _ObjectToSQLHelper.checkPackage(entity);
        Set conditionFieldSet = null;
        if (condition != null) {
            conditionFieldSet = condition.getFieldSet();
        }
        String sql = "";
        StringBuffer sqlBuffer = new StringBuffer();
        StringBuffer valueBuffer = new StringBuffer();
        boolean firstWhere = true;
        try {
            boolean notDeleteWholeRecords;
            String tableName = _ObjectToSQLHelper._toTableName(entity);
            sqlBuffer.append("delete from ");
            sqlBuffer.append(tableName);
            Field[] fields = entity.getClass().getDeclaredFields();
            int len = fields.length;
            ArrayList<PreparedValue> list = new ArrayList<PreparedValue>();
            PreparedValue preparedValue = null;
            int k = 0;
            for (int i = 0; i < len; ++i) {
                fields[i].setAccessible(true);
                if (HoneyUtil.isContinue(includeType, fields[i].get(entity), fields[i]) || fields[i].get(entity) == null && "id".equalsIgnoreCase(fields[i].getName()) || conditionFieldSet != null && conditionFieldSet.contains(fields[i].getName())) continue;
                if (firstWhere) {
                    sqlBuffer.append(" where ");
                    firstWhere = false;
                } else {
                    sqlBuffer.append(" and ");
                }
                sqlBuffer.append(_ObjectToSQLHelper._toColumnName(fields[i].getName()));
                if (fields[i].get(entity) == null) {
                    sqlBuffer.append(" is null");
                    continue;
                }
                sqlBuffer.append("=");
                sqlBuffer.append("?");
                valueBuffer.append(",");
                valueBuffer.append(fields[i].get(entity));
                preparedValue = new PreparedValue();
                preparedValue.setType(fields[i].getType().getName());
                preparedValue.setValue(fields[i].get(entity));
                list.add(k++, preparedValue);
            }
            if (condition != null) {
                condition.setSuidType(SuidType.DELETE);
                firstWhere = ConditionHelper.processCondition(sqlBuffer, valueBuffer, list, condition, firstWhere);
            }
            sql = sqlBuffer.toString();
            if (valueBuffer.length() > 0) {
                valueBuffer.deleteCharAt(0);
            }
            HoneyContext.setPreparedValue(sql, list);
            HoneyContext.setSqlValue(sql, valueBuffer.toString());
            _ObjectToSQLHelper.addInContextForCache(sql, valueBuffer.toString(), tableName);
            if (firstWhere && (notDeleteWholeRecords = HoneyConfig.getHoneyConfig().isNotDeleteWholeRecords())) {
                Logger.logSQL("delete SQL: ", sql);
                throw new BeeIllegalBusinessException("BeeIllegalBusinessException: It is not allowed delete whole records in one table.");
            }
        }
        catch (IllegalAccessException e) {
            throw ExceptionHelper.convert(e);
        }
        return sql;
    }

    private static boolean isContainField(String[] checkFields, String fieldName) {
        int len = checkFields.length;
        for (int i = 0; i < len; ++i) {
            if (!checkFields[i].equalsIgnoreCase(fieldName)) continue;
            return true;
        }
        return false;
    }

    private static boolean isExcludeField(String excludeFieldList, String checkField) {
        String[] excludeFields;
        for (String f : excludeFields = excludeFieldList.split(",")) {
            if (!f.equals(checkField)) continue;
            return true;
        }
        return false;
    }

    static void addInContextForCache(String sql, String sqlValue, String tableName) {
        CacheSuidStruct struct = new CacheSuidStruct();
        struct.setSql(sql);
        struct.setSqlValue(sqlValue);
        struct.setTableNames(tableName);
        HoneyContext.setCacheInfo(sql, struct);
    }

    private static <T> void checkPackage(T entity) {
        HoneyUtil.checkPackage(entity);
    }

    private static String _toTableName(Object entity) {
        return NameTranslateHandle.toTableName(NameUtil.getClassFullName(entity));
    }

    private static String _toColumnName(String fieldName) {
        return NameTranslateHandle.toColumnName(fieldName);
    }
}

