/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.compiler;

import java.util.Vector;
import org.teatrove.tea.compiler.SourceInfo;
import org.teatrove.tea.compiler.Token;
import org.teatrove.tea.compiler.Type;
import org.teatrove.tea.parsetree.AndExpression;
import org.teatrove.tea.parsetree.ArithmeticExpression;
import org.teatrove.tea.parsetree.Block;
import org.teatrove.tea.parsetree.BooleanLiteral;
import org.teatrove.tea.parsetree.BreakStatement;
import org.teatrove.tea.parsetree.CompareExpression;
import org.teatrove.tea.parsetree.ConcatenateExpression;
import org.teatrove.tea.parsetree.ContinueStatement;
import org.teatrove.tea.parsetree.Expression;
import org.teatrove.tea.parsetree.ForeachStatement;
import org.teatrove.tea.parsetree.IfStatement;
import org.teatrove.tea.parsetree.Literal;
import org.teatrove.tea.parsetree.NegateExpression;
import org.teatrove.tea.parsetree.Node;
import org.teatrove.tea.parsetree.NotExpression;
import org.teatrove.tea.parsetree.NumberLiteral;
import org.teatrove.tea.parsetree.OrExpression;
import org.teatrove.tea.parsetree.ParenExpression;
import org.teatrove.tea.parsetree.RelationalExpression;
import org.teatrove.tea.parsetree.Statement;
import org.teatrove.tea.parsetree.StatementList;
import org.teatrove.tea.parsetree.StringLiteral;
import org.teatrove.tea.parsetree.TernaryExpression;
import org.teatrove.tea.parsetree.TreeMutator;
import org.teatrove.tea.parsetree.VariableRef;

public class BasicOptimizer {
    private Node mTree;

    public BasicOptimizer(Node tree) {
        this.mTree = tree;
    }

    public Node optimize() {
        return (Node)this.mTree.accept(new Visitor());
    }

    private static class Visitor
    extends TreeMutator {
        private Visitor() {
        }

        @Override
        public Object visit(Statement node) {
            return null;
        }

        @Override
        public Object visit(StatementList node) {
            Statement[] stmts = this.optimizeStatements(node.getStatements());
            if (stmts == null || stmts.length == 0) {
                return null;
            }
            if (stmts.length == 1) {
                return stmts[0];
            }
            return new StatementList(node.getSourceInfo(), stmts);
        }

        @Override
        public Object visit(Block node) {
            Statement fin;
            Statement[] stmts = this.optimizeStatements(node.getStatements());
            Statement init = node.getInitializer();
            if (init != null) {
                init = (Statement)init.accept(this);
            }
            if ((fin = node.getFinalizer()) != null) {
                fin = (Statement)fin.accept(this);
            }
            if (stmts == null || stmts.length == 0) {
                if (init == null && fin == null) {
                    return null;
                }
                node.setStatements(new Statement[0]);
            } else {
                node.setStatements(stmts);
            }
            node.setInitializer(init);
            node.setFinalizer(fin);
            return node;
        }

        private Statement[] optimizeStatements(Statement[] stmts) {
            if (stmts == null) {
                return null;
            }
            int length = stmts.length;
            Vector<Statement> v = new Vector<Statement>(length);
            for (int i = 0; i < length; ++i) {
                Statement stmt = (Statement)stmts[i].accept(this);
                if (stmt == null) continue;
                v.addElement(stmt);
            }
            Object[] newStmts = new Statement[v.size()];
            v.copyInto(newStmts);
            return newStmts;
        }

        @Override
        public Object visit(BreakStatement node) {
            return (BreakStatement)super.visit(node);
        }

        @Override
        public Object visit(ContinueStatement node) {
            return (ContinueStatement)super.visit(node);
        }

        @Override
        public Object visit(ForeachStatement node) {
            node = (ForeachStatement)super.visit(node);
            Expression range = node.getRange();
            Expression endRange = node.getEndRange();
            if (endRange != null && range.isValueKnown() && endRange.isValueKnown()) {
                Object rangeValue = range.getValue();
                Object endRangeValue = endRange.getValue();
                if (rangeValue instanceof Number && endRangeValue instanceof Number && ((Number)rangeValue).intValue() > ((Number)endRangeValue).intValue()) {
                    node.setBody(null);
                }
            }
            return node;
        }

        @Override
        public Object visit(IfStatement node) {
            Block elsePart;
            Expression condition = this.visitExpression(node.getCondition());
            if (condition.isValueKnown() && condition.getType().getObjectClass() == Boolean.class) {
                if (((Boolean)condition.getValue()).booleanValue()) {
                    Block thenPart = node.getThenPart();
                    if (thenPart != null) {
                        thenPart = (Block)thenPart.accept(this);
                    }
                    return thenPart;
                }
                Block elsePart2 = node.getElsePart();
                if (elsePart2 != null) {
                    elsePart2 = (Block)elsePart2.accept(this);
                }
                return elsePart2;
            }
            Block thenPart = node.getThenPart();
            if (thenPart != null) {
                thenPart = (Block)thenPart.accept(this);
            }
            if ((elsePart = node.getElsePart()) != null) {
                elsePart = (Block)elsePart.accept(this);
            }
            if (thenPart == null && elsePart != null) {
                thenPart = elsePart;
                elsePart = null;
                condition.convertTo(Type.BOOLEAN_TYPE);
                condition = new NotExpression(condition.getSourceInfo(), condition);
                condition.convertTo(Type.BOOLEAN_TYPE);
            }
            node.setCondition(condition);
            node.setThenPart(thenPart);
            node.setElsePart(elsePart);
            return node;
        }

        @Override
        public Object visit(ParenExpression node) {
            return node.getExpression().accept(this);
        }

        @Override
        public Object visit(NegateExpression node) {
            SourceInfo info = node.getSourceInfo();
            Expression expr = this.visitExpression(node.getExpression());
            if (expr.isValueKnown()) {
                Object value = expr.getValue();
                if (value instanceof Number) {
                    Number number = (Number)value;
                    if (value instanceof Integer) {
                        return new NumberLiteral(info, -number.intValue());
                    }
                    if (value instanceof Long) {
                        return new NumberLiteral(info, -number.longValue());
                    }
                    if (value instanceof Float) {
                        return new NumberLiteral(info, -number.floatValue());
                    }
                    if (value instanceof Double) {
                        return new NumberLiteral(info, -number.doubleValue());
                    }
                }
            } else if (expr instanceof NegateExpression) {
                return ((NegateExpression)expr).getExpression();
            }
            node.setExpression(expr);
            return node;
        }

        @Override
        public Object visit(NotExpression node) {
            SourceInfo info = node.getSourceInfo();
            Expression expr = this.visitExpression(node.getExpression());
            if (expr.isValueKnown()) {
                Object value = expr.getValue();
                if (value instanceof Boolean) {
                    boolean bv = (Boolean)value;
                    return new BooleanLiteral(info, !bv);
                }
            } else if (expr instanceof NotExpression) {
                return ((NotExpression)expr).getExpression();
            }
            node.setExpression(expr);
            return node;
        }

        @Override
        public Object visit(ConcatenateExpression node) {
            SourceInfo info = node.getSourceInfo();
            Expression left = this.visitExpression(node.getLeftExpression());
            Expression right = this.visitExpression(node.getRightExpression());
            if (left.isValueKnown() && left.getValue() instanceof String) {
                String leftValue = (String)left.getValue();
                if (right.isValueKnown() && right.getValue() instanceof String) {
                    String rightValue = (String)right.getValue();
                    return new StringLiteral(info, leftValue + rightValue);
                }
                if (leftValue.length() == 0) {
                    return right;
                }
            } else if (right.isValueKnown() && right.getValue() instanceof String && ((String)right.getValue()).length() == 0) {
                return left;
            }
            node.setLeftExpression(left);
            node.setRightExpression(right);
            return node;
        }

        @Override
        public strictfp Object visit(ArithmeticExpression node) {
            SourceInfo info = node.getSourceInfo();
            Token operator = node.getOperator();
            Expression left = this.visitExpression(node.getLeftExpression());
            Expression right = this.visitExpression(node.getRightExpression());
            if (node.getType() != null && left.isValueKnown() && right.isValueKnown()) {
                int ID = operator.getID();
                Object leftValue = left.getValue();
                Object rightValue = right.getValue();
                Type type = left.getType();
                if (leftValue instanceof Number && rightValue instanceof Number && type.equals(right.getType())) {
                    Class<?> clazz = type.getObjectClass();
                    Number lv = (Number)leftValue;
                    Number rv = (Number)rightValue;
                    try {
                        if (clazz == Integer.class) {
                            int i1 = lv.intValue();
                            int i2 = rv.intValue();
                            switch (ID) {
                                case 29: {
                                    return new NumberLiteral(info, i1 + i2);
                                }
                                case 30: {
                                    return new NumberLiteral(info, i1 - i2);
                                }
                                case 31: {
                                    return new NumberLiteral(info, i1 * i2);
                                }
                                case 32: {
                                    return new NumberLiteral(info, i1 / i2);
                                }
                                case 33: {
                                    return new NumberLiteral(info, i1 % i2);
                                }
                            }
                        } else if (clazz == Float.class) {
                            float f1 = lv.floatValue();
                            float f2 = rv.floatValue();
                            switch (ID) {
                                case 29: {
                                    return new NumberLiteral(info, f1 + f2);
                                }
                                case 30: {
                                    return new NumberLiteral(info, f1 - f2);
                                }
                                case 31: {
                                    return new NumberLiteral(info, f1 * f2);
                                }
                                case 32: {
                                    return new NumberLiteral(info, f1 / f2);
                                }
                                case 33: {
                                    return new NumberLiteral(info, f1 % f2);
                                }
                            }
                        } else if (clazz == Long.class) {
                            long L1 = lv.longValue();
                            long L2 = rv.longValue();
                            switch (ID) {
                                case 29: {
                                    return new NumberLiteral(info, L1 + L2);
                                }
                                case 30: {
                                    return new NumberLiteral(info, L1 - L2);
                                }
                                case 31: {
                                    return new NumberLiteral(info, L1 * L2);
                                }
                                case 32: {
                                    return new NumberLiteral(info, L1 / L2);
                                }
                                case 33: {
                                    return new NumberLiteral(info, L1 % L2);
                                }
                            }
                        } else if (clazz == Double.class) {
                            double d1 = lv.doubleValue();
                            double d2 = rv.doubleValue();
                            switch (ID) {
                                case 29: {
                                    return new NumberLiteral(info, d1 + d2);
                                }
                                case 30: {
                                    return new NumberLiteral(info, d1 - d2);
                                }
                                case 31: {
                                    return new NumberLiteral(info, d1 * d2);
                                }
                                case 32: {
                                    return new NumberLiteral(info, d1 / d2);
                                }
                                case 33: {
                                    return new NumberLiteral(info, d1 % d2);
                                }
                            }
                        }
                    }
                    catch (ArithmeticException e) {
                        // empty catch block
                    }
                }
            }
            node.setLeftExpression(left);
            node.setRightExpression(right);
            return node;
        }

        @Override
        public Object visit(RelationalExpression node) {
            boolean rightIsNull;
            SourceInfo info = node.getSourceInfo();
            Token operator = node.getOperator();
            int ID = operator.getID();
            Expression left = this.visitExpression(node.getLeftExpression());
            Type leftType = left.getType();
            Object leftValue = left.getValue();
            if (ID == 49) {
                Type rightType = node.getIsaTypeName().getType();
                if (rightType.getObjectClass().isAssignableFrom(leftType.getObjectClass())) {
                    return new BooleanLiteral(info, true);
                }
                node.setLeftExpression(left);
                return node;
            }
            Expression right = this.visitExpression(node.getRightExpression());
            Type rightType = right.getType();
            Object rightValue = right.getValue();
            if (node.getType() != null && left.isValueKnown() && right.isValueKnown() && leftValue != null && rightValue != null) {
                Type type = leftType;
                if (leftValue instanceof Number && rightValue instanceof Number && type.equals(rightType)) {
                    Class<?> clazz = type.getObjectClass();
                    Number lv = (Number)leftValue;
                    Number rv = (Number)rightValue;
                    if (clazz == Integer.class) {
                        int i1 = lv.intValue();
                        int i2 = rv.intValue();
                        switch (ID) {
                            case 24: {
                                return new BooleanLiteral(info, i1 == i2);
                            }
                            case 27: {
                                return new BooleanLiteral(info, i1 != i2);
                            }
                            case 22: {
                                return new BooleanLiteral(info, i1 < i2);
                            }
                            case 26: {
                                return new BooleanLiteral(info, i1 > i2);
                            }
                            case 23: {
                                return new BooleanLiteral(info, i1 <= i2);
                            }
                            case 25: {
                                return new BooleanLiteral(info, i1 >= i2);
                            }
                        }
                    } else if (clazz == Float.class) {
                        float f1 = lv.floatValue();
                        float f2 = rv.floatValue();
                        switch (ID) {
                            case 24: {
                                return new BooleanLiteral(info, f1 == f2);
                            }
                            case 27: {
                                return new BooleanLiteral(info, f1 != f2);
                            }
                            case 22: {
                                return new BooleanLiteral(info, f1 < f2);
                            }
                            case 26: {
                                return new BooleanLiteral(info, f1 > f2);
                            }
                            case 23: {
                                return new BooleanLiteral(info, f1 <= f2);
                            }
                            case 25: {
                                return new BooleanLiteral(info, f1 >= f2);
                            }
                        }
                    } else if (clazz == Long.class) {
                        long L1 = lv.longValue();
                        long L2 = rv.longValue();
                        switch (ID) {
                            case 24: {
                                return new BooleanLiteral(info, L1 == L2);
                            }
                            case 27: {
                                return new BooleanLiteral(info, L1 != L2);
                            }
                            case 22: {
                                return new BooleanLiteral(info, L1 < L2);
                            }
                            case 26: {
                                return new BooleanLiteral(info, L1 > L2);
                            }
                            case 23: {
                                return new BooleanLiteral(info, L1 <= L2);
                            }
                            case 25: {
                                return new BooleanLiteral(info, L1 >= L2);
                            }
                        }
                    } else if (clazz == Double.class) {
                        double d1 = lv.doubleValue();
                        double d2 = rv.doubleValue();
                        switch (ID) {
                            case 24: {
                                return new BooleanLiteral(info, d1 == d2);
                            }
                            case 27: {
                                return new BooleanLiteral(info, d1 != d2);
                            }
                            case 22: {
                                return new BooleanLiteral(info, d1 < d2);
                            }
                            case 26: {
                                return new BooleanLiteral(info, d1 > d2);
                            }
                            case 23: {
                                return new BooleanLiteral(info, d1 <= d2);
                            }
                            case 25: {
                                return new BooleanLiteral(info, d1 >= d2);
                            }
                        }
                    }
                } else if (leftValue instanceof String && rightValue instanceof String) {
                    int result = ((String)leftValue).compareTo((String)rightValue);
                    switch (ID) {
                        case 24: {
                            return new BooleanLiteral(info, result == 0);
                        }
                        case 27: {
                            return new BooleanLiteral(info, result != 0);
                        }
                        case 22: {
                            return new BooleanLiteral(info, result < 0);
                        }
                        case 26: {
                            return new BooleanLiteral(info, result > 0);
                        }
                        case 23: {
                            return new BooleanLiteral(info, result <= 0);
                        }
                        case 25: {
                            return new BooleanLiteral(info, result >= 0);
                        }
                    }
                }
            }
            if (leftType.isNonNull() && rightType.isNonNull() && leftType.getObjectClass() == Boolean.class && rightType.getObjectClass() == Boolean.class) {
                if (left.isValueKnown() && leftValue != null) {
                    boolean lv = (Boolean)leftValue;
                    if (right.isValueKnown() && rightValue != null) {
                        boolean rv = (Boolean)rightValue;
                        if (ID == 24) {
                            return new BooleanLiteral(info, lv == rv);
                        }
                        if (ID == 27) {
                            return new BooleanLiteral(info, lv != rv);
                        }
                    } else if (lv) {
                        if (ID == 24) {
                            return right;
                        }
                        if (ID == 27) {
                            right.convertTo(Type.BOOLEAN_TYPE);
                            right = new NotExpression(info, right);
                            right.convertTo(Type.BOOLEAN_TYPE);
                            return right;
                        }
                    } else {
                        if (ID == 24) {
                            right.convertTo(Type.BOOLEAN_TYPE);
                            right = new NotExpression(info, right);
                            right.convertTo(Type.BOOLEAN_TYPE);
                            return right;
                        }
                        if (ID == 27) {
                            return right;
                        }
                    }
                } else if (right.isValueKnown() && rightValue != null) {
                    boolean rv = (Boolean)rightValue;
                    if (rv) {
                        if (ID == 24) {
                            return left;
                        }
                        if (ID == 27) {
                            left.convertTo(Type.BOOLEAN_TYPE);
                            left = new NotExpression(info, left);
                            left.setType(Type.BOOLEAN_TYPE);
                            return left;
                        }
                    } else {
                        if (ID == 24) {
                            left.convertTo(Type.BOOLEAN_TYPE);
                            left = new NotExpression(info, left);
                            left.setType(Type.BOOLEAN_TYPE);
                            return left;
                        }
                        if (ID == 27) {
                            return left;
                        }
                    }
                }
            }
            boolean leftIsNull = left.isValueKnown() && leftValue == null;
            boolean bl = rightIsNull = right.isValueKnown() && rightValue == null;
            if (leftIsNull && rightIsNull) {
                if (ID == 24) {
                    return new BooleanLiteral(info, true);
                }
                if (ID == 27) {
                    return new BooleanLiteral(info, false);
                }
            } else if (leftIsNull && rightType.isNonNull() && (right instanceof Literal || right instanceof VariableRef) || rightIsNull && leftType.isNonNull() && (left instanceof Literal || left instanceof VariableRef)) {
                if (ID == 24) {
                    return new BooleanLiteral(info, false);
                }
                if (ID == 27) {
                    return new BooleanLiteral(info, true);
                }
            }
            node.setLeftExpression(left);
            node.setRightExpression(right);
            return node;
        }

        @Override
        public Object visit(AndExpression node) {
            Object rightValue;
            Object leftValue;
            SourceInfo info = node.getSourceInfo();
            Expression left = this.visitExpression(node.getLeftExpression());
            Expression right = this.visitExpression(node.getRightExpression());
            if (left.isValueKnown() && (leftValue = left.getValue()) instanceof Boolean) {
                if (((Boolean)leftValue).booleanValue()) {
                    return right;
                }
                return new BooleanLiteral(info, false);
            }
            if (right.isValueKnown() && (rightValue = right.getValue()) instanceof Boolean && ((Boolean)rightValue).booleanValue()) {
                return left;
            }
            node.setLeftExpression(left);
            node.setRightExpression(right);
            return node;
        }

        @Override
        public Object visit(OrExpression node) {
            Object rightValue;
            Object leftValue;
            SourceInfo info = node.getSourceInfo();
            Expression left = this.visitExpression(node.getLeftExpression());
            Expression right = this.visitExpression(node.getRightExpression());
            if (left.isValueKnown() && (leftValue = left.getValue()) instanceof Boolean) {
                if (((Boolean)leftValue).booleanValue()) {
                    return new BooleanLiteral(info, true);
                }
                return right;
            }
            if (right.isValueKnown() && (rightValue = right.getValue()) instanceof Boolean && !((Boolean)rightValue).booleanValue()) {
                return left;
            }
            node.setLeftExpression(left);
            node.setRightExpression(right);
            return node;
        }

        @Override
        public Object visit(TernaryExpression node) {
            Expression elsePart;
            Expression condition = this.visitExpression(node.getCondition());
            if (condition.isValueKnown() && condition.getType().getObjectClass() == Boolean.class) {
                if (((Boolean)condition.getValue()).booleanValue()) {
                    Expression thenPart = node.getThenPart();
                    if (thenPart != null) {
                        thenPart = (Expression)thenPart.accept(this);
                    }
                    return thenPart;
                }
                Expression elsePart2 = node.getElsePart();
                if (elsePart2 != null) {
                    elsePart2 = (Expression)elsePart2.accept(this);
                }
                return elsePart2;
            }
            Expression thenPart = node.getThenPart();
            if (thenPart != null) {
                thenPart = (Expression)thenPart.accept(this);
            }
            if ((elsePart = node.getElsePart()) != null) {
                elsePart = (Expression)elsePart.accept(this);
            }
            if (thenPart == null && elsePart != null) {
                thenPart = elsePart;
                elsePart = null;
                condition.convertTo(Type.BOOLEAN_TYPE);
                condition = new NotExpression(condition.getSourceInfo(), condition);
                condition.convertTo(Type.BOOLEAN_TYPE);
            }
            node.setCondition(condition);
            node.setThenPart(thenPart);
            node.setElsePart(elsePart);
            return node;
        }

        @Override
        public Object visit(CompareExpression node) {
            Expression left = this.visitExpression(node.getLeftExpression());
            Expression right = this.visitExpression(node.getRightExpression());
            if (left.isValueKnown() && right.isValueKnown()) {
                Object lvalue = left.getValue();
                Object rvalue = right.getValue();
                if (lvalue != null && lvalue != null) {
                    if (lvalue instanceof Comparable && lvalue.getClass().isAssignableFrom(rvalue.getClass())) {
                        int result = ((Comparable)lvalue).compareTo(rvalue);
                        return new NumberLiteral(node.getSourceInfo(), result);
                    }
                    int result = lvalue.toString().compareTo(rvalue.toString());
                    return new NumberLiteral(node.getSourceInfo(), result);
                }
            }
            node.setLeftExpression(left);
            node.setRightExpression(right);
            return node;
        }
    }
}

