/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.compiler;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Arrays;
import org.teatrove.tea.compiler.Compiler;
import org.teatrove.tea.compiler.ErrorEvent;
import org.teatrove.tea.compiler.ErrorListener;
import org.teatrove.tea.compiler.Parser;
import org.teatrove.tea.compiler.Scanner;
import org.teatrove.tea.parsetree.Template;
import org.teatrove.tea.parsetree.Variable;
import org.teatrove.trove.classfile.TypeDesc;
import org.teatrove.trove.io.SourceReader;

public abstract class CompilationUnit
implements ErrorListener {
    private String mName;
    private Compiler mCompiler;
    private Template mTree;
    private int mErrorCount;

    public CompilationUnit(String name, Compiler compiler) {
        this.mName = name;
        this.mCompiler = compiler;
    }

    public String getName() {
        return this.mName;
    }

    public String getShortName() {
        String name = this.getName();
        int index = name.lastIndexOf(46);
        if (index >= 0) {
            return name.substring(index + 1);
        }
        return name;
    }

    public Compiler getCompiler() {
        return this.mCompiler;
    }

    public Class<?> getRuntimeContext() {
        return this.mCompiler.getRuntimeContext();
    }

    @Override
    public void compileError(ErrorEvent e) {
        ++this.mErrorCount;
    }

    public int getErrorCount() {
        return this.mErrorCount;
    }

    public Template getParseTree() {
        if (this.mTree == null && this.mCompiler != null) {
            return this.mCompiler.getParseTree(this);
        }
        return this.mTree;
    }

    public void setParseTree(Template tree) {
        this.mTree = tree;
    }

    public final String[] getImportedPackages() {
        return this.mCompiler.getImportedPackages();
    }

    public String getTargetPackage() {
        return null;
    }

    public abstract String getSourceFileName();

    public abstract Reader getReader() throws IOException;

    public boolean shouldCompile() throws IOException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean signatureEquals(String templateName, TypeDesc[] params, TypeDesc returnType) throws IOException {
        TypeDesc srcReturnType;
        if (!this.getName().equals(templateName)) {
            return false;
        }
        BufferedReader r = new BufferedReader(this.getReader());
        SourceReader srcReader = new SourceReader((Reader)r, "<%", "%>");
        Template tree = null;
        try {
            Scanner s = new Scanner(srcReader, this);
            s.addErrorListener(this);
            Parser p = new Parser(s, this);
            p.addErrorListener(this);
            tree = p.parse();
            s.close();
        }
        finally {
            ((Reader)r).close();
        }
        Variable[] vars = tree.getParams();
        Object[] sourceParams = new TypeDesc[vars.length];
        for (int i = 0; i < vars.length; ++i) {
            String type = this.classNameFromVariable(vars[i].getTypeName().getName(), vars[i].getTypeName().getDimensions());
            sourceParams[i] = TypeDesc.forClass((String)type);
        }
        Object[] temp = new TypeDesc[params.length - 1];
        System.arraycopy(params, 1, temp, 0, temp.length);
        if (!Arrays.equals(temp, sourceParams)) {
            return false;
        }
        return null == tree.getReturnType() || returnType.equals((Object)(srcReturnType = TypeDesc.forClass((String)tree.getReturnType().getSimpleName())));
    }

    private String classNameFromVariable(String type, int dimensions) {
        if ("short".equals(type) || "long".equals(type) || "double".equals(type)) {
            type = type.substring(0, 1).toUpperCase() + type.substring(1);
        }
        if ("int".equals(type)) {
            type = "Integer";
        }
        if ("Short".equals(type) || "Integer".equals(type) || "Long".equals(type) || "Double".equals(type) || "String".equals(type)) {
            type = "java.lang." + type;
        }
        for (int j = 0; j < dimensions; ++j) {
            type = type + "[]";
        }
        return type;
    }

    public abstract OutputStream getOutputStream() throws IOException;

    public abstract void resetOutputStream();
}

