/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.compiler;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.teatrove.tea.compiler.CompilationUnit;
import org.teatrove.tea.compiler.Compiler;
import org.teatrove.tea.compiler.SourceInfo;
import org.teatrove.tea.compiler.Type;
import org.teatrove.tea.parsetree.Name;
import org.teatrove.tea.parsetree.Template;
import org.teatrove.tea.parsetree.Variable;
import org.teatrove.tea.runtime.Substitution;
import org.teatrove.trove.io.SourceReader;

public class CompiledTemplate
extends CompilationUnit {
    private Template mTree;
    private Class<?> mTemplateClass;
    private Method mExecuteMethod;
    private SourceInfo mCallerInfo = null;
    private CompilationUnit mCaller;
    private Variable[] mParameters;
    private Class<?> mRuntimeContext;
    private boolean mSubParam = false;
    private static final String TEMPLATE_PACKAGE = "org.teatrove.teaservlet.template";

    public CompiledTemplate(String name, Compiler compiler, CompilationUnit caller) {
        super(name, compiler);
        this.mCaller = caller;
        try {
            if (caller != null && caller.getReader() instanceof SourceReader) {
                SourceReader r = (SourceReader)caller.getReader();
                this.mCallerInfo = new SourceInfo(r.getLineNumber(), r.getStartPosition(), r.getEndPosition());
            }
        }
        catch (IOException ignore) {
            // empty catch block
        }
    }

    private static String resolveName(String name, CompilationUnit from) {
        String fromName;
        if (from != null && name.indexOf(46) == -1 && (fromName = from.getName()).indexOf(46) != -1) {
            name = fromName.substring(0, fromName.lastIndexOf(46)) + "." + name;
        }
        return name;
    }

    private Class<?> getTemplateClass() {
        String fqName = this.getTargetPackage() + "." + this.getName();
        try {
            this.mTemplateClass = this.getCompiler().loadClass(fqName);
        }
        catch (ClassNotFoundException nx) {
            try {
                this.mTemplateClass = this.getCompiler().loadClass(this.getName());
            }
            catch (ClassNotFoundException nx2) {
                return null;
            }
        }
        return this.mTemplateClass;
    }

    @Override
    public String getName() {
        return CompiledTemplate.resolveName(super.getName(), this.mCaller);
    }

    public boolean isValid() {
        this.getTemplateClass();
        if (this.findExecuteMethod() == null) {
            throw new IllegalArgumentException("Cannot locate compiled template entry point.");
        }
        Class<?>[] p = this.mExecuteMethod.getParameterTypes();
        this.mSubParam = false;
        this.mRuntimeContext = p[0];
        return this.mRuntimeContext.isInterface();
    }

    public static boolean exists(Compiler c, String name, CompilationUnit from) {
        String fqName = CompiledTemplate.getFullyQualifiedName(CompiledTemplate.resolveName(name, from));
        try {
            c.loadClass(fqName);
            return true;
        }
        catch (ClassNotFoundException nx) {
            try {
                c.loadClass(CompiledTemplate.resolveName(name, from));
                return true;
            }
            catch (ClassNotFoundException nx2) {
                return false;
            }
        }
    }

    public static String getFullyQualifiedName(String name) {
        return !name.startsWith(TEMPLATE_PACKAGE) ? "org.teatrove.teaservlet.template." + name : name;
    }

    @Override
    public Class<?> getRuntimeContext() {
        return this.mRuntimeContext;
    }

    @Override
    public Template getParseTree() {
        this.getTemplateClass();
        if (this.findExecuteMethod() == null) {
            throw new IllegalArgumentException("Cannot locate compiled template entry point.");
        }
        this.reflectParameters();
        this.mTree = new Template(this.mCallerInfo, new Name(this.mCallerInfo, this.getName()), this.mParameters, this.mSubParam, null, null);
        this.mTree.setReturnType(new Type(this.mExecuteMethod.getReturnType(), this.mExecuteMethod.getGenericReturnType()));
        return this.mTree;
    }

    private Method findExecuteMethod() {
        this.mExecuteMethod = null;
        Method[] methods = this.mTemplateClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!"execute".equals(methods[i].getName())) continue;
            this.mExecuteMethod = methods[i];
        }
        return this.mExecuteMethod;
    }

    private void reflectParameters() {
        Class<?>[] p = this.mExecuteMethod.getParameterTypes();
        java.lang.reflect.Type[] t = this.mExecuteMethod.getGenericParameterTypes();
        ArrayList<Variable> list = new ArrayList<Variable>();
        this.mSubParam = false;
        this.mRuntimeContext = p[0];
        if (!this.mRuntimeContext.isInterface()) {
            throw new IllegalArgumentException("No context found in compiled template execute method.");
        }
        for (int i = 1; i < p.length; ++i) {
            if (Substitution.class == p[i]) {
                this.mSubParam = true;
                continue;
            }
            list.add(new Variable(this.mCallerInfo, null, new Type(p[i], t[i])));
        }
        this.mParameters = list.toArray(new Variable[list.size()]);
    }

    @Override
    public void setParseTree(Template tree) {
    }

    @Override
    public String getTargetPackage() {
        return this.mCaller.getTargetPackage() != null ? this.mCaller.getTargetPackage() : TEMPLATE_PACKAGE;
    }

    @Override
    public boolean shouldCompile() throws IOException {
        return false;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.mCaller != null ? this.mCaller.getOutputStream() : null;
    }

    @Override
    public void resetOutputStream() {
        if (this.mCaller != null) {
            this.mCaller.resetOutputStream();
        }
    }

    @Override
    public Reader getReader() throws IOException {
        return this.mCaller != null ? this.mCaller.getReader() : null;
    }

    @Override
    public String getSourceFileName() {
        return "Compiled code.";
    }
}

