/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.compiler;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.teatrove.tea.compiler.BasicOptimizer;
import org.teatrove.tea.compiler.CodeGenerator;
import org.teatrove.tea.compiler.CompilationUnit;
import org.teatrove.tea.compiler.CompiledTemplate;
import org.teatrove.tea.compiler.ErrorEvent;
import org.teatrove.tea.compiler.ErrorListener;
import org.teatrove.tea.compiler.JavaClassGenerator;
import org.teatrove.tea.compiler.MessageFormatter;
import org.teatrove.tea.compiler.Parser;
import org.teatrove.tea.compiler.Scanner;
import org.teatrove.tea.compiler.SourceInfo;
import org.teatrove.tea.compiler.StatusEvent;
import org.teatrove.tea.compiler.StatusListener;
import org.teatrove.tea.compiler.TypeChecker;
import org.teatrove.tea.parsetree.Template;
import org.teatrove.tea.runtime.UtilityContext;
import org.teatrove.trove.io.SourceReader;

public abstract class Compiler {
    final Map<String, Template> mParseTreeMap;
    private final Map<String, CompilationUnit> mCompilationUnitMap = new HashMap<String, CompilationUnit>();
    private final Set<String> mCompiled = new HashSet<String>();
    private Set<String> mPreserveTree;
    private Class<?> mContextClass = UtilityContext.class;
    private Method[] mRuntimeMethods;
    private Method[] mStringConverters;
    private ErrorListener mErrorListener;
    private Vector<ErrorListener> mErrorListeners = new Vector(4);
    private int mErrorCount = 0;
    private Vector<StatusListener> mStatusListeners = new Vector();
    private boolean mGenerateCode = true;
    private boolean mExceptionGuardian = false;
    private ClassLoader mClassLoader;
    private MessageFormatter mFormatter;
    private Set<String> mImports = new HashSet<String>();

    public Compiler() {
        this(Collections.synchronizedMap(new HashMap()));
    }

    public Compiler(Map<String, Template> parseTreeMap) {
        this.mImports.add("java.lang");
        this.mImports.add("java.util");
        this.mParseTreeMap = parseTreeMap;
        this.mErrorListener = new ErrorListener(){

            @Override
            public void compileError(ErrorEvent e) {
                Compiler.this.dispatchCompileError(e);
            }
        };
        this.mFormatter = MessageFormatter.lookup(this);
    }

    public void addErrorListener(ErrorListener listener) {
        this.mErrorListeners.addElement(listener);
    }

    public void removeErrorListener(ErrorListener listener) {
        this.mErrorListeners.removeElement(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchCompileError(ErrorEvent e) {
        ++this.mErrorCount;
        Vector<ErrorListener> vector = this.mErrorListeners;
        synchronized (vector) {
            for (int i = 0; i < this.mErrorListeners.size(); ++i) {
                this.mErrorListeners.elementAt(i).compileError(e);
            }
        }
    }

    public void addStatusListener(StatusListener listener) {
        this.mStatusListeners.addElement(listener);
    }

    public void removeStatusListener(StatusListener listener) {
        this.mStatusListeners.removeElement(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchCompileStatus(StatusEvent e) {
        Vector<StatusListener> vector = this.mStatusListeners;
        synchronized (vector) {
            for (int i = 0; i < this.mStatusListeners.size(); ++i) {
                this.mStatusListeners.elementAt(i).statusUpdate(e);
            }
        }
    }

    private void uncaughtException(Throwable e) {
        Thread t = Thread.currentThread();
        t.getThreadGroup().uncaughtException(t, e);
    }

    public void setCodeGenerationEnabled(boolean flag) {
        this.mGenerateCode = flag;
    }

    public boolean isCodeGenerationEnabled() {
        return this.mGenerateCode;
    }

    public void setExceptionGuardianEnabled(boolean flag) {
        this.mExceptionGuardian = flag;
    }

    public boolean isExceptionGuardianEnabled() {
        return this.mExceptionGuardian;
    }

    public void setClassLoader(ClassLoader loader) {
        this.mClassLoader = loader;
    }

    public ClassLoader getClassLoader() {
        return this.mClassLoader;
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        while (true) {
            try {
                if (this.mClassLoader == null) {
                    return Class.forName(name);
                }
                return this.mClassLoader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                int index = name.lastIndexOf(46);
                if (index < 0) {
                    throw e;
                }
                name = name.substring(0, index) + '$' + name.substring(index + 1);
                continue;
            }
            break;
        }
    }

    public void preserveParseTree(String name) {
        if (this.mPreserveTree == null) {
            this.mPreserveTree = new HashSet<String>();
        }
        this.mPreserveTree.add(name);
    }

    public String[] compile(String name) throws IOException {
        return this.compile(new String[]{name});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] compile(String[] names) throws IOException {
        int i;
        Map<String, Template> map = this.mParseTreeMap;
        synchronized (map) {
            for (i = 0; i < names.length && !Thread.interrupted(); ++i) {
                this.dispatchCompileStatus(new StatusEvent(this, i, names.length, names[i]));
                CompilationUnit unit = this.getCompilationUnit(names[i], null);
                if (unit == null) {
                    String msg = this.mFormatter.format("not.found", names[i]);
                    this.dispatchCompileError(new ErrorEvent((Object)this, msg, (SourceInfo)null, null));
                    continue;
                }
                if (this.mCompiled.contains(names[i]) || !unit.shouldCompile()) continue;
                this.mParseTreeMap.remove(names[i]);
                this.getParseTree(unit);
            }
        }
        names = new String[this.mCompiled.size()];
        Iterator<String> it = this.mCompiled.iterator();
        i = 0;
        while (it.hasNext()) {
            names[i++] = it.next();
        }
        return names;
    }

    public int getErrorCount() {
        return this.mErrorCount;
    }

    public CompilationUnit getCompilationUnit(String name, CompilationUnit from) {
        String fqName = this.determineQualifiedName(name, from);
        boolean compiled = false;
        if (fqName == null && (compiled = CompiledTemplate.exists(this, name, from))) {
            fqName = CompiledTemplate.getFullyQualifiedName(name);
        }
        if (fqName == null) {
            return null;
        }
        CompilationUnit unit = this.mCompilationUnitMap.get(fqName);
        if (unit == null) {
            if (!compiled) {
                unit = this.createCompilationUnit(fqName);
                if (unit != null) {
                    this.mCompilationUnitMap.put(fqName, unit);
                }
            } else {
                unit = new CompiledTemplate(name, this, from);
                if (((CompiledTemplate)unit).isValid()) {
                    this.mCompilationUnitMap.put(fqName, unit);
                } else {
                    unit = null;
                }
            }
        }
        return unit;
    }

    public String[] getImportedPackages() {
        return this.mImports.toArray(new String[this.mImports.size()]);
    }

    public void addImportedPackage(String imported) {
        this.mImports.add(imported);
    }

    public void addImportedPackages(String[] imports) {
        if (imports == null) {
            return;
        }
        for (String imported : imports) {
            this.mImports.add(imported);
        }
    }

    public Class<?> getRuntimeContext() {
        return this.mContextClass;
    }

    public void setRuntimeContext(Class<?> contextClass) {
        this.mContextClass = contextClass;
        this.mRuntimeMethods = null;
        this.mStringConverters = null;
    }

    public final Method[] getRuntimeContextMethods() {
        if (this.mRuntimeMethods == null) {
            this.mRuntimeMethods = this.getRuntimeContext().getMethods();
        }
        return (Method[])this.mRuntimeMethods.clone();
    }

    public String getRuntimeReceiver() {
        return "print";
    }

    public String getRuntimeStringConverter() {
        return "toString";
    }

    public final Method[] getStringConverterMethods() {
        if (this.mStringConverters == null) {
            String name = this.getRuntimeStringConverter();
            Vector<Method> methods = new Vector<Method>();
            if (name != null) {
                Method[] contextMethods = this.getRuntimeContextMethods();
                for (int i = 0; i < contextMethods.length; ++i) {
                    Method m = contextMethods[i];
                    if (!m.getName().equals(name) || m.getReturnType() != String.class || m.getParameterTypes().length != 1) continue;
                    methods.addElement(m);
                }
            }
            int customSize = methods.size();
            Method[] stringMethods = String.class.getMethods();
            for (int i = 0; i < stringMethods.length; ++i) {
                Method cm;
                int j;
                Method m = stringMethods[i];
                if (!m.getName().equals("valueOf") || m.getReturnType() != String.class || m.getParameterTypes().length != 1 || !Modifier.isStatic(m.getModifiers())) continue;
                Class<?> type = m.getParameterTypes()[0];
                for (j = 0; j < customSize && (cm = (Method)methods.elementAt(j)).getParameterTypes()[0] != type; ++j) {
                }
                if (j != customSize) continue;
                methods.addElement(m);
            }
            this.mStringConverters = new Method[methods.size()];
            methods.copyInto(this.mStringConverters);
        }
        return (Method[])this.mStringConverters.clone();
    }

    private String determineQualifiedName(String name, CompilationUnit from) {
        String qual;
        String fromName;
        int index;
        if (from != null && (index = (fromName = from.getName()).lastIndexOf(46)) >= 0 && this.sourceExists(qual = fromName.substring(0, index + 1) + name)) {
            return qual;
        }
        if (this.sourceExists(name)) {
            return name;
        }
        return null;
    }

    public abstract boolean sourceExists(String var1);

    protected abstract CompilationUnit createCompilationUnit(String var1);

    protected SourceReader createSourceReader(CompilationUnit unit) throws IOException {
        BufferedReader r = new BufferedReader(unit.getReader());
        return new SourceReader((Reader)r, "<%", "%>");
    }

    protected Scanner createScanner(SourceReader reader, CompilationUnit unit) throws IOException {
        return new Scanner(reader, unit);
    }

    protected Parser createParser(Scanner scanner, CompilationUnit unit) throws IOException {
        return new Parser(scanner, unit);
    }

    protected TypeChecker createTypeChecker(CompilationUnit unit) {
        TypeChecker tc = new TypeChecker(unit);
        tc.setClassLoader(this.getClassLoader());
        tc.setExceptionGuardianEnabled(this.isExceptionGuardianEnabled());
        return tc;
    }

    protected CodeGenerator createCodeGenerator(CompilationUnit unit) throws IOException {
        return new JavaClassGenerator(unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Template getParseTree(CompilationUnit unit) {
        Map<String, Template> map = this.mParseTreeMap;
        synchronized (map) {
            return this.getParseTree0(unit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Template getParseTree0(CompilationUnit unit) {
        Template tree;
        block20: {
            Object msg;
            String name = unit.getName();
            tree = this.mParseTreeMap.get(name);
            if (tree != null) {
                return tree;
            }
            try {
                this.addErrorListener(unit);
                try {
                    Scanner s = this.createScanner(this.createSourceReader(unit), unit);
                    s.addErrorListener(this.mErrorListener);
                    Parser p = this.createParser(s, unit);
                    p.addErrorListener(this.mErrorListener);
                    tree = p.parse();
                    this.mParseTreeMap.put(name, tree);
                    s.close();
                }
                catch (IOException e) {
                    this.uncaughtException(e);
                    String msg2 = this.mFormatter.format("read.error", e.toString());
                    this.dispatchCompileError(new ErrorEvent((Object)this, msg2, (SourceInfo)null, unit));
                    Template template = tree;
                    this.removeErrorListener(unit);
                    if (!(tree == null || this.mPreserveTree != null && this.mPreserveTree.contains(name))) {
                        tree.setStatement(null);
                    }
                    return template;
                }
                TypeChecker tc = this.createTypeChecker(unit);
                tc.setClassLoader(this.getClassLoader());
                tc.addErrorListener(this.mErrorListener);
                tc.typeCheck();
                if (this.mCompiled.contains(name) || !unit.shouldCompile()) {
                    msg = tree;
                    return msg;
                }
                this.mCompiled.add(name);
                if (unit.getErrorCount() != 0 || !this.mGenerateCode) break block20;
                OutputStream out = null;
                try {
                    out = unit.getOutputStream();
                    if (out != null) {
                        tree = (Template)new BasicOptimizer(tree).optimize();
                        this.mParseTreeMap.put(name, tree);
                        CodeGenerator codegen = this.createCodeGenerator(unit);
                        codegen.writeTo(out);
                        out.flush();
                        out.close();
                    }
                }
                catch (Throwable e) {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable err) {
                            this.uncaughtException(err);
                        }
                    }
                    unit.resetOutputStream();
                    this.uncaughtException(e);
                    String msg3 = this.mFormatter.format("write.error", e.toString());
                    this.dispatchCompileError(new ErrorEvent((Object)this, msg3, (SourceInfo)null, unit));
                    Template template = tree;
                    this.removeErrorListener(unit);
                    if (!(tree == null || this.mPreserveTree != null && this.mPreserveTree.contains(name))) {
                        tree.setStatement(null);
                    }
                    return template;
                }
            }
            catch (Throwable e) {
                this.uncaughtException(e);
                msg = this.mFormatter.format("internal.error", e.toString());
                this.dispatchCompileError(new ErrorEvent((Object)this, (String)msg, (SourceInfo)null, unit));
            }
            finally {
                this.removeErrorListener(unit);
                if (!(tree == null || this.mPreserveTree != null && this.mPreserveTree.contains(name))) {
                    tree.setStatement(null);
                }
            }
        }
        return tree;
    }
}

