/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.compiler;

import java.util.EventObject;
import org.teatrove.tea.compiler.CompilationUnit;
import org.teatrove.tea.compiler.SourceInfo;
import org.teatrove.tea.compiler.Token;

public class ErrorEvent
extends EventObject {
    private static final long serialVersionUID = 1L;
    private String mErrorMsg;
    private Token mCulprit;
    private SourceInfo mInfo;
    private CompilationUnit mUnit;

    ErrorEvent(Object source, String errorMsg, Token culprit) {
        this(source, errorMsg, culprit, null);
    }

    ErrorEvent(Object source, String errorMsg, SourceInfo info) {
        this(source, errorMsg, info, null);
    }

    ErrorEvent(Object source, String errorMsg, Token culprit, CompilationUnit unit) {
        super(source);
        this.mErrorMsg = errorMsg;
        this.mCulprit = culprit;
        if (culprit != null) {
            this.mInfo = culprit.getSourceInfo();
        }
        this.mUnit = unit;
    }

    ErrorEvent(Object source, String errorMsg, SourceInfo info, CompilationUnit unit) {
        super(source);
        this.mErrorMsg = errorMsg;
        this.mInfo = info;
        this.mUnit = unit;
    }

    public String getErrorMessage() {
        return this.mErrorMsg;
    }

    public String getDetailedErrorMessage() {
        String prepend = this.getSourceInfoMessage();
        if (prepend == null || prepend.length() == 0) {
            return this.mErrorMsg;
        }
        return prepend + ": " + this.mErrorMsg;
    }

    public String getSourceInfoMessage() {
        String msg = this.mUnit == null ? (this.mInfo == null ? "" : String.valueOf(this.mInfo.getLine())) : (this.mInfo == null ? this.mUnit.getSourceFileName() : this.mUnit.getSourceFileName() + ':' + this.mInfo.getLine());
        return msg;
    }

    public SourceInfo getSourceInfo() {
        return this.mInfo;
    }

    public Token getCulpritToken() {
        return this.mCulprit;
    }

    public CompilationUnit getCompilationUnit() {
        return this.mUnit;
    }
}

