/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.compiler;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import org.teatrove.tea.compiler.Type;

public class Generics {
    private Generics() {
    }

    public static Type findType(Type type, Type ... parents) {
        if (parents == null || parents.length == 0) {
            return null;
        }
        java.lang.reflect.Type ttype = type.getGenericClass();
        if (!(ttype instanceof TypeVariable)) {
            return null;
        }
        TypeVariable tvar = (TypeVariable)ttype;
        for (java.lang.reflect.Type bounds : tvar.getBounds()) {
            if (!(bounds instanceof Class) || Object.class.equals((Object)bounds)) continue;
            return new Type((Class)bounds);
        }
        for (Type parent : parents) {
            TypeVariable<Class<?>>[] tvars = parent.getObjectClass().getTypeParameters();
            for (int i = 0; i < tvars.length; ++i) {
                ParameterizedType pptype;
                java.lang.reflect.Type[] ptypes;
                java.lang.reflect.Type ptype;
                if (!tvar.getName().equals(tvars[i].getName()) || !((ptype = parent.getGenericClass()) instanceof ParameterizedType) || i >= (ptypes = (pptype = (ParameterizedType)ptype).getActualTypeArguments()).length) continue;
                return Generics.getUnderlyingType(ptypes[i]);
            }
        }
        return null;
    }

    public static Class<?> getRawType(ParameterizedType type) {
        java.lang.reflect.Type rawtype = type.getRawType();
        if (rawtype instanceof Class) {
            return (Class)rawtype;
        }
        throw new IllegalStateException("ParameterizedType cannot have a non-Class based rawType: " + rawtype);
    }

    public static Type getBoundedType(TypeVariable<?> type) {
        if (type.getBounds().length == 0) {
            throw new IllegalStateException("TypeVariable has missing bounds information: " + type);
        }
        java.lang.reflect.Type ttype = type.getBounds()[0];
        return Generics.getUnderlyingType(ttype);
    }

    public static Type getBoundedType(WildcardType type) {
        if (type.getUpperBounds().length == 0) {
            throw new IllegalStateException("WildcardType has missing bounds information: " + type);
        }
        java.lang.reflect.Type ttype = type.getUpperBounds()[0];
        return Generics.getUnderlyingType(ttype);
    }

    public static Type getUnderlyingType(java.lang.reflect.Type ttype) {
        if (ttype instanceof Class) {
            return new Type((Class)ttype);
        }
        if (ttype instanceof TypeVariable) {
            return Generics.getBoundedType((TypeVariable)ttype);
        }
        if (ttype instanceof ParameterizedType) {
            Class<?> ptype = Generics.getRawType((ParameterizedType)ttype);
            return new Type(ptype, ttype);
        }
        if (ttype instanceof GenericArrayType) {
            Class<?> ctype = Generics.getComponentType((GenericArrayType)ttype);
            return new Type(ctype, ttype);
        }
        if (ttype instanceof WildcardType) {
            java.lang.reflect.Type[] ubounds = ((WildcardType)ttype).getUpperBounds();
            if (ubounds != null && ubounds.length > 0) {
                return Generics.getUnderlyingType(ubounds[0]);
            }
            java.lang.reflect.Type[] lbounds = ((WildcardType)ttype).getLowerBounds();
            if (lbounds != null && lbounds.length > 0) {
                return Generics.getUnderlyingType(lbounds[0]);
            }
        }
        throw new IllegalStateException("type has invalid bounds type: " + ttype);
    }

    public static Class<?> getComponentType(GenericArrayType type) {
        int levels = 0;
        java.lang.reflect.Type ctype = type;
        while (ctype instanceof GenericArrayType) {
            ++levels;
            ctype = ctype.getGenericComponentType();
        }
        if (ctype instanceof Class) {
            return Array.newInstance((Class)ctype, new int[levels]).getClass();
        }
        if (ctype instanceof ParameterizedType) {
            Class<?> rawtype = Generics.getRawType((ParameterizedType)ctype);
            return Array.newInstance(rawtype, new int[levels]).getClass();
        }
        if (ctype instanceof TypeVariable) {
            Type jtype = Generics.getBoundedType((TypeVariable)ctype);
            return Array.newInstance(jtype.getObjectClass(), new int[levels]).getClass();
        }
        throw new IllegalStateException("GenericArrayType has invalid component type: " + ctype);
    }

    public static Type getIterationType(Type type) {
        return Generics.getIterationType(type.getGenericClass());
    }

    public static Type getIterationType(java.lang.reflect.Type generic) {
        if (generic instanceof ParameterizedType) {
            java.lang.reflect.Type[] subtypes = ((ParameterizedType)generic).getActualTypeArguments();
            if (subtypes != null && subtypes.length >= 1) {
                java.lang.reflect.Type subtype = subtypes[0];
                if (subtype instanceof Class) {
                    return new Type((Class)subtype);
                }
                if (subtype instanceof ParameterizedType) {
                    return new Type(Generics.getRawType((ParameterizedType)subtype), subtype);
                }
                if (subtype instanceof TypeVariable) {
                    return Generics.getBoundedType((TypeVariable)subtype);
                }
                if (subtype instanceof WildcardType) {
                    return Generics.getBoundedType((WildcardType)subtype);
                }
                if (subtype instanceof GenericArrayType) {
                    Class<?> ctype = Generics.getComponentType((GenericArrayType)subtype);
                    return new Type(ctype, subtype);
                }
            }
        } else if (generic instanceof Class) {
            return Generics.getIterationType(((Class)generic).getGenericSuperclass());
        }
        return Type.OBJECT_TYPE;
    }

    public static Type getKeyType(Type type) {
        return Generics.getIterationType(type);
    }

    public static Type getKeyType(java.lang.reflect.Type generic) {
        return Generics.getIterationType(generic);
    }

    public static Type getValueType(Type type) {
        return Generics.getValueType(type.getGenericClass());
    }

    public static Type getValueType(java.lang.reflect.Type generic) {
        java.lang.reflect.Type[] subtypes;
        if (generic instanceof ParameterizedType && (subtypes = ((ParameterizedType)generic).getActualTypeArguments()) != null && subtypes.length >= 1) {
            java.lang.reflect.Type subtype = subtypes[1];
            if (subtype instanceof Class) {
                return new Type((Class)subtype);
            }
            if (subtype instanceof ParameterizedType) {
                return new Type(Generics.getRawType((ParameterizedType)subtype), subtype);
            }
            if (subtype instanceof TypeVariable) {
                return Generics.getBoundedType((TypeVariable)subtype);
            }
            if (subtype instanceof WildcardType) {
                return Generics.getBoundedType((WildcardType)subtype);
            }
            if (subtype instanceof GenericArrayType) {
                Class<?> ctype = Generics.getComponentType((GenericArrayType)subtype);
                return new Type(ctype, subtype);
            }
        }
        return Type.OBJECT_TYPE;
    }
}

