/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.compiler;

import java.beans.IntrospectionException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.teatrove.tea.compiler.CodeGenerator;
import org.teatrove.tea.compiler.CompilationUnit;
import org.teatrove.tea.compiler.Compiler;
import org.teatrove.tea.compiler.MethodMatcher;
import org.teatrove.tea.compiler.SourceInfo;
import org.teatrove.tea.compiler.Token;
import org.teatrove.tea.compiler.Type;
import org.teatrove.tea.parsetree.AndExpression;
import org.teatrove.tea.parsetree.ArithmeticExpression;
import org.teatrove.tea.parsetree.ArrayLookup;
import org.teatrove.tea.parsetree.AssignmentStatement;
import org.teatrove.tea.parsetree.Block;
import org.teatrove.tea.parsetree.BooleanLiteral;
import org.teatrove.tea.parsetree.BreakStatement;
import org.teatrove.tea.parsetree.CallExpression;
import org.teatrove.tea.parsetree.CompareExpression;
import org.teatrove.tea.parsetree.ConcatenateExpression;
import org.teatrove.tea.parsetree.ContinueStatement;
import org.teatrove.tea.parsetree.ExceptionGuardStatement;
import org.teatrove.tea.parsetree.Expression;
import org.teatrove.tea.parsetree.ExpressionList;
import org.teatrove.tea.parsetree.ExpressionStatement;
import org.teatrove.tea.parsetree.ForeachStatement;
import org.teatrove.tea.parsetree.FunctionCallExpression;
import org.teatrove.tea.parsetree.IfStatement;
import org.teatrove.tea.parsetree.ImportDirective;
import org.teatrove.tea.parsetree.Logical;
import org.teatrove.tea.parsetree.Lookup;
import org.teatrove.tea.parsetree.Name;
import org.teatrove.tea.parsetree.NegateExpression;
import org.teatrove.tea.parsetree.NewArrayExpression;
import org.teatrove.tea.parsetree.NoOpExpression;
import org.teatrove.tea.parsetree.Node;
import org.teatrove.tea.parsetree.NodeVisitor;
import org.teatrove.tea.parsetree.NotExpression;
import org.teatrove.tea.parsetree.NullLiteral;
import org.teatrove.tea.parsetree.NullSafe;
import org.teatrove.tea.parsetree.NumberLiteral;
import org.teatrove.tea.parsetree.OrExpression;
import org.teatrove.tea.parsetree.ParenExpression;
import org.teatrove.tea.parsetree.RelationalExpression;
import org.teatrove.tea.parsetree.ReturnStatement;
import org.teatrove.tea.parsetree.SpreadExpression;
import org.teatrove.tea.parsetree.Statement;
import org.teatrove.tea.parsetree.StatementList;
import org.teatrove.tea.parsetree.StringLiteral;
import org.teatrove.tea.parsetree.SubstitutionStatement;
import org.teatrove.tea.parsetree.Template;
import org.teatrove.tea.parsetree.TemplateCallExpression;
import org.teatrove.tea.parsetree.TernaryExpression;
import org.teatrove.tea.parsetree.TreeWalker;
import org.teatrove.tea.parsetree.TypeExpression;
import org.teatrove.tea.parsetree.TypeName;
import org.teatrove.tea.parsetree.Variable;
import org.teatrove.tea.parsetree.VariableRef;
import org.teatrove.tea.runtime.Context;
import org.teatrove.tea.runtime.Substitution;
import org.teatrove.tea.runtime.SubstitutionId;
import org.teatrove.tea.runtime.Truthful;
import org.teatrove.trove.classfile.ClassFile;
import org.teatrove.trove.classfile.CodeBuilder;
import org.teatrove.trove.classfile.Label;
import org.teatrove.trove.classfile.LocalVariable;
import org.teatrove.trove.classfile.Location;
import org.teatrove.trove.classfile.MethodInfo;
import org.teatrove.trove.classfile.Modifiers;
import org.teatrove.trove.classfile.TypeDesc;
import org.teatrove.trove.util.MergedClass;

public class JavaClassGenerator
extends CodeGenerator {
    public static final String EXECUTE_METHOD_NAME = "execute";
    public static final String PARAMETER_METHOD_NAME = "getTemplateParameterNames";
    private static final String CONTEXT_PARAM_NAME = "context";
    private static final String SUB_PARAM_NAME = "sub";
    private static final int LENGTH_ESTIMATE = 16;
    private static TypeDesc[] cObjectParam = new TypeDesc[]{TypeDesc.OBJECT};
    private static TypeDesc[] cStringParam = new TypeDesc[]{TypeDesc.STRING};
    private static TypeDesc[] cIntParam = new TypeDesc[]{TypeDesc.INT};
    private static TypeDesc cStringBuilderDesc = JavaClassGenerator.makeDesc(StringBuilder.class);
    private CompilationUnit mUnit;
    private LocalVariable mGlobalTime;
    private LocalVariable mSubTime;
    private int mTemporary;
    private int mSubBlockCount;
    private boolean mGenerateSubFormat;
    private List<String> mCallerToSubNoList = new ArrayList<String>();
    private Map<String, Variable> mFields = new HashMap<String, Variable>();
    private List<Object> mInitializerStatements = new ArrayList<Object>();

    private static TypeDesc makeDesc(String name) {
        return TypeDesc.forClass((String)name);
    }

    private static TypeDesc makeDesc(Class<?> clazz) {
        return TypeDesc.forClass(clazz);
    }

    private static TypeDesc makeDesc(Type type) {
        return JavaClassGenerator.makeDesc(type, true);
    }

    private static TypeDesc makeDesc(Type type, boolean natural) {
        if (natural) {
            return JavaClassGenerator.makeDesc(type.getNaturalClass());
        }
        return JavaClassGenerator.makeDesc(type.getObjectClass());
    }

    private static TypeDesc makeDesc(Variable v) {
        if (v.getType() != null) {
            return JavaClassGenerator.makeDesc(v.getType(), true);
        }
        if (v.getTypeName() != null) {
            return JavaClassGenerator.makeDesc(v.getTypeName().getName());
        }
        throw new IllegalStateException("missing type: " + v.getName());
    }

    public JavaClassGenerator(CompilationUnit unit) {
        super(unit.getParseTree());
        this.mUnit = unit;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        String className = this.mUnit.getName();
        String targetPackage = this.mUnit.getTargetPackage();
        if (targetPackage != null) {
            className = targetPackage + '.' + className;
        }
        ClassFile classFile = new ClassFile(className);
        classFile.getModifiers().setFinal(true);
        String sourceFile = this.mUnit.getSourceFileName();
        if (sourceFile != null) {
            classFile.setSourceFile(sourceFile);
        }
        Template t = this.getParseTree();
        t.accept(new TreeWalker(){

            @Override
            public Object visit(FunctionCallExpression node) {
                if (node.getSubstitutionParam() != null) {
                    JavaClassGenerator.this.mSubBlockCount++;
                    JavaClassGenerator.this.mGenerateSubFormat = true;
                }
                return super.visit(node);
            }

            @Override
            public Object visit(TemplateCallExpression node) {
                if (node.getSubstitutionParam() != null) {
                    JavaClassGenerator.this.mSubBlockCount++;
                    JavaClassGenerator.this.mGenerateSubFormat = true;
                }
                return super.visit(node);
            }

            @Override
            public Object visit(Variable node) {
                if (node.isField()) {
                    JavaClassGenerator.this.mGenerateSubFormat = true;
                }
                return super.visit(node);
            }
        });
        this.generateTemplate(t, className, classFile);
        classFile.writeTo(out);
        out.flush();
    }

    protected void generateTemplateParameters(Template t, ClassFile classFile) {
        Variable[] params = t.getParams();
        int paramCount = params.length;
        Modifiers pubstat = new Modifiers();
        pubstat.setPublic(true);
        pubstat.setStatic(true);
        TypeDesc stringArrayDesc = TypeDesc.STRING.toArrayType();
        MethodInfo mi = classFile.addMethod(pubstat, PARAMETER_METHOD_NAME, stringArrayDesc, new TypeDesc[0]);
        CodeBuilder builder = new CodeBuilder(mi);
        builder.loadConstant(paramCount);
        builder.newObject(stringArrayDesc);
        for (int i = 0; i < paramCount; ++i) {
            builder.dup();
            builder.loadConstant(i);
            builder.loadConstant(params[i].getName());
            builder.storeToArray(TypeDesc.STRING);
        }
        builder.returnValue(TypeDesc.OBJECT);
    }

    protected void generateTemplate(Template t, String className, ClassFile classFile) {
        Type type;
        Variable[] allParams;
        Method subDetachMethod;
        Method subIdMethod;
        Method subContextMethod;
        Method subMethod;
        Class<Substitution> subClass;
        if (this.mGenerateSubFormat) {
            subClass = Substitution.class;
            classFile.addInterface(subClass);
            classFile.addInterface(Cloneable.class);
            classFile.addInterface(Serializable.class);
            try {
                subMethod = subClass.getMethod("substitute", new Class[0]);
                subContextMethod = subClass.getMethod("substitute", Context.class);
                subIdMethod = subClass.getMethod("getIdentifier", new Class[0]);
                subDetachMethod = subClass.getMethod("detach", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new InternalError(e.toString());
            }
        } else {
            subClass = null;
            subMethod = null;
            subContextMethod = null;
            subIdMethod = null;
            subDetachMethod = null;
        }
        Variable[] params = t.getParams();
        int paramCount = params.length;
        this.generateTemplateParameters(t, classFile);
        Modifiers pubstat = new Modifiers();
        pubstat.setPublic(true);
        pubstat.setStatic(true);
        if (t.hasSubstitutionParam()) {
            Variable subParam;
            allParams = new Variable[paramCount + 2];
            type = new Type(Substitution.class);
            allParams[paramCount + 1] = subParam = new Variable(null, SUB_PARAM_NAME, type);
        } else {
            allParams = new Variable[paramCount + 1];
        }
        type = new Type(this.mUnit.getCompiler().getRuntimeContext());
        allParams[0] = new Variable(null, CONTEXT_PARAM_NAME, type);
        allParams[0].setTransient(true);
        for (int i = 0; i < paramCount; ++i) {
            allParams[i + 1] = params[i];
        }
        TypeDesc[] paramTypes = new TypeDesc[allParams.length];
        for (int i = 0; i < allParams.length; ++i) {
            if (this.mGenerateSubFormat) {
                allParams[i].setField(true);
            }
            paramTypes[i] = JavaClassGenerator.makeDesc(allParams[i]);
        }
        Type returnType = t.getReturnType();
        TypeDesc returnTypeDesc = returnType == null ? null : JavaClassGenerator.makeDesc(returnType);
        MethodInfo mi = classFile.addMethod(pubstat, EXECUTE_METHOD_NAME, returnTypeDesc, paramTypes);
        mi.addException("java.lang.Exception");
        CodeBuilder builder = new CodeBuilder(mi);
        LocalVariable[] localVars = builder.getParameters();
        for (int i = 0; i < localVars.length; ++i) {
            localVars[i].setName(allParams[i].getName());
        }
        TypeDesc methodObserverType = JavaClassGenerator.makeDesc(MergedClass.InvocationEventObserver.class);
        boolean profilingEnabled = this.isProfilingEnabled();
        if (profilingEnabled) {
            this.mGlobalTime = builder.createLocalVariable("startTime", JavaClassGenerator.makeDesc(Long.TYPE));
            builder.invokeStatic(this.mUnit.getRuntimeContext().getName(), "getInvocationObserver", methodObserverType, new TypeDesc[0]);
            builder.invokeInterface(methodObserverType.getFullName(), "currentTime", TypeDesc.forClass(Long.TYPE), new TypeDesc[0]);
            builder.storeLocal(this.mGlobalTime);
        }
        if (!this.mGenerateSubFormat) {
            Visitor gen = new Visitor(allParams, builder.getParameters());
            gen.allowInitializerStatements();
            gen.generateNormalFormat(builder, t);
        } else {
            boolean doReturnValue = !Type.VOID_TYPE.equals(returnType);
            TypeDesc thisType = JavaClassGenerator.makeDesc(className);
            builder.newObject(thisType);
            builder.dup();
            for (int i = 0; i < localVars.length; ++i) {
                builder.loadLocal(localVars[i]);
            }
            builder.invokeConstructor(paramTypes);
            if (doReturnValue) {
                builder.dup();
            }
            builder.invoke(subMethod);
            Visitor gen = new Visitor(allParams);
            gen.allowInitializerStatements();
            mi = classFile.addMethod(subMethod);
            CodeBuilder subBuilder = new CodeBuilder(mi);
            gen.generateContext(subBuilder);
            Label gotContext = subBuilder.createLabel();
            subBuilder.ifNullBranch((Location)gotContext, false);
            String unSupExName = UnsupportedOperationException.class.getName();
            subBuilder.newObject(JavaClassGenerator.makeDesc(unSupExName));
            subBuilder.dup();
            subBuilder.invokeConstructor(unSupExName, new TypeDesc[0]);
            subBuilder.throwObject();
            gotContext.setLocation();
            subBuilder.loadThis();
            gen.generateContext(subBuilder);
            subBuilder.invoke(subContextMethod);
            subBuilder.returnVoid();
            mi = classFile.addMethod(subContextMethod);
            subBuilder = new CodeBuilder(mi);
            String[] subFieldNames = gen.generateSubFormat(subBuilder, t);
            if (profilingEnabled) {
                builder.invokeStatic(this.mUnit.getRuntimeContext().getName(), "getInvocationObserver", methodObserverType, new TypeDesc[0]);
                builder.loadConstant(this.mUnit.getName());
                builder.loadConstant(null);
                builder.invokeStatic(this.mUnit.getRuntimeContext().getName(), "getInvocationObserver", methodObserverType, new TypeDesc[0]);
                builder.invokeInterface(methodObserverType.getFullName(), "currentTime", JavaClassGenerator.makeDesc(Long.TYPE), new TypeDesc[0]);
                builder.loadLocal(this.mGlobalTime);
                builder.math((byte)101);
                builder.invokeInterface(methodObserverType.getFullName(), "invokedEvent", null, new TypeDesc[]{JavaClassGenerator.makeDesc(String.class), JavaClassGenerator.makeDesc(String.class), JavaClassGenerator.makeDesc(Long.TYPE)});
            }
            if (doReturnValue) {
                builder.loadField(subFieldNames[1], returnTypeDesc);
                builder.returnValue(JavaClassGenerator.makeDesc(returnType.getNaturalClass()));
            } else {
                builder.returnVoid();
            }
            mi = classFile.addMethod(subIdMethod);
            subBuilder = new CodeBuilder(mi);
            TypeDesc td = JavaClassGenerator.makeDesc(SubstitutionId.class);
            subBuilder.newObject(td);
            subBuilder.dup();
            subBuilder.loadThis();
            subBuilder.loadThis();
            subBuilder.loadField(subFieldNames[0], TypeDesc.INT);
            subBuilder.invokeConstructor(td.getRootName(), new TypeDesc[]{TypeDesc.OBJECT, TypeDesc.INT});
            subBuilder.returnValue(td);
            mi = classFile.addMethod(subDetachMethod);
            subBuilder = new CodeBuilder(mi);
            subBuilder.loadThis();
            subBuilder.invokeVirtual("clone", TypeDesc.OBJECT, new TypeDesc[0]);
            subBuilder.checkCast(thisType);
            LocalVariable sub = subBuilder.createLocalVariable(null, thisType);
            subBuilder.storeLocal(sub);
            subBuilder.loadLocal(sub);
            subBuilder.loadConstant(null);
            subBuilder.storeField(gen.mContextParam.getVariable().getName(), paramTypes[0]);
            if (t.hasSubstitutionParam()) {
                subBuilder.loadLocal(sub);
                subBuilder.loadLocal(sub);
                String subFieldName = gen.mSubParam.getVariable().getName();
                TypeDesc subType = JavaClassGenerator.makeDesc(subClass);
                subBuilder.loadField(subFieldName, subType);
                subBuilder.invoke(subDetachMethod);
                subBuilder.storeField(subFieldName, subType);
            }
            subBuilder.loadLocal(sub);
            subBuilder.returnValue(TypeDesc.OBJECT);
        }
        Modifiers pvt = new Modifiers();
        pvt.setPrivate(true);
        mi = this.mGenerateSubFormat ? classFile.addConstructor(pvt, paramTypes) : classFile.addConstructor(pvt, new TypeDesc[0]);
        builder = new CodeBuilder(mi);
        builder.loadThis();
        builder.invokeSuperConstructor(new TypeDesc[0]);
        if (this.mGenerateSubFormat) {
            localVars = builder.getParameters();
            for (int i = 0; i < localVars.length; ++i) {
                builder.loadThis();
                builder.loadLocal(localVars[i]);
                builder.storeField(allParams[i].getName(), paramTypes[i]);
            }
        }
        builder.returnVoid();
        if (this.mInitializerStatements.size() > 0) {
            mi = classFile.addInitializer();
            builder = new CodeBuilder(mi);
            Visitor gen = new Visitor(new Variable[0]);
            for (int i = 0; i < this.mInitializerStatements.size(); ++i) {
                Statement stmt = (Statement)this.mInitializerStatements.get(i);
                gen.generateNormalFormat(builder, stmt);
            }
            builder.returnVoid();
        }
        Iterator<Variable> it = this.mFields.values().iterator();
        Modifiers flags = new Modifiers();
        flags.setPrivate(true);
        while (it.hasNext()) {
            Variable v = it.next();
            flags.setStatic(v.isStatic());
            flags.setTransient(v.isTransient());
            TypeDesc td = JavaClassGenerator.makeDesc(v);
            classFile.addField(flags, v.getName(), td).markSynthetic();
        }
    }

    private boolean isProfilingEnabled() {
        Class<?> mergedClass = this.mUnit.getRuntimeContext();
        boolean profilingEnabled = true;
        try {
            Method a = mergedClass.getDeclaredMethod("getObserverMode", new Class[0]);
            int observerMode = (Integer)a.invoke(null, new Object[0]);
            profilingEnabled = (observerMode & 1) != 0 && (observerMode & 4) != 0;
        }
        catch (Exception ex) {
            profilingEnabled = false;
        }
        return profilingEnabled;
    }

    private static interface NullSafeCallback {
        public Type execute();
    }

    private static class BreakAndContinueLabels {
        Label mBreakLabel = null;
        Label mContinueLabel = null;

        public BreakAndContinueLabels(Label breakLabel) {
            this.mBreakLabel = breakLabel;
        }

        public Label getBreakLabel() {
            return this.mBreakLabel;
        }

        public void setContinueLabel(Label continueLabel) {
            this.mContinueLabel = continueLabel;
        }

        public Label getContinueLabel() {
            return this.mContinueLabel;
        }
    }

    private static class DetailException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private Exception mException;

        public DetailException(Exception e, String detail) {
            super(e.getMessage() + ' ' + detail);
            this.mException = e;
        }

        @Override
        public String toString() {
            return this.mException.getClass().getName() + ": " + this.getMessage();
        }

        @Override
        public void printStackTrace() {
            this.mException.printStackTrace();
        }

        @Override
        public void printStackTrace(PrintStream ps) {
            this.mException.printStackTrace(ps);
        }

        @Override
        public void printStackTrace(PrintWriter pw) {
            this.mException.printStackTrace(pw);
        }
    }

    private static class GuardHandler {
        final Label tryStart;
        final Label tryEnd;
        final Statement replacement;

        public GuardHandler(Label tryStart, Label tryEnd, Statement replacement) {
            this.tryStart = tryStart;
            this.tryEnd = tryEnd;
            this.replacement = replacement;
        }
    }

    private class Visitor
    implements NodeVisitor {
        private CodeBuilder mBuilder;
        private int mLastLine = -1;
        private Map<Variable, LocalVariable> mVariableMap = new HashMap<Variable, LocalVariable>();
        private boolean mAllowInitializerStatements;
        private VariableRef mContextParam;
        private VariableRef mSubParam;
        private VariableRef mBlockId;
        private VariableRef mReturnValue;
        private LocalVariable mStartTime;
        private List<Object> mBreakInfoStack = new ArrayList<Object>();
        private List<Node> mCaseNodes;
        private List<GuardHandler> mExceptionGuardHandlers;

        public Visitor(Variable[] params) {
            this(params, null);
        }

        public Visitor(Variable[] params, LocalVariable[] localVars) {
            for (int i = 0; i < params.length; ++i) {
                Variable param = params[i];
                if (param.isField()) {
                    this.declareVariable(param);
                    continue;
                }
                this.declareVariable(param, localVars[i]);
            }
        }

        public void allowInitializerStatements() {
            this.mAllowInitializerStatements = true;
        }

        public void generateNormalFormat(CodeBuilder builder, Node node) {
            this.mBuilder = builder;
            this.generate(node);
            this.generateExceptionHandlers();
        }

        public String[] generateSubFormat(CodeBuilder builder, Template node) {
            int newSize;
            this.mBuilder = builder;
            final LocalVariable param = builder.getParameters()[0];
            Variable contextVar = this.mContextParam.getVariable();
            Variable newLocalContext = new Variable(null, contextVar.getName(), contextVar.getType());
            this.declareVariable(newLocalContext, param);
            this.mBuilder.loadLocal(param);
            this.mBuilder.checkCast(JavaClassGenerator.makeDesc(contextVar));
            this.mBuilder.storeLocal(param);
            this.storeToVariable(contextVar, new Runnable(){

                @Override
                public void run() {
                    Visitor.this.mBuilder.loadLocal(param);
                }
            });
            contextVar.setField(false);
            Type returnType = node.getReturnType();
            if (!Type.VOID_TYPE.equals(returnType)) {
                Variable returnValue = new Variable(null, "returnValue", returnType);
                returnValue.setField(true);
                this.declareVariable(returnValue);
                this.mReturnValue = new VariableRef(null, returnValue.getName());
                this.mReturnValue.setVariable(returnValue);
            }
            Type blockIdType = Type.INT_TYPE;
            Variable blockId = new Variable(null, "blockId", blockIdType);
            blockId.setField(true);
            this.declareVariable(blockId);
            this.mBlockId = new VariableRef(null, blockId.getName());
            this.mBlockId.setVariable(blockId);
            this.mBuilder.loadThis();
            this.mBuilder.loadField(blockId.getName(), TypeDesc.INT);
            int[] cases = new int[JavaClassGenerator.this.mSubBlockCount + 1];
            Label[] switchLabels = new Label[JavaClassGenerator.this.mSubBlockCount + 1];
            this.mCaseNodes = new ArrayList<Node>(JavaClassGenerator.this.mSubBlockCount + 1);
            for (int i = 0; i <= JavaClassGenerator.this.mSubBlockCount; ++i) {
                cases[i] = i;
                switchLabels[i] = this.mBuilder.createLabel();
            }
            Label defaultLabel = this.mBuilder.createLabel();
            this.mBuilder.switchBranch(cases, (Location[])switchLabels, (Location)defaultLabel);
            int size = 0;
            this.mCaseNodes.add(node);
            while ((newSize = this.mCaseNodes.size()) > size) {
                while (size < newSize) {
                    if (size > 0) {
                        this.mBuilder.returnVoid();
                    }
                    switchLabels[size].setLocation();
                    TypeDesc methodObserverType = TypeDesc.forClass(MergedClass.InvocationEventObserver.class);
                    boolean profilingEnabled = JavaClassGenerator.this.isProfilingEnabled();
                    LocalVariable startTime = this.mBuilder.createLocalVariable("blockTime", TypeDesc.forClass(Long.TYPE));
                    if (profilingEnabled && size > 0) {
                        this.mBuilder.invokeStatic(this.mContextParam.getVariable().getType().getObjectClass().getName(), "getInvocationObserver", methodObserverType, new TypeDesc[0]);
                        this.mBuilder.invokeInterface(methodObserverType.getFullName(), "currentTime", TypeDesc.forClass(Long.TYPE), new TypeDesc[0]);
                        this.mBuilder.storeLocal(startTime);
                    }
                    this.generate(this.mCaseNodes.get(size));
                    if (profilingEnabled && size > 0) {
                        this.mBuilder.invokeStatic(this.mContextParam.getVariable().getType().getObjectClass().getName(), "getInvocationObserver", methodObserverType, new TypeDesc[0]);
                        this.mBuilder.loadConstant(JavaClassGenerator.this.mUnit.getName());
                        this.mBuilder.loadConstant((String)JavaClassGenerator.this.mCallerToSubNoList.get(size - 1));
                        this.mBuilder.invokeStatic(this.mContextParam.getVariable().getType().getObjectClass().getName(), "getInvocationObserver", methodObserverType, new TypeDesc[0]);
                        this.mBuilder.invokeInterface(methodObserverType.getFullName(), "currentTime", TypeDesc.forClass(Long.TYPE), new TypeDesc[0]);
                        this.mBuilder.loadLocal(startTime);
                        this.mBuilder.math((byte)101);
                        this.mBuilder.invokeInterface(methodObserverType.getFullName(), "invokedEvent", null, new TypeDesc[]{TypeDesc.forClass(String.class), TypeDesc.forClass(String.class), TypeDesc.forClass(Long.TYPE)});
                    }
                    ++size;
                }
            }
            defaultLabel.setLocation();
            this.mBuilder.returnVoid();
            this.generateExceptionHandlers();
            return new String[]{this.mBlockId.getName(), this.mReturnValue != null ? this.mReturnValue.getName() : null};
        }

        public void generateContext(CodeBuilder builder) {
            this.mBuilder = builder;
            if (this.mContextParam == null) {
                throw new NullPointerException("Context parameter is null");
            }
            this.generate(this.mContextParam);
        }

        private void generate(Node node) {
            try {
                this.setLineNumber(node.getSourceInfo());
                if (!(node instanceof Expression)) {
                    node.accept(this);
                    return;
                }
                Expression expr = (Expression)node;
                LinkedList<Expression.Conversion> conversions = expr.getConversionChain();
                ListIterator it = conversions.listIterator(conversions.size());
                while (it.hasPrevious()) {
                    this.typeConvertBegin((Expression.Conversion)it.previous());
                }
                expr.accept(this);
                while (it.hasNext()) {
                    this.typeConvertEnd((Expression.Conversion)it.next());
                }
            }
            catch (DetailException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new DetailException(e, "(near line " + this.mLastLine + ')');
            }
        }

        private void generateExceptionHandlers() {
            if (this.mExceptionGuardHandlers == null) {
                return;
            }
            int size = this.mExceptionGuardHandlers.size();
            if (size == 0) {
                return;
            }
            Label dumpException = this.mBuilder.createLabel();
            for (int i = 0; i < size; ++i) {
                GuardHandler gh = this.mExceptionGuardHandlers.get(i);
                this.mBuilder.exceptionHandler((Location)gh.tryStart, (Location)gh.tryEnd, "java.lang.RuntimeException");
                this.mBuilder.jsr((Location)dumpException);
                if (gh.replacement != null) {
                    this.generate(gh.replacement);
                }
                this.mBuilder.branch((Location)gh.tryEnd);
            }
            dumpException.setLocation();
            TypeDesc throwableDesc = JavaClassGenerator.makeDesc(Throwable.class);
            TypeDesc threadDesc = JavaClassGenerator.makeDesc(Thread.class);
            TypeDesc threadGroupDesc = JavaClassGenerator.makeDesc(ThreadGroup.class);
            LocalVariable exception = this.mBuilder.createLocalVariable("e", throwableDesc);
            LocalVariable retAddr = this.mBuilder.createLocalVariable("addr", TypeDesc.OBJECT);
            LocalVariable thread = this.mBuilder.createLocalVariable("t", threadDesc);
            this.mBuilder.storeLocal(retAddr);
            this.mBuilder.storeLocal(exception);
            this.mBuilder.invokeStatic("java.lang.Thread", "currentThread", threadDesc, new TypeDesc[0]);
            this.mBuilder.storeLocal(thread);
            this.mBuilder.loadLocal(thread);
            this.mBuilder.invokeVirtual("java.lang.Thread", "getThreadGroup", threadGroupDesc, new TypeDesc[0]);
            this.mBuilder.loadLocal(thread);
            this.mBuilder.loadLocal(exception);
            this.mBuilder.invokeVirtual("java.lang.ThreadGroup", "uncaughtException", null, new TypeDesc[]{threadDesc, throwableDesc});
            this.mBuilder.ret(retAddr);
        }

        @Override
        public Object visit(Template node) {
            Statement stmt = node.getStatement();
            if (stmt != null) {
                this.generate(stmt);
            }
            return null;
        }

        @Override
        public Object visit(Name node) {
            return null;
        }

        @Override
        public Object visit(TypeName node) {
            return null;
        }

        @Override
        public Object visit(Variable node) {
            this.declareVariable(node);
            return null;
        }

        @Override
        public Object visit(ExpressionList node) {
            return null;
        }

        @Override
        public Object visit(Statement node) {
            return null;
        }

        @Override
        public Object visit(ImportDirective node) {
            return null;
        }

        @Override
        public Object visit(StatementList node) {
            Statement[] list = node.getStatements();
            if (list == null) {
                return null;
            }
            for (int i = 0; i < list.length; ++i) {
                this.generate(list[i]);
            }
            return null;
        }

        @Override
        public Object visit(Block node) {
            Statement fin;
            Statement init = node.getInitializer();
            if (init != null) {
                this.generate(init);
            }
            if ((fin = node.getFinalizer()) != null) {
                this.mBreakInfoStack.add(fin);
            }
            this.visit((StatementList)node);
            if (fin != null) {
                this.generate(fin);
                this.mBreakInfoStack.remove(this.mBreakInfoStack.size() - 1);
            }
            return null;
        }

        @Override
        public Object visit(AssignmentStatement node) {
            ArithmeticExpression arith;
            int ID;
            VariableRef lvalue = node.getLValue();
            Type ltype = lvalue.getType();
            Variable v = lvalue.getVariable();
            LocalVariable local = this.getLocalVariable(v);
            final Expression rvalue = node.getRValue();
            Type rtype = rvalue.getType();
            if (local != null && ltype.getNaturalClass() == Integer.TYPE && rtype.getNaturalClass() == Integer.TYPE && rvalue instanceof ArithmeticExpression && ((ID = (arith = (ArithmeticExpression)rvalue).getOperator().getID()) == 29 || ID == 30)) {
                Expression left = arith.getLeftExpression();
                Expression right = arith.getRightExpression();
                Integer amount = null;
                if (left instanceof VariableRef && right.isValueKnown()) {
                    if (((VariableRef)left).getVariable() == v) {
                        amount = (Integer)right.getValue();
                    }
                } else if (right instanceof VariableRef && left.isValueKnown() && ID != 30 && ((VariableRef)right).getVariable() == v) {
                    amount = (Integer)left.getValue();
                }
                if (amount != null) {
                    int i = amount;
                    if (ID == 29) {
                        this.mBuilder.integerIncrement(local, i);
                    } else {
                        this.mBuilder.integerIncrement(local, -i);
                    }
                    return null;
                }
            }
            this.storeToVariable(v, new Runnable(){

                @Override
                public void run() {
                    Visitor.this.generate(rvalue);
                }
            });
            return null;
        }

        @Override
        public Object visit(ForeachStatement node) {
            Label breakLoc = this.mBuilder.createLabel();
            this.mBreakInfoStack.add(new BreakAndContinueLabels(breakLoc));
            if (node.getEndRange() == null) {
                if (node.getRange().getType().getObjectClass().isArray()) {
                    this.generateForeachArray(node);
                } else {
                    this.generateForeachIterator(node);
                }
            } else {
                this.generateForeachRange(node);
            }
            this.mBreakInfoStack.remove(this.mBreakInfoStack.size() - 1);
            breakLoc.setLocation();
            return null;
        }

        @Override
        public Object visit(BreakStatement node) {
            int i = this.mBreakInfoStack.size();
            while (--i >= 0) {
                Object obj = this.mBreakInfoStack.get(i);
                if (obj instanceof BreakAndContinueLabels) {
                    this.mBuilder.branch((Location)((BreakAndContinueLabels)obj).getBreakLabel());
                    break;
                }
                if (!(obj instanceof Statement)) continue;
                this.generate((Statement)obj);
            }
            return null;
        }

        @Override
        public Object visit(ContinueStatement node) {
            int i = this.mBreakInfoStack.size();
            while (--i >= 0) {
                Object obj = this.mBreakInfoStack.get(i);
                if (obj instanceof BreakAndContinueLabels) {
                    this.mBuilder.branch((Location)((BreakAndContinueLabels)obj).getContinueLabel());
                    break;
                }
                if (!(obj instanceof Statement)) continue;
                this.generate((Statement)obj);
            }
            return null;
        }

        @Override
        public Object visit(IfStatement node) {
            Block thenPart = node.getThenPart();
            Block elsePart = node.getElsePart();
            Label elseLabel = this.mBuilder.createLabel();
            Label endLabel = this.mBuilder.createLabel();
            if (thenPart == null) {
                this.generateBranch(node.getCondition(), endLabel, true);
            } else {
                this.generateBranch(node.getCondition(), elseLabel, false);
            }
            if (thenPart != null) {
                this.generate(thenPart);
                if (elsePart != null) {
                    this.mBuilder.branch((Location)endLabel);
                }
            }
            elseLabel.setLocation();
            if (elsePart != null) {
                this.generate(elsePart);
            }
            endLabel.setLocation();
            return null;
        }

        @Override
        public Object visit(SubstitutionStatement node) {
            Method subMethod;
            TypeDesc methodObserverType = TypeDesc.forClass(MergedClass.InvocationEventObserver.class);
            boolean profilingEnabled = JavaClassGenerator.this.isProfilingEnabled();
            if (profilingEnabled) {
                if (JavaClassGenerator.this.mSubTime == null) {
                    JavaClassGenerator.this.mSubTime = this.mBuilder.createLocalVariable("subTime", TypeDesc.forClass(Long.TYPE));
                }
                this.mBuilder.invokeStatic(this.mContextParam.getVariable().getType().getObjectClass().getName(), "getInvocationObserver", methodObserverType, new TypeDesc[0]);
                this.mBuilder.invokeInterface(methodObserverType.getFullName(), "currentTime", TypeDesc.forClass(Long.TYPE), new TypeDesc[0]);
                this.mBuilder.storeLocal(JavaClassGenerator.this.mSubTime);
            }
            Class<Substitution> subClass = Substitution.class;
            try {
                subMethod = subClass.getMethod("substitute", Context.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e.toString());
            }
            this.generate(this.mSubParam);
            this.generateContext();
            this.mBuilder.invoke(subMethod);
            if (profilingEnabled) {
                this.mBuilder.invokeStatic(this.mContextParam.getVariable().getType().getObjectClass().getName(), "getInvocationObserver", methodObserverType, new TypeDesc[0]);
                this.mBuilder.loadConstant(JavaClassGenerator.this.mUnit.getName());
                this.mBuilder.loadConstant("__substitution");
                this.mBuilder.invokeStatic(this.mContextParam.getVariable().getType().getObjectClass().getName(), "getInvocationObserver", methodObserverType, new TypeDesc[0]);
                this.mBuilder.invokeInterface(methodObserverType.getFullName(), "currentTime", TypeDesc.forClass(Long.TYPE), new TypeDesc[0]);
                this.mBuilder.loadLocal(JavaClassGenerator.this.mSubTime);
                this.mBuilder.math((byte)101);
                this.mBuilder.invokeInterface(methodObserverType.getFullName(), "invokedEvent", null, new TypeDesc[]{TypeDesc.forClass(String.class), TypeDesc.forClass(String.class), TypeDesc.forClass(Long.TYPE)});
            }
            return null;
        }

        @Override
        public Object visit(ExpressionStatement node) {
            Method receiver = node.getReceiverMethod();
            if (receiver != null && !Modifier.isStatic(receiver.getModifiers())) {
                this.generateContext();
            }
            this.generate(node.getExpression());
            if (receiver != null) {
                this.mBuilder.invoke(receiver);
                Class<?> retType = receiver.getReturnType();
                if (retType != null && retType != Void.TYPE) {
                    if (JavaClassGenerator.makeDesc(retType).isDoubleWord()) {
                        this.mBuilder.pop2();
                    } else {
                        this.mBuilder.pop();
                    }
                }
            }
            return null;
        }

        @Override
        public Object visit(ReturnStatement node) {
            Expression expr = node.getExpression();
            boolean profilingEnabled = JavaClassGenerator.this.isProfilingEnabled();
            if (this.mCaseNodes != null) {
                if (expr != null) {
                    Type type = expr.getType();
                    if (!Type.VOID_TYPE.equals(type)) {
                        this.mBuilder.loadThis();
                        this.generate(node.getExpression());
                        TypeDesc td = JavaClassGenerator.makeDesc(this.mReturnValue.getType());
                        this.mBuilder.storeField(this.mReturnValue.getName(), td);
                    } else {
                        this.generate(node.getExpression());
                    }
                }
            } else if (expr != null) {
                this.generate(node.getExpression());
                if (profilingEnabled) {
                    this.generateGlobalProfilingEnd();
                }
                this.mBuilder.returnValue(JavaClassGenerator.makeDesc(expr.getType()));
            } else {
                if (profilingEnabled) {
                    this.generateGlobalProfilingEnd();
                }
                this.mBuilder.returnVoid();
            }
            return null;
        }

        private void generateGlobalProfilingEnd() {
            TypeDesc methodObserverType = JavaClassGenerator.makeDesc(MergedClass.InvocationEventObserver.class);
            this.mBuilder.invokeStatic(JavaClassGenerator.this.mUnit.getRuntimeContext().getName(), "getInvocationObserver", methodObserverType, new TypeDesc[0]);
            this.mBuilder.loadConstant(JavaClassGenerator.this.mUnit.getName());
            this.mBuilder.loadConstant(null);
            this.mBuilder.invokeStatic(JavaClassGenerator.this.mUnit.getRuntimeContext().getName(), "getInvocationObserver", methodObserverType, new TypeDesc[0]);
            this.mBuilder.invokeInterface(methodObserverType.getFullName(), "currentTime", JavaClassGenerator.makeDesc(Long.TYPE), new TypeDesc[0]);
            this.mBuilder.loadLocal(JavaClassGenerator.this.mGlobalTime);
            this.mBuilder.math((byte)101);
            this.mBuilder.invokeInterface(methodObserverType.getFullName(), "invokedEvent", null, new TypeDesc[]{JavaClassGenerator.makeDesc(String.class), JavaClassGenerator.makeDesc(String.class), JavaClassGenerator.makeDesc(Long.TYPE)});
        }

        @Override
        public Object visit(ExceptionGuardStatement node) {
            Statement guarded = node.getGuarded();
            if (guarded == null) {
                return null;
            }
            Statement replacement = node.getReplacement();
            if (guarded.isReturn() && (replacement == null || !replacement.isReturn())) {
                this.generate(guarded);
                return null;
            }
            Label tryStart = this.mBuilder.createLabel().setLocation();
            this.generate(guarded);
            Label tryEnd = this.mBuilder.createLabel().setLocation();
            if (this.mExceptionGuardHandlers == null) {
                this.mExceptionGuardHandlers = new ArrayList<GuardHandler>();
            }
            this.mExceptionGuardHandlers.add(new GuardHandler(tryStart, tryEnd, replacement));
            return null;
        }

        @Override
        public Object visit(Expression node) {
            return null;
        }

        @Override
        public Object visit(ParenExpression node) {
            this.generate(node.getExpression());
            return null;
        }

        @Override
        public Object visit(NewArrayExpression node) {
            ExpressionList list = node.getExpressionList();
            Expression[] exprs = list.getExpressions();
            Type initialType = node.getInitialType();
            Class<?> initialClass = initialType.getObjectClass();
            if (this.mAllowInitializerStatements && node.isAllConstant()) {
                SourceInfo info = node.getSourceInfo();
                Variable var = new Variable(info, "array", initialType);
                var.setStatic(true);
                this.generate(var);
                VariableRef ref = new VariableRef(info, "array");
                ref.setVariable(var);
                Expression clonedNode = (Expression)node.clone();
                clonedNode.setType(initialType);
                AssignmentStatement assn = new AssignmentStatement(info, ref, clonedNode);
                JavaClassGenerator.this.mInitializerStatements.add(assn);
                TypeDesc td = JavaClassGenerator.makeDesc(initialClass);
                this.mBuilder.loadStaticField(var.getName(), td);
            } else if (node.isAssociative()) {
                Method putMethod;
                TypeDesc td = JavaClassGenerator.makeDesc(LinkedHashMap.class);
                this.mBuilder.newObject(td);
                this.mBuilder.dup();
                int capacity = exprs.length;
                if (capacity != 0) {
                    if (capacity == 2) {
                        capacity = 1;
                    } else {
                        BigInteger cap = BigInteger.valueOf(capacity + 1);
                        while (!cap.isProbablePrime(100)) {
                            cap = cap.add(BigInteger.valueOf(2L));
                        }
                        capacity = cap.intValue();
                    }
                }
                this.mBuilder.loadConstant(capacity);
                this.mBuilder.invokeConstructor(LinkedHashMap.class.getName(), cIntParam);
                try {
                    putMethod = LinkedHashMap.class.getMethod("put", Object.class, Object.class);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(e.toString());
                }
                boolean doPop = putMethod.getReturnType() != Void.TYPE;
                for (int i = 0; i < exprs.length; i += 2) {
                    this.mBuilder.dup();
                    this.generate(exprs[i]);
                    this.generate(exprs[i + 1]);
                    this.mBuilder.invoke(putMethod);
                    if (!doPop) continue;
                    this.mBuilder.pop();
                }
                if (node.isAllConstant()) {
                    try {
                        Method unmodifiable = Collections.class.getMethod("unmodifiableMap", Map.class);
                        this.mBuilder.invoke(unmodifiable);
                    }
                    catch (NoSuchMethodException e) {}
                }
            } else {
                Class<?> componentClass = initialClass.getComponentType();
                TypeDesc componentType = JavaClassGenerator.makeDesc(componentClass);
                this.mBuilder.loadConstant(exprs.length);
                this.mBuilder.newObject(componentType.toArrayType());
                for (int i = 0; i < exprs.length; ++i) {
                    Expression expr = exprs[i];
                    if (expr.isValueKnown()) {
                        Object value = expr.getValue();
                        Type type = expr.getType();
                        if (!type.isPrimitive() ? value == null : (value instanceof Number ? ((Number)value).doubleValue() == 0.0 : value instanceof Boolean && (Boolean)value == false)) continue;
                    }
                    this.mBuilder.dup();
                    this.mBuilder.loadConstant(i);
                    this.generate(expr);
                    this.mBuilder.storeToArray(componentType);
                }
            }
            return null;
        }

        @Override
        public Object visit(FunctionCallExpression node) {
            this.generateCallExpression(node);
            return null;
        }

        @Override
        public Object visit(TemplateCallExpression node) {
            this.generateCallExpression(node);
            return null;
        }

        @Override
        public Object visit(VariableRef node) {
            this.loadFromVariable(node.getVariable());
            return null;
        }

        @Override
        public Object visit(final Lookup node) {
            final Expression expr = node.getExpression();
            this.generate(expr);
            this.setLineNumber(node.getSourceInfo());
            Field field = node.getReadProperty();
            if (field != null) {
                this.mBuilder.loadStaticField(field.getDeclaringClass().getName(), field.getName(), JavaClassGenerator.makeDesc(node.getType()));
                return null;
            }
            this.generateNullSafe(node, expr, new NullSafeCallback(){

                @Override
                public Type execute() {
                    Method readMethod = node.getReadMethod();
                    String lookupName = node.getLookupName().getName();
                    if (expr.getType().getObjectClass().isArray() && lookupName.equals("length")) {
                        Visitor.this.mBuilder.arrayLength();
                        return Type.INT_TYPE;
                    }
                    if (Modifier.isStatic(readMethod.getModifiers())) {
                        Visitor.this.mBuilder.pop();
                    }
                    Visitor.this.mBuilder.invoke(readMethod);
                    return new Type(readMethod.getReturnType(), readMethod.getGenericReturnType());
                }
            });
            return null;
        }

        @Override
        public Object visit(final ArrayLookup node) {
            final Expression expr = node.getExpression();
            this.generate(expr);
            this.generateNullSafe(node, expr, new NullSafeCallback(){

                @Override
                public Type execute() {
                    Method readMethod = node.getReadMethod();
                    Expression lookup = node.getLookupIndex();
                    Type type = expr.getType();
                    Class<?> lookupClass = type.getObjectClass();
                    boolean doArrayLookup = lookupClass.isArray();
                    if (!doArrayLookup && Modifier.isStatic(readMethod.getModifiers())) {
                        Visitor.this.mBuilder.pop();
                    }
                    Visitor.this.generate(lookup);
                    Visitor.this.setLineNumber(node.getLookupToken().getSourceInfo());
                    if (!doArrayLookup) {
                        Visitor.this.mBuilder.invoke(readMethod);
                        return node.getType();
                    }
                    try {
                        Type elementType = expr.getInitialType().getArrayElementType();
                        Visitor.this.mBuilder.loadFromArray(JavaClassGenerator.makeDesc(elementType));
                        return elementType;
                    }
                    catch (IntrospectionException e) {
                        throw new RuntimeException(e.toString());
                    }
                }
            });
            return null;
        }

        @Override
        public Object visit(NegateExpression node) {
            Expression expr = node.getExpression();
            Class<?> exprClass = expr.getType().getNaturalClass();
            this.generate(expr);
            int opcode = exprClass == Integer.TYPE ? 116 : (exprClass == Float.TYPE ? 118 : (exprClass == Long.TYPE ? 117 : (exprClass == Double.TYPE ? 119 : 116)));
            this.mBuilder.math((byte)opcode);
            return null;
        }

        @Override
        public Object visit(ConcatenateExpression node) {
            Expression left = node.getLeftExpression();
            Expression right = node.getRightExpression();
            Type leftType = left.getType();
            Type rightType = right.getType();
            if (left instanceof ConcatenateExpression || leftType.isNullable() || leftType.getObjectClass() != String.class || rightType.isNullable() || rightType.getObjectClass() != String.class) {
                this.generateAppend(node, this.estimateBufferRequirement(node));
                this.mBuilder.invokeVirtual("java.lang.StringBuilder", "toString", TypeDesc.STRING, new TypeDesc[0]);
            } else {
                this.generate(left);
                this.generate(right);
                this.mBuilder.invokeVirtual("java.lang.String", "concat", TypeDesc.STRING, cStringParam);
            }
            return null;
        }

        @Override
        public Object visit(ArithmeticExpression node) {
            Expression left = node.getLeftExpression();
            Expression right = node.getRightExpression();
            Type type = left.getType();
            if (type == null || !type.equals(right.getType())) {
                throw new RuntimeException("ArithmeticExpression types don't match: " + type + ", " + right.getType());
            }
            this.generate(node.getLeftExpression());
            this.generate(node.getRightExpression());
            this.setLineNumber(node.getOperator().getSourceInfo());
            int opcode = 0;
            int ID = node.getOperator().getID();
            Class<?> clazz = type.getNaturalClass();
            if (clazz == Integer.TYPE) {
                switch (ID) {
                    case 29: {
                        opcode = 96;
                        break;
                    }
                    case 30: {
                        opcode = 100;
                        break;
                    }
                    case 31: {
                        opcode = 104;
                        break;
                    }
                    case 32: {
                        opcode = 108;
                        break;
                    }
                    case 33: {
                        opcode = 112;
                    }
                }
            } else if (clazz == Float.TYPE) {
                switch (ID) {
                    case 29: {
                        opcode = 98;
                        break;
                    }
                    case 30: {
                        opcode = 102;
                        break;
                    }
                    case 31: {
                        opcode = 106;
                        break;
                    }
                    case 32: {
                        opcode = 110;
                        break;
                    }
                    case 33: {
                        opcode = 114;
                    }
                }
            } else if (clazz == Long.TYPE) {
                switch (ID) {
                    case 29: {
                        opcode = 97;
                        break;
                    }
                    case 30: {
                        opcode = 101;
                        break;
                    }
                    case 31: {
                        opcode = 105;
                        break;
                    }
                    case 32: {
                        opcode = 109;
                        break;
                    }
                    case 33: {
                        opcode = 113;
                    }
                }
            } else if (clazz == Double.TYPE) {
                switch (ID) {
                    case 29: {
                        opcode = 99;
                        break;
                    }
                    case 30: {
                        opcode = 103;
                        break;
                    }
                    case 31: {
                        opcode = 107;
                        break;
                    }
                    case 32: {
                        opcode = 111;
                        break;
                    }
                    case 33: {
                        opcode = 115;
                    }
                }
            }
            this.mBuilder.math((byte)opcode);
            return null;
        }

        @Override
        public Object visit(RelationalExpression node) {
            this.generateLogical(node);
            return null;
        }

        @Override
        public Object visit(NotExpression node) {
            this.generateLogical(node);
            return null;
        }

        @Override
        public Object visit(AndExpression node) {
            this.generateLogical(node);
            return null;
        }

        @Override
        public Object visit(OrExpression node) {
            this.generateLogical(node);
            return null;
        }

        @Override
        public Object visit(TernaryExpression node) {
            Expression thenPart = node.getThenPart();
            Expression elsePart = node.getElsePart();
            Expression condition = node.getCondition();
            Label elseLabel = this.mBuilder.createLabel();
            Label endLabel = this.mBuilder.createLabel();
            if (thenPart == condition) {
                condition = thenPart = this.createAssignment(condition).getLValue();
            }
            if (thenPart == null) {
                this.generateBranch(condition, endLabel, true);
            } else {
                this.generateBranch(condition, elseLabel, false);
            }
            if (thenPart != null) {
                this.generate(thenPart);
                if (elsePart != null) {
                    this.mBuilder.branch((Location)endLabel);
                }
            }
            elseLabel.setLocation();
            if (elsePart != null) {
                this.generate(elsePart);
            }
            endLabel.setLocation();
            return null;
        }

        @Override
        public Object visit(CompareExpression node) {
            boolean comparable;
            Expression left = node.getLeftExpression();
            Expression right = node.getRightExpression();
            Type ltype = left.getType();
            Type rtype = right.getType();
            this.generate(left);
            LocalVariable lvar = this.mBuilder.createLocalVariable(null, JavaClassGenerator.makeDesc(ltype));
            this.mBuilder.storeLocal(lvar);
            this.generate(right);
            LocalVariable rvar = this.mBuilder.createLocalVariable(null, JavaClassGenerator.makeDesc(rtype));
            this.mBuilder.storeLocal(rvar);
            boolean bl = comparable = Comparable.class.isAssignableFrom(ltype.getObjectClass()) && ltype.getNaturalClass().isAssignableFrom(rtype.getNaturalClass());
            if (ltype.isPrimitive() && rtype.isPrimitive()) {
                Label endLocation = this.mBuilder.createLabel();
                Label ltLocation = this.mBuilder.createLabel();
                Label gtLocation = this.mBuilder.createLabel();
                this.mBuilder.loadLocal(lvar);
                this.mBuilder.loadLocal(rvar);
                this.generateComparison(ltLocation, "!=", ltype);
                this.mBuilder.loadConstant(0);
                this.mBuilder.branch((Location)endLocation);
                ltLocation.setLocation();
                this.mBuilder.loadLocal(lvar);
                this.mBuilder.loadLocal(rvar);
                this.generateComparison(gtLocation, "<", ltype);
                this.mBuilder.loadConstant(1);
                this.mBuilder.branch((Location)endLocation);
                gtLocation.setLocation();
                this.mBuilder.loadConstant(-1);
                endLocation.setLocation();
            } else {
                Label location1 = this.mBuilder.createLabel();
                Label location2 = this.mBuilder.createLabel();
                Label location3 = this.mBuilder.createLabel();
                Label location4 = this.mBuilder.createLabel();
                Label endLocation = this.mBuilder.createLabel();
                this.mBuilder.loadLocal(lvar);
                this.mBuilder.ifNullBranch((Location)location1, false);
                this.mBuilder.loadLocal(rvar);
                this.mBuilder.ifNullBranch((Location)location2, false);
                this.mBuilder.loadConstant(0);
                this.mBuilder.branch((Location)endLocation);
                location2.setLocation();
                this.mBuilder.loadConstant(-1);
                this.mBuilder.branch((Location)endLocation);
                location1.setLocation();
                this.mBuilder.loadLocal(rvar);
                this.mBuilder.ifNullBranch((Location)location3, false);
                this.mBuilder.loadConstant(1);
                this.mBuilder.branch((Location)endLocation);
                location3.setLocation();
                this.mBuilder.loadLocal(lvar);
                this.mBuilder.loadLocal(rvar);
                if (!comparable) {
                    this.mBuilder.loadLocal(lvar);
                    this.mBuilder.instanceOf(JavaClassGenerator.makeDesc(Comparable.class));
                    this.mBuilder.ifZeroComparisonBranch((Location)location4, "!=");
                    this.mBuilder.swap();
                    this.mBuilder.invoke(this.getMethod(Object.class, "toString", new Class[0]));
                    this.mBuilder.swap();
                    this.mBuilder.invoke(this.getMethod(Object.class, "toString", new Class[0]));
                }
                location4.setLocation();
                this.mBuilder.invoke(this.getMethod(Comparable.class, "compareTo", Object.class));
                endLocation.setLocation();
            }
            return null;
        }

        private void generateComparison(Label label, String choice, Type type) {
            this.generateComparison(label, choice, type.getNaturalClass());
        }

        private void generateComparison(Label label, String choice, Class<?> clazz) {
            if (clazz == Long.TYPE) {
                this.mBuilder.math((byte)-108);
                this.mBuilder.ifZeroComparisonBranch((Location)label, choice);
            } else if (clazz == Float.TYPE) {
                this.mBuilder.math((byte)-106);
                this.mBuilder.ifZeroComparisonBranch((Location)label, choice);
            } else if (clazz == Double.TYPE) {
                this.mBuilder.math((byte)-104);
                this.mBuilder.ifZeroComparisonBranch((Location)label, choice);
            } else {
                this.mBuilder.ifComparisonBranch((Location)label, choice);
            }
        }

        @Override
        public Object visit(NoOpExpression node) {
            return null;
        }

        @Override
        public Object visit(TypeExpression node) {
            return null;
        }

        @Override
        public Object visit(SpreadExpression node) {
            Expression expr = node.getExpression();
            this.generate(expr);
            LocalVariable collection = this.mBuilder.createLocalVariable(null, JavaClassGenerator.makeDesc(expr.getType()));
            this.mBuilder.storeLocal(collection);
            Class<?> exprClass = expr.getType().getNaturalClass();
            Type elementType = null;
            try {
                elementType = expr.getType().getIterationElementType();
            }
            catch (IntrospectionException exception) {
                throw new IllegalStateException(exception);
            }
            Class<?> elementClass = elementType.getNaturalClass();
            this.mBuilder.loadLocal(collection);
            Label endLabel = this.mBuilder.createLabel();
            Label nullLabel = this.mBuilder.createLabel();
            this.mBuilder.ifNullBranch((Location)nullLabel, true);
            if (Collection.class.isAssignableFrom(exprClass)) {
                TypeDesc arrayList = JavaClassGenerator.makeDesc(node.getType());
                this.mBuilder.newObject(arrayList);
                this.mBuilder.dup();
                this.mBuilder.loadLocal(collection);
                this.mBuilder.invoke(this.getMethod(Collection.class, "size", new Class[0]));
                this.mBuilder.invokeConstructor(node.getType().getClassName(), new TypeDesc[]{JavaClassGenerator.makeDesc(Integer.TYPE)});
                LocalVariable list = this.mBuilder.createLocalVariable(null, arrayList);
                this.mBuilder.storeLocal(list);
                this.mBuilder.loadLocal(collection);
                LocalVariable iterator = this.mBuilder.createLocalVariable(null, JavaClassGenerator.makeDesc(Iterator.class));
                this.mBuilder.invoke(this.getMethod(Collection.class, "iterator", new Class[0]));
                this.mBuilder.storeLocal(iterator);
                Label endLoopLabel = this.mBuilder.createLabel();
                Label checkLabel = this.mBuilder.createLabel();
                this.mBuilder.branch((Location)checkLabel);
                Label startLabel = this.mBuilder.createLabel().setLocation();
                Label continueLabel = this.mBuilder.createLabel();
                this.mBuilder.loadLocal(list);
                this.mBuilder.loadLocal(iterator);
                this.mBuilder.invokeInterface("java.util.Iterator", "next", TypeDesc.OBJECT, new TypeDesc[0]);
                this.mBuilder.dup();
                Label addLabel = this.mBuilder.createLabel();
                this.mBuilder.ifNullBranch((Location)addLabel, true);
                if (elementClass != Object.class) {
                    this.mBuilder.checkCast(JavaClassGenerator.makeDesc(elementClass));
                }
                this.generate(node.getOperation());
                addLabel.setLocation();
                this.mBuilder.invoke(this.getMethod(List.class, "add", Object.class));
                this.mBuilder.ifZeroComparisonBranch((Location)nullLabel, "==");
                continueLabel.setLocation();
                checkLabel.setLocation();
                this.mBuilder.loadLocal(iterator);
                this.mBuilder.invokeInterface("java.util.Iterator", "hasNext", TypeDesc.BOOLEAN, new TypeDesc[0]);
                this.mBuilder.ifZeroComparisonBranch((Location)startLabel, "!=");
                endLoopLabel.setLocation();
                this.mBuilder.loadLocal(list);
            } else if (exprClass.isArray()) {
                Type operationType = node.getOperation().getType();
                TypeDesc arrayType = JavaClassGenerator.makeDesc(node.getType());
                LocalVariable length = this.mBuilder.createLocalVariable(null, TypeDesc.INT);
                this.mBuilder.loadLocal(collection);
                this.mBuilder.arrayLength();
                this.mBuilder.storeLocal(length);
                this.mBuilder.loadLocal(length);
                this.mBuilder.newObject(arrayType);
                LocalVariable array = this.mBuilder.createLocalVariable(null, arrayType);
                this.mBuilder.storeLocal(array);
                Label endLoopLabel = this.mBuilder.createLabel();
                LocalVariable indexLocal = this.mBuilder.createLocalVariable(null, TypeDesc.INT);
                this.mBuilder.loadConstant(0);
                this.mBuilder.storeLocal(indexLocal);
                Label checkLabel = this.mBuilder.createLabel();
                this.mBuilder.branch((Location)checkLabel);
                Label startLabel = this.mBuilder.createLabel().setLocation();
                Label continueLabel = this.mBuilder.createLabel();
                this.mBuilder.loadLocal(array);
                this.mBuilder.loadLocal(indexLocal);
                this.mBuilder.loadLocal(collection);
                this.mBuilder.loadLocal(indexLocal);
                this.mBuilder.loadFromArray(TypeDesc.OBJECT);
                this.mBuilder.dup();
                Label addLabel = this.mBuilder.createLabel();
                Label null2Label = this.mBuilder.createLabel();
                this.mBuilder.ifNullBranch((Location)null2Label, true);
                this.generate(node.getOperation());
                this.mBuilder.branch((Location)addLabel);
                null2Label.setLocation();
                this.mBuilder.pop();
                if (operationType.isPrimitive()) {
                    Class<?> clazz = operationType.getNaturalClass();
                    if (Integer.TYPE.equals(clazz)) {
                        this.mBuilder.loadConstant(0);
                    } else if (Boolean.TYPE.equals(clazz)) {
                        this.mBuilder.loadConstant(false);
                    } else if (Double.TYPE.equals(clazz)) {
                        this.mBuilder.loadConstant(0.0);
                    } else if (Float.TYPE.equals(clazz)) {
                        this.mBuilder.loadConstant(0.0f);
                    } else if (Long.TYPE.equals(clazz)) {
                        this.mBuilder.loadConstant(0L);
                    } else {
                        this.mBuilder.loadConstant(0);
                    }
                } else {
                    this.mBuilder.loadNull();
                }
                addLabel.setLocation();
                this.mBuilder.storeToArray(JavaClassGenerator.makeDesc(operationType));
                continueLabel.setLocation();
                this.mBuilder.integerIncrement(indexLocal, 1);
                checkLabel.setLocation();
                this.mBuilder.loadLocal(indexLocal);
                this.mBuilder.loadLocal(length);
                this.mBuilder.ifComparisonBranch((Location)startLabel, "<");
                endLoopLabel.setLocation();
                this.mBuilder.loadLocal(array);
            }
            this.mBuilder.branch((Location)endLabel);
            nullLabel.setLocation();
            this.mBuilder.loadNull();
            endLabel.setLocation();
            return null;
        }

        @Override
        public Object visit(NullLiteral node) {
            this.mBuilder.loadNull();
            return null;
        }

        @Override
        public Object visit(BooleanLiteral node) {
            boolean value = (Boolean)node.getValue();
            Type type = node.getType();
            Class<Object> clazz = type.getNaturalClass();
            if (clazz == Boolean.TYPE) {
                this.mBuilder.loadConstant(value);
            } else if (clazz.isAssignableFrom(Boolean.class)) {
                TypeDesc td = JavaClassGenerator.makeDesc(Boolean.class);
                if (value) {
                    this.mBuilder.loadStaticField("java.lang.Boolean", "TRUE", td);
                } else {
                    this.mBuilder.loadStaticField("java.lang.Boolean", "FALSE", td);
                }
            } else if (clazz.isAssignableFrom(String.class)) {
                this.mBuilder.loadConstant(String.valueOf(value));
            } else {
                this.typeError(Type.BOOLEAN_TYPE, type);
            }
            return null;
        }

        @Override
        public Object visit(StringLiteral node) {
            this.mBuilder.loadConstant((String)node.getValue());
            return null;
        }

        @Override
        public Object visit(NumberLiteral node) {
            Number value = (Number)node.getValue();
            Type toType = node.getType();
            Type fromType = Number.class.isAssignableFrom(toType.getObjectClass()) ? toType.toPrimitive() : new Type(value.getClass()).toPrimitive();
            Class<?> fromClass = fromType.getObjectClass();
            if (Integer.class.isAssignableFrom(fromClass)) {
                this.mBuilder.loadConstant(value.intValue());
            } else if (Float.class.isAssignableFrom(fromClass)) {
                this.mBuilder.loadConstant(value.floatValue());
            } else if (Long.class.isAssignableFrom(fromClass)) {
                this.mBuilder.loadConstant(value.longValue());
            } else if (Double.class.isAssignableFrom(fromClass)) {
                this.mBuilder.loadConstant(value.doubleValue());
            } else {
                this.typeError(fromType, toType);
            }
            return null;
        }

        private void generateContext() {
            if (this.mContextParam == null) {
                throw new NullPointerException("Context parameter is null");
            }
            this.generate(this.mContextParam);
        }

        private void generateBranch(Expression expr, Label label, boolean whenTrue) {
            if (expr instanceof Logical) {
                if (expr instanceof RelationalExpression) {
                    this.generateBranch((RelationalExpression)expr, label, whenTrue);
                } else if (expr instanceof NotExpression) {
                    this.generateBranch((NotExpression)expr, label, whenTrue);
                } else if (expr instanceof AndExpression) {
                    this.generateBranch((AndExpression)expr, label, whenTrue);
                } else if (expr instanceof OrExpression) {
                    this.generateBranch((OrExpression)expr, label, whenTrue);
                }
            } else {
                Type type = expr.getType();
                if (expr.isValueKnown()) {
                    Object value = expr.getValue();
                    if (value == null && !whenTrue) {
                        this.mBuilder.branch((Location)label);
                    } else if (value instanceof Truthful) {
                        boolean isTrue = ((Truthful)value).isTrue();
                        if (!isTrue && !whenTrue || isTrue && whenTrue) {
                            this.mBuilder.branch((Location)label);
                        }
                    } else if (value instanceof Boolean) {
                        boolean isTrue = (Boolean)value;
                        if (!isTrue && !whenTrue || isTrue && whenTrue) {
                            this.mBuilder.branch((Location)label);
                        }
                    } else if (value instanceof Float || value instanceof Double) {
                        double dblvalue = ((Number)value).doubleValue();
                        if (dblvalue == 0.0 && !whenTrue || dblvalue != 0.0 && whenTrue) {
                            this.mBuilder.branch((Location)label);
                        }
                    } else if (value instanceof Number) {
                        int intvalue = ((Number)value).intValue();
                        if (intvalue == 0 && !whenTrue || intvalue != 0 && whenTrue) {
                            this.mBuilder.branch((Location)label);
                        }
                    } else if (value instanceof String) {
                        int length = ((String)value).length();
                        if (length == 0 && !whenTrue || length != 0 && whenTrue) {
                            this.mBuilder.branch((Location)label);
                        }
                    } else if (value != null && value.getClass().isArray()) {
                        int length = Array.getLength(value);
                        if (length == 0 && !whenTrue || length != 0 && whenTrue) {
                            this.mBuilder.branch((Location)label);
                        }
                    } else if (value instanceof Collection) {
                        int length = ((Collection)value).size();
                        if (length == 0 && !whenTrue || length != 0 && whenTrue) {
                            this.mBuilder.branch((Location)label);
                        }
                    } else if (value instanceof Map) {
                        int length = ((Map)value).size();
                        if (length == 0 && !whenTrue || length != 0 && whenTrue) {
                            this.mBuilder.branch((Location)label);
                        }
                    } else if (value != null && whenTrue) {
                        this.mBuilder.branch((Location)label);
                    }
                } else if (type == null) {
                    this.generate(expr);
                    this.mBuilder.ifZeroComparisonBranch((Location)label, whenTrue ? "!=" : "==");
                } else if (type.isPrimitive()) {
                    this.generate(expr);
                    Class<?> clazz = type.getNaturalClass();
                    if (Long.TYPE.equals(clazz)) {
                        this.mBuilder.loadConstant(0L);
                        this.mBuilder.math((byte)-108);
                        this.mBuilder.ifZeroComparisonBranch((Location)label, whenTrue ? "!=" : "==");
                    } else if (Float.TYPE.equals(clazz)) {
                        this.mBuilder.loadConstant(0.0f);
                        this.mBuilder.math((byte)-106);
                        this.mBuilder.ifZeroComparisonBranch((Location)label, whenTrue ? "!=" : "==");
                    } else if (Double.TYPE.equals(clazz)) {
                        this.mBuilder.loadConstant(0.0);
                        this.mBuilder.math((byte)-104);
                        this.mBuilder.ifZeroComparisonBranch((Location)label, whenTrue ? "!=" : "==");
                    } else {
                        this.mBuilder.ifZeroComparisonBranch((Location)label, whenTrue ? "!=" : "==");
                    }
                } else {
                    this.generate(expr);
                    LocalVariable local = this.mBuilder.createLocalVariable(null, JavaClassGenerator.makeDesc(type));
                    this.mBuilder.storeLocal(local);
                    if (type.isNullable()) {
                        this.mBuilder.loadLocal(local);
                        this.mBuilder.ifNullBranch((Location)label, !whenTrue);
                    }
                    this.mBuilder.loadLocal(local);
                    Class<?> clazz = type.getNaturalClass();
                    if (Truthful.class.isAssignableFrom(clazz)) {
                        this.mBuilder.invoke(this.getMethod(Truthful.class, "isTrue", new Class[0]));
                        this.mBuilder.ifZeroComparisonBranch((Location)label, whenTrue ? "!=" : "==");
                    } else if (Boolean.class.isAssignableFrom(clazz)) {
                        this.mBuilder.invoke(this.getMethod(Boolean.class, "booleanValue", new Class[0]));
                        this.mBuilder.ifZeroComparisonBranch((Location)label, whenTrue ? "!=" : "==");
                    } else if (Long.class.isAssignableFrom(clazz)) {
                        this.mBuilder.invoke(this.getMethod(Long.class, "longValue", new Class[0]));
                        this.mBuilder.loadConstant(0L);
                        this.mBuilder.math((byte)-106);
                        this.mBuilder.ifZeroComparisonBranch((Location)label, whenTrue ? "!=" : "==");
                    } else if (Double.class.isAssignableFrom(clazz)) {
                        this.mBuilder.invoke(this.getMethod(Double.class, "doubleValue", new Class[0]));
                        this.mBuilder.loadConstant(0.0);
                        this.mBuilder.math((byte)-104);
                        this.mBuilder.ifZeroComparisonBranch((Location)label, whenTrue ? "!=" : "==");
                    } else if (Float.class.isAssignableFrom(clazz)) {
                        this.mBuilder.invoke(this.getMethod(Float.class, "floatValue", new Class[0]));
                        this.mBuilder.loadConstant(0.0f);
                        this.mBuilder.math((byte)-106);
                        this.mBuilder.ifZeroComparisonBranch((Location)label, whenTrue ? "!=" : "==");
                    } else if (Number.class.isAssignableFrom(clazz)) {
                        this.mBuilder.invoke(this.getMethod(Number.class, "intValue", new Class[0]));
                        this.mBuilder.ifZeroComparisonBranch((Location)label, whenTrue ? "!=" : "==");
                    } else if (String.class.isAssignableFrom(clazz)) {
                        this.mBuilder.invoke(this.getMethod(String.class, "length", new Class[0]));
                        this.mBuilder.ifZeroComparisonBranch((Location)label, whenTrue ? "!=" : "==");
                    } else if (clazz.isArray()) {
                        this.mBuilder.arrayLength();
                        this.mBuilder.ifZeroComparisonBranch((Location)label, whenTrue ? "!=" : "==");
                    } else if (Collection.class.isAssignableFrom(clazz)) {
                        this.mBuilder.invoke(this.getMethod(Collection.class, "size", new Class[0]));
                        this.mBuilder.ifZeroComparisonBranch((Location)label, whenTrue ? "!=" : "==");
                    } else if (Map.class.isAssignableFrom(clazz)) {
                        this.mBuilder.invoke(this.getMethod(Map.class, "size", new Class[0]));
                        this.mBuilder.ifZeroComparisonBranch((Location)label, whenTrue ? "!=" : "==");
                    } else {
                        this.mBuilder.pop();
                        if (whenTrue) {
                            this.mBuilder.branch((Location)label);
                        }
                    }
                }
            }
        }

        private Method getMethod(Class<?> clazz, String method, Class<?> ... params) {
            try {
                return clazz.getMethod(method, params);
            }
            catch (Exception e) {
                throw new RuntimeException("unable to get method: " + clazz + "." + method, e);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void generateBranch(RelationalExpression expr, Label label, boolean whenTrue) {
            Type rightType;
            Token operator = expr.getOperator();
            Expression left = expr.getLeftExpression();
            if (operator.getID() == 49) {
                TypeName typeName = expr.getIsaTypeName();
                this.generate(left);
                this.setLineNumber(operator.getSourceInfo());
                this.mBuilder.instanceOf(JavaClassGenerator.makeDesc(typeName.getType(), false));
                this.mBuilder.ifZeroComparisonBranch((Location)label, whenTrue ? "!=" : "==");
                return;
            }
            Expression right = expr.getRightExpression();
            String choice = this.getChoice(operator, whenTrue);
            Type leftType = left.getType();
            Class<?> clazz = leftType.getCompatibleType(rightType = right.getType()).getNaturalClass();
            if (clazz == null) {
                throw new RuntimeException("Relational type mismatch: " + leftType + ", " + rightType);
            }
            if (!leftType.isPrimitive()) {
                if (choice == "==" || choice == "!=") {
                    if (right.isValueKnown() && right.getValue() == null) {
                        this.generate(left);
                        this.mBuilder.ifNullBranch((Location)label, choice == "==");
                        return;
                    } else if (left.isValueKnown() && left.getValue() == null) {
                        this.generate(right);
                        this.mBuilder.ifNullBranch((Location)label, choice == "==");
                        return;
                    } else {
                        String className = "java.lang.Object";
                        String methodName = "equals";
                        TypeDesc ret = TypeDesc.BOOLEAN;
                        if (leftType.isNonNull() || right.isValueKnown()) {
                            if (leftType.isNonNull()) {
                                this.generate(left);
                                this.generate(right);
                            } else {
                                this.generate(right);
                                this.generate(left);
                            }
                            this.setLineNumber(operator.getSourceInfo());
                            this.mBuilder.invokeVirtual(className, methodName, ret, cObjectParam);
                            this.mBuilder.ifZeroComparisonBranch((Location)label, choice == "==" ? "!=" : "==");
                            return;
                        } else {
                            this.generate(left);
                            this.mBuilder.dup();
                            Label leftNotNull = this.mBuilder.createLabel();
                            this.mBuilder.ifNullBranch((Location)leftNotNull, false);
                            this.mBuilder.pop();
                            Label fallThrough = this.mBuilder.createLabel();
                            if (rightType.isNonNull()) {
                                if (choice == "==") {
                                    this.mBuilder.branch((Location)fallThrough);
                                } else {
                                    this.mBuilder.branch((Location)label);
                                }
                            } else {
                                this.generate(right);
                                this.mBuilder.ifNullBranch((Location)label, choice == "==");
                                this.mBuilder.branch((Location)fallThrough);
                            }
                            leftNotNull.setLocation();
                            this.generate(right);
                            this.setLineNumber(operator.getSourceInfo());
                            this.mBuilder.invokeVirtual(className, methodName, ret, cObjectParam);
                            this.mBuilder.ifZeroComparisonBranch((Location)label, choice == "==" ? "!=" : "==");
                            fallThrough.setLocation();
                        }
                    }
                    return;
                } else if (String.class.isAssignableFrom(clazz)) {
                    this.generate(left);
                    this.generate(right);
                    this.setLineNumber(operator.getSourceInfo());
                    this.mBuilder.invokeVirtual("java.lang.String", "compareTo", TypeDesc.INT, cStringParam);
                    this.mBuilder.ifZeroComparisonBranch((Location)label, choice);
                    return;
                } else {
                    if (!Comparable.class.isAssignableFrom(clazz)) throw new RuntimeException("Can't do " + choice + " for type " + leftType);
                    this.generate(left);
                    this.generate(right);
                    this.setLineNumber(operator.getSourceInfo());
                    this.mBuilder.invokeInterface("java.lang.Comparable", "compareTo", TypeDesc.INT, cObjectParam);
                    this.mBuilder.ifZeroComparisonBranch((Location)label, choice);
                }
                return;
            } else if (clazz == Integer.TYPE) {
                int value;
                if (right.isValueKnown()) {
                    int value2 = (Integer)right.getValue();
                    if (value2 == 0) {
                        this.generate(left);
                        this.mBuilder.ifZeroComparisonBranch((Location)label, choice);
                        return;
                    }
                } else if (left.isValueKnown() && (value = ((Integer)left.getValue()).intValue()) == 0) {
                    this.generate(right);
                    choice = this.getChoice(operator, !whenTrue);
                    this.mBuilder.ifZeroComparisonBranch((Location)label, choice);
                    return;
                }
                this.generate(left);
                this.generate(right);
                this.mBuilder.ifComparisonBranch((Location)label, choice);
                return;
            } else if (clazz == Boolean.TYPE) {
                this.generate(left);
                this.generate(right);
                this.mBuilder.ifComparisonBranch((Location)label, choice);
                return;
            } else {
                int op;
                this.generate(left);
                this.generate(right);
                if (clazz == Long.TYPE) {
                    op = -108;
                } else if (clazz == Float.TYPE) {
                    int ID = operator.getID();
                    op = ID == 22 || ID == 23 || ID == 24 ? -106 : -107;
                } else {
                    if (clazz != Double.TYPE) throw new RuntimeException("Unsupported comparison type: " + leftType);
                    int ID = operator.getID();
                    op = ID == 22 || ID == 23 || ID == 24 ? -104 : -105;
                }
                this.mBuilder.math((byte)op);
                this.mBuilder.ifZeroComparisonBranch((Location)label, choice);
            }
        }

        private void generateBranch(NotExpression expr, Label label, boolean whenTrue) {
            this.generateBranch(expr.getExpression(), label, !whenTrue);
        }

        private void generateBranch(AndExpression expr, Label label, boolean whenTrue) {
            if (whenTrue) {
                Label falseLabel = this.mBuilder.createLabel();
                this.generateBranch(expr.getLeftExpression(), falseLabel, false);
                this.generateBranch(expr.getRightExpression(), label, true);
                falseLabel.setLocation();
            } else {
                this.generateBranch(expr.getLeftExpression(), label, false);
                this.generateBranch(expr.getRightExpression(), label, false);
            }
        }

        private void generateBranch(OrExpression expr, Label label, boolean whenTrue) {
            if (whenTrue) {
                this.generateBranch(expr.getLeftExpression(), label, true);
                this.generateBranch(expr.getRightExpression(), label, true);
            } else {
                Label trueLabel = this.mBuilder.createLabel();
                this.generateBranch(expr.getLeftExpression(), trueLabel, true);
                this.generateBranch(expr.getRightExpression(), label, false);
                trueLabel.setLocation();
            }
        }

        private String getChoice(Token operator, boolean whenTrue) {
            if (whenTrue) {
                switch (operator.getID()) {
                    case 24: {
                        return "==";
                    }
                    case 27: {
                        return "!=";
                    }
                    case 22: {
                        return "<";
                    }
                    case 26: {
                        return ">";
                    }
                    case 23: {
                        return "<=";
                    }
                    case 25: {
                        return ">=";
                    }
                }
            } else {
                switch (operator.getID()) {
                    case 24: {
                        return "!=";
                    }
                    case 27: {
                        return "==";
                    }
                    case 22: {
                        return ">=";
                    }
                    case 26: {
                        return "<=";
                    }
                    case 23: {
                        return ">";
                    }
                    case 25: {
                        return "<";
                    }
                }
            }
            throw new RuntimeException("Unknown relational operator: " + operator.getImage());
        }

        private void generateAppend(Expression expr, int estimate) {
            String val;
            if (!(expr instanceof ConcatenateExpression)) {
                this.generate(expr);
                return;
            }
            ConcatenateExpression concat = (ConcatenateExpression)expr;
            Expression left = concat.getLeftExpression();
            Expression right = concat.getRightExpression();
            Type leftType = left.getType();
            Type rightType = right.getType();
            if (left instanceof ConcatenateExpression) {
                this.generateAppend(left, estimate);
            } else {
                this.mBuilder.newObject(cStringBuilderDesc);
                this.mBuilder.dup();
                if (left.isValueKnown()) {
                    this.mBuilder.loadConstant(estimate);
                    this.mBuilder.invokeConstructor("java.lang.StringBuilder", cIntParam);
                    if (left instanceof StringLiteral) {
                        val = (String)((StringLiteral)left).getValue();
                        if (val.length() == 1) {
                            this.mBuilder.loadConstant((int)val.charAt(0));
                            leftType = new Type(Character.TYPE);
                        } else {
                            this.generate(left);
                        }
                    } else {
                        this.generate(left);
                    }
                } else {
                    if ((estimate -= 16) < 0) {
                        estimate += 16;
                    }
                    this.mBuilder.loadConstant(estimate);
                    LocalVariable leftResult = this.mBuilder.createLocalVariable("left", TypeDesc.STRING);
                    this.generate(left);
                    this.mBuilder.storeLocal(leftResult);
                    Label ctor = this.mBuilder.createLabel();
                    if (leftType.isNullable()) {
                        this.mBuilder.loadLocal(leftResult);
                        this.mBuilder.ifNullBranch((Location)ctor, true);
                    }
                    this.mBuilder.loadLocal(leftResult);
                    this.mBuilder.invokeVirtual("java.lang.String", "length", TypeDesc.INT, new TypeDesc[0]);
                    this.mBuilder.math((byte)96);
                    ctor.setLocation();
                    this.mBuilder.invokeConstructor("java.lang.StringBuilder", cIntParam);
                    this.mBuilder.loadLocal(leftResult);
                }
                this.append(leftType);
            }
            if (right instanceof StringLiteral) {
                val = (String)((StringLiteral)right).getValue();
                if (val.length() == 1) {
                    this.mBuilder.loadConstant((int)val.charAt(0));
                    rightType = new Type(Character.TYPE);
                } else {
                    this.generate(right);
                }
            } else {
                this.generate(right);
            }
            this.setLineNumber(concat.getOperator().getSourceInfo());
            this.append(rightType);
        }

        private void append(Type type) {
            TypeDesc[] param;
            Class<Object> clazz = type.getNaturalClass();
            if (type.isPrimitive()) {
                if (clazz == Byte.TYPE || clazz == Short.TYPE) {
                    clazz = Integer.TYPE;
                }
                param = new TypeDesc[]{JavaClassGenerator.makeDesc(clazz)};
            } else {
                param = clazz == String.class ? cStringParam : cObjectParam;
            }
            this.mBuilder.invokeVirtual("java.lang.StringBuilder", "append", cStringBuilderDesc, param);
        }

        private int estimateBufferRequirement(ConcatenateExpression concat) {
            return this.estimateBufferRequirement(concat.getLeftExpression()) + this.estimateBufferRequirement(concat.getRightExpression());
        }

        private int estimateBufferRequirement(Expression expr) {
            Object value;
            if (expr.isValueKnown() && (value = expr.getValue()) instanceof String) {
                return ((String)value).length();
            }
            if (expr instanceof ConcatenateExpression) {
                return this.estimateBufferRequirement((ConcatenateExpression)expr);
            }
            return 16;
        }

        private void typeConvertBegin(Expression.Conversion conversion) {
            Type from = conversion.getFromType();
            if (from == null) {
                return;
            }
            Type to = conversion.getToType();
            this.typeConvertBegin(from, to, conversion.isCastPreferred());
        }

        private void typeConvertBegin(Type from, Type to, boolean castPreferred) {
            boolean convertStringToNonNull;
            Class<?> fromNat = from.getNaturalClass();
            Class<?> toNat = to.getNaturalClass();
            if (fromNat.isArray() && toNat.isArray()) {
                return;
            }
            if (from.isPrimitive()) {
                Class<?> toObj;
                if (to.isPrimitive()) {
                    return;
                }
                Class<?> fromObj = from.getObjectClass();
                if (fromObj == (toObj = to.getObjectClass())) {
                    if (fromObj != Boolean.class && fromObj != Integer.class) {
                        this.mBuilder.newObject(JavaClassGenerator.makeDesc(from, false));
                        this.mBuilder.dup();
                    }
                    return;
                }
            } else if (to.isPrimitive() ? from.hasPrimitivePeer() || Number.class.isAssignableFrom(to.getObjectClass()) && Number.class.isAssignableFrom(from.getObjectClass()) : Number.class.isAssignableFrom(fromNat) && Number.class.isAssignableFrom(toNat)) {
                return;
            }
            boolean bl = convertStringToNonNull = from.isNullable() && to.isNonNull() && String.class.isAssignableFrom(fromNat) && String.class.isAssignableFrom(toNat);
            if (!convertStringToNonNull && toNat.isAssignableFrom(fromNat)) {
                return;
            }
            boolean canCast = fromNat.isAssignableFrom(toNat);
            boolean canConvertToString = toNat.isAssignableFrom(String.class);
            if (!(!canConvertToString || canCast && castPreferred)) {
                Method converter;
                if (!(String.class.isAssignableFrom(fromNat) || to.isNullable() && (from.isNullable() || fromNat.isAssignableFrom(String.class)) || Modifier.isStatic((converter = this.stringConversionMethod(from)).getModifiers()))) {
                    this.generateContext();
                }
                return;
            }
            if (canCast) {
                return;
            }
            this.typeError(from, to);
        }

        private void typeConvertEnd(Expression.Conversion conversion) {
            Type from = conversion.getFromType();
            if (from == null) {
                return;
            }
            Type to = conversion.getToType();
            this.typeConvertEnd(from, to, conversion.isCastPreferred());
        }

        private void typeConvertEnd(Type from, Type to, boolean castPreferred) {
            boolean convertStringToNonNull;
            Class<?> fromNat = from.getNaturalClass();
            Class<?> toNat = to.getNaturalClass();
            if (fromNat.isArray() && toNat.isArray()) {
                if (fromNat != toNat) {
                    this.convertArray(from, to);
                }
                return;
            }
            if (from.isPrimitive()) {
                Class<?> toObj;
                if (to.isPrimitive()) {
                    this.mBuilder.convert(JavaClassGenerator.makeDesc(from), JavaClassGenerator.makeDesc(to));
                    return;
                }
                Class<?> fromObj = from.getObjectClass();
                if (fromObj == (toObj = to.getObjectClass())) {
                    if (fromObj == Boolean.class) {
                        TypeDesc td = JavaClassGenerator.makeDesc(Boolean.class);
                        Label falseLabel = this.mBuilder.createLabel();
                        Label endLabel = this.mBuilder.createLabel();
                        this.mBuilder.ifZeroComparisonBranch((Location)falseLabel, "==");
                        this.mBuilder.loadStaticField("java.lang.Boolean", "TRUE", td);
                        this.mBuilder.branch((Location)endLabel);
                        falseLabel.setLocation();
                        this.mBuilder.loadStaticField("java.lang.Boolean", "FALSE", td);
                        endLabel.setLocation();
                    } else if (fromObj == Integer.class) {
                        this.mBuilder.invokeStatic("org.teatrove.trove.util.IntegerFactory", "toInteger", JavaClassGenerator.makeDesc(Integer.class), cIntParam);
                    } else {
                        TypeDesc[] param = new TypeDesc[]{JavaClassGenerator.makeDesc(from)};
                        this.mBuilder.invokeConstructor(toObj.getName(), param);
                    }
                    return;
                }
            } else if (to.isPrimitive()) {
                if (Number.class.isAssignableFrom(from.getObjectClass()) && Number.class.isAssignableFrom(to.getObjectClass())) {
                    String methodName = null;
                    if (toNat == Integer.TYPE) {
                        methodName = "intValue";
                    } else if (toNat == Float.TYPE) {
                        methodName = "floatValue";
                    } else if (toNat == Long.TYPE) {
                        methodName = "longValue";
                    } else if (toNat == Double.TYPE) {
                        methodName = "doubleValue";
                    }
                    if (methodName != null) {
                        this.mBuilder.invokeVirtual("java.lang.Number", methodName, JavaClassGenerator.makeDesc(toNat), new TypeDesc[0]);
                        return;
                    }
                } else {
                    if (from.getObjectClass() == Boolean.class && toNat == Boolean.TYPE) {
                        this.mBuilder.invokeVirtual("java.lang.Boolean", "booleanValue", JavaClassGenerator.makeDesc(toNat), new TypeDesc[0]);
                        return;
                    }
                    if (from.getObjectClass() == Character.class && toNat == Character.TYPE) {
                        this.mBuilder.invokeVirtual("java.lang.Character", "charValue", JavaClassGenerator.makeDesc(toNat), new TypeDesc[0]);
                        return;
                    }
                }
            } else if (Number.class.isAssignableFrom(fromNat) && Number.class.isAssignableFrom(toNat)) {
                if (fromNat == toNat) {
                    return;
                }
                this.mBuilder.loadStaticField(toNat.getName(), "TYPE", JavaClassGenerator.makeDesc(Class.class));
                this.mBuilder.invokeStatic("org.teatrove.tea.runtime.WrapperTypeConversionUtil", "convert", JavaClassGenerator.makeDesc(Number.class), new TypeDesc[]{JavaClassGenerator.makeDesc(Number.class), JavaClassGenerator.makeDesc(Class.class)});
                this.mBuilder.checkCast(JavaClassGenerator.makeDesc(toNat));
                return;
            }
            boolean bl = convertStringToNonNull = from.isNullable() && to.isNonNull() && String.class.isAssignableFrom(fromNat) && String.class.isAssignableFrom(toNat);
            if (!convertStringToNonNull && toNat.isAssignableFrom(fromNat)) {
                return;
            }
            boolean canCast = fromNat.isAssignableFrom(toNat);
            boolean canConvertToString = toNat.isAssignableFrom(String.class);
            if (!(!canConvertToString || canCast && castPreferred)) {
                Method converter = this.stringConversionMethod(from);
                if (String.class.isAssignableFrom(fromNat)) {
                    this.mBuilder.dup();
                    Label nonNullLabel = this.mBuilder.createLabel();
                    this.mBuilder.ifNullBranch((Location)nonNullLabel, false);
                    if (!Modifier.isStatic(converter.getModifiers())) {
                        this.generateContext();
                        this.mBuilder.swap();
                    }
                    this.mBuilder.invoke(converter);
                    nonNullLabel.setLocation();
                } else if (to.isNullable() && (from.isNullable() || fromNat.isAssignableFrom(String.class))) {
                    Label castLabel = this.mBuilder.createLabel();
                    if (from.isNullable()) {
                        this.mBuilder.dup();
                        this.mBuilder.ifNullBranch((Location)castLabel, true);
                    }
                    if (fromNat.isAssignableFrom(String.class)) {
                        this.mBuilder.dup();
                        this.mBuilder.instanceOf(TypeDesc.STRING);
                        this.mBuilder.ifZeroComparisonBranch((Location)castLabel, "!=");
                    }
                    if (!Modifier.isStatic(converter.getModifiers())) {
                        this.generateContext();
                        this.mBuilder.swap();
                    }
                    this.mBuilder.invoke(converter);
                    Label continueLabel = this.mBuilder.createLabel();
                    this.mBuilder.branch((Location)continueLabel);
                    castLabel.setLocation();
                    this.mBuilder.checkCast(TypeDesc.STRING);
                    continueLabel.setLocation();
                } else {
                    this.mBuilder.invoke(converter);
                }
                return;
            }
            if (canCast) {
                if (from != Type.NULL_TYPE) {
                    this.mBuilder.checkCast(JavaClassGenerator.makeDesc(toNat));
                }
                return;
            }
            this.typeError(from, to);
        }

        private Method stringConversionMethod(Type from) {
            Compiler c = JavaClassGenerator.this.mUnit.getCompiler();
            Method[] methods = c.getStringConverterMethods();
            Type[] param = new Type[]{from};
            int cnt = MethodMatcher.match(methods, null, param);
            if (cnt >= 1) {
                return methods[0];
            }
            throw new RuntimeException("Couldn't convert " + from + " to String");
        }

        private void typeError(Type from, Type to) {
            throw new RuntimeException("Can't convert " + from + " to " + to);
        }

        private void convertArray(Type from, Type to) {
            Label endLabel;
            Type toElement;
            Type fromElement;
            try {
                fromElement = from.getArrayElementType();
                toElement = to.getArrayElementType();
            }
            catch (IntrospectionException e) {
                throw new RuntimeException(e.toString());
            }
            TypeDesc originalType = JavaClassGenerator.makeDesc(from);
            LocalVariable originalArray = this.mBuilder.createLocalVariable("originalArray", originalType);
            LocalVariable length = this.mBuilder.createLocalVariable("length", TypeDesc.INT);
            this.mBuilder.storeLocal(originalArray);
            if (from.isNonNull()) {
                endLabel = null;
            } else {
                this.mBuilder.loadLocal(originalArray);
                Label startLabel = this.mBuilder.createLabel();
                this.mBuilder.ifNullBranch((Location)startLabel, false);
                this.mBuilder.loadConstant(null);
                endLabel = this.mBuilder.createLabel();
                this.mBuilder.branch((Location)endLabel);
                startLabel.setLocation();
            }
            this.mBuilder.loadLocal(originalArray);
            this.mBuilder.arrayLength();
            this.mBuilder.storeLocal(length);
            this.mBuilder.loadLocal(length);
            this.mBuilder.newObject(JavaClassGenerator.makeDesc(to));
            Label testLabel = this.mBuilder.createLabel();
            this.mBuilder.branch((Location)testLabel);
            Label loopLabel = this.mBuilder.createLabel().setLocation();
            this.mBuilder.dup();
            this.mBuilder.loadLocal(length);
            this.typeConvertBegin(fromElement, toElement, false);
            this.mBuilder.loadLocal(originalArray);
            this.mBuilder.loadLocal(length);
            this.mBuilder.loadFromArray(JavaClassGenerator.makeDesc(fromElement));
            this.typeConvertEnd(fromElement, toElement, false);
            this.mBuilder.storeToArray(JavaClassGenerator.makeDesc(toElement));
            testLabel.setLocation();
            this.mBuilder.integerIncrement(length, -1);
            this.mBuilder.loadLocal(length);
            this.mBuilder.ifZeroComparisonBranch((Location)loopLabel, ">=");
            if (endLabel != null) {
                endLabel.setLocation();
            }
        }

        private void saveContinueLabel(Label startLabel) {
            Object top = this.mBreakInfoStack.get(this.mBreakInfoStack.size() - 1);
            if (!(top instanceof BreakAndContinueLabels)) {
                throw new IllegalArgumentException("Internal compiler error: Break stack - unexpected object found.");
            }
            ((BreakAndContinueLabels)top).setContinueLabel(startLabel);
        }

        private void generateForeachArray(ForeachStatement node) {
            Expression range = node.getRange();
            Statement init = node.getInitializer();
            Block body = node.getBody();
            final LocalVariable indexLocal = this.mBuilder.createLocalVariable(null, TypeDesc.INT);
            TypeDesc rangeDesc = JavaClassGenerator.makeDesc(range.getType(), false);
            final LocalVariable rangeLocal = this.mBuilder.createLocalVariable(null, rangeDesc);
            this.generate(range);
            this.mBuilder.storeLocal(rangeLocal);
            if (init != null) {
                this.generate(init);
            }
            Label endLabel = this.mBuilder.createLabel();
            if (range.getType().isNullable()) {
                this.mBuilder.loadLocal(rangeLocal);
                this.mBuilder.ifNullBranch((Location)endLabel, true);
            }
            this.mBuilder.loadLocal(rangeLocal);
            this.mBuilder.arrayLength();
            LocalVariable endIndexLocal = null;
            if (!node.isReverse()) {
                endIndexLocal = this.mBuilder.createLocalVariable(null, TypeDesc.INT);
                this.mBuilder.storeLocal(endIndexLocal);
                this.mBuilder.loadConstant(0);
                this.mBuilder.storeLocal(indexLocal);
            } else {
                this.mBuilder.storeLocal(indexLocal);
            }
            Label checkLabel = this.mBuilder.createLabel();
            this.mBuilder.branch((Location)checkLabel);
            Label startLabel = this.mBuilder.createLabel().setLocation();
            Label continueLabel = this.mBuilder.createLabel();
            this.saveContinueLabel(continueLabel);
            final VariableRef loopVarRef = node.getLoopVariable();
            final Class<?> loopVarClass = loopVarRef.getType().getNaturalClass();
            final Class<?> rangeComponentClass = range.getType().getObjectClass().getComponentType();
            this.storeToVariable(loopVarRef.getVariable(), new Runnable(){

                @Override
                public void run() {
                    Visitor.this.mBuilder.loadLocal(rangeLocal);
                    Visitor.this.mBuilder.loadLocal(indexLocal);
                    Visitor.this.mBuilder.loadFromArray(JavaClassGenerator.makeDesc(loopVarRef.getType()));
                    if (loopVarClass != rangeComponentClass) {
                        Visitor.this.mBuilder.checkCast(JavaClassGenerator.makeDesc(loopVarRef.getType()));
                    }
                }
            });
            if (body != null) {
                this.generate(body);
            }
            continueLabel.setLocation();
            if (!node.isReverse()) {
                this.mBuilder.integerIncrement(indexLocal, 1);
                checkLabel.setLocation();
                this.mBuilder.loadLocal(indexLocal);
                this.mBuilder.loadLocal(endIndexLocal);
                this.mBuilder.ifComparisonBranch((Location)startLabel, "<");
            } else {
                checkLabel.setLocation();
                this.mBuilder.integerIncrement(indexLocal, -1);
                this.mBuilder.loadLocal(indexLocal);
                this.mBuilder.ifZeroComparisonBranch((Location)startLabel, ">=");
            }
            endLabel.setLocation();
        }

        private void generateForeachIterator(final ForeachStatement node) {
            TypeDesc td;
            Expression range = node.getRange();
            Statement init = node.getInitializer();
            Block body = node.getBody();
            if (!"java.util.List".equals(range.getType().getNaturalClass().getName()) && node.isReverse()) {
                this.mBuilder.newObject(JavaClassGenerator.makeDesc(ArrayList.class));
                this.mBuilder.dup();
            }
            this.generate(range);
            if ("java.util.Map".equals(range.getType().getNaturalClass().getName())) {
                this.mBuilder.invokeInterface("java.util.Map", "keySet", JavaClassGenerator.makeDesc(Set.class), new TypeDesc[0]);
            }
            if (!"java.util.List".equals(range.getType().getNaturalClass().getName()) && node.isReverse()) {
                this.mBuilder.invokeConstructor("java.util.ArrayList", new TypeDesc[]{JavaClassGenerator.makeDesc(Collection.class)});
            }
            if (init != null) {
                this.generate(init);
            }
            Label endLabel = this.mBuilder.createLabel();
            Label notNullLabel = this.mBuilder.createLabel();
            if (range.getType().isNullable()) {
                this.mBuilder.dup();
                this.mBuilder.ifNullBranch((Location)notNullLabel, false);
                this.mBuilder.pop();
                this.mBuilder.branch((Location)endLabel);
            }
            notNullLabel.setLocation();
            if (!node.isReverse()) {
                td = JavaClassGenerator.makeDesc(Iterator.class);
                this.mBuilder.invokeInterface("java.lang.Iterable", "iterator", td, new TypeDesc[0]);
            } else {
                this.mBuilder.dup();
                this.mBuilder.invokeInterface("java.util.Collection", "size", TypeDesc.INT, new TypeDesc[0]);
                td = JavaClassGenerator.makeDesc(ListIterator.class);
                this.mBuilder.invokeInterface("java.util.List", "listIterator", td, cIntParam);
            }
            final LocalVariable iteratorLocal = this.mBuilder.createLocalVariable(null, td);
            this.mBuilder.storeLocal(iteratorLocal);
            Label checkLabel = this.mBuilder.createLabel();
            this.mBuilder.branch((Location)checkLabel);
            Label startLabel = this.mBuilder.createLabel().setLocation();
            Label continueLabel = this.mBuilder.createLabel();
            this.saveContinueLabel(continueLabel);
            final VariableRef loopVarRef = node.getLoopVariable();
            final Class<?> loopVarClass = loopVarRef.getType().getNaturalClass();
            this.storeToVariable(loopVarRef.getVariable(), new Runnable(){

                @Override
                public void run() {
                    Visitor.this.mBuilder.loadLocal(iteratorLocal);
                    if (!node.isReverse()) {
                        Visitor.this.mBuilder.invokeInterface("java.util.Iterator", "next", TypeDesc.OBJECT, new TypeDesc[0]);
                    } else {
                        Visitor.this.mBuilder.invokeInterface("java.util.ListIterator", "previous", TypeDesc.OBJECT, new TypeDesc[0]);
                    }
                    if (loopVarClass != Object.class) {
                        Visitor.this.mBuilder.checkCast(JavaClassGenerator.makeDesc(loopVarRef.getType()));
                    }
                }
            });
            if (body != null) {
                this.generate(body);
            }
            continueLabel.setLocation();
            checkLabel.setLocation();
            this.mBuilder.loadLocal(iteratorLocal);
            td = TypeDesc.BOOLEAN;
            if (!node.isReverse()) {
                this.mBuilder.invokeInterface("java.util.Iterator", "hasNext", td, new TypeDesc[0]);
            } else {
                this.mBuilder.invokeInterface("java.util.ListIterator", "hasPrevious", td, new TypeDesc[0]);
            }
            this.mBuilder.ifZeroComparisonBranch((Location)startLabel, "!=");
            endLabel.setLocation();
        }

        private void generateForeachRange(ForeachStatement node) {
            String choice;
            Expression endIndexExpr;
            Expression indexExpr;
            Expression range = node.getRange();
            Expression endRange = node.getEndRange();
            Statement init = node.getInitializer();
            Block body = node.getBody();
            LocalVariable endIndexLocal = null;
            long endIndexValue = 0L;
            if (!node.isReverse()) {
                indexExpr = range;
                endIndexExpr = endRange;
            } else {
                indexExpr = endRange;
                endIndexExpr = range;
            }
            VariableRef loopVarRef = node.getLoopVariable();
            Variable loopVar = loopVarRef.getVariable();
            this.storeToVariable(loopVar, new Runnable(){

                @Override
                public void run() {
                    Visitor.this.generate(indexExpr);
                }
            });
            boolean longRange = Type.LONG_TYPE.equals(loopVar.getType());
            if (endIndexExpr.isValueKnown()) {
                endIndexValue = ((Number)endIndexExpr.getValue()).longValue();
            } else {
                this.generate(endIndexExpr);
                endIndexLocal = longRange ? this.mBuilder.createLocalVariable(null, TypeDesc.LONG) : this.mBuilder.createLocalVariable(null, TypeDesc.INT);
                this.mBuilder.storeLocal(endIndexLocal);
            }
            if (init != null) {
                this.generate(init);
            }
            Label checkLabel = this.mBuilder.createLabel();
            this.mBuilder.branch((Location)checkLabel);
            Label startLabel = this.mBuilder.createLabel().setLocation();
            Label continueLabel = this.mBuilder.createLabel();
            this.saveContinueLabel(continueLabel);
            if (body != null) {
                this.generate(body);
            }
            continueLabel.setLocation();
            if (!node.isReverse()) {
                this.incrementIntVariable(loopVar, 1);
                choice = "<=";
            } else {
                this.incrementIntVariable(loopVar, -1);
                choice = ">=";
            }
            checkLabel.setLocation();
            this.loadFromVariable(loopVar);
            if (endIndexLocal != null) {
                this.mBuilder.loadLocal(endIndexLocal);
                if (longRange) {
                    this.mBuilder.math((byte)-108);
                    this.mBuilder.ifZeroComparisonBranch((Location)startLabel, choice);
                } else {
                    this.mBuilder.ifComparisonBranch((Location)startLabel, choice);
                }
            } else if (longRange) {
                this.mBuilder.loadConstant(endIndexValue);
                this.mBuilder.math((byte)-108);
                this.mBuilder.ifZeroComparisonBranch((Location)startLabel, choice);
            } else if (endIndexValue != 0L) {
                this.mBuilder.loadConstant((int)endIndexValue);
                this.mBuilder.ifComparisonBranch((Location)startLabel, choice);
            } else {
                this.mBuilder.ifZeroComparisonBranch((Location)startLabel, choice);
            }
        }

        private void generateCallExpression(final CallExpression node) {
            final Expression expr = node.getExpression();
            if (expr != null) {
                this.generate(expr);
            }
            NullSafeCallback callback = new NullSafeCallback(){

                @Override
                public Type execute() {
                    int blockNum;
                    Statement init = node.getInitializer();
                    Block subParam = node.getSubstitutionParam();
                    Expression[] exprs = node.getParams().getExpressions();
                    if (subParam != null) {
                        blockNum = Visitor.this.mCaseNodes.size() - 1;
                        Visitor.this.mBuilder.loadThis();
                        Visitor.this.mBuilder.loadConstant(blockNum + 1);
                        Visitor.this.mBuilder.storeField(Visitor.this.mBlockId.getName(), TypeDesc.INT);
                        Visitor.this.mCaseNodes.add(subParam);
                        if (node instanceof FunctionCallExpression) {
                            Method call = ((FunctionCallExpression)node).getCalledMethod();
                            JavaClassGenerator.this.mCallerToSubNoList.add("__block_" + call.getName());
                        }
                        if (node instanceof TemplateCallExpression) {
                            CompilationUnit unit = ((TemplateCallExpression)node).getCalledTemplate();
                            JavaClassGenerator.this.mCallerToSubNoList.add("__block__" + unit.getName());
                        }
                    } else {
                        blockNum = 0;
                    }
                    TypeDesc methodObserverType = TypeDesc.forClass(MergedClass.InvocationEventObserver.class);
                    LocalVariable retVal = null;
                    String calleeName = null;
                    Type returnType = null;
                    TypeDesc returnTypeDesc = null;
                    boolean profilingEnabled = JavaClassGenerator.this.isProfilingEnabled();
                    if (profilingEnabled) {
                        if (Visitor.this.mStartTime == null) {
                            Visitor.this.mStartTime = Visitor.this.mBuilder.createLocalVariable("startTime", TypeDesc.forClass(Long.TYPE));
                        }
                        Visitor.this.mBuilder.invokeStatic(Visitor.this.mContextParam.getVariable().getType().getObjectClass().getName(), "getInvocationObserver", methodObserverType, new TypeDesc[0]);
                        Visitor.this.mBuilder.invokeInterface(methodObserverType.getFullName(), "currentTime", TypeDesc.forClass(Long.TYPE), new TypeDesc[0]);
                        Visitor.this.mBuilder.storeLocal(Visitor.this.mStartTime);
                    }
                    if (node instanceof FunctionCallExpression) {
                        FunctionCallExpression function = (FunctionCallExpression)node;
                        Method call = function.getCalledMethod();
                        if (expr == null && !Modifier.isStatic(call.getModifiers())) {
                            Visitor.this.generateContext();
                        }
                        Class<?>[] params = call.getParameterTypes();
                        for (int i = 0; i < exprs.length; ++i) {
                            Class<?> type;
                            if (call.isVarArgs() && i == params.length - 1 && !params[i].isAssignableFrom(type = exprs[i].getType().getNaturalClass())) {
                                Visitor.this.mBuilder.loadConstant(exprs.length);
                                TypeDesc desc = JavaClassGenerator.makeDesc(params[i]);
                                Visitor.this.mBuilder.newObject(desc, 1);
                                int idx = 0;
                                int j = i;
                                while (j < exprs.length) {
                                    Visitor.this.mBuilder.dup();
                                    Visitor.this.mBuilder.loadConstant(idx);
                                    Visitor.this.generate(exprs[j]);
                                    Visitor.this.mBuilder.storeToArray(desc.getComponentType());
                                    ++j;
                                    ++idx;
                                }
                                break;
                            }
                            Visitor.this.generate(exprs[i]);
                        }
                        if (call.isVarArgs() && exprs.length < params.length) {
                            Visitor.this.mBuilder.loadConstant(0);
                            Visitor.this.mBuilder.newObject(JavaClassGenerator.makeDesc(params[params.length - 1]), 1);
                        }
                        if (subParam != null) {
                            Visitor.this.mBuilder.loadThis();
                        }
                        if (init != null) {
                            Visitor.this.generate(init);
                        }
                        if (call.getReturnType() != null) {
                            returnType = new Type(call.getReturnType(), call.getGenericReturnType());
                            returnTypeDesc = JavaClassGenerator.makeDesc(returnType);
                            retVal = Visitor.this.mBuilder.createLocalVariable("retVal", returnTypeDesc);
                        }
                        Visitor.this.mBuilder.invoke(call);
                        calleeName = call.getName();
                    } else if (node instanceof TemplateCallExpression) {
                        TypeDesc[] params;
                        String className;
                        CompilationUnit unit = ((TemplateCallExpression)node).getCalledTemplate();
                        if (expr == null) {
                            Visitor.this.generateContext();
                        }
                        for (int i = 0; i < exprs.length; ++i) {
                            Visitor.this.generate(exprs[i]);
                        }
                        if (init != null) {
                            Visitor.this.generate(init);
                        }
                        className = (className = unit.getTargetPackage()) == null ? unit.getName() : className + '.' + unit.getName();
                        Template tree = unit.getParseTree();
                        Variable[] formals = tree.getParams();
                        int length = formals.length;
                        if (subParam == null) {
                            params = new TypeDesc[length + 1];
                        } else {
                            params = new TypeDesc[length + 2];
                            params[params.length - 1] = JavaClassGenerator.makeDesc(Substitution.class);
                            Visitor.this.mBuilder.loadThis();
                        }
                        params[0] = JavaClassGenerator.makeDesc(unit.getRuntimeContext());
                        for (int i = 0; i < length; ++i) {
                            params[i + 1] = JavaClassGenerator.makeDesc(formals[i]);
                        }
                        if (tree.getReturnType() != null) {
                            returnType = tree.getReturnType();
                            returnTypeDesc = JavaClassGenerator.makeDesc(tree.getReturnType());
                            retVal = Visitor.this.mBuilder.createLocalVariable("retVal", returnTypeDesc);
                        }
                        calleeName = "_" + unit.getName();
                        Visitor.this.mBuilder.invokeStatic(className, JavaClassGenerator.EXECUTE_METHOD_NAME, returnTypeDesc, params);
                    }
                    if (returnTypeDesc != null && !TypeDesc.VOID.equals(returnTypeDesc)) {
                        Visitor.this.mBuilder.storeLocal(retVal);
                    }
                    if (profilingEnabled) {
                        Visitor.this.mBuilder.invokeStatic(Visitor.this.mContextParam.getVariable().getType().getObjectClass().getName(), "getInvocationObserver", methodObserverType, new TypeDesc[0]);
                        Visitor.this.mBuilder.loadConstant(JavaClassGenerator.this.mUnit.getName());
                        Visitor.this.mBuilder.loadConstant(calleeName);
                        Visitor.this.mBuilder.invokeStatic(Visitor.this.mContextParam.getVariable().getType().getObjectClass().getName(), "getInvocationObserver", methodObserverType, new TypeDesc[0]);
                        Visitor.this.mBuilder.invokeInterface(methodObserverType.getFullName(), "currentTime", TypeDesc.forClass(Long.TYPE), new TypeDesc[0]);
                        Visitor.this.mBuilder.loadLocal(Visitor.this.mStartTime);
                        Visitor.this.mBuilder.math((byte)101);
                        Visitor.this.mBuilder.invokeInterface(methodObserverType.getFullName(), "invokedEvent", null, new TypeDesc[]{TypeDesc.forClass(String.class), TypeDesc.forClass(String.class), TypeDesc.forClass(Long.TYPE)});
                    }
                    if (returnTypeDesc != null && !TypeDesc.VOID.equals(returnTypeDesc)) {
                        Visitor.this.mBuilder.loadLocal(retVal);
                    }
                    if (subParam != null) {
                        Visitor.this.mBuilder.loadThis();
                        Visitor.this.mBuilder.loadConstant(blockNum);
                        Visitor.this.mBuilder.storeField(Visitor.this.mBlockId.getName(), TypeDesc.INT);
                    }
                    return returnType;
                }
            };
            if (expr != null) {
                this.generateNullSafe(node, expr, callback);
            } else {
                callback.execute();
            }
        }

        private void generateLogical(Expression expr) {
            Label trueLabel = this.mBuilder.createLabel();
            Label endLabel = this.mBuilder.createLabel();
            this.generateBranch(expr, trueLabel, true);
            Type type = expr.getInitialType();
            Class<Object> clazz = type.getNaturalClass();
            if (clazz == Boolean.TYPE) {
                this.mBuilder.loadConstant(false);
                this.mBuilder.branch((Location)endLabel);
                trueLabel.setLocation();
                this.mBuilder.loadConstant(true);
                endLabel.setLocation();
            } else if (clazz.isAssignableFrom(Boolean.class)) {
                TypeDesc td = JavaClassGenerator.makeDesc(Boolean.class);
                this.mBuilder.loadStaticField("java.lang.Boolean", "FALSE", td);
                this.mBuilder.branch((Location)endLabel);
                trueLabel.setLocation();
                this.mBuilder.loadStaticField("java.lang.Boolean", "TRUE", td);
                endLabel.setLocation();
            } else if (clazz.isAssignableFrom(String.class)) {
                this.mBuilder.loadConstant("false");
                this.mBuilder.branch((Location)endLabel);
                trueLabel.setLocation();
                this.mBuilder.loadConstant("true");
                endLabel.setLocation();
            } else {
                this.typeError(Type.BOOLEAN_TYPE, type);
            }
        }

        private void generateNullSafe(Expression node, Expression expr, NullSafeCallback callback) {
            NullSafe nullSafe;
            NullSafe nullSafe2;
            Label endLocation = null;
            Label elseLocation = null;
            if (node instanceof NullSafe && (nullSafe2 = (NullSafe)((Object)node)).isNullSafe() && expr.getType().isNullable()) {
                endLocation = this.mBuilder.createLabel();
                elseLocation = this.mBuilder.createLabel();
                this.mBuilder.dup();
                this.mBuilder.ifNullBranch((Location)elseLocation, true);
            }
            Type rtype = callback.execute();
            if (node instanceof NullSafe && (nullSafe = (NullSafe)((Object)node)).isNullSafe() && expr.getType().isNullable()) {
                Type ntype;
                this.mBuilder.branch((Location)endLocation);
                elseLocation.setLocation();
                Type type = ntype = rtype == null ? node.getType() : rtype;
                if (ntype != null && ntype.isPrimitive()) {
                    this.mBuilder.pop();
                    Class<?> primitive = ntype.getNaturalClass();
                    if (primitive == Boolean.TYPE) {
                        this.mBuilder.loadConstant(false);
                    } else if (primitive == Long.TYPE) {
                        this.mBuilder.loadConstant(0L);
                    } else if (primitive == Float.TYPE) {
                        this.mBuilder.loadConstant(0.0f);
                    } else if (primitive == Double.TYPE) {
                        this.mBuilder.loadConstant(0.0);
                    } else {
                        this.mBuilder.loadConstant(0);
                    }
                } else {
                    this.mBuilder.checkCast(JavaClassGenerator.makeDesc(ntype));
                }
                endLocation.setLocation();
            }
        }

        private AssignmentStatement createAssignment(Expression expr) {
            return this.createAssignment("tmp" + JavaClassGenerator.this.mTemporary++, expr);
        }

        private AssignmentStatement createAssignment(String name, Expression expr) {
            Type type = expr.getType();
            SourceInfo info = expr.getSourceInfo();
            Variable var = new Variable(info, name, type);
            this.generate(var);
            VariableRef ref = new VariableRef(info, name);
            ref.setVariable(var);
            AssignmentStatement stmt = new AssignmentStatement(info, ref, expr);
            this.generate(stmt);
            return stmt;
        }

        private void declareVariable(Variable node) {
            this.declareVariable(node, null);
        }

        private void declareVariable(Variable var, LocalVariable localVar) {
            String name = var.getName();
            if (name == JavaClassGenerator.CONTEXT_PARAM_NAME) {
                this.mContextParam = new VariableRef(null, name);
                this.mContextParam.setVariable(var);
            } else if (name == JavaClassGenerator.SUB_PARAM_NAME) {
                this.mSubParam = new VariableRef(null, name);
                this.mSubParam.setVariable(var);
            }
            if (var.isField()) {
                if (JavaClassGenerator.this.mFields.get(name) != var) {
                    int i = 0;
                    do {
                        name = var.getName() + '$' + i++;
                    } while (JavaClassGenerator.this.mFields.get(name) != null);
                    JavaClassGenerator.this.mFields.put(name, var);
                    var.setName(name);
                }
                this.mVariableMap.put(var, null);
            } else {
                if (localVar == null) {
                    TypeDesc desc = JavaClassGenerator.makeDesc(var);
                    localVar = this.mBuilder.createLocalVariable(var.getName(), desc);
                }
                this.mVariableMap.put(var, localVar);
            }
        }

        private LocalVariable getLocalVariable(Variable var) {
            if (!this.mVariableMap.containsKey(var)) {
                this.declareVariable(var, null);
            }
            return this.mVariableMap.get(var);
        }

        private void loadFromVariable(Variable var) {
            if (var.isField()) {
                if (!this.mVariableMap.containsKey(var)) {
                    this.declareVariable(var, null);
                }
                TypeDesc td = JavaClassGenerator.makeDesc(var);
                if (var.isStatic()) {
                    this.mBuilder.loadStaticField(var.getName(), td);
                } else {
                    this.mBuilder.loadThis();
                    this.mBuilder.loadField(var.getName(), td);
                }
            } else {
                LocalVariable local = this.mVariableMap.get(var);
                if (local == null) {
                    throw new RuntimeException("Attempting to read from uninitialized local variable: " + var);
                }
                this.mBuilder.loadLocal(local);
            }
        }

        private void storeToVariable(Variable var, Runnable callback) {
            if (var.isField() && !var.isStatic()) {
                this.mBuilder.loadThis();
            }
            callback.run();
            if (var.isField()) {
                if (!this.mVariableMap.containsKey(var)) {
                    this.declareVariable(var, null);
                }
                TypeDesc td = JavaClassGenerator.makeDesc(var);
                if (var.isStatic()) {
                    this.mBuilder.storeStaticField(var.getName(), td);
                } else {
                    this.mBuilder.storeField(var.getName(), td);
                }
            } else {
                this.mBuilder.storeLocal(this.getLocalVariable(var));
            }
        }

        private void incrementIntVariable(final Variable var, final int amount) {
            if (amount == 0) {
                return;
            }
            final Class<?> clazz = var.getType().getNaturalClass();
            LocalVariable local = this.getLocalVariable(var);
            if (local != null && clazz == Integer.TYPE) {
                this.mBuilder.integerIncrement(local, amount);
            } else {
                this.storeToVariable(var, new Runnable(){

                    @Override
                    public void run() {
                        Visitor.this.loadFromVariable(var);
                        if (clazz == Integer.TYPE) {
                            if (amount >= 0) {
                                Visitor.this.mBuilder.loadConstant(amount);
                                Visitor.this.mBuilder.math((byte)96);
                            } else {
                                Visitor.this.mBuilder.loadConstant(-amount);
                                Visitor.this.mBuilder.math((byte)100);
                            }
                        } else if (clazz == Long.TYPE) {
                            if (amount >= 0) {
                                Visitor.this.mBuilder.loadConstant((long)amount);
                                Visitor.this.mBuilder.math((byte)97);
                            } else {
                                Visitor.this.mBuilder.loadConstant((long)(-amount));
                                Visitor.this.mBuilder.math((byte)101);
                            }
                        }
                    }
                });
            }
        }

        private void setLineNumber(SourceInfo info) {
            int line;
            if (info != null && (line = info.getLine()) != this.mLastLine) {
                this.mLastLine = line;
                this.mBuilder.mapLineNumber(line);
            }
        }
    }
}

