/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.compiler;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.WeakHashMap;

class MessageFormatter {
    private static Map<Class<?>, MessageFormatter> cMessageFormatters;
    private ResourceBundle mResources;

    public static MessageFormatter lookup(Object user) throws MissingResourceException {
        return MessageFormatter.lookup(user.getClass());
    }

    private static MessageFormatter lookup(Class<?> clazz) {
        MessageFormatter formatter = cMessageFormatters.get(clazz);
        if (formatter == null) {
            String className = clazz.getName();
            int index = className.lastIndexOf(46);
            String resourcesName = index >= 0 ? className.substring(0, index + 1) + "resources." + className.substring(index + 1) : "resources." + className;
            try {
                formatter = new MessageFormatter(ResourceBundle.getBundle(resourcesName));
            }
            catch (MissingResourceException e) {
                if (clazz.getSuperclass() == null) {
                    throw e;
                }
                try {
                    formatter = MessageFormatter.lookup(clazz.getSuperclass());
                }
                catch (MissingResourceException e2) {
                    throw e;
                }
            }
            cMessageFormatters.put(clazz, formatter);
        }
        return formatter;
    }

    private MessageFormatter(ResourceBundle resources) {
        this.mResources = resources;
    }

    public String format(String key) {
        String message = null;
        try {
            message = this.mResources.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (message != null) {
            return message;
        }
        return key;
    }

    public String format(String key, String arg) {
        String message = null;
        try {
            message = this.mResources.getString(key);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        if (message != null) {
            return MessageFormat.format(message, arg);
        }
        return key + ": " + arg;
    }

    public String format(String key, String arg1, String arg2) {
        String message = null;
        try {
            message = this.mResources.getString(key);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        if (message != null) {
            return MessageFormat.format(message, arg1, arg2);
        }
        return key + ": " + arg1 + ", " + arg2;
    }

    public String format(String key, String arg1, String arg2, String arg3) {
        String message = null;
        try {
            message = this.mResources.getString(key);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        if (message != null) {
            return MessageFormat.format(message, arg1, arg2, arg3);
        }
        return key + ": " + arg1 + ", " + arg2 + ", " + arg3;
    }

    static {
        try {
            cMessageFormatters = new WeakHashMap(7);
        }
        catch (LinkageError e) {
            cMessageFormatters = new HashMap(7);
        }
        catch (Exception e) {
            cMessageFormatters = new HashMap(7);
        }
    }
}

