/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.compiler;

import java.beans.IntrospectionException;
import java.lang.reflect.Method;
import org.teatrove.tea.compiler.Type;

public class MethodMatcher {
    public static int match(Method[] methods, String name, Type ... params) {
        Method m;
        int i;
        int paramCount = params.length;
        int matchCount = methods.length;
        int[] costs = new int[matchCount];
        int lowestTotalCost = Integer.MAX_VALUE;
        int length = matchCount;
        matchCount = 0;
        for (i = 0; i < length; ++i) {
            Type methodParam;
            int cost;
            int j;
            Class<?>[] methodParams;
            int cnt;
            m = methods[i];
            if (name != null && !m.getName().equals(name) || (cnt = (methodParams = m.getParameterTypes()).length) != paramCount && (!m.isVarArgs() || paramCount < cnt - 1)) continue;
            int total = 0;
            for (j = 0; j < paramCount && (cost = (methodParam = MethodMatcher.getMethodParam(m, j, params[j])).convertableFrom(params[j])) >= 0; ++j) {
                total += cost;
            }
            if (j != paramCount) continue;
            if (!m.isVarArgs() || j < methodParams.length) {
                // empty if block
            }
            costs[matchCount] = ++total;
            methods[matchCount++] = m;
            if (total >= lowestTotalCost) continue;
            lowestTotalCost = total;
        }
        if (matchCount <= 1) {
            return matchCount;
        }
        length = matchCount;
        matchCount = 0;
        for (i = 0; i < length; ++i) {
            if (costs[i] > lowestTotalCost) continue;
            costs[matchCount] = costs[i];
            methods[matchCount++] = methods[i];
        }
        if (matchCount <= 1) {
            return matchCount;
        }
        Method[] paramResults = new Method[paramCount];
        for (int j = 0; j < paramCount; ++j) {
            Class<?> lastMatch = null;
            Method bestFit = null;
            length = matchCount;
            int bestFits = 0;
            for (int i2 = 0; i2 < length; ++i2) {
                Class<?> param;
                m = methods[i2];
                Type methodType = MethodMatcher.getMethodParam(m, j, params[j]);
                Class<?> methodParam = methodType.getNaturalClass();
                if (!methodParam.isAssignableFrom(param = params[j].getNaturalClass())) continue;
                if (lastMatch != null) {
                    bestFits = lastMatch.equals(methodParam) ? ++bestFits : 0;
                }
                if (lastMatch != null && !lastMatch.isAssignableFrom(methodParam)) continue;
                bestFit = m;
                lastMatch = methodParam;
            }
            if (bestFits != 0) continue;
            paramResults[j] = bestFit;
        }
        Method last = null;
        for (int i3 = 0; i3 < paramCount; ++i3) {
            if (last == null) {
                last = paramResults[i3];
                continue;
            }
            if (last.equals(paramResults[i3])) continue;
            return -1;
        }
        if (last == null) {
            return -1;
        }
        methods[0] = last;
        return 1;
    }

    public static Type getMethodParam(Method method, int index, Type type) {
        Type result = null;
        Class<?>[] methodParams = method.getParameterTypes();
        java.lang.reflect.Type[] methodTypes = method.getGenericParameterTypes();
        if (method.isVarArgs() && index >= methodParams.length - 1) {
            int idx = methodParams.length - 1;
            Type varArg = new Type(methodParams[idx], methodTypes[idx]);
            if (index == methodParams.length - 1 && varArg.convertableFrom(type) >= 0) {
                result = varArg;
            }
            if (result == null) {
                try {
                    result = varArg.getArrayElementType();
                }
                catch (IntrospectionException ie) {
                    throw new RuntimeException(ie);
                }
            }
        } else if (index < methodParams.length) {
            result = new Type(methodParams[index], methodTypes[index]);
        }
        return result;
    }
}

