/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.compiler;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Vector;
import org.teatrove.tea.compiler.CompilationUnit;
import org.teatrove.tea.compiler.ErrorEvent;
import org.teatrove.tea.compiler.ErrorListener;
import org.teatrove.tea.compiler.MessageFormatter;
import org.teatrove.tea.compiler.Scanner;
import org.teatrove.tea.compiler.SourceInfo;
import org.teatrove.tea.compiler.Token;
import org.teatrove.tea.compiler.TreePrinter;
import org.teatrove.tea.parsetree.AndExpression;
import org.teatrove.tea.parsetree.ArithmeticExpression;
import org.teatrove.tea.parsetree.ArrayLookup;
import org.teatrove.tea.parsetree.AssignmentStatement;
import org.teatrove.tea.parsetree.Block;
import org.teatrove.tea.parsetree.BooleanLiteral;
import org.teatrove.tea.parsetree.BreakStatement;
import org.teatrove.tea.parsetree.CallExpression;
import org.teatrove.tea.parsetree.CompareExpression;
import org.teatrove.tea.parsetree.ConcatenateExpression;
import org.teatrove.tea.parsetree.ContinueStatement;
import org.teatrove.tea.parsetree.Directive;
import org.teatrove.tea.parsetree.Expression;
import org.teatrove.tea.parsetree.ExpressionList;
import org.teatrove.tea.parsetree.ExpressionStatement;
import org.teatrove.tea.parsetree.ForeachStatement;
import org.teatrove.tea.parsetree.FunctionCallExpression;
import org.teatrove.tea.parsetree.IfStatement;
import org.teatrove.tea.parsetree.ImportDirective;
import org.teatrove.tea.parsetree.Lookup;
import org.teatrove.tea.parsetree.Name;
import org.teatrove.tea.parsetree.NegateExpression;
import org.teatrove.tea.parsetree.NewArrayExpression;
import org.teatrove.tea.parsetree.NoOpExpression;
import org.teatrove.tea.parsetree.Node;
import org.teatrove.tea.parsetree.NotExpression;
import org.teatrove.tea.parsetree.NullLiteral;
import org.teatrove.tea.parsetree.NullSafe;
import org.teatrove.tea.parsetree.NumberLiteral;
import org.teatrove.tea.parsetree.OrExpression;
import org.teatrove.tea.parsetree.ParenExpression;
import org.teatrove.tea.parsetree.RelationalExpression;
import org.teatrove.tea.parsetree.SpreadExpression;
import org.teatrove.tea.parsetree.Statement;
import org.teatrove.tea.parsetree.StatementList;
import org.teatrove.tea.parsetree.StringLiteral;
import org.teatrove.tea.parsetree.SubstitutionStatement;
import org.teatrove.tea.parsetree.Template;
import org.teatrove.tea.parsetree.TemplateCallExpression;
import org.teatrove.tea.parsetree.TernaryExpression;
import org.teatrove.tea.parsetree.TypeName;
import org.teatrove.tea.parsetree.Variable;
import org.teatrove.tea.parsetree.VariableRef;
import org.teatrove.trove.io.SourceReader;

public class Parser {
    private Scanner mScanner;
    private CompilationUnit mUnit;
    private Vector<ErrorListener> mListeners = new Vector(1);
    private int mErrorCount = 0;
    private int mEOFErrorCount = 0;
    private MessageFormatter mFormatter;

    public Parser(Scanner scanner) {
        this(scanner, null);
    }

    public Parser(Scanner scanner, CompilationUnit unit) {
        this.mScanner = scanner;
        this.mUnit = unit;
        this.mFormatter = MessageFormatter.lookup(this);
    }

    public void addErrorListener(ErrorListener listener) {
        this.mListeners.addElement(listener);
    }

    public void removeErrorListener(ErrorListener listener) {
        this.mListeners.removeElement(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchParseError(ErrorEvent e) {
        ++this.mErrorCount;
        Vector<ErrorListener> vector = this.mListeners;
        synchronized (vector) {
            for (int i = 0; i < this.mListeners.size(); ++i) {
                this.mListeners.elementAt(i).compileError(e);
            }
        }
    }

    private void error(String str, Token culprit) {
        str = this.mFormatter.format(str);
        if (culprit.getID() == 1) {
            if (this.mEOFErrorCount++ == 0) {
                str = this.mFormatter.format("error.at.end", str);
            } else {
                return;
            }
        }
        this.dispatchParseError(new ErrorEvent((Object)this, str, culprit, this.mUnit));
    }

    private void error(String str, String arg, Token culprit) {
        str = this.mFormatter.format(str, arg);
        if (culprit.getID() == 1) {
            if (this.mEOFErrorCount++ == 0) {
                str = this.mFormatter.format("error.at.end", str);
            } else {
                return;
            }
        }
        this.dispatchParseError(new ErrorEvent((Object)this, str, culprit, this.mUnit));
    }

    private void error(String str, SourceInfo info) {
        str = this.mFormatter.format(str);
        this.dispatchParseError(new ErrorEvent((Object)this, str, info, this.mUnit));
    }

    public Template parse() throws IOException {
        Template t = this.parseTemplate();
        if (t != null) {
            return t;
        }
        return new Template(new SourceInfo(0, 0, 0), null, null, false, null, null);
    }

    public int getErrorCount() {
        return this.mErrorCount;
    }

    private Token read() throws IOException {
        return this.mScanner.readToken();
    }

    private Token peek() throws IOException {
        return this.mScanner.peekToken();
    }

    private void unread(Token token) throws IOException {
        this.mScanner.unreadToken(token);
    }

    private Template parseTemplate() throws IOException {
        Variable[] params = null;
        Token token = this.read();
        SourceInfo directiveInfo = token.getSourceInfo();
        ArrayList<Directive> directiveList = new ArrayList<Directive>();
        while (token.getID() == 58) {
            directiveList.add(new ImportDirective(directiveInfo, this.parseTypeName().getName()));
            token = this.read();
            if (token.getID() != 14) continue;
            token = this.read();
        }
        SourceInfo templateInfo = token.getSourceInfo();
        if (token.getID() != 53) {
            if (token.getID() == 5 && this.peek().getID() == 53) {
                this.error("template.start", token);
                token = this.read();
            } else {
                this.error("template.declaration", token);
            }
        }
        SourceInfo nameInfo = this.peek().getSourceInfo();
        Name name = new Name(nameInfo, this.parseIdentifier());
        params = this.parseFormalParameters();
        boolean subParam = false;
        token = this.peek();
        if (token.getID() == 10 || token.getID() == 18) {
            if (token.getID() == 18) {
                this.error("template.substitution.lbrace", token);
            } else {
                this.read();
                token = this.peek();
            }
            if (token.getID() == 18) {
                this.read();
                token = this.peek();
                if (token.getID() == 11) {
                    this.read();
                    subParam = true;
                } else {
                    this.error("template.substitution.rbrace", token);
                }
            } else {
                this.error("template.substitution.ellipsis", token);
                if (token.getID() == 11) {
                    this.read();
                    subParam = true;
                }
            }
        }
        Vector<Node> v = new Vector<Node>(10, 0);
        SourceInfo info = this.peek().getSourceInfo();
        Node statement = null;
        while (this.peek().getID() != 1) {
            if (this.peek().getID() == 58) {
                this.read();
                this.error("statement.misuse.import", this.peek());
            } else {
                statement = this.parseStatement();
            }
            v.addElement(statement);
        }
        if (statement != null) {
            info = info.setEndPosition(statement.getSourceInfo());
        }
        Object[] statements = new Statement[v.size()];
        v.copyInto(statements);
        StatementList statementList = new StatementList(info, (Statement[])statements);
        templateInfo = templateInfo.setEndPosition(statementList.getSourceInfo());
        return new Template(templateInfo, name, params, subParam, statementList, directiveList);
    }

    private String parseIdentifier() throws IOException {
        Token token = this.read();
        if (token.getID() != 7) {
            if (token.isReservedWord()) {
                this.error("identifier.reserved.word", token.getImage(), token);
                return token.getImage();
            }
            this.error("identifier.expected", token);
            return "";
        }
        return token.getStringValue();
    }

    /*
     * Enabled aggressive block sorting
     */
    private Name parseName() throws IOException {
        SourceInfo info = null;
        StringBuffer name = new StringBuffer(20);
        while (true) {
            Token token;
            if ((token = this.read()).getID() != 7) {
                info = info == null ? token.getSourceInfo() : info.setEndPosition(token.getSourceInfo());
                if (!token.isReservedWord()) {
                    this.error("name.identifier.expected", token);
                    return new Name(info, name.toString());
                }
                this.error("name.reserved.word", token.getImage(), token);
                name.append(token.getImage());
            } else {
                name.append(token.getStringValue());
                info = info == null ? token.getSourceInfo() : info.setEndPosition(token.getSourceInfo());
            }
            token = this.peek();
            if (token.getID() != 16) {
                return new Name(info, name.toString());
            }
            token = this.read();
            name.append('.');
            info = info.setEndPosition(token.getSourceInfo());
        }
    }

    private TypeName parseTypeName() throws IOException {
        Name name = this.parseName();
        SourceInfo info = name.getSourceInfo();
        ArrayList<TypeName> genericTypes = null;
        if (this.peek().getID() == 22) {
            Token token;
            this.read();
            genericTypes = new ArrayList<TypeName>();
            do {
                genericTypes.add(this.parseTypeName());
            } while ((token = this.read()).getID() == 15);
            if (token.getID() != 26) {
                this.error("name.generics.gt", token);
            }
            info = info.setEndPosition(token.getSourceInfo());
        }
        int dim = 0;
        while (this.peek().getID() == 12) {
            ++dim;
            Token token = this.read();
            if (this.peek().getID() == 13) {
                token = this.read();
            } else {
                this.error("name.rbracket", this.peek());
            }
            info = info.setEndPosition(token.getSourceInfo());
        }
        if (genericTypes == null) {
            return new TypeName(info, name, dim);
        }
        TypeName[] generics = genericTypes.toArray(new TypeName[genericTypes.size()]);
        return new TypeName(info, name, generics, dim);
    }

    private Variable parseVariableDeclaration(boolean isStaticallyTyped) throws IOException {
        TypeName typeName = this.parseTypeName();
        SourceInfo info = this.peek().getSourceInfo();
        String varName = this.parseIdentifier();
        return new Variable(info, varName, typeName, isStaticallyTyped);
    }

    private Variable[] parseFormalParameters() throws IOException {
        Token token = this.peek();
        if (token.getID() == 8) {
            this.read();
            token = this.peek();
        } else {
            this.error("params.lparen", token);
        }
        Vector<Variable> vars = new Vector<Variable>(10, 0);
        if (token.getID() != 9) {
            while (true) {
                if ((token = this.peek()).getID() == 9) {
                    this.error("params.premature.end", token);
                    break;
                }
                vars.addElement(this.parseVariableDeclaration(false));
                token = this.peek();
                if (token.getID() != 15) break;
                this.read();
            }
        }
        if (token.getID() == 9) {
            this.read();
        } else {
            this.error("params.rparen.expected", token);
        }
        Object[] variables = new Variable[vars.size()];
        vars.copyInto(variables);
        return variables;
    }

    private VariableRef parseLValue() throws IOException {
        return this.parseLValue(this.read());
    }

    private VariableRef parseLValue(Token token) throws IOException {
        String loopVarName;
        if (token.getID() != 7) {
            if (token.isReservedWord()) {
                this.error("lvalue.reserved.word", token.getImage(), token);
                loopVarName = token.getImage();
            } else {
                this.error("lvalue.identifier.expected", token);
                loopVarName = "";
            }
        } else {
            loopVarName = token.getStringValue();
        }
        return new VariableRef(token.getSourceInfo(), loopVarName);
    }

    private Block parseBlock() throws IOException {
        Token p;
        Token token = this.peek();
        SourceInfo info = token.getSourceInfo();
        if (token.getID() != 10) {
            this.error("block.lbrace.expected", token);
            if (token.getID() == 14) {
                this.read();
                return new Block(info, new Statement[0]);
            }
        } else {
            token = this.read();
        }
        Vector<Statement> v = new Vector<Statement>(10, 0);
        while ((p = this.peek()).getID() != 11) {
            if (p.getID() == 1) {
                this.error("block.rbrace.expected", p);
                break;
            }
            v.addElement(this.parseStatement());
        }
        token = this.read();
        Object[] statements = new Statement[v.size()];
        v.copyInto(statements);
        info = info.setEndPosition(token.getSourceInfo());
        return new Block(info, (Statement[])statements);
    }

    private Statement parseStatement() throws IOException {
        Statement st = null;
        block14: while (st == null) {
            Token token = this.read();
            switch (token.getID()) {
                case 14: {
                    int ID = this.peek().getID();
                    if (ID != 11 && ID != 1) continue block14;
                    st = new Statement(token.getSourceInfo());
                    continue block14;
                }
                case 55: {
                    st = this.parseBreakStatement(token);
                    continue block14;
                }
                case 59: {
                    st = this.parseContinueStatement(token);
                    continue block14;
                }
                case 47: {
                    st = this.parseIfStatement(token);
                    continue block14;
                }
                case 50: {
                    st = this.parseForeachStatement(token);
                    continue block14;
                }
                case 56: {
                    SourceInfo info = token.getSourceInfo();
                    Variable v = this.parseVariableDeclaration(true);
                    VariableRef lvalue = new VariableRef(info, v.getName());
                    lvalue.setVariable(v);
                    Expression rvalue = new NullLiteral(info);
                    if (this.peek().getID() == 34) {
                        this.read();
                        rvalue = this.parseExpression();
                        info = info.setEndPosition(rvalue.getSourceInfo());
                    }
                    st = new AssignmentStatement(info, lvalue, rvalue);
                    continue block14;
                }
                case 7: {
                    if (this.peek().getID() == 34) {
                        st = this.parseAssignmentStatement(token);
                        continue block14;
                    }
                    st = new ExpressionStatement(this.parseExpression(token));
                    continue block14;
                }
                case 18: {
                    st = new SubstitutionStatement(token.getSourceInfo());
                    continue block14;
                }
                case 1: {
                    this.error("statement.expected", token);
                    st = new Statement(token.getSourceInfo());
                    continue block14;
                }
                case 48: {
                    this.error("statement.misuse.else", token);
                    st = this.parseBlock();
                    continue block14;
                }
                case 51: {
                    this.error("statement.misuse.in", token);
                    st = new ExpressionStatement(this.parseExpression(token));
                    continue block14;
                }
                case 52: {
                    this.error("statement.misuse.reverse", token);
                    st = new ExpressionStatement(this.parseExpression(token));
                    continue block14;
                }
            }
            st = new ExpressionStatement(this.parseExpression(token));
        }
        return st;
    }

    private BreakStatement parseBreakStatement(Token token) throws IOException {
        return new BreakStatement(token.getSourceInfo());
    }

    private ContinueStatement parseContinueStatement(Token token) throws IOException {
        return new ContinueStatement(token.getSourceInfo());
    }

    private IfStatement parseIfStatement(Token token) throws IOException {
        SourceInfo info = token.getSourceInfo();
        Expression condition = this.parseExpression();
        if (!(condition instanceof ParenExpression)) {
            this.error("if.condition", condition.getSourceInfo());
        }
        Block thenPart = this.parseBlock();
        Block elsePart = null;
        token = this.peek();
        if (token.getID() != 48) {
            info = info.setEndPosition(thenPart.getSourceInfo());
        } else {
            this.read();
            token = this.peek();
            elsePart = token.getID() == 47 ? new Block(this.parseIfStatement(this.read())) : this.parseBlock();
            info = info.setEndPosition(elsePart.getSourceInfo());
        }
        return new IfStatement(info, condition, thenPart, elsePart);
    }

    private ForeachStatement parseForeachStatement(Token token) throws IOException {
        SourceInfo info = token.getSourceInfo();
        token = this.peek();
        if (token.getID() == 8) {
            this.read();
        } else {
            this.error("foreach.lparen.expected", token);
        }
        VariableRef loopVar = this.parseLValue();
        boolean foundASToken = false;
        Token asToken = this.peek();
        if (asToken.getID() == 57) {
            foundASToken = true;
            this.read();
            TypeName typeName = this.parseTypeName();
            SourceInfo info2 = this.peek().getSourceInfo();
            loopVar.setVariable(new Variable(info2, loopVar.getName(), typeName, true));
        }
        if ((token = this.peek()).getID() == 51) {
            this.read();
        } else {
            this.error("foreach.in.expected", token);
        }
        Expression range = this.parseExpression();
        Expression endRange = null;
        token = this.peek();
        if (token.getID() == 17) {
            this.read();
            endRange = this.parseExpression();
            token = this.peek();
        }
        if (endRange != null && foundASToken) {
            this.error("foreach.as.not.allowed", asToken);
        }
        boolean reverse = false;
        if (token.getID() == 52) {
            this.read();
            reverse = true;
            token = this.peek();
        }
        if (token.getID() == 9) {
            this.read();
        } else {
            this.error("foreach.rparen.expected", token);
        }
        Block body = this.parseBlock();
        info = info.setEndPosition(body.getSourceInfo());
        return new ForeachStatement(info, loopVar, range, endRange, reverse, body);
    }

    private AssignmentStatement parseAssignmentStatement(Token token) throws IOException {
        SourceInfo info = token.getSourceInfo();
        VariableRef lvalue = this.parseLValue(token);
        if (this.peek().getID() == 34) {
            this.read();
        } else {
            this.error("assignment.equals.expected", this.peek());
        }
        Expression rvalue = this.parseExpression();
        info = info.setEndPosition(rvalue.getSourceInfo());
        if (this.peek().getID() == 57) {
            this.read();
            TypeName typeName = this.parseTypeName();
            SourceInfo info2 = this.peek().getSourceInfo();
            lvalue.setVariable(new Variable(info2, lvalue.getName(), typeName, true));
        }
        return new AssignmentStatement(info, lvalue, rvalue);
    }

    private ExpressionList parseList(int lbracket, int rbracket, boolean associative) throws IOException {
        int leftID = lbracket;
        int rightID = rbracket;
        Token token = this.peek();
        SourceInfo info = token.getSourceInfo();
        if (token.getID() == leftID) {
            this.read();
            token = this.peek();
        } else if (lbracket == 8) {
            this.error("list.lparen.expected", token);
        } else if (lbracket == 12) {
            this.error("list.lbracket.expected", token);
        } else if (lbracket == 10) {
            this.error("list.lbrace.expected", token);
        } else {
            this.error("list.expected", token);
        }
        Vector<Expression> exprs = new Vector<Expression>(10, 0);
        boolean done = false;
        if (token.getID() != rightID) {
            Expression expr = null;
            while (true) {
                if ((token = this.read()).getID() == rightID) {
                    this.error("list.premature.end", token);
                    info = info.setEndPosition(token.getSourceInfo());
                    done = true;
                    break;
                }
                expr = this.parseExpression(token);
                exprs.addElement(expr);
                token = this.peek();
                if (token.getID() != 15 && token.getID() != 35 && token.getID() != 36) break;
                token = this.read();
            }
            if (!done && expr != null) {
                info = info.setEndPosition(expr.getSourceInfo());
            }
        }
        if (!done) {
            token = this.peek();
            if (token.getID() == rightID) {
                token = this.read();
                info = info.setEndPosition(token.getSourceInfo());
            } else if (rbracket == 9) {
                this.error("list.rparen.expected", token);
            } else if (rbracket == 13) {
                this.error("list.rbracket.expected", token);
            } else if (rbracket == 11) {
                this.error("list.rbrace.expected", token);
            } else {
                this.error("list.expected", token);
            }
        }
        Object[] elements = new Expression[exprs.size()];
        exprs.copyInto(elements);
        return new ExpressionList(info, (Expression[])elements);
    }

    private Expression parseExpression() throws IOException {
        return this.parseExpression(this.read());
    }

    private Expression parseExpression(Token token) throws IOException {
        return this.parseTernaryExpression(token);
    }

    private Expression parseTernaryExpression(Token token) throws IOException {
        SourceInfo info = token.getSourceInfo();
        Expression expr = this.parseOrExpression(token);
        token = this.peek();
        if (token.getID() == 37) {
            this.read();
            token = this.peek();
            if (token.getID() == 36) {
                this.read();
                Expression thenExpr = expr;
                Expression elseExpr = this.parseTernaryExpression(this.read());
                info = info.setEndPosition(elseExpr.getSourceInfo());
                expr = new TernaryExpression(info, expr, thenExpr, elseExpr);
            } else {
                Expression thenExpr = this.parseTernaryExpression(this.read());
                token = this.peek();
                if (token.getID() != 36) {
                    this.error("ternary.colon.expected", token);
                }
                this.read();
                Expression elseExpr = this.parseTernaryExpression(this.read());
                info = info.setEndPosition(elseExpr.getSourceInfo());
                expr = new TernaryExpression(info, expr, thenExpr, elseExpr);
            }
        }
        return expr;
    }

    private Expression parseOrExpression(Token token) throws IOException {
        SourceInfo info = token.getSourceInfo();
        Expression expr = this.parseAndExpression(token);
        while ((token = this.peek()).getID() == 45) {
            this.read();
            Expression right = this.parseAndExpression(this.read());
            info = info.setEndPosition(right.getSourceInfo());
            expr = new OrExpression(info, token, expr, right);
        }
        return expr;
    }

    private Expression parseAndExpression(Token token) throws IOException {
        SourceInfo info = token.getSourceInfo();
        Expression expr = this.parseEqualityExpression(token);
        while ((token = this.peek()).getID() == 46) {
            this.read();
            Expression right = this.parseEqualityExpression(this.read());
            info = info.setEndPosition(right.getSourceInfo());
            expr = new AndExpression(info, token, expr, right);
        }
        return expr;
    }

    private Expression parseEqualityExpression(Token token) throws IOException {
        SourceInfo info = token.getSourceInfo();
        Expression expr = this.parseRelationalExpression(token);
        block4: while (true) {
            token = this.peek();
            switch (token.getID()) {
                case 34: {
                    this.error("equality.misuse.assign", token);
                    token = new Token(token.getSourceInfo(), 24);
                }
                case 24: 
                case 27: {
                    this.read();
                    Expression right = this.parseRelationalExpression(this.read());
                    info = info.setEndPosition(right.getSourceInfo());
                    expr = new RelationalExpression(info, token, expr, right);
                    continue block4;
                }
            }
            break;
        }
        return expr;
    }

    private Expression parseRelationalExpression(Token token) throws IOException {
        SourceInfo info = token.getSourceInfo();
        Expression expr = this.parseCompareExpression(token);
        block4: while (true) {
            token = this.peek();
            switch (token.getID()) {
                case 22: 
                case 23: 
                case 25: 
                case 26: {
                    this.read();
                    Expression right = this.parseCompareExpression(this.read());
                    info = info.setEndPosition(right.getSourceInfo());
                    expr = new RelationalExpression(info, token, expr, right);
                    continue block4;
                }
                case 49: {
                    this.read();
                    TypeName typeName = this.parseTypeName();
                    info = info.setEndPosition(typeName.getSourceInfo());
                    expr = new RelationalExpression(info, token, expr, typeName);
                    continue block4;
                }
            }
            break;
        }
        return expr;
    }

    private Expression parseCompareExpression(Token token) throws IOException {
        SourceInfo info = token.getSourceInfo();
        Expression expr = this.parseConcatenateExpression(token);
        while ((token = this.peek()).getID() == 39) {
            this.read();
            Expression right = this.parseConcatenateExpression(this.read());
            info = info.setEndPosition(right.getSourceInfo());
            expr = new CompareExpression(info, token, expr, right);
        }
        return expr;
    }

    private Expression parseConcatenateExpression(Token token) throws IOException {
        SourceInfo info = token.getSourceInfo();
        Expression expr = this.parseAdditiveExpression(token);
        while ((token = this.peek()).getID() == 28) {
            this.read();
            Expression right = this.parseAdditiveExpression(this.read());
            info = info.setEndPosition(right.getSourceInfo());
            expr = new ConcatenateExpression(info, token, expr, right);
        }
        return expr;
    }

    private Expression parseAdditiveExpression(Token token) throws IOException {
        SourceInfo info = token.getSourceInfo();
        Expression expr = this.parseMultiplicativeExpression(token);
        block3: while (true) {
            token = this.peek();
            switch (token.getID()) {
                case 29: 
                case 30: {
                    this.read();
                    Expression right = this.parseMultiplicativeExpression(this.read());
                    info = info.setEndPosition(right.getSourceInfo());
                    expr = new ArithmeticExpression(info, token, expr, right);
                    continue block3;
                }
            }
            break;
        }
        return expr;
    }

    private Expression parseMultiplicativeExpression(Token token) throws IOException {
        SourceInfo info = token.getSourceInfo();
        Expression expr = this.parseUnaryExpression(token);
        block3: while (true) {
            token = this.peek();
            switch (token.getID()) {
                case 31: 
                case 32: 
                case 33: {
                    this.read();
                    Expression right = this.parseUnaryExpression(this.read());
                    info = info.setEndPosition(right.getSourceInfo());
                    expr = new ArithmeticExpression(info, token, expr, right);
                    continue block3;
                }
            }
            break;
        }
        return expr;
    }

    private Expression parseUnaryExpression(Token token) throws IOException {
        switch (token.getID()) {
            case 44: {
                SourceInfo info = token.getSourceInfo();
                Expression expr = this.parseUnaryExpression(this.read());
                info = info.setEndPosition(expr.getSourceInfo());
                return new NotExpression(info, expr);
            }
            case 30: {
                SourceInfo info = token.getSourceInfo();
                Expression expr = this.parseUnaryExpression(this.read());
                info = info.setEndPosition(expr.getSourceInfo());
                return new NegateExpression(info, expr);
            }
        }
        return this.parseLookup(token);
    }

    private Expression parseLookup(Token token) throws IOException {
        SourceInfo info = token.getSourceInfo();
        Expression expr = this.parseFactor(token);
        while (true) {
            Name lookupName;
            SourceInfo nameInfo;
            token = this.peek();
            boolean nullsafe = false;
            Token prefix = null;
            if (token.getID() == 37) {
                prefix = this.read();
                token = this.peek();
                if (token.getID() == 16 || token.getID() == 12) {
                    nullsafe = true;
                } else {
                    this.unread(prefix);
                }
            }
            if (!nullsafe && token.getID() == 40) {
                Token spread = this.read();
                token = this.read();
                nameInfo = token.getSourceInfo();
                if (token.getID() != 7) {
                    if (token.isReservedWord()) {
                        this.error("lookup.reserved.word", token.getImage(), token);
                        lookupName = new Name(nameInfo, token.getImage());
                    } else {
                        this.error("lookup.identifier.expected", token);
                        lookupName = new Name(nameInfo, null);
                    }
                } else {
                    lookupName = new Name(nameInfo, token.getStringValue());
                    info = info.setEndPosition(nameInfo);
                }
                Expression operation = null;
                NoOpExpression noop = new NoOpExpression(info);
                operation = this.peek().getID() == 8 ? this.parseCallExpression(FunctionCallExpression.class, noop, lookupName, info) : new Lookup(info, noop, spread, lookupName);
                expr = new SpreadExpression(info, expr, operation);
            } else if (token.getID() == 16) {
                Token dot = this.read();
                token = this.read();
                nameInfo = token.getSourceInfo();
                if (token.getID() != 7) {
                    if (token.isReservedWord()) {
                        this.error("lookup.reserved.word", token.getImage(), token);
                        lookupName = new Name(nameInfo, token.getImage());
                    } else {
                        this.error("lookup.identifier.expected", token);
                        lookupName = new Name(nameInfo, null);
                    }
                } else {
                    lookupName = new Name(nameInfo, token.getStringValue());
                    info = info.setEndPosition(nameInfo);
                }
                expr = this.peek().getID() == 8 ? this.parseCallExpression(FunctionCallExpression.class, expr, lookupName, info) : new Lookup(info, expr, dot, lookupName);
            } else {
                if (token.getID() != 12) break;
                Token lbrack = this.read();
                token = this.read();
                if (token.getID() == 13) {
                    info = info.setEndPosition(token.getSourceInfo());
                    this.error("lookup.empty.brackets", token);
                    expr = new ArrayLookup(info, expr, lbrack, new Expression(info));
                    continue;
                }
                Expression arrayLookup = this.parseExpression(token);
                token = this.peek();
                if (token.getID() == 13) {
                    this.read();
                    info = info.setEndPosition(token.getSourceInfo());
                } else {
                    this.error("lookup.rbracket.expected", token);
                    info = info.setEndPosition(arrayLookup.getSourceInfo());
                }
                expr = new ArrayLookup(info, expr, lbrack, arrayLookup);
            }
            if (!(expr instanceof NullSafe)) continue;
            ((NullSafe)((Object)expr)).setNullSafe(nullsafe);
        }
        return expr;
    }

    private Expression parseFactor(Token token) throws IOException {
        SourceInfo info = token.getSourceInfo();
        switch (token.getID()) {
            case 20: 
            case 21: {
                return this.parseNewArrayExpression(token);
            }
            case 8: {
                token = this.peek();
                Expression expr = token.getID() == 9 ? null : this.parseExpression(this.read());
                token = this.peek();
                if (token.getID() == 9) {
                    this.read();
                    info = info.setEndPosition(token.getSourceInfo());
                } else {
                    this.error("factor.rparen.expected", token);
                    info = info.setEndPosition(expr.getSourceInfo());
                }
                if (expr == null) {
                    this.error("factor.empty.parens", info);
                    expr = new Expression(info);
                }
                return new ParenExpression(info, expr);
            }
            case 41: {
                return new NullLiteral(info);
            }
            case 42: {
                return new BooleanLiteral(info, true);
            }
            case 43: {
                return new BooleanLiteral(info, false);
            }
            case 54: {
                return this.parseTemplateCallExpression(token);
            }
            case 6: {
                if (token.getNumericType() == 0) {
                    this.error("factor.number.invalid", token);
                }
                switch (token.getNumericType()) {
                    case 1: {
                        return new NumberLiteral(info, token.getIntValue());
                    }
                    case 2: {
                        return new NumberLiteral(info, token.getLongValue());
                    }
                    case 3: {
                        return new NumberLiteral(info, token.getFloatValue());
                    }
                }
                return new NumberLiteral(info, token.getDoubleValue());
            }
            case 5: {
                return new StringLiteral(info, token.getStringValue());
            }
            case 7: {
                FunctionCallExpression call = this.parseFunctionCallExpression(token);
                if (call != null) {
                    return call;
                }
                return new VariableRef(info, token.getStringValue());
            }
            case 1: {
                this.error("factor.expression.expected", token);
                break;
            }
            case 9: {
                this.error("factor.rparen.unmatched", token);
                break;
            }
            case 11: {
                this.error("factor.rbrace.unmatched", token);
                break;
            }
            case 13: {
                this.error("factor.rbracket.unmatched", token);
                break;
            }
            case 34: {
                this.error("factor.illegal.assignment", token);
                break;
            }
            case 17: {
                this.error("factor.misuse.dotdot", token);
                break;
            }
            default: {
                if (token.isReservedWord()) {
                    this.error("factor.reserved.word", token.getImage(), token);
                    break;
                }
                this.error("factor.unexpected.token", token);
            }
        }
        return new Expression(token.getSourceInfo());
    }

    private Expression parseNewArrayExpression(Token token) throws IOException {
        boolean associative = token.getID() == 21;
        SourceInfo info = token.getSourceInfo();
        ExpressionList list = this.parseList(8, 9, associative);
        info = info.setEndPosition(list.getSourceInfo());
        return new NewArrayExpression(info, list, associative);
    }

    private TemplateCallExpression parseTemplateCallExpression(Token token) throws IOException {
        SourceInfo info = token.getSourceInfo();
        Name target = this.parseName();
        info.setEndPosition(target.getSourceInfo());
        return this.parseCallExpression(TemplateCallExpression.class, null, target, info);
    }

    private FunctionCallExpression parseFunctionCallExpression(Token token) throws IOException {
        Token next = this.peek();
        if (next.getID() != 8) {
            return null;
        }
        SourceInfo info = token.getSourceInfo();
        Name target = new Name(info, token.getStringValue());
        return this.parseCallExpression(FunctionCallExpression.class, null, target, info);
    }

    private <T extends CallExpression> T parseCallExpression(Class<T> clazz, Expression expression, Node target, SourceInfo info) throws IOException {
        ExpressionList list = this.parseList(8, 9, false);
        info = info.setEndPosition(list.getSourceInfo());
        Block subParam = null;
        if (this.peek().getID() == 10) {
            subParam = this.parseBlock();
            info = info.setEndPosition(subParam.getSourceInfo());
        }
        try {
            return (T)((CallExpression)clazz.getConstructor(SourceInfo.class, Expression.class, Name.class, ExpressionList.class, Block.class).newInstance(info, expression, target, list, subParam));
        }
        catch (Exception exception) {
            throw new IOException("unable to create ctor", exception);
        }
    }

    public static void main(String[] arg) throws Exception {
        Tester.test(arg);
    }

    private static class Tester
    implements ErrorListener {
        public static void test(String[] arg) throws Exception {
            new Tester(arg[0]);
        }

        public Tester(String filename) throws Exception {
            BufferedReader file = new BufferedReader(new FileReader(filename));
            Scanner scanner = new Scanner(new SourceReader((Reader)file, "<%", "%>"));
            scanner.addErrorListener(this);
            Parser parser = new Parser(scanner);
            parser.addErrorListener(this);
            Template tree = parser.parse();
            if (tree != null) {
                TreePrinter printer = new TreePrinter(tree);
                printer.writeTo(System.out);
            }
        }

        @Override
        public void compileError(ErrorEvent e) {
            System.out.println(e.getDetailedErrorMessage());
        }
    }
}

