/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.compiler;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Stack;
import java.util.Vector;
import org.teatrove.tea.compiler.CompilationUnit;
import org.teatrove.tea.compiler.DoubleToken;
import org.teatrove.tea.compiler.ErrorEvent;
import org.teatrove.tea.compiler.ErrorListener;
import org.teatrove.tea.compiler.FloatToken;
import org.teatrove.tea.compiler.IntToken;
import org.teatrove.tea.compiler.LongToken;
import org.teatrove.tea.compiler.MessageFormatter;
import org.teatrove.tea.compiler.SourceInfo;
import org.teatrove.tea.compiler.StringToken;
import org.teatrove.tea.compiler.Token;
import org.teatrove.trove.io.SourceReader;

public class Scanner {
    private SourceReader mSource;
    private CompilationUnit mUnit;
    private boolean mEmitSpecial;
    private StringBuilder mWord = new StringBuilder(20);
    private Stack<Token> mLookahead = new Stack();
    private Token mEOFToken;
    private Vector<ErrorListener> mListeners = new Vector(1);
    private int mErrorCount = 0;
    private MessageFormatter mFormatter;

    public Scanner(SourceReader in) {
        this(in, null);
    }

    public Scanner(SourceReader in, CompilationUnit unit) {
        this.mSource = in;
        this.mUnit = unit;
        this.mFormatter = MessageFormatter.lookup(this);
    }

    public void addErrorListener(ErrorListener listener) {
        this.mListeners.addElement(listener);
    }

    public void removeErrorListener(ErrorListener listener) {
        this.mListeners.removeElement(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchParseError(ErrorEvent e) {
        ++this.mErrorCount;
        Vector<ErrorListener> vector = this.mListeners;
        synchronized (vector) {
            for (int i = 0; i < this.mListeners.size(); ++i) {
                this.mListeners.elementAt(i).compileError(e);
            }
        }
    }

    private void error(String str, SourceInfo info) {
        this.dispatchParseError(new ErrorEvent((Object)this, this.mFormatter.format(str), info, this.mUnit));
    }

    private void error(String str) {
        this.error(str, new SourceInfo(this.mSource.getLineNumber(), this.mSource.getStartPosition(), this.mSource.getEndPosition()));
    }

    public void emitSpecialTokens(boolean enable) {
        this.mEmitSpecial = enable;
    }

    public synchronized Token readToken() throws IOException {
        if (this.mLookahead.empty()) {
            return this.scanToken();
        }
        return this.mLookahead.pop();
    }

    public synchronized Token peekToken() throws IOException {
        if (this.mLookahead.empty()) {
            return this.mLookahead.push(this.scanToken());
        }
        return this.mLookahead.peek();
    }

    public synchronized void unreadToken(Token token) throws IOException {
        this.mLookahead.push(token);
    }

    public void close() throws IOException {
        this.mSource.close();
    }

    public int getErrorCount() {
        return this.mErrorCount;
    }

    private Token scanToken() throws IOException {
        int c;
        block30: while ((c = this.mSource.read()) != -1) {
            switch (c) {
                case -3: {
                    Token enter = this.mEmitSpecial ? this.makeStringToken(4, this.mSource.getEndTag()) : null;
                    Token t = this.scanText(c);
                    if (this.mEmitSpecial) {
                        if (t.getStringValue().length() > 0) {
                            this.mLookahead.push(t);
                        }
                        return enter;
                    }
                    if (t.getStringValue().length() == 0) continue block30;
                    return t;
                }
                case -2: {
                    return this.makeStringToken(3, this.mSource.getBeginTag());
                }
                case 40: {
                    return this.makeToken(8);
                }
                case 41: {
                    return this.makeToken(9);
                }
                case 123: {
                    return this.makeToken(10);
                }
                case 125: {
                    return this.makeToken(11);
                }
                case 91: {
                    return this.makeToken(12);
                }
                case 93: {
                    return this.makeToken(13);
                }
                case 59: {
                    return this.makeToken(14);
                }
                case 44: {
                    return this.makeToken(15);
                }
                case 58: {
                    return this.makeToken(36);
                }
                case 63: {
                    return this.makeToken(37);
                }
                case 46: {
                    int startPos;
                    int peek = this.mSource.peek();
                    if (peek >= 48 && peek <= 57) {
                        this.error("number.decimal.start");
                        return this.scanNumber(c);
                    }
                    if (peek == 46) {
                        startPos = this.mSource.getStartPosition();
                        this.mSource.read();
                        peek = this.mSource.peek();
                        if (peek == 46) {
                            this.mSource.read();
                            return this.makeToken(18, startPos);
                        }
                        return this.makeToken(17, startPos);
                    }
                    return this.makeToken(16);
                }
                case 35: {
                    int startPos;
                    int peek = this.mSource.peek();
                    if (peek == 35) {
                        startPos = this.mSource.getStartPosition();
                        this.mSource.read();
                        return this.makeToken(21, startPos);
                    }
                    return this.makeToken(20);
                }
                case 33: {
                    int startPos;
                    if (this.mSource.peek() == 61) {
                        startPos = this.mSource.getStartPosition();
                        this.mSource.read();
                        return this.makeToken(27, startPos);
                    }
                    return this.makeStringToken(0, String.valueOf((char)c));
                }
                case 60: {
                    int startPos;
                    if (this.mSource.peek() == 61) {
                        startPos = this.mSource.getStartPosition();
                        this.mSource.read();
                        if (this.mSource.peek() == 62) {
                            this.mSource.read();
                            return this.makeToken(39, startPos);
                        }
                        return this.makeToken(23, startPos);
                    }
                    return this.makeToken(22);
                }
                case 62: {
                    int startPos;
                    if (this.mSource.peek() == 61) {
                        startPos = this.mSource.getStartPosition();
                        this.mSource.read();
                        return this.makeToken(25, startPos);
                    }
                    return this.makeToken(26);
                }
                case 61: {
                    int startPos;
                    if (this.mSource.peek() == 61) {
                        startPos = this.mSource.getStartPosition();
                        this.mSource.read();
                        return this.makeToken(24, startPos);
                    }
                    if (this.mSource.peek() == 62) {
                        startPos = this.mSource.getStartPosition();
                        this.mSource.read();
                        return this.makeToken(35, startPos);
                    }
                    return this.makeToken(34);
                }
                case 38: {
                    return this.makeToken(28);
                }
                case 43: {
                    return this.makeToken(29);
                }
                case 45: {
                    return this.makeToken(30);
                }
                case 42: {
                    int startPos;
                    if (this.mSource.peek() == 46) {
                        startPos = this.mSource.getStartPosition();
                        this.mSource.read();
                        return this.makeToken(40, startPos);
                    }
                    return this.makeToken(31);
                }
                case 37: {
                    return this.makeToken(33);
                }
                case 47: {
                    Token t;
                    int startPos = this.mSource.getStartPosition();
                    int peek = this.mSource.peek();
                    if (peek == 42) {
                        this.mSource.read();
                        this.mSource.ignoreTags(true);
                        t = this.scanMultiLineComment(startPos);
                        this.mSource.ignoreTags(false);
                        if (!this.mEmitSpecial) continue block30;
                        return t;
                    }
                    if (peek == 47) {
                        this.mSource.read();
                        t = this.scanOneLineComment(startPos);
                        if (!this.mEmitSpecial) continue block30;
                        return t;
                    }
                    return this.makeToken(32);
                }
                case 34: 
                case 39: {
                    this.mSource.ignoreTags(true);
                    Token t = this.scanString(c);
                    this.mSource.ignoreTags(false);
                    return t;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    return this.scanNumber(c);
                }
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    return this.scanIdentifier(c);
                }
                case 0: 
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    continue block30;
                }
            }
            if (Character.isWhitespace((char)c)) continue;
            if (Character.isLetter((char)c)) {
                return this.scanIdentifier(c);
            }
            return this.makeStringToken(0, String.valueOf((char)c));
        }
        if (this.mEOFToken == null) {
            this.mEOFToken = this.makeToken(1);
        }
        return this.mEOFToken;
    }

    private Token scanText(int c) throws IOException {
        c = this.mSource.read();
        int startLine = this.mSource.getLineNumber();
        int startPos = this.mSource.getStartPosition();
        int endPos = this.mSource.getEndPosition();
        StringBuilder buf = new StringBuilder(256);
        while (c != -1) {
            if (c == -2) {
                if (!this.mEmitSpecial) break;
                this.mLookahead.push(this.makeStringToken(3, this.mSource.getBeginTag()));
                break;
            }
            if (c == -3) {
                buf.append(this.mSource.getEndTag());
            } else {
                buf.append((char)c);
            }
            if (this.mSource.peek() < 0) {
                endPos = this.mSource.getEndPosition();
            }
            c = this.mSource.read();
        }
        if (c == -1) {
            int i;
            int length = buf.length();
            for (i = length - 1; i >= 0 && buf.charAt(i) <= ' '; --i) {
            }
            buf.setLength(i + 1);
        }
        String str = buf.toString();
        return new StringToken(startLine, startPos, endPos, 5, str);
    }

    private Token scanString(int delimiter) throws IOException {
        int c;
        int startLine = this.mSource.getLineNumber();
        int startPos = this.mSource.getStartPosition();
        this.mWord.setLength(0);
        while ((c = this.mSource.read()) != -1 && c != delimiter) {
            if (c == 10 || c == 13) {
                this.error("string.newline");
                break;
            }
            if (c == 92) {
                int next = this.mSource.read();
                switch (next) {
                    case 48: {
                        c = 0;
                        break;
                    }
                    case 98: {
                        c = 8;
                        break;
                    }
                    case 116: {
                        c = 9;
                        break;
                    }
                    case 110: {
                        c = 10;
                        break;
                    }
                    case 102: {
                        c = 12;
                        break;
                    }
                    case 114: {
                        c = 13;
                        break;
                    }
                    case 92: {
                        c = 92;
                        break;
                    }
                    case 39: {
                        c = 39;
                        break;
                    }
                    case 34: {
                        c = 34;
                        break;
                    }
                    default: {
                        this.error("escape.code");
                        c = next;
                    }
                }
            }
            this.mWord.append((char)c);
        }
        if (c == -1) {
            this.error("string.eof");
        }
        StringToken t = new StringToken(startLine, startPos, this.mSource.getEndPosition(), 5, this.mWord.toString());
        return t;
    }

    private Token scanNumber(int c) throws IOException {
        Token token;
        int startLine = this.mSource.getLineNumber();
        int startPos = this.mSource.getStartPosition();
        this.mWord.setLength(0);
        int errorPos = -1;
        int type = 0;
        if (c == 48 && (this.mSource.peek() == 120 || this.mSource.peek() == 88)) {
            type = 1;
            this.mSource.read();
            c = this.mSource.read();
        }
        while (c != -1) {
            block26: {
                block33: {
                    block35: {
                        block34: {
                            block28: {
                                block31: {
                                    int peek;
                                    block32: {
                                        block30: {
                                            block29: {
                                                block27: {
                                                    block24: {
                                                        block25: {
                                                            if (c != 46) break block24;
                                                            peek = this.mSource.peek();
                                                            if (peek == 46) {
                                                                this.mSource.unread();
                                                                break;
                                                            }
                                                            if (peek < 48 || peek > 57) {
                                                                this.error("number.decimal.end");
                                                            }
                                                            this.mWord.append((char)c);
                                                            if (type != 0) break block25;
                                                            type = 6;
                                                            break block26;
                                                        }
                                                        if (errorPos >= 0) break block26;
                                                        errorPos = this.mSource.getStartPosition();
                                                        break block26;
                                                    }
                                                    if (c < 48 || c > 57) break block27;
                                                    this.mWord.append((char)c);
                                                    if ((type == 2 || type == 3 || type == 4 || type == 5) && errorPos < 0) {
                                                        errorPos = this.mSource.getStartPosition();
                                                    }
                                                    break block26;
                                                }
                                                if ((c < 97 || c > 102) && (c < 65 || c > 70)) break block28;
                                                if (type != 1) break block29;
                                                this.mWord.append((char)c);
                                                break block26;
                                            }
                                            if (c != 102 && c != 70) break block30;
                                            if (type != 0 && type != 6 && type != 7) break block31;
                                            type = 4;
                                            break block26;
                                        }
                                        if (c != 100 && c != 68) break block32;
                                        if (type != 0 && type != 6 && type != 7) break block31;
                                        type = 5;
                                        break block26;
                                    }
                                    if (c != 101 && c != 69 || type != 0 && type != 6) break block31;
                                    this.mWord.append((char)c);
                                    type = 7;
                                    peek = this.mSource.peek();
                                    if (peek == 43 || peek == 45) {
                                        this.mWord.append((char)this.mSource.read());
                                    }
                                    break block26;
                                }
                                this.mWord.append((char)c);
                                if (errorPos >= 0) break block26;
                                errorPos = this.mSource.getStartPosition();
                                break block26;
                            }
                            if (c != 108 && c != 76) break block33;
                            if (type != 0) break block34;
                            type = 2;
                            break block26;
                        }
                        if (type != 1) break block35;
                        type = 3;
                        break block26;
                    }
                    this.mWord.append((char)c);
                    if (errorPos >= 0) break block26;
                    errorPos = this.mSource.getStartPosition();
                    break block26;
                }
                if (Character.isLetterOrDigit((char)c)) {
                    this.mWord.append((char)c);
                    if (errorPos < 0) {
                        errorPos = this.mSource.getStartPosition();
                    }
                } else {
                    this.mSource.unread();
                    break;
                }
            }
            c = this.mSource.read();
        }
        String str = this.mWord.toString();
        int endPos = this.mSource.getEndPosition();
        if (errorPos >= 0) {
            token = new StringToken(startLine, startPos, endPos, errorPos, 6, str);
        } else {
            try {
                switch (type) {
                    default: {
                        try {
                            token = new IntToken(startLine, startPos, endPos, Integer.parseInt(str));
                        }
                        catch (NumberFormatException e) {
                            token = new LongToken(startLine, startPos, endPos, Long.parseLong(str));
                        }
                        break;
                    }
                    case 1: {
                        try {
                            token = new IntToken(startLine, startPos, endPos, this.parseHexInt(str));
                        }
                        catch (NumberFormatException e) {
                            token = new LongToken(startLine, startPos, endPos, this.parseHexLong(str));
                        }
                        break;
                    }
                    case 2: {
                        token = new LongToken(startLine, startPos, endPos, Long.parseLong(str));
                        break;
                    }
                    case 3: {
                        token = new LongToken(startLine, startPos, endPos, this.parseHexLong(str));
                        break;
                    }
                    case 4: {
                        token = new FloatToken(startLine, startPos, endPos, Float.parseFloat(str));
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        token = new DoubleToken(startLine, startPos, endPos, Double.parseDouble(str));
                        break;
                    }
                }
            }
            catch (NumberFormatException e) {
                token = new IntToken(startLine, startPos, endPos, 0);
                this.error("number.range", token.getSourceInfo());
            }
        }
        return token;
    }

    private int parseHexInt(String str) {
        if (str.length() > 8) {
            while (str.charAt(0) == '0') {
                str = str.substring(1);
            }
        }
        try {
            return Integer.parseInt(str, 16);
        }
        catch (NumberFormatException e) {
            if (str.length() == 8) {
                return (int)Long.parseLong(str, 16);
            }
            throw e;
        }
    }

    private long parseHexLong(String str) {
        if (str.length() > 16) {
            while (str.charAt(0) == '0') {
                str = str.substring(1);
            }
        }
        try {
            return Long.parseLong(str, 16);
        }
        catch (NumberFormatException e) {
            if (str.length() == 16) {
                long v1 = Long.parseLong(str.substring(0, 8), 16);
                long v2 = Long.parseLong(str.substring(8), 16);
                return v1 << (int)(32L + v2) & 0xFFFFFFFFL;
            }
            throw e;
        }
    }

    private Token scanIdentifier(int c) throws IOException {
        int id;
        int startLine = this.mSource.getLineNumber();
        int startPos = this.mSource.getStartPosition();
        int endPos = this.mSource.getEndPosition();
        this.mWord.setLength(0);
        this.mWord.append((char)c);
        block3: while ((c = this.mSource.peek()) != -1) {
            switch (c) {
                case 36: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    this.mSource.read();
                    endPos = this.mSource.getEndPosition();
                    this.mWord.append((char)c);
                    continue block3;
                }
            }
            if (!Character.isLetterOrDigit((char)c)) break;
            this.mSource.read();
            endPos = this.mSource.getEndPosition();
            this.mWord.append((char)c);
        }
        Token t = (id = Token.findReservedWordID(this.mWord)) != 0 ? new Token(startLine, startPos, endPos, id) : new StringToken(startLine, startPos, endPos, 7, this.mWord.toString());
        this.mWord.setLength(0);
        return t;
    }

    private Token scanOneLineComment(int startPos) throws IOException {
        int c;
        int startLine = this.mSource.getLineNumber();
        int endPos = this.mSource.getEndPosition();
        this.mWord.setLength(0);
        this.mWord.append('/').append('/');
        while ((c = this.mSource.peek()) != -1 && c != 13 && c != 10) {
            this.mSource.read();
            this.mWord.append((char)c);
            endPos = this.mSource.getEndPosition();
        }
        return new StringToken(startLine, startPos, endPos, 2, this.mWord.toString());
    }

    private Token scanMultiLineComment(int startPos) throws IOException {
        int c;
        int startLine = this.mSource.getLineNumber();
        this.mWord.setLength(0);
        this.mWord.append('/').append('*');
        while ((c = this.mSource.read()) != -1) {
            this.mWord.append((char)c);
            if (c != 42 || this.mSource.peek() != 47) continue;
            this.mWord.append('/');
            this.mSource.read();
            break;
        }
        if (c == -1) {
            this.error("comment.eof");
        }
        return new StringToken(startLine, startPos, this.mSource.getEndPosition(), 2, this.mWord.toString());
    }

    private Token makeToken(int ID) {
        return new Token(this.mSource.getLineNumber(), this.mSource.getStartPosition(), this.mSource.getEndPosition(), ID);
    }

    private Token makeToken(int ID, int startPos) {
        return new Token(this.mSource.getLineNumber(), startPos, this.mSource.getEndPosition(), ID);
    }

    private Token makeStringToken(int ID, String str) {
        return new StringToken(this.mSource.getLineNumber(), this.mSource.getStartPosition(), this.mSource.getEndPosition(), ID, str);
    }

    public static void main(String[] arg) throws Exception {
        Tester.test(arg);
    }

    private static class Tester {
        private Tester() {
        }

        public static void test(String[] arg) throws Exception {
            Token token;
            Reader file = new BufferedReader(new FileReader(arg[2]));
            Scanner s = new Scanner(new SourceReader(file, arg[0], arg[1]));
            while ((token = s.readToken()).getID() != 1) {
                int id = token.getID();
                if (id == 10) {
                    System.out.println();
                }
                System.out.print(token + " ");
                if (id != 10 && id != 11 && id != 14) continue;
                System.out.println();
                if (id != 11) continue;
                System.out.println();
            }
            System.out.println("\n\n*** Full Token Dump ***\n");
            file = new FileReader(arg[2]);
            s = new Scanner(new SourceReader(file, arg[0], arg[1]));
            s.emitSpecialTokens(true);
            while ((token = s.readToken()).getID() != 1) {
                String value;
                System.out.print(token.getCode() + ": ");
                System.out.print(token.getSourceInfo() + ": ");
                if (token.getID() == 6) {
                    switch (token.getNumericType()) {
                        case 1: {
                            System.out.print("int: ");
                            break;
                        }
                        case 2: {
                            System.out.print("long: ");
                            break;
                        }
                        case 3: {
                            System.out.print("float: ");
                            break;
                        }
                        case 4: {
                            System.out.print("double: ");
                            break;
                        }
                        default: {
                            System.out.print("BAD: ");
                        }
                    }
                }
                if ((value = token.getStringValue()) != null) {
                    System.out.println(value);
                    continue;
                }
                System.out.println(token.getImage());
            }
        }
    }
}

