/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.teatrove.tea.compiler.Type;
import org.teatrove.tea.parsetree.Variable;
import org.teatrove.tea.parsetree.VariableRef;

public class Scope {
    private Map<Variable, Variable> mVariables;
    private Scope mParent;
    private Collection<Scope> mChildren;
    private Set<Variable> mPrivateVars;
    private Map<String, Variable> mDeclared = new HashMap<String, Variable>(11);
    private Collection<VariableRef> mVariableRefs = new ArrayList<VariableRef>();

    public Scope() {
        this(null);
    }

    public Scope(Scope parent) {
        this.mParent = parent;
        if (this.mParent != null) {
            this.mVariables = parent.mVariables;
            if (parent.mChildren == null) {
                parent.mChildren = new ArrayList<Scope>(5);
            }
            parent.mChildren.add(this);
        } else {
            this.mVariables = new HashMap<Variable, Variable>(53);
        }
    }

    public Scope getParent() {
        return this.mParent;
    }

    public Scope[] getChildren() {
        if (this.mChildren == null) {
            return new Scope[0];
        }
        return this.mChildren.toArray(new Scope[this.mChildren.size()]);
    }

    public Variable declareVariable(Variable var) {
        return this.declareVariable(var, false);
    }

    public Variable declareVariable(Variable var, boolean isPrivate) {
        if (this.mVariables.containsKey(var)) {
            var = this.mVariables.get(var);
        } else {
            this.mVariables.put(var, var);
        }
        this.mDeclared.put(var.getName(), var);
        if (isPrivate) {
            if (this.mPrivateVars == null) {
                this.mPrivateVars = new HashSet<Variable>(7);
            }
            this.mPrivateVars.add(var);
        } else if (this.mPrivateVars != null) {
            this.mPrivateVars.remove(var);
        }
        return var;
    }

    public void declareVariables(Variable[] vars) {
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = this.declareVariable(vars[i]);
        }
    }

    public Variable getDeclaredVariable(String name) {
        return this.getDeclaredVariable(name, false);
    }

    public Variable getDeclaredVariable(String name, boolean publicOnly) {
        Variable var = this.mDeclared.get(name);
        if (!(var == null || publicOnly && this.mPrivateVars != null && this.mPrivateVars.contains(var))) {
            return var;
        }
        if (this.mParent != null) {
            return this.mParent.getDeclaredVariable(name);
        }
        return null;
    }

    private Variable[] getLocallyDeclaredVariables() {
        Collection<Variable> vars = this.mDeclared.values();
        return vars.toArray(new Variable[vars.size()]);
    }

    public boolean bindToVariable(VariableRef ref) {
        String name = ref.getName();
        Variable var = this.getDeclaredVariable(name);
        if (var != null) {
            ref.setType(null);
            ref.setVariable(var);
            this.mVariableRefs.add(ref);
            return true;
        }
        return false;
    }

    public VariableRef[] getVariableRefs() {
        ArrayList<VariableRef> allRefs = new ArrayList<VariableRef>();
        Scope.fillVariableRefs(allRefs, this);
        return allRefs.toArray(new VariableRef[allRefs.size()]);
    }

    private static void fillVariableRefs(Collection<VariableRef> refs, Scope scope) {
        refs.addAll(scope.mVariableRefs);
        Collection<Scope> children = scope.mChildren;
        if (children != null) {
            Iterator<Scope> it = children.iterator();
            while (it.hasNext()) {
                Scope.fillVariableRefs(refs, it.next());
            }
        }
    }

    public VariableRef[] getLocalVariableRefs() {
        VariableRef[] refs = new VariableRef[this.mVariableRefs.size()];
        return this.mVariableRefs.toArray(refs);
    }

    public VariableRef[] getOutOfScopeVariableRefs() {
        Scope parent = this.getParent();
        if (parent == null) {
            return new VariableRef[0];
        }
        ArrayList<VariableRef> allRefs = new ArrayList<VariableRef>();
        Scope.fillVariableRefs(allRefs, this);
        ArrayList<VariableRef> refs = new ArrayList<VariableRef>(allRefs.size());
        for (VariableRef ref : allRefs) {
            Variable var = ref.getVariable();
            if (var == null || parent.getDeclaredVariable(var.getName()) != var) continue;
            refs.add(ref);
        }
        VariableRef[] refsArray = new VariableRef[refs.size()];
        return refs.toArray(refsArray);
    }

    public VariableRef[] getLocalOutOfScopeVariableRefs() {
        Scope parent = this.getParent();
        if (parent == null) {
            return new VariableRef[0];
        }
        ArrayList<VariableRef> refs = new ArrayList<VariableRef>(this.mVariableRefs.size());
        for (VariableRef ref : this.mVariableRefs) {
            Variable var = ref.getVariable();
            if (var == null || parent.getDeclaredVariable(var.getName()) != var) continue;
            refs.add(ref);
        }
        VariableRef[] refsArray = new VariableRef[refs.size()];
        return refs.toArray(refsArray);
    }

    public boolean isEnclosing(Scope scope) {
        while (scope != null) {
            if (this == scope) {
                return true;
            }
            scope = scope.getParent();
        }
        return false;
    }

    public Scope getEnclosingScope(Scope scope) {
        for (Scope s = this; s != null; s = s.getParent()) {
            if (!s.isEnclosing(scope)) continue;
            return s;
        }
        return null;
    }

    public Variable[] intersect(Scope scope) {
        ArrayList<Variable> intersection = new ArrayList<Variable>();
        HashSet<String> matchedNames = new HashSet<String>(7);
        Scope.intersectFrom(this, scope, matchedNames, intersection);
        Scope.intersectFrom(scope, this, matchedNames, intersection);
        Variable[] vars = new Variable[intersection.size()];
        return intersection.toArray(vars);
    }

    public Variable[] promote() {
        Scope parent = this.getParent();
        if (parent == null) {
            return new Variable[0];
        }
        ArrayList<Variable> promotion = new ArrayList<Variable>();
        HashSet<String> matchedNames = new HashSet<String>(7);
        Scope.intersectFrom(this, parent, matchedNames, promotion);
        Variable[] vars = new Variable[promotion.size()];
        return promotion.toArray(vars);
    }

    private static void intersectFrom(Scope scope1, Scope scope2, Set<String> matchedNames, Collection<Variable> vars) {
        Set<Variable> privates1 = scope1.mPrivateVars;
        Variable[] vars1 = scope1.getLocallyDeclaredVariables();
        for (int i = 0; i < vars1.length; ++i) {
            Type type2;
            Type type1;
            Type type;
            String varName;
            Variable var1 = vars1[i];
            if (privates1 != null && privates1.contains(var1) || matchedNames.contains(varName = var1.getName())) continue;
            matchedNames.add(varName);
            Variable var2 = scope2.getDeclaredVariable(varName, true);
            if (var2 == null || (type = (type1 = var1.getType()).getCompatibleType(type2 = var2.getType())) == null) continue;
            Variable var = null;
            var = type.equals(type1) ? var1 : (type.equals(type2) ? var2 : new Variable(var1.getSourceInfo(), varName, type, var != null ? var.isStaticallyTyped() : false));
            vars.add(var);
        }
    }

    public void delete() {
        Scope parent = this.getParent();
        if (parent != null) {
            parent.mChildren.remove(this);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(super.toString());
        buf.append('\n');
        this.append(buf, this, "");
        return buf.toString();
    }

    private void append(StringBuffer buf, Scope scope, String indent) {
        buf.append(indent);
        buf.append("{\n");
        String indentMore = indent + "    ";
        Variable[] vars = scope.getLocallyDeclaredVariables();
        for (int i = 0; i < vars.length; ++i) {
            Type type;
            Variable var = vars[i];
            buf.append(indentMore);
            Set<Variable> privateVars = scope.mPrivateVars;
            if (privateVars != null && privateVars.contains(var)) {
                buf.append("private ");
            }
            if ((type = var.getType()) != null) {
                buf.append(type.getFullName());
            } else {
                buf.append("<null>");
            }
            buf.append(' ');
            buf.append(var.getName());
            buf.append(";  // ");
            buf.append(var);
            buf.append('\n');
        }
        VariableRef[] refs = scope.getLocalVariableRefs();
        for (int i = 0; i < refs.length; ++i) {
            VariableRef ref = refs[i];
            buf.append(indentMore);
            buf.append(ref.getName());
            buf.append(";  // ");
            buf.append(ref);
            buf.append(" to ");
            buf.append(ref.getVariable());
            buf.append('\n');
        }
        Scope[] children = scope.getChildren();
        for (int i = 0; i < children.length; ++i) {
            this.append(buf, children[i], indentMore);
        }
        buf.append(indent);
        buf.append("}\n");
    }
}

