/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.teatrove.trove.classfile.ClassFile;
import org.teatrove.trove.classfile.CodeAssembler;
import org.teatrove.trove.classfile.CodeAssemblerPrinter;
import org.teatrove.trove.classfile.CodeDisassembler;
import org.teatrove.trove.classfile.MethodInfo;
import org.teatrove.trove.classfile.TypeDesc;

public class TemplateCallExtractor {
    public static final String TEMPLATE_PACKAGE = "org.teatrove.teaservlet.template.";

    public static MethodInfo getTemplateExecuteMethod(InputStream in) throws IOException {
        ClassFile classFile = ClassFile.readFrom((InputStream)in);
        MethodInfo executeMethod = null;
        MethodInfo[] all = classFile.getMethods();
        for (int i = 0; i < all.length; ++i) {
            if (!"execute".equals(all[i].getName()) || !all[i].getModifiers().isStatic()) continue;
            executeMethod = all[i];
            break;
        }
        in.close();
        return executeMethod;
    }

    private static MethodInfo getTemplateSubstituteMethod(InputStream in) throws IOException {
        ClassFile classFile = ClassFile.readFrom((InputStream)in);
        MethodInfo substituteMethod = null;
        MethodInfo[] all = classFile.getMethods();
        for (int i = 0; i < all.length; ++i) {
            if (!"substitute".equals(all[i].getName()) || all[i].getMethodDescriptor().getParameterCount() != 1) continue;
            substituteMethod = all[i];
            break;
        }
        in.close();
        return substituteMethod;
    }

    public static String[] getTemplatesCalled(String basePath, String templateName) {
        final HashMap templatesCalledMap = new HashMap();
        try {
            File templatePath = new File(new File(basePath), templateName.replace('.', '/') + ".class");
            if (!templatePath.exists() && templateName.startsWith(TEMPLATE_PACKAGE)) {
                templatePath = new File(new File(basePath), templateName.substring(TEMPLATE_PACKAGE.length()).replace('.', '/') + ".class");
            }
            MethodInfo executeMethod = TemplateCallExtractor.getTemplateExecuteMethod(new FileInputStream(templatePath));
            CodeDisassembler cd = new CodeDisassembler(executeMethod);
            cd.disassemble((CodeAssembler)new CodeAssemblerPrinter(executeMethod.getMethodDescriptor().getParameterTypes(), true, null){

                public void invokeStatic(String className, String methodName, TypeDesc ret, TypeDesc[] params) {
                    if ("execute".equals(methodName)) {
                        templatesCalledMap.put(className.replace('.', '/'), className);
                    }
                }

                public void println(String s) {
                }
            });
            MethodInfo substituteMethod = TemplateCallExtractor.getTemplateSubstituteMethod(new FileInputStream(templatePath));
            if (substituteMethod == null) {
                return templatesCalledMap.keySet().toArray(new String[templatesCalledMap.keySet().size()]);
            }
            cd = new CodeDisassembler(substituteMethod);
            cd.disassemble((CodeAssembler)new CodeAssemblerPrinter(substituteMethod.getMethodDescriptor().getParameterTypes(), true, null){

                public void invokeStatic(String className, String methodName, TypeDesc ret, TypeDesc[] params) {
                    if ("execute".equals(methodName)) {
                        templatesCalledMap.put(className.replace('.', '/'), className);
                    }
                }

                public void println(String s) {
                }
            });
        }
        catch (IOException ix) {
            return new String[0];
        }
        return templatesCalledMap.keySet().toArray(new String[templatesCalledMap.keySet().size()]);
    }

    public static AppMethodInfo[] getAppMethodsCalled(String basePath, String templateName, final String contextClass) {
        final HashMap methodsCalledMap = new HashMap();
        try {
            File templatePath = new File(new File(basePath), templateName.replace('.', '/') + ".class");
            if (!templatePath.exists() && templateName.startsWith(TEMPLATE_PACKAGE)) {
                templatePath = new File(new File(basePath), templateName.substring(TEMPLATE_PACKAGE.length()).replace('.', '/') + ".class");
            }
            MethodInfo executeMethod = TemplateCallExtractor.getTemplateExecuteMethod(new FileInputStream(templatePath));
            CodeDisassembler cd = new CodeDisassembler(executeMethod);
            cd.disassemble((CodeAssembler)new CodeAssemblerPrinter(executeMethod.getMethodDescriptor().getParameterTypes(), true, null){

                public void invokeVirtual(String className, String methodName, TypeDesc ret, TypeDesc[] params) {
                    if ("print".equals(methodName) || "toString".equals(methodName) || "equals".equals(methodName) || contextClass.indexOf(className) == -1 && className.indexOf("MergedClass") == -1) {
                        return;
                    }
                    AppMethodInfo ami = new AppMethodInfo(methodName, params);
                    if (!methodsCalledMap.containsKey(ami)) {
                        methodsCalledMap.put(ami, ami);
                    } else {
                        ((AppMethodInfo)methodsCalledMap.get(ami)).incCallCount();
                    }
                }

                public void println(String s) {
                }
            });
            MethodInfo substituteMethod = TemplateCallExtractor.getTemplateSubstituteMethod(new FileInputStream(templatePath));
            if (substituteMethod == null) {
                return methodsCalledMap.values().toArray(new AppMethodInfo[methodsCalledMap.values().size()]);
            }
            cd = new CodeDisassembler(substituteMethod);
            cd.disassemble((CodeAssembler)new CodeAssemblerPrinter(substituteMethod.getMethodDescriptor().getParameterTypes(), true, null){

                public void invokeVirtual(String className, String methodName, TypeDesc ret, TypeDesc[] params) {
                    if ("print".equals(methodName) || "toString".equals(methodName) || "equals".equals(methodName) || contextClass.indexOf(className) == -1 && className.indexOf("MergedClass") == -1) {
                        return;
                    }
                    AppMethodInfo ami = new AppMethodInfo(methodName, params);
                    if (!methodsCalledMap.containsKey(ami)) {
                        methodsCalledMap.put(ami, ami);
                    } else {
                        ((AppMethodInfo)methodsCalledMap.get(ami)).incCallCount();
                    }
                }

                public void println(String s) {
                }
            });
        }
        catch (IOException ix) {
            return new AppMethodInfo[0];
        }
        return methodsCalledMap.values().toArray(new AppMethodInfo[methodsCalledMap.values().size()]);
    }

    public static class AppMethodInfo {
        private String mName;
        private TypeDesc[] mParams;
        private int mCallCount;

        public AppMethodInfo(String name, TypeDesc[] params) {
            this.mName = name;
            this.mParams = params != null ? params : new TypeDesc[]{};
            this.mCallCount = 1;
        }

        public AppMethodInfo(String desc, String delim) {
            this.mName = desc.substring(0, desc.indexOf(40));
            StringTokenizer st = new StringTokenizer(desc.substring(desc.indexOf(40) + 1, desc.indexOf(41)), delim);
            ArrayList<TypeDesc> l = new ArrayList<TypeDesc>();
            while (st.hasMoreTokens()) {
                l.add(TypeDesc.forDescriptor((String)st.nextToken().trim()));
            }
            this.mParams = l.toArray(new TypeDesc[l.size()]);
            try {
                this.mCallCount = Integer.parseInt(desc.substring(desc.lastIndexOf(58) + 1));
            }
            catch (NumberFormatException ne) {
                this.mCallCount = 1;
            }
        }

        public AppMethodInfo(String desc) {
            this(desc, "|");
        }

        public AppMethodInfo(Method method) {
            Class<?>[] pTypes = method.getParameterTypes();
            Type[] gTypes = method.getGenericParameterTypes();
            this.mParams = new TypeDesc[pTypes.length];
            for (int i = 0; i < this.mParams.length; ++i) {
                this.mParams[i] = TypeDesc.forClass(pTypes[i], (Type)gTypes[i]);
            }
            this.mCallCount = 1;
            this.mName = method.getName();
        }

        public String getName() {
            return this.mName;
        }

        public TypeDesc[] getParams() {
            return this.mParams;
        }

        public int getCallCount() {
            return this.mCallCount;
        }

        public void incCallCount() {
            ++this.mCallCount;
        }

        public int hashCode() {
            int hash = this.mName.hashCode();
            for (int i = 0; this.mParams != null && i < this.mParams.length; ++i) {
                hash ^= this.mParams[i].toString().hashCode();
            }
            return hash;
        }

        public String toString() {
            return this.getDescriptorStr() + ":" + this.mCallCount;
        }

        public String getDescriptorStr(String delim) {
            StringBuffer s = new StringBuffer(this.mName + "(");
            for (int i = 0; this.mParams != null && i < this.mParams.length; ++i) {
                s.append(this.mParams[i].toString());
                if (i >= this.mParams.length - 1) continue;
                s.append(delim).append(" ");
            }
            s.append(")");
            return s.toString();
        }

        public String getDescriptorStr() {
            return this.getDescriptorStr("|");
        }

        public boolean equals(Object o) {
            for (int i = 0; this.mParams != null && i < this.mParams.length; ++i) {
                if (((AppMethodInfo)o).getParams().length == this.mParams.length && ((AppMethodInfo)o).getParams()[i].equals((Object)this.mParams[i])) continue;
                return false;
            }
            return ((AppMethodInfo)o).getName().equals(this.mName);
        }
    }
}

