/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.compiler;

import java.beans.MethodDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarException;
import java.util.jar.JarFile;
import java.util.zip.ZipException;
import org.teatrove.tea.compiler.Compiler;
import org.teatrove.tea.compiler.TemplateCallExtractor;
import org.teatrove.trove.classfile.MethodInfo;
import org.teatrove.trove.classfile.TypeDesc;
import org.teatrove.trove.log.Syslog;
import org.teatrove.trove.util.PropertyMap;
import org.teatrove.trove.util.PropertyParser;

public class TemplateRepository {
    private File mRootClassesDir;
    private String mRootPackage;
    private HashMap<String, TemplateInfo> mTemplateInfoMap = new HashMap();
    private HashMap<String, Map<String, TemplateInfo>> mAncestorMap = null;
    private HashMap<String, Map<String, TemplateInfo>> mFunctionMap = null;
    private static final SimpleDateFormat mDateFmt = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss(S) a z");
    private static TemplateRepository mInstance = null;
    public static final String REPOSITORY_FILENAME = ".templates.info";

    private TemplateRepository(File rootClassesDir, String rootPackage) {
        this.mRootClassesDir = rootClassesDir;
        this.mRootPackage = rootPackage.replace('.', '/');
        this.mRootPackage = !this.mRootPackage.endsWith("/") ? (this.mRootPackage = this.mRootPackage + "/") : this.mRootPackage;
    }

    public static synchronized void init(File rootClassesDir, String rootPackage) {
        if (rootClassesDir == null || rootPackage == null) {
            return;
        }
        if (!rootClassesDir.isDirectory()) {
            throw new IllegalArgumentException("Root classes parameter not a directory.");
        }
        if (mInstance != null) {
            throw new RuntimeException("Repository already initialized.");
        }
        mInstance = new TemplateRepository(rootClassesDir, rootPackage);
        try {
            long start = System.currentTimeMillis();
            mInstance.loadRepositoryFile();
            Syslog.info((String)("Repository initialized.  Elapsed time " + (System.currentTimeMillis() - start) + " ms."));
        }
        catch (Exception ex) {
            long start = System.currentTimeMillis();
            Syslog.info((String)"Generating repository...");
            try {
                mInstance.getTemplateInfoForAllFiles();
                mInstance.createRepositoryFile();
            }
            catch (IOException ix) {
                ix.printStackTrace();
            }
            Syslog.info((String)("Repository created.  Elapsed time " + (double)(System.currentTimeMillis() - start) / 1000.0 + " sec."));
        }
    }

    public static boolean isInitialized() {
        return mInstance != null;
    }

    public static TemplateRepository getInstance() {
        if (mInstance == null) {
            throw new RuntimeException("Repository not initialized.");
        }
        return mInstance;
    }

    public TemplateInfo getTemplateInfoForClassFile(File f) throws IOException {
        if (!f.exists()) {
            return null;
        }
        MethodInfo mi = TemplateCallExtractor.getTemplateExecuteMethod(new FileInputStream(f));
        return mi != null ? new TemplateInfo(mi, f.lastModified(), this.mRootClassesDir) : null;
    }

    private void getTemplateInfoForAllFiles() throws IOException {
        this.getTemplateInfoForAllFiles(this.mRootClassesDir);
        this.getTemplateInfoForPrecompiledTemplates();
        this.buildAncestorMap();
    }

    private void getTemplateInfoForAllFiles(File startingFileContext) throws IOException {
        File[] dirList = startingFileContext.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File f, String name) {
                return f.isDirectory();
            }
        });
        for (int i = 0; dirList != null && i < dirList.length; ++i) {
            this.getTemplateInfoForAllFiles(dirList[i]);
        }
        File[] classList = startingFileContext.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File f, String name) {
                return f.canRead() && name.endsWith(".class");
            }
        });
        for (int i = 0; classList != null && i < classList.length; ++i) {
            TemplateInfo t = this.getTemplateInfoForClassFile(classList[i]);
            if (t == null) continue;
            this.mTemplateInfoMap.put(t.getName(), t);
        }
    }

    private void getTemplateInfoForPrecompiledTemplates() {
        StringTokenizer paths = new StringTokenizer(System.getProperty("java.class.path"), File.pathSeparator, false);
        while (paths.hasMoreTokens()) {
            String name = paths.nextToken();
            if (!name.endsWith(".jar")) continue;
            try {
                JarFile jar = null;
                try {
                    jar = new JarFile(name);
                }
                catch (ZipException zx) {
                    Syslog.warn((String)("The jar file " + name + " is in the classpath but does not exist or is unreadable."));
                    continue;
                }
                Enumeration<JarEntry> e = jar.entries();
                while (e.hasMoreElements()) {
                    MethodInfo mi;
                    JarEntry entry = e.nextElement();
                    if (!entry.getName().startsWith("org.teatrove.teaservlet.template.".replace('.', '/')) || !entry.getName().endsWith(".class") || (mi = TemplateCallExtractor.getTemplateExecuteMethod(jar.getInputStream(entry))) == null) continue;
                    TemplateInfo t = new TemplateInfo(mi, entry.getTime(), this.mRootClassesDir, true);
                    this.mTemplateInfoMap.put(t.getName(), t);
                }
            }
            catch (JarException jx) {
                Syslog.error((Throwable)jx);
            }
            catch (IOException ix) {
                Syslog.error((Throwable)ix);
            }
        }
    }

    public synchronized void createRepositoryFile() throws IOException {
        StringBuffer buf = new StringBuffer();
        long lastModified = System.currentTimeMillis();
        buf.append("lastModified = ").append(mDateFmt.format(new Date(lastModified))).append("\n");
        buf.append("templates {\n");
        Iterator<String> i = this.mTemplateInfoMap.keySet().iterator();
        while (i.hasNext()) {
            buf.append(this.mTemplateInfoMap.get(i.next()).toString());
        }
        buf.append("}\n");
        File repositoryFile = new File(this.mRootClassesDir, REPOSITORY_FILENAME);
        FileOutputStream out = new FileOutputStream(repositoryFile);
        out.write(buf.toString().getBytes());
        out.flush();
        out.close();
        repositoryFile.setLastModified(lastModified);
    }

    private void loadRepositoryFile() throws IOException, ParseException {
        PropertyMap m = new PropertyMap();
        PropertyParser p = new PropertyParser((Map)m);
        File repositoryFile = new File(this.mRootClassesDir, REPOSITORY_FILENAME);
        p.parse((Reader)new FileReader(repositoryFile));
        boolean isWindows = System.getProperty("os.name").startsWith("Windows");
        long lastModified = mDateFmt.parse((String)m.get("lastModified")).getTime();
        if (isWindows && repositoryFile.lastModified() != lastModified || !isWindows && Math.max(repositoryFile.lastModified(), lastModified) - Math.min(repositoryFile.lastModified(), lastModified) >= 1000L) {
            String corruptMsg = "Repository corrupt.  Rebuild Needed.";
            Syslog.error((String)corruptMsg);
            throw new RuntimeException(corruptMsg);
        }
        PropertyMap templateMap = m.subMap("templates");
        for (String key : templateMap.subMapKeySet()) {
            this.mTemplateInfoMap.put(key, new TemplateInfo(key, templateMap.subMap(key)));
        }
        this.buildAncestorMap();
    }

    private void buildAncestorMap() {
        this.mAncestorMap = new HashMap();
        this.mFunctionMap = new HashMap();
        for (TemplateInfo t : this.mTemplateInfoMap.values()) {
            int j;
            for (j = 0; j < t.getDependents().length; ++j) {
                Map<String, TemplateInfo> parentMap = this.mAncestorMap.get(t.getDependents()[j]);
                if (parentMap == null) {
                    parentMap = new HashMap<String, TemplateInfo>();
                }
                if (!parentMap.containsKey(t.getName())) {
                    parentMap.put(t.getName(), t);
                }
                this.mAncestorMap.put(t.getDependents()[j], parentMap);
            }
            for (j = 0; j < t.getAppMethodsCalled().length; ++j) {
                String sKey = t.getAppMethodsCalled()[j].toString();
                Map<String, TemplateInfo> callMap = this.mFunctionMap.get(sKey);
                if (callMap == null) {
                    callMap = new HashMap<String, TemplateInfo>();
                    this.mFunctionMap.put(sKey, callMap);
                }
                if (callMap.containsKey(t.getName())) continue;
                callMap.put(t.getName(), t);
            }
        }
    }

    public TemplateInfo[] getCallers(String templateName) {
        String string = templateName = !templateName.startsWith(this.mRootPackage) ? this.getFullyQualifiedTemplateName(templateName) : templateName;
        if (this.mAncestorMap.containsKey(templateName)) {
            Collection<TemplateInfo> parents = this.mAncestorMap.get(templateName).values();
            return parents.toArray(new TemplateInfo[parents.size()]);
        }
        return new TemplateInfo[0];
    }

    public TemplateInfo[] getMethodCallers(MethodDescriptor methodDesc) {
        Method method = methodDesc.getMethod();
        Class<?>[] paramClasses = method.getParameterTypes();
        Type[] paramTypes = method.getGenericParameterTypes();
        TypeDesc[] params = new TypeDesc[paramClasses.length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = TypeDesc.forClass(paramClasses[i], (Type)paramTypes[i]);
        }
        TemplateCallExtractor.AppMethodInfo mi = new TemplateCallExtractor.AppMethodInfo(method.getName(), params);
        if (this.mFunctionMap.containsKey(mi)) {
            Collection<TemplateInfo> callers = this.mFunctionMap.get(mi).values();
            return callers.toArray(new TemplateInfo[callers.size()]);
        }
        return new TemplateInfo[0];
    }

    public TemplateInfo getTemplateInfo(String templateName) {
        templateName = !templateName.startsWith(this.mRootPackage) ? this.getFullyQualifiedTemplateName(templateName) : templateName;
        return this.mTemplateInfoMap.get(templateName);
    }

    public TemplateInfo[] getTemplateInfos() {
        Collection<TemplateInfo> collection = this.mTemplateInfoMap.values();
        TemplateInfo[] result = null;
        if (collection.size() > 0) {
            result = collection.toArray(new TemplateInfo[collection.size()]);
        }
        return result;
    }

    public String[] getCallersNeedingRecompile(String[] names, Compiler compiler) throws IOException {
        HashMap<String, TemplateInfo> needsCompile = new HashMap<String, TemplateInfo>();
        for (int i = 0; i < names.length; ++i) {
            TemplateInfo tOld;
            String templateName = this.getFullyQualifiedTemplateName(names[i]);
            TemplateInfo tNew = this.getTemplateInfoForClassFile(this.getClassFileForName(templateName));
            if (tNew == null || !this.mTemplateInfoMap.containsKey(templateName) || tNew.equals(tOld = this.mTemplateInfoMap.get(templateName))) continue;
            TemplateInfo[] callers = this.getCallers(templateName);
            for (int j = 0; j < callers.length; ++j) {
                String shortPath = callers[j].getName().substring(this.mRootPackage.length()).replace('/', '.');
                if (needsCompile.containsKey(shortPath) || !compiler.sourceExists(shortPath)) continue;
                needsCompile.put(shortPath, callers[j]);
                this.getClassFileForName(callers[j].getName()).delete();
            }
        }
        return needsCompile.keySet().toArray(new String[needsCompile.size()]);
    }

    public synchronized void update(String[] templatesChanged) throws IOException {
        HashMap<String, String> updated = new HashMap<String, String>();
        for (int i = 0; i < templatesChanged.length; ++i) {
            String templateName = this.getFullyQualifiedTemplateName(templatesChanged[i]);
            if (updated.containsKey(templateName)) continue;
            TemplateInfo tUpdated = this.getTemplateInfoForClassFile(this.getClassFileForName(templateName));
            if (tUpdated != null) {
                this.mTemplateInfoMap.put(templateName, tUpdated);
            } else {
                this.mTemplateInfoMap.remove(templateName);
            }
            updated.put(templateName, templateName);
        }
        this.buildAncestorMap();
        this.createRepositoryFile();
    }

    private String getFullyQualifiedTemplateName(String name) {
        String s = name.replace('.', '/');
        return !s.startsWith(this.mRootPackage) ? this.mRootPackage + s : s;
    }

    private File getClassFileForName(String name) throws IOException {
        File templateFile = null;
        if (name.startsWith(this.mRootPackage)) {
            templateFile = new File(this.mRootClassesDir, name.substring(this.mRootPackage.length()) + ".class");
        }
        if (templateFile == null || !templateFile.exists()) {
            templateFile = new File(this.mRootClassesDir, name + ".class");
        }
        return templateFile;
    }

    public static String formatTypeDesc(TypeDesc d) {
        int i;
        StringBuffer name = new StringBuffer(d.getFullName());
        if (d.isPrimitive()) {
            switch (d.getTypeCode()) {
                case 1: {
                    return "Void";
                }
                case 4: {
                    name = new StringBuffer("boolean");
                    break;
                }
                case 8: {
                    name = new StringBuffer("byte");
                    break;
                }
                case 5: {
                    name = new StringBuffer("char");
                    break;
                }
                case 7: {
                    name = new StringBuffer("double");
                    break;
                }
                case 6: {
                    name = new StringBuffer("float");
                    break;
                }
                case 10: {
                    name = new StringBuffer("int");
                    break;
                }
                case 11: {
                    name = new StringBuffer("long");
                    break;
                }
                case 9: {
                    name = new StringBuffer("short");
                    break;
                }
                default: {
                    name = new StringBuffer("unknown");
                }
            }
        }
        if ((i = name.toString().indexOf("java.lang.")) != -1) {
            name.replace(i, 10, "");
        }
        if (d.isArray()) {
            for (int j = 0; j < d.getDimensions(); ++j) {
                name.append("[]");
            }
        }
        return name.toString();
    }

    public class TemplateInfo {
        String mName;
        long mLastModified;
        TypeDesc mReturnType;
        TypeDesc[] mParameterTypes;
        String[] mDependents;
        TemplateCallExtractor.AppMethodInfo[] mMethodsCalled;
        boolean mPrecompiled = false;

        TemplateInfo(MethodInfo mi, long lastModified, File rootClassesDir, boolean precompiled) {
            this.mLastModified = lastModified;
            this.mName = mi.getClassFile().getClassName().replace('.', '/');
            this.mReturnType = mi.getMethodDescriptor().getReturnType();
            this.mParameterTypes = mi.getMethodDescriptor().getParameterTypes();
            this.mDependents = TemplateCallExtractor.getTemplatesCalled(rootClassesDir.getAbsolutePath(), mi.getClassFile().getClassName());
            this.mMethodsCalled = this.mParameterTypes.length > 0 ? TemplateCallExtractor.getAppMethodsCalled(rootClassesDir.getAbsolutePath(), mi.getClassFile().getClassName(), this.mParameterTypes[0].toString()) : new TemplateCallExtractor.AppMethodInfo[0];
            this.mPrecompiled = precompiled;
        }

        TemplateInfo(String name, PropertyMap p) {
            this.mName = name;
            try {
                this.mLastModified = mDateFmt.parse((String)p.get("lastModified")).getTime();
            }
            catch (ParseException ignore) {
                // empty catch block
            }
            this.mReturnType = TypeDesc.forDescriptor((String)((String)p.get("returnType")));
            ArrayList<TypeDesc> paramList = new ArrayList<TypeDesc>();
            if (p.get("parameterTypes") != null) {
                StringTokenizer params = new StringTokenizer((String)p.get("parameterTypes"), ",", false);
                while (params.hasMoreTokens()) {
                    paramList.add(TypeDesc.forDescriptor((String)params.nextToken().trim()));
                }
            }
            this.mParameterTypes = paramList.toArray(new TypeDesc[paramList.size()]);
            ArrayList<String> depList = new ArrayList<String>();
            if (p.get("dependents") != null) {
                StringTokenizer deps = new StringTokenizer((String)p.get("dependents"), ",", false);
                while (deps.hasMoreTokens()) {
                    depList.add(deps.nextToken().trim());
                }
            }
            this.mDependents = depList.toArray(new String[depList.size()]);
            ArrayList<TemplateCallExtractor.AppMethodInfo> methodList = new ArrayList<TemplateCallExtractor.AppMethodInfo>();
            if (p.get("methodsCalled") != null) {
                StringTokenizer meths = new StringTokenizer((String)p.get("methodsCalled"), ",", false);
                while (meths.hasMoreTokens()) {
                    methodList.add(new TemplateCallExtractor.AppMethodInfo(meths.nextToken().trim()));
                }
            }
            this.mMethodsCalled = methodList.toArray(new TemplateCallExtractor.AppMethodInfo[methodList.size()]);
            this.mPrecompiled = "true".equals(p.get("precompiled"));
        }

        TemplateInfo(MethodInfo mi, long lastModified, File rootClassesDir) {
            this(mi, lastModified, rootClassesDir, false);
        }

        public boolean equals(TemplateInfo t) {
            if (t == null || !this.getName().equals(t.getName()) || !this.getReturnType().equals((Object)t.getReturnType()) || this.getParameterTypes().length != t.getParameterTypes().length) {
                return false;
            }
            for (int i = 0; i < this.getParameterTypes().length; ++i) {
                if (this.getParameterTypes()[i].equals((Object)t.getParameterTypes()[i])) continue;
                return false;
            }
            return true;
        }

        public String getName() {
            return this.mName;
        }

        public TypeDesc getReturnType() {
            return this.mReturnType;
        }

        public TypeDesc[] getParameterTypes() {
            return this.mParameterTypes;
        }

        public String[] getDependents() {
            return this.mDependents;
        }

        public long getLastModified() {
            return this.mLastModified;
        }

        public Date getLastModifiedDate() {
            return new Date(this.mLastModified);
        }

        public boolean isPrecompiled() {
            return this.mPrecompiled;
        }

        public String getShortName() {
            return this.mName.substring(TemplateRepository.this.mRootPackage.length());
        }

        public TemplateCallExtractor.AppMethodInfo[] getAppMethodsCalled() {
            return this.mMethodsCalled;
        }

        public String toString() {
            int i;
            String indent = "        ";
            StringBuffer buf = new StringBuffer();
            buf.append("    \"").append(this.mName).append("\" {\n");
            buf.append(indent).append("lastModified = ").append(mDateFmt.format(new Date(this.mLastModified))).append("\n");
            buf.append(indent).append("returnType = ").append(this.mReturnType).append("\n");
            if (this.mParameterTypes.length > 0) {
                buf.append(indent).append("parameterTypes = ");
                for (i = 0; i < this.mParameterTypes.length; ++i) {
                    buf.append(this.mParameterTypes[i]);
                    if (i >= this.mParameterTypes.length - 1) continue;
                    buf.append(", ");
                }
                buf.append("\n");
            }
            if (this.mDependents.length > 0) {
                buf.append(indent).append("dependents = ");
                for (i = 0; i < this.mDependents.length; ++i) {
                    buf.append(this.mDependents[i]);
                    if (i >= this.mDependents.length - 1) continue;
                    buf.append(", ");
                }
                buf.append("\n");
            }
            if (this.mMethodsCalled.length > 0) {
                buf.append(indent).append("methodsCalled = ");
                for (i = 0; i < this.mMethodsCalled.length; ++i) {
                    buf.append(this.mMethodsCalled[i]);
                    if (i >= this.mMethodsCalled.length - 1) continue;
                    buf.append(", ");
                }
                buf.append("\n");
            }
            buf.append(indent).append("precompiled = " + this.mPrecompiled + "\n");
            buf.append("    }\n");
            return buf.toString();
        }
    }
}

