/*
 * Decompiled with CFR 0.152.
 */
package org.teatrove.tea.compiler;

import java.io.PrintStream;
import java.io.Serializable;
import org.teatrove.tea.compiler.SourceDetailedInfo;
import org.teatrove.tea.compiler.SourceInfo;

public class Token
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int UNKNOWN = 0;
    public static final int EOF = 1;
    public static final int COMMENT = 2;
    public static final int ENTER_CODE = 3;
    public static final int ENTER_TEXT = 4;
    public static final int STRING = 5;
    public static final int NUMBER = 6;
    public static final int IDENT = 7;
    private static final int FIRST_BRACKET_ID = 8;
    public static final int LPAREN = 8;
    public static final int RPAREN = 9;
    public static final int LBRACE = 10;
    public static final int RBRACE = 11;
    public static final int LBRACK = 12;
    public static final int RBRACK = 13;
    private static final int LAST_BRACKET_ID = 13;
    private static final int FIRST_OPERATOR_ID = 19;
    public static final int SEMI = 14;
    public static final int COMMA = 15;
    public static final int DOT = 16;
    public static final int DOTDOT = 17;
    public static final int ELLIPSIS = 18;
    public static final int SLASH = 19;
    public static final int HASH = 20;
    public static final int DOUBLE_HASH = 21;
    public static final int LT = 22;
    public static final int LE = 23;
    public static final int EQ = 24;
    public static final int GE = 25;
    public static final int GT = 26;
    public static final int NE = 27;
    public static final int CONCAT = 28;
    public static final int PLUS = 29;
    public static final int MINUS = 30;
    public static final int MULT = 31;
    public static final int DIV = 32;
    public static final int MOD = 33;
    public static final int ASSIGN = 34;
    public static final int EQUAL_GREATER = 35;
    public static final int COLON = 36;
    public static final int QUESTION = 37;
    public static final int LAMBDA = 38;
    public static final int SPACESHIP = 39;
    public static final int SPREAD = 40;
    private static final int LAST_OPERATOR_ID = 40;
    private static final int FIRST_RESERVED_ID = 41;
    public static final int NULL = 41;
    public static final int TRUE = 42;
    public static final int FALSE = 43;
    public static final int NOT = 44;
    public static final int OR = 45;
    public static final int AND = 46;
    public static final int IF = 47;
    public static final int ELSE = 48;
    public static final int ISA = 49;
    public static final int FOREACH = 50;
    public static final int IN = 51;
    public static final int REVERSE = 52;
    public static final int TEMPLATE = 53;
    public static final int CALL = 54;
    public static final int BREAK = 55;
    public static final int DEFINE = 56;
    public static final int AS = 57;
    public static final int IMPORT = 58;
    public static final int CONTINUE = 59;
    public static final int CLASS = 60;
    private static final int LAST_RESERVED_ID = 60;
    private static final int LAST_ID = 60;
    private int mTokenID;
    private SourceInfo mInfo;

    Token(int sourceLine, int sourceStartPos, int sourceEndPos, int tokenID) {
        this(sourceLine, sourceStartPos, sourceEndPos, sourceStartPos, tokenID);
    }

    Token(int sourceLine, int sourceStartPos, int sourceEndPos, int sourceDetailPos, int tokenID) {
        this.mTokenID = tokenID;
        if (tokenID > 60) {
            throw new IllegalArgumentException("Token ID out of range: " + tokenID);
        }
        this.mInfo = sourceStartPos == sourceDetailPos ? new SourceInfo(sourceLine, sourceStartPos, sourceEndPos) : new SourceDetailedInfo(sourceLine, sourceStartPos, sourceEndPos, sourceDetailPos);
        if (sourceStartPos > sourceEndPos) {
            throw new IllegalArgumentException("Token start position greater than end position at line: " + sourceLine);
        }
    }

    public Token(SourceInfo info, int tokenID) {
        this.mTokenID = tokenID;
        if (tokenID > 60) {
            throw new IllegalArgumentException("Token ID out of range: " + tokenID);
        }
        this.mInfo = info;
    }

    public static final boolean isReservedWord(int id) {
        return 41 <= id && id <= 60;
    }

    public static final boolean isOperator(int id) {
        return 19 <= id && id <= 40;
    }

    public static final boolean isBracket(int id) {
        return 8 <= id && id <= 13;
    }

    public static final boolean isOpenBracket(int id) {
        return id == 8 || id == 10 || id == 12;
    }

    public static final boolean isCloseBracket(int id) {
        return id == 9 || id == 11 || id == 13;
    }

    public static final int getMatchingBracket(int id) {
        if (Token.isOpenBracket(id)) {
            return ++id;
        }
        if (Token.isCloseBracket(id)) {
            return --id;
        }
        return -1;
    }

    public static int findReservedWordID(StringBuilder word) {
        char c = word.charAt(0);
        switch (c) {
            case 'a': {
                if (Token.matches(word, "and")) {
                    return 46;
                }
                if (!Token.matches(word, "as")) break;
                return 57;
            }
            case 'b': {
                if (!Token.matches(word, "break")) break;
                return 55;
            }
            case 'c': {
                if (Token.matches(word, "call")) {
                    return 54;
                }
                if (Token.matches(word, "class___")) {
                    return 60;
                }
                if (!Token.matches(word, "continue")) break;
                return 59;
            }
            case 'd': {
                if (!Token.matches(word, "define")) break;
                return 56;
            }
            case 'e': {
                if (!Token.matches(word, "else")) break;
                return 48;
            }
            case 'f': {
                if (Token.matches(word, "foreach")) {
                    return 50;
                }
                if (!Token.matches(word, "false")) break;
                return 43;
            }
            case 'i': {
                if (Token.matches(word, "if")) {
                    return 47;
                }
                if (Token.matches(word, "import")) {
                    return 58;
                }
                if (Token.matches(word, "in")) {
                    return 51;
                }
                if (!Token.matches(word, "isa")) break;
                return 49;
            }
            case 'n': {
                if (Token.matches(word, "null")) {
                    return 41;
                }
                if (!Token.matches(word, "not")) break;
                return 44;
            }
            case 'o': {
                if (!Token.matches(word, "or")) break;
                return 45;
            }
            case 'r': {
                if (!Token.matches(word, "reverse")) break;
                return 52;
            }
            case 't': {
                if (Token.matches(word, "true")) {
                    return 42;
                }
                if (!Token.matches(word, "template")) break;
                return 53;
            }
        }
        return 0;
    }

    private static boolean matches(StringBuilder word, String val) {
        int len = word.length();
        if (len != val.length()) {
            return false;
        }
        for (int index = 1; index < len; ++index) {
            char cv;
            char cw = word.charAt(index);
            if (cw == (cv = val.charAt(index))) continue;
            return false;
        }
        return true;
    }

    public final void dump() {
        this.dump(System.out);
    }

    public final void dump(PrintStream out) {
        out.println("Token [Code: " + this.getCode() + "] [Image: " + this.getImage() + "] [Value: " + this.getStringValue() + "] [Id: " + this.getID() + "] [start: " + this.mInfo.getStartPosition() + "] [end " + this.mInfo.getEndPosition() + "]");
    }

    public final int getID() {
        return this.mTokenID;
    }

    public final boolean isReservedWord() {
        return Token.isReservedWord(this.mTokenID);
    }

    public final boolean isBracket() {
        return Token.isBracket(this.mTokenID);
    }

    public final boolean isOpenBracket() {
        return Token.isOpenBracket(this.mTokenID);
    }

    public final boolean isCloseBracket() {
        return Token.isCloseBracket(this.mTokenID);
    }

    public final boolean isOperator() {
        return Token.isOperator(this.mTokenID);
    }

    public String getImage() {
        return Code.TOKEN_IMAGES[this.mTokenID];
    }

    public String getCode() {
        return Code.TOKEN_CODES[this.mTokenID];
    }

    public final SourceInfo getSourceInfo() {
        return this.mInfo;
    }

    public String getStringValue() {
        return null;
    }

    public int getNumericType() {
        return 0;
    }

    public int getIntValue() {
        return 0;
    }

    public long getLongValue() {
        return 0L;
    }

    public float getFloatValue() {
        return 0.0f;
    }

    public double getDoubleValue() {
        return 0.0;
    }

    public String toString() {
        String str;
        StringBuilder buf = new StringBuilder(10);
        String image = this.getImage();
        if (image != null) {
            buf.append(image);
        }
        if ((str = this.getStringValue()) != null) {
            if (image != null) {
                buf.append(' ');
            }
            buf.append(str);
        }
        return buf.toString();
    }

    private static class Code {
        public static final String[] TOKEN_IMAGES = new String[]{null, null, null, null, null, null, null, null, "(", ")", "{", "}", "[", "]", ";", ",", ".", "..", "...", "/", "#", "##", "<", "<=", "==", ">=", ">", "!=", "&", "+", "-", "*", "/", "%", "=", "=>", ":", "?", "->", "<=>", "*.", "null", "true", "false", "not", "or", "and", "if", "else", "isa", "foreach", "in", "reverse", "template", "call", "break", "define", "as", "import", "continue", "class___"};
        public static final String[] TOKEN_CODES = new String[]{"UNKNOWN", "EOF", "COMMENT", "ENTER_CODE", "ENTER_TEXT", "STRING", "NUMBER", "IDENT", "LPAREN", "RPAREN", "LBRACE", "RBRACE", "LBRACK", "RBRACK", "SEMI", "COMMA", "DOT", "DOTDOT", "ELLIPSIS", "SLASH", "HASH", "DOUBLE_HASH", "LT", "LE", "EQ", "GE", "GT", "NE", "CONCAT", "PLUS", "MINUS", "MULT", "DIV", "MOD", "ASSIGN", "EQUAL_GREATER", "COLON", "QUESTION", "LAMBDA", "SPACESHIP", "SPREAD", "NULL", "TRUE", "FALSE", "NOT", "OR", "AND", "IF", "ELSE", "ISA", "FOREACH", "IN", "REVERSE", "TEMPLATE", "CALL", "BREAK", "DEFINE", "AS", "IMPORT", "CONTINUE", "CLASS"};

        private Code() {
        }

        static {
            if (TOKEN_IMAGES.length != TOKEN_CODES.length) {
                throw new RuntimeException("TOKEN_IMAGES and TOKEN_CODES have different lengths");
            }
        }
    }
}

